/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: cputime_tmrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the cputime_tmrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=cputime_tmr.class)
public class cputime_tmrPointer extends StructurePointer {

	// NULL
	public static final cputime_tmrPointer NULL = new cputime_tmrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected cputime_tmrPointer(long address) {
		super(address);
	}

	public static cputime_tmrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static cputime_tmrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static cputime_tmrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new cputime_tmrPointer(address);
	}

	public cputime_tmrPointer add(long count) {
		return cputime_tmrPointer.cast(address + (cputime_tmr.SIZEOF * count));
	}

	public cputime_tmrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public cputime_tmrPointer addOffset(long offset) {
		return cputime_tmrPointer.cast(address + offset);
	}

	public cputime_tmrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public cputime_tmrPointer sub(long count) {
		return cputime_tmrPointer.cast(address - (cputime_tmr.SIZEOF * count));
	}

	public cputime_tmrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public cputime_tmrPointer subOffset(long offset) {
		return cputime_tmrPointer.cast(address - offset);
	}

	public cputime_tmrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public cputime_tmrPointer untag(long mask) {
		return cputime_tmrPointer.cast(address & ~mask);
	}

	public cputime_tmrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return cputime_tmr.SIZEOF;
	}

	// Implementation methods

	// caddr_t data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataOffset_", declaredType="caddr_t")
	public U8Pointer data() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(cputime_tmr._dataOffset_));
	}

	// caddr_t data
	public PointerPointer dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(cputime_tmr._dataOffset_));
	}

	// U16 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U16")
	public U16 flags() throws CorruptDataException {
		return new U16(getShortAtOffset(cputime_tmr._flagsOffset_));
	}

	// U16 flags
	public U16Pointer flagsEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(cputime_tmr._flagsOffset_));
	}

	// void* func
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_funcOffset_", declaredType="void*")
	public VoidPointer func() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(cputime_tmr._funcOffset_));
	}

	// void* func
	public PointerPointer funcEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(cputime_tmr._funcOffset_));
	}

	// ulong id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_idOffset_", declaredType="ulong")
	public UDATA id() throws CorruptDataException {
		return new U64(getLongAtOffset(cputime_tmr._idOffset_));
	}

	// ulong id
	public UDATAPointer idEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(cputime_tmr._idOffset_));
	}

	// U32 interval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_intervalOffset_", declaredType="U32")
	public UDATA interval() throws CorruptDataException {
		return new U32(getIntAtOffset(cputime_tmr._intervalOffset_));
	}

	// U32 interval
	public UDATAPointer intervalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(cputime_tmr._intervalOffset_));
	}

	// posix_tmr* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="posix_tmr*")
	public posix_tmrPointer next() throws CorruptDataException {
		return posix_tmrPointer.cast(getPointerAtOffset(cputime_tmr._nextOffset_));
	}

	// posix_tmr* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(cputime_tmr._nextOffset_));
	}

	// posix_tmr* prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_prevOffset_", declaredType="posix_tmr*")
	public posix_tmrPointer prev() throws CorruptDataException {
		return posix_tmrPointer.cast(getPointerAtOffset(cputime_tmr._prevOffset_));
	}

	// posix_tmr* prev
	public PointerPointer prevEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(cputime_tmr._prevOffset_));
	}

	// timer_t timerid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_timeridOffset_", declaredType="timer_t")
	public IDATA timerid() throws CorruptDataException {
		return new I64(getLongAtOffset(cputime_tmr._timeridOffset_));
	}

	// timer_t timerid
	public IDATAPointer timeridEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(cputime_tmr._timeridOffset_));
	}

	// U32 value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_valueOffset_", declaredType="U32")
	public UDATA value() throws CorruptDataException {
		return new U32(getIntAtOffset(cputime_tmr._valueOffset_));
	}

	// U32 value
	public UDATAPointer valueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(cputime_tmr._valueOffset_));
	}

}
