/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ld_infoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ld_infoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ld_info.class)
public class ld_infoPointer extends StructurePointer {

	// NULL
	public static final ld_infoPointer NULL = new ld_infoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ld_infoPointer(long address) {
		super(address);
	}

	public static ld_infoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ld_infoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ld_infoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ld_infoPointer(address);
	}

	public ld_infoPointer add(long count) {
		return ld_infoPointer.cast(address + (ld_info.SIZEOF * count));
	}

	public ld_infoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ld_infoPointer addOffset(long offset) {
		return ld_infoPointer.cast(address + offset);
	}

	public ld_infoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ld_infoPointer sub(long count) {
		return ld_infoPointer.cast(address - (ld_info.SIZEOF * count));
	}

	public ld_infoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ld_infoPointer subOffset(long offset) {
		return ld_infoPointer.cast(address - offset);
	}

	public ld_infoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ld_infoPointer untag(long mask) {
		return ld_infoPointer.cast(address & ~mask);
	}

	public ld_infoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ld_info.SIZEOF;
	}

	// Implementation methods

	// I64 _file._core_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__file$_core_offsetOffset_", declaredType="I64")
	public IDATA _file$_core_offset() throws CorruptDataException {
		return new I64(getLongAtOffset(ld_info.__file$_core_offsetOffset_));
	}

	// I64 _file._core_offset
	public IDATAPointer _file$_core_offsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ld_info.__file$_core_offsetOffset_));
	}

	// I32 _file._ldinfo_fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__file$_ldinfo_fdOffset_", declaredType="I32")
	public IDATA _file$_ldinfo_fd() throws CorruptDataException {
		return new I32(getIntAtOffset(ld_info.__file$_ldinfo_fdOffset_));
	}

	// I32 _file._ldinfo_fd
	public IDATAPointer _file$_ldinfo_fdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ld_info.__file$_ldinfo_fdOffset_));
	}

	// file* _file._ldinfo_fp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__file$_ldinfo_fpOffset_", declaredType="file*")
	public filePointer _file$_ldinfo_fp() throws CorruptDataException {
		return filePointer.cast(getPointerAtOffset(ld_info.__file$_ldinfo_fpOffset_));
	}

	// file* _file._ldinfo_fp
	public PointerPointer _file$_ldinfo_fpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ld_info.__file$_ldinfo_fpOffset_));
	}

	// void* ldinfo_dataorg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_dataorgOffset_", declaredType="void*")
	public VoidPointer ldinfo_dataorg() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(ld_info._ldinfo_dataorgOffset_));
	}

	// void* ldinfo_dataorg
	public PointerPointer ldinfo_dataorgEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ld_info._ldinfo_dataorgOffset_));
	}

	// U64 ldinfo_datasize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_datasizeOffset_", declaredType="U64")
	public UDATA ldinfo_datasize() throws CorruptDataException {
		return new U64(getLongAtOffset(ld_info._ldinfo_datasizeOffset_));
	}

	// U64 ldinfo_datasize
	public UDATAPointer ldinfo_datasizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ld_info._ldinfo_datasizeOffset_));
	}

	// U8[] ldinfo_filename
	public U8Pointer ldinfo_filenameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(ld_info._ldinfo_filenameOffset_));
	}

	// uint ldinfo_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_flagsOffset_", declaredType="uint")
	public UDATA ldinfo_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(ld_info._ldinfo_flagsOffset_));
	}

	// uint ldinfo_flags
	public UDATAPointer ldinfo_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ld_info._ldinfo_flagsOffset_));
	}

	// uint ldinfo_next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_nextOffset_", declaredType="uint")
	public UDATA ldinfo_next() throws CorruptDataException {
		return new U32(getIntAtOffset(ld_info._ldinfo_nextOffset_));
	}

	// uint ldinfo_next
	public UDATAPointer ldinfo_nextEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ld_info._ldinfo_nextOffset_));
	}

	// void* ldinfo_textorg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_textorgOffset_", declaredType="void*")
	public VoidPointer ldinfo_textorg() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(ld_info._ldinfo_textorgOffset_));
	}

	// void* ldinfo_textorg
	public PointerPointer ldinfo_textorgEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ld_info._ldinfo_textorgOffset_));
	}

	// U64 ldinfo_textsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ldinfo_textsizeOffset_", declaredType="U64")
	public UDATA ldinfo_textsize() throws CorruptDataException {
		return new U64(getLongAtOffset(ld_info._ldinfo_textsizeOffset_));
	}

	// U64 ldinfo_textsize
	public UDATAPointer ldinfo_textsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ld_info._ldinfo_textsizeOffset_));
	}

}
