/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: prochr_execexitPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the prochr_execexitPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=prochr_execexit.class)
public class prochr_execexitPointer extends StructurePointer {

	// NULL
	public static final prochr_execexitPointer NULL = new prochr_execexitPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected prochr_execexitPointer(long address) {
		super(address);
	}

	public static prochr_execexitPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static prochr_execexitPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static prochr_execexitPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new prochr_execexitPointer(address);
	}

	public prochr_execexitPointer add(long count) {
		return prochr_execexitPointer.cast(address + (prochr_execexit.SIZEOF * count));
	}

	public prochr_execexitPointer add(Scalar count) {
		return add(count.longValue());
	}

	public prochr_execexitPointer addOffset(long offset) {
		return prochr_execexitPointer.cast(address + offset);
	}

	public prochr_execexitPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public prochr_execexitPointer sub(long count) {
		return prochr_execexitPointer.cast(address - (prochr_execexit.SIZEOF * count));
	}

	public prochr_execexitPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public prochr_execexitPointer subOffset(long offset) {
		return prochr_execexitPointer.cast(address - offset);
	}

	public prochr_execexitPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public prochr_execexitPointer untag(long mask) {
		return prochr_execexitPointer.cast(address & ~mask);
	}

	public prochr_execexitPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return prochr_execexit.SIZEOF;
	}

	// Implementation methods

	// dev_t dev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_devOffset_", declaredType="dev_t")
	public UDATA dev() throws CorruptDataException {
		return new U64(getLongAtOffset(prochr_execexit._devOffset_));
	}

	// dev_t dev
	public UDATAPointer devEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(prochr_execexit._devOffset_));
	}

	// uint_t gen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_genOffset_", declaredType="uint_t")
	public UDATA gen() throws CorruptDataException {
		return new U32(getIntAtOffset(prochr_execexit._genOffset_));
	}

	// uint_t gen
	public UDATAPointer genEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(prochr_execexit._genOffset_));
	}

	// ino_t ino
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_inoOffset_", declaredType="ino_t")
	public UDATA ino() throws CorruptDataException {
		return new U64(getLongAtOffset(prochr_execexit._inoOffset_));
	}

	// ino_t ino
	public UDATAPointer inoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(prochr_execexit._inoOffset_));
	}

	// I32 len
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lenOffset_", declaredType="I32")
	public IDATA len() throws CorruptDataException {
		return new I32(getIntAtOffset(prochr_execexit._lenOffset_));
	}

	// I32 len
	public IDATAPointer lenEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(prochr_execexit._lenOffset_));
	}

}
