/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ptsprsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ptsprsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ptsprs.class)
public class ptsprsPointer extends StructurePointer {

	// NULL
	public static final ptsprsPointer NULL = new ptsprsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ptsprsPointer(long address) {
		super(address);
	}

	public static ptsprsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ptsprsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ptsprsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ptsprsPointer(address);
	}

	public ptsprsPointer add(long count) {
		return ptsprsPointer.cast(address + (ptsprs.SIZEOF * count));
	}

	public ptsprsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ptsprsPointer addOffset(long offset) {
		return ptsprsPointer.cast(address + offset);
	}

	public ptsprsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ptsprsPointer sub(long count) {
		return ptsprsPointer.cast(address - (ptsprs.SIZEOF * count));
	}

	public ptsprsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ptsprsPointer subOffset(long offset) {
		return ptsprsPointer.cast(address - offset);
	}

	public ptsprsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ptsprsPointer untag(long mask) {
		return ptsprsPointer.cast(address & ~mask);
	}

	public ptsprsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ptsprs.SIZEOF;
	}

	// Implementation methods

	// U32 pt_cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_crOffset_", declaredType="U32")
	public UDATA pt_cr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_crOffset_));
	}

	// U32 pt_cr
	public UDATAPointer pt_crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_crOffset_));
	}

	// U32 pt_ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_ctrOffset_", declaredType="U32")
	public UDATA pt_ctr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_ctrOffset_));
	}

	// U32 pt_ctr
	public UDATAPointer pt_ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_ctrOffset_));
	}

	// U32 pt_fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_fpscrOffset_", declaredType="U32")
	public UDATA pt_fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_fpscrOffset_));
	}

	// U32 pt_fpscr
	public UDATAPointer pt_fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_fpscrOffset_));
	}

	// U32 pt_fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_fpscrxOffset_", declaredType="U32")
	public UDATA pt_fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_fpscrxOffset_));
	}

	// U32 pt_fpscrx
	public UDATAPointer pt_fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_fpscrxOffset_));
	}

	// U32 pt_iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_iarOffset_", declaredType="U32")
	public UDATA pt_iar() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_iarOffset_));
	}

	// U32 pt_iar
	public UDATAPointer pt_iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_iarOffset_));
	}

	// U32 pt_lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_lrOffset_", declaredType="U32")
	public UDATA pt_lr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_lrOffset_));
	}

	// U32 pt_lr
	public UDATAPointer pt_lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_lrOffset_));
	}

	// U32 pt_mq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_mqOffset_", declaredType="U32")
	public UDATA pt_mq() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_mqOffset_));
	}

	// U32 pt_mq
	public UDATAPointer pt_mqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_mqOffset_));
	}

	// U32 pt_msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_msrOffset_", declaredType="U32")
	public UDATA pt_msr() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_msrOffset_));
	}

	// U32 pt_msr
	public UDATAPointer pt_msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_msrOffset_));
	}

	// U32 pt_reserved_0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_0Offset_", declaredType="U32")
	public UDATA pt_reserved_0() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_0Offset_));
	}

	// U32 pt_reserved_0
	public UDATAPointer pt_reserved_0EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_0Offset_));
	}

	// U8 pt_reserved_1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_1Offset_", declaredType="U8")
	public U8 pt_reserved_1() throws CorruptDataException {
		return new U8(getByteAtOffset(ptsprs._pt_reserved_1Offset_));
	}

	// U8 pt_reserved_1
	public U8Pointer pt_reserved_1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(ptsprs._pt_reserved_1Offset_));
	}

	// U8 pt_reserved_2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_2Offset_", declaredType="U8")
	public U8 pt_reserved_2() throws CorruptDataException {
		return new U8(getByteAtOffset(ptsprs._pt_reserved_2Offset_));
	}

	// U8 pt_reserved_2
	public U8Pointer pt_reserved_2EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(ptsprs._pt_reserved_2Offset_));
	}

	// U8[] pt_reserved_3
	public U8Pointer pt_reserved_3EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(ptsprs._pt_reserved_3Offset_));
	}

	// U32[] pt_reserved_4
	public UDATAPointer pt_reserved_4EA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(ptsprs._pt_reserved_4Offset_));
	}

	// U32 pt_reserved_5
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_5Offset_", declaredType="U32")
	public UDATA pt_reserved_5() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_5Offset_));
	}

	// U32 pt_reserved_5
	public UDATAPointer pt_reserved_5EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_5Offset_));
	}

	// U32 pt_reserved_6
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_6Offset_", declaredType="U32")
	public UDATA pt_reserved_6() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_6Offset_));
	}

	// U32 pt_reserved_6
	public UDATAPointer pt_reserved_6EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_6Offset_));
	}

	// U32 pt_reserved_7
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_7Offset_", declaredType="U32")
	public UDATA pt_reserved_7() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_7Offset_));
	}

	// U32 pt_reserved_7
	public UDATAPointer pt_reserved_7EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_7Offset_));
	}

	// U32 pt_reserved_8
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_8Offset_", declaredType="U32")
	public UDATA pt_reserved_8() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_8Offset_));
	}

	// U32 pt_reserved_8
	public UDATAPointer pt_reserved_8EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_8Offset_));
	}

	// U32 pt_reserved_9
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_reserved_9Offset_", declaredType="U32")
	public UDATA pt_reserved_9() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_reserved_9Offset_));
	}

	// U32 pt_reserved_9
	public UDATAPointer pt_reserved_9EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_reserved_9Offset_));
	}

	// U32 pt_xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pt_xerOffset_", declaredType="U32")
	public UDATA pt_xer() throws CorruptDataException {
		return new U32(getIntAtOffset(ptsprs._pt_xerOffset_));
	}

	// U32 pt_xer
	public UDATAPointer pt_xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ptsprs._pt_xerOffset_));
	}

}
