/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vminfo_psizePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vminfo_psizePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=vminfo_psize.class)
public class vminfo_psizePointer extends StructurePointer {

	// NULL
	public static final vminfo_psizePointer NULL = new vminfo_psizePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vminfo_psizePointer(long address) {
		super(address);
	}

	public static vminfo_psizePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vminfo_psizePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vminfo_psizePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vminfo_psizePointer(address);
	}

	public vminfo_psizePointer add(long count) {
		return vminfo_psizePointer.cast(address + (vminfo_psize.SIZEOF * count));
	}

	public vminfo_psizePointer add(Scalar count) {
		return add(count.longValue());
	}

	public vminfo_psizePointer addOffset(long offset) {
		return vminfo_psizePointer.cast(address + offset);
	}

	public vminfo_psizePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vminfo_psizePointer sub(long count) {
		return vminfo_psizePointer.cast(address - (vminfo_psize.SIZEOF * count));
	}

	public vminfo_psizePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vminfo_psizePointer subOffset(long offset) {
		return vminfo_psizePointer.cast(address - offset);
	}

	public vminfo_psizePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vminfo_psizePointer untag(long mask) {
		return vminfo_psizePointer.cast(address & ~mask);
	}

	public vminfo_psizePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return vminfo_psize.SIZEOF;
	}

	// Implementation methods

	// rpn64_t ame_deficit_npgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_deficit_npgsOffset_", declaredType="rpn64_t")
	public IDATA ame_deficit_npgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._ame_deficit_npgsOffset_));
	}

	// rpn64_t ame_deficit_npgs
	public IDATAPointer ame_deficit_npgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._ame_deficit_npgsOffset_));
	}

	// rpn64_t ame_numframes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_numframesOffset_", declaredType="rpn64_t")
	public IDATA ame_numframes() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._ame_numframesOffset_));
	}

	// rpn64_t ame_numframes
	public IDATAPointer ame_numframesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._ame_numframesOffset_));
	}

	// rpn64_t ame_numfrb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ame_numfrbOffset_", declaredType="rpn64_t")
	public IDATA ame_numfrb() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._ame_numfrbOffset_));
	}

	// rpn64_t ame_numfrb
	public IDATAPointer ame_numfrbEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._ame_numfrbOffset_));
	}

	// U64 attr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_attrOffset_", declaredType="U64")
	public UDATA attr() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._attrOffset_));
	}

	// U64 attr
	public UDATAPointer attrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._attrOffset_));
	}

	// U64 backtrks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_backtrksOffset_", declaredType="U64")
	public UDATA backtrks() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._backtrksOffset_));
	}

	// U64 backtrks
	public UDATAPointer backtrksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._backtrksOffset_));
	}

	// U64 cmem_ncomp_ops
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_ncomp_opsOffset_", declaredType="U64")
	public UDATA cmem_ncomp_ops() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cmem_ncomp_opsOffset_));
	}

	// U64 cmem_ncomp_ops
	public UDATAPointer cmem_ncomp_opsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_ncomp_opsOffset_));
	}

	// U64 cmem_ndecomp_ops
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_ndecomp_opsOffset_", declaredType="U64")
	public UDATA cmem_ndecomp_ops() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cmem_ndecomp_opsOffset_));
	}

	// U64 cmem_ndecomp_ops
	public UDATAPointer cmem_ndecomp_opsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_ndecomp_opsOffset_));
	}

	// size64_t cmem_tot_csize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_tot_csizeOffset_", declaredType="size64_t")
	public UDATA cmem_tot_csize() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cmem_tot_csizeOffset_));
	}

	// size64_t cmem_tot_csize
	public UDATAPointer cmem_tot_csizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_tot_csizeOffset_));
	}

	// rpn64_t cmem_tot_ncpgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_tot_ncpgsOffset_", declaredType="rpn64_t")
	public IDATA cmem_tot_ncpgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._cmem_tot_ncpgsOffset_));
	}

	// rpn64_t cmem_tot_ncpgs
	public IDATAPointer cmem_tot_ncpgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_tot_ncpgsOffset_));
	}

	// size64_t cmem_ucpool_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_ucpool_sizeOffset_", declaredType="size64_t")
	public UDATA cmem_ucpool_size() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cmem_ucpool_sizeOffset_));
	}

	// size64_t cmem_ucpool_size
	public UDATAPointer cmem_ucpool_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_ucpool_sizeOffset_));
	}

	// size64_t cmem_wseg_csize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_wseg_csizeOffset_", declaredType="size64_t")
	public UDATA cmem_wseg_csize() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cmem_wseg_csizeOffset_));
	}

	// size64_t cmem_wseg_csize
	public UDATAPointer cmem_wseg_csizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_wseg_csizeOffset_));
	}

	// rpn64_t cmem_wseg_ncpgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cmem_wseg_ncpgsOffset_", declaredType="rpn64_t")
	public IDATA cmem_wseg_ncpgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._cmem_wseg_ncpgsOffset_));
	}

	// rpn64_t cmem_wseg_ncpgs
	public IDATAPointer cmem_wseg_ncpgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._cmem_wseg_ncpgsOffset_));
	}

	// U64 cycles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cyclesOffset_", declaredType="U64")
	public UDATA cycles() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._cyclesOffset_));
	}

	// U64 cycles
	public UDATAPointer cyclesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._cyclesOffset_));
	}

	// U64 exfills
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_exfillsOffset_", declaredType="U64")
	public UDATA exfills() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._exfillsOffset_));
	}

	// U64 exfills
	public UDATAPointer exfillsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._exfillsOffset_));
	}

	// U64 extendwts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_extendwtsOffset_", declaredType="U64")
	public UDATA extendwts() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._extendwtsOffset_));
	}

	// U64 extendwts
	public UDATAPointer extendwtsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._extendwtsOffset_));
	}

	// U64 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U64")
	public UDATA flags() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._flagsOffset_));
	}

	// U64 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._flagsOffset_));
	}

	// U64 freewts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freewtsOffset_", declaredType="U64")
	public UDATA freewts() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._freewtsOffset_));
	}

	// U64 freewts
	public UDATAPointer freewtsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._freewtsOffset_));
	}

	// rpn64_t klock_kstk_steals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_klock_kstk_stealsOffset_", declaredType="rpn64_t")
	public IDATA klock_kstk_steals() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._klock_kstk_stealsOffset_));
	}

	// rpn64_t klock_kstk_steals
	public IDATAPointer klock_kstk_stealsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._klock_kstk_stealsOffset_));
	}

	// rpn64_t klock_pin_npgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_klock_pin_npgsOffset_", declaredType="rpn64_t")
	public IDATA klock_pin_npgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._klock_pin_npgsOffset_));
	}

	// rpn64_t klock_pin_npgs
	public IDATAPointer klock_pin_npgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._klock_pin_npgsOffset_));
	}

	// rpn64_t klock_pta_steals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_klock_pta_stealsOffset_", declaredType="rpn64_t")
	public IDATA klock_pta_steals() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._klock_pta_stealsOffset_));
	}

	// rpn64_t klock_pta_steals
	public IDATAPointer klock_pta_stealsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._klock_pta_stealsOffset_));
	}

	// rpn64_t klock_tot_npgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_klock_tot_npgsOffset_", declaredType="rpn64_t")
	public IDATA klock_tot_npgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._klock_tot_npgsOffset_));
	}

	// rpn64_t klock_tot_npgs
	public IDATAPointer klock_tot_npgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._klock_tot_npgsOffset_));
	}

	// rpn64_t klock_tot_steals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_klock_tot_stealsOffset_", declaredType="rpn64_t")
	public IDATA klock_tot_steals() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._klock_tot_stealsOffset_));
	}

	// rpn64_t klock_tot_steals
	public IDATAPointer klock_tot_stealsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._klock_tot_stealsOffset_));
	}

	// U64 lockexct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lockexctOffset_", declaredType="U64")
	public UDATA lockexct() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._lockexctOffset_));
	}

	// U64 lockexct
	public UDATAPointer lockexctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._lockexctOffset_));
	}

	// rpn64_t maxfree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxfreeOffset_", declaredType="rpn64_t")
	public IDATA maxfree() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._maxfreeOffset_));
	}

	// rpn64_t maxfree
	public IDATAPointer maxfreeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._maxfreeOffset_));
	}

	// size64_t memavailable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_memavailableOffset_", declaredType="size64_t")
	public UDATA memavailable() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._memavailableOffset_));
	}

	// size64_t memavailable
	public UDATAPointer memavailableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._memavailableOffset_));
	}

	// rpn64_t minfree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minfreeOffset_", declaredType="rpn64_t")
	public IDATA minfree() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._minfreeOffset_));
	}

	// rpn64_t minfree
	public IDATAPointer minfreeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._minfreeOffset_));
	}

	// rpn64_t nonsys_pgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nonsys_pgsOffset_", declaredType="rpn64_t")
	public IDATA nonsys_pgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._nonsys_pgsOffset_));
	}

	// rpn64_t nonsys_pgs
	public IDATAPointer nonsys_pgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._nonsys_pgsOffset_));
	}

	// rpn64_t numclient
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numclientOffset_", declaredType="rpn64_t")
	public IDATA numclient() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numclientOffset_));
	}

	// rpn64_t numclient
	public IDATAPointer numclientEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numclientOffset_));
	}

	// rpn64_t numclsegpin
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numclsegpinOffset_", declaredType="rpn64_t")
	public IDATA numclsegpin() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numclsegpinOffset_));
	}

	// rpn64_t numclsegpin
	public IDATAPointer numclsegpinEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numclsegpinOffset_));
	}

	// rpn64_t numclseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numclseguseOffset_", declaredType="rpn64_t")
	public IDATA numclseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numclseguseOffset_));
	}

	// rpn64_t numclseguse
	public IDATAPointer numclseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numclseguseOffset_));
	}

	// rpn64_t numcompress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numcompressOffset_", declaredType="rpn64_t")
	public IDATA numcompress() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numcompressOffset_));
	}

	// rpn64_t numcompress
	public IDATAPointer numcompressEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numcompressOffset_));
	}

	// rpn64_t numframes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numframesOffset_", declaredType="rpn64_t")
	public IDATA numframes() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numframesOffset_));
	}

	// rpn64_t numframes
	public IDATAPointer numframesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numframesOffset_));
	}

	// rpn64_t numfrb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numfrbOffset_", declaredType="rpn64_t")
	public IDATA numfrb() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numfrbOffset_));
	}

	// rpn64_t numfrb
	public IDATAPointer numfrbEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numfrbOffset_));
	}

	// U64 numiodone
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numiodoneOffset_", declaredType="U64")
	public UDATA numiodone() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._numiodoneOffset_));
	}

	// U64 numiodone
	public UDATAPointer numiodoneEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._numiodoneOffset_));
	}

	// rpn64_t numperm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpermOffset_", declaredType="rpn64_t")
	public IDATA numperm() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpermOffset_));
	}

	// rpn64_t numperm
	public IDATAPointer numpermEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpermOffset_));
	}

	// rpn64_t numpermio
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpermioOffset_", declaredType="rpn64_t")
	public IDATA numpermio() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpermioOffset_));
	}

	// rpn64_t numpermio
	public IDATAPointer numpermioEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpermioOffset_));
	}

	// rpn64_t numpgsp_pgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpgsp_pgsOffset_", declaredType="rpn64_t")
	public IDATA numpgsp_pgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpgsp_pgsOffset_));
	}

	// rpn64_t numpgsp_pgs
	public IDATAPointer numpgsp_pgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpgsp_pgsOffset_));
	}

	// rpn64_t numpout
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpoutOffset_", declaredType="rpn64_t")
	public IDATA numpout() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpoutOffset_));
	}

	// rpn64_t numpout
	public IDATAPointer numpoutEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpoutOffset_));
	}

	// rpn64_t numpsegpin
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpsegpinOffset_", declaredType="rpn64_t")
	public IDATA numpsegpin() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpsegpinOffset_));
	}

	// rpn64_t numpsegpin
	public IDATAPointer numpsegpinEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpsegpinOffset_));
	}

	// rpn64_t numpseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numpseguseOffset_", declaredType="rpn64_t")
	public IDATA numpseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numpseguseOffset_));
	}

	// rpn64_t numpseguse
	public IDATAPointer numpseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numpseguseOffset_));
	}

	// rpn64_t numralloc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numrallocOffset_", declaredType="rpn64_t")
	public IDATA numralloc() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numrallocOffset_));
	}

	// rpn64_t numralloc
	public IDATAPointer numrallocEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numrallocOffset_));
	}

	// rpn64_t numremote
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numremoteOffset_", declaredType="rpn64_t")
	public IDATA numremote() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numremoteOffset_));
	}

	// rpn64_t numremote
	public IDATAPointer numremoteEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numremoteOffset_));
	}

	// U64 numsios
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numsiosOffset_", declaredType="U64")
	public UDATA numsios() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._numsiosOffset_));
	}

	// U64 numsios
	public UDATAPointer numsiosEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._numsiosOffset_));
	}

	// rpn64_t numvpages
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numvpagesOffset_", declaredType="rpn64_t")
	public IDATA numvpages() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numvpagesOffset_));
	}

	// rpn64_t numvpages
	public IDATAPointer numvpagesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numvpagesOffset_));
	}

	// rpn64_t numwsegpin
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numwsegpinOffset_", declaredType="rpn64_t")
	public IDATA numwsegpin() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numwsegpinOffset_));
	}

	// rpn64_t numwsegpin
	public IDATAPointer numwsegpinEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numwsegpinOffset_));
	}

	// rpn64_t numwseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numwseguseOffset_", declaredType="rpn64_t")
	public IDATA numwseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._numwseguseOffset_));
	}

	// rpn64_t numwseguse
	public IDATAPointer numwseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._numwseguseOffset_));
	}

	// U64 pageins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pageinsOffset_", declaredType="U64")
	public UDATA pageins() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pageinsOffset_));
	}

	// U64 pageins
	public UDATAPointer pageinsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pageinsOffset_));
	}

	// U64 pageouts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pageoutsOffset_", declaredType="U64")
	public UDATA pageouts() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pageoutsOffset_));
	}

	// U64 pageouts
	public UDATAPointer pageoutsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pageoutsOffset_));
	}

	// U64 pendiowts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pendiowtsOffset_", declaredType="U64")
	public UDATA pendiowts() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pendiowtsOffset_));
	}

	// U64 pendiowts
	public UDATAPointer pendiowtsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pendiowtsOffset_));
	}

	// rpn64_t pfavail
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfavailOffset_", declaredType="rpn64_t")
	public IDATA pfavail() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._pfavailOffset_));
	}

	// rpn64_t pfavail
	public IDATAPointer pfavailEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._pfavailOffset_));
	}

	// rpn64_t pfpinavail
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfpinavailOffset_", declaredType="rpn64_t")
	public IDATA pfpinavail() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._pfpinavailOffset_));
	}

	// rpn64_t pfpinavail
	public IDATAPointer pfpinavailEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._pfpinavailOffset_));
	}

	// rpn64_t pfrsvdblks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pfrsvdblksOffset_", declaredType="rpn64_t")
	public IDATA pfrsvdblks() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._pfrsvdblksOffset_));
	}

	// rpn64_t pfrsvdblks
	public IDATAPointer pfrsvdblksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._pfrsvdblksOffset_));
	}

	// U64 pgexct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgexctOffset_", declaredType="U64")
	public UDATA pgexct() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pgexctOffset_));
	}

	// U64 pgexct
	public UDATAPointer pgexctEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pgexctOffset_));
	}

	// U64 pgrclm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgrclmOffset_", declaredType="U64")
	public UDATA pgrclm() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pgrclmOffset_));
	}

	// U64 pgrclm
	public UDATAPointer pgrclmEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pgrclmOffset_));
	}

	// U64 pgspgins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgspginsOffset_", declaredType="U64")
	public UDATA pgspgins() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pgspginsOffset_));
	}

	// U64 pgspgins
	public UDATAPointer pgspginsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pgspginsOffset_));
	}

	// U64 pgspgouts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgspgoutsOffset_", declaredType="U64")
	public UDATA pgspgouts() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pgspgoutsOffset_));
	}

	// U64 pgspgouts
	public UDATAPointer pgspgoutsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pgspgoutsOffset_));
	}

	// U64 pgsteals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pgstealsOffset_", declaredType="U64")
	public UDATA pgsteals() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._pgstealsOffset_));
	}

	// U64 pgsteals
	public UDATAPointer pgstealsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._pgstealsOffset_));
	}

	// psize_t psize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_psizeOffset_", declaredType="psize_t")
	public IDATA psize() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._psizeOffset_));
	}

	// psize_t psize
	public IDATAPointer psizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._psizeOffset_));
	}

	// rpn64_t[] rpgcnt
	public IDATAPointer rpgcntEA() throws CorruptDataException {
		return I64Pointer.cast(nonNullFieldEA(vminfo_psize._rpgcntOffset_));
	}

	// U64 scans
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scansOffset_", declaredType="U64")
	public UDATA scans() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._scansOffset_));
	}

	// U64 scans
	public UDATAPointer scansEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._scansOffset_));
	}

	// rpn64_t soft_clseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_soft_clseguseOffset_", declaredType="rpn64_t")
	public IDATA soft_clseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._soft_clseguseOffset_));
	}

	// rpn64_t soft_clseguse
	public IDATAPointer soft_clseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._soft_clseguseOffset_));
	}

	// rpn64_t soft_pseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_soft_pseguseOffset_", declaredType="rpn64_t")
	public IDATA soft_pseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._soft_pseguseOffset_));
	}

	// rpn64_t soft_pseguse
	public IDATAPointer soft_pseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._soft_pseguseOffset_));
	}

	// rpn64_t soft_wseguse
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_soft_wseguseOffset_", declaredType="rpn64_t")
	public IDATA soft_wseguse() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._soft_wseguseOffset_));
	}

	// rpn64_t soft_wseguse
	public IDATAPointer soft_wseguseEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._soft_wseguseOffset_));
	}

	// rpn64_t system_pgs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_system_pgsOffset_", declaredType="rpn64_t")
	public IDATA system_pgs() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._system_pgsOffset_));
	}

	// rpn64_t system_pgs
	public IDATAPointer system_pgsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._system_pgsOffset_));
	}

	// rpn64_t true_numframes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_true_numframesOffset_", declaredType="rpn64_t")
	public IDATA true_numframes() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._true_numframesOffset_));
	}

	// rpn64_t true_numframes
	public IDATAPointer true_numframesEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._true_numframesOffset_));
	}

	// rpn64_t true_numfrb
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_true_numfrbOffset_", declaredType="rpn64_t")
	public IDATA true_numfrb() throws CorruptDataException {
		return new I64(getLongAtOffset(vminfo_psize._true_numfrbOffset_));
	}

	// rpn64_t true_numfrb
	public IDATAPointer true_numfrbEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vminfo_psize._true_numfrbOffset_));
	}

	// U64 zerofills
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_zerofillsOffset_", declaredType="U64")
	public UDATA zerofills() throws CorruptDataException {
		return new U64(getLongAtOffset(vminfo_psize._zerofillsOffset_));
	}

	// U64 zerofills
	public UDATAPointer zerofillsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vminfo_psize._zerofillsOffset_));
	}

}
