/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9Consts
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9Consts {

	// VM Constants

	public static final long SIZEOF;
	public static final long BCV_ERR_ARGUMENTS_MISMATCH;
	public static final long BCV_ERR_ARRAY_ARITY_OVERFLOW;
	public static final long BCV_ERR_ARRAY_DIMENSION_MISMATCH;
	public static final long BCV_ERR_BAD_ACCESS_PROTECTED;
	public static final long BCV_ERR_BAD_BYTECODE;
	public static final long BCV_ERR_BAD_INIT_OBJECT;
	public static final long BCV_ERR_BAD_INVOKESPECIAL;
	public static final long BCV_ERR_DEAD_CODE;
	public static final long BCV_ERR_EXPECT_STACKMAP_FRAME;
	public static final long BCV_ERR_FRAMES_INCOMPATIBLE_TYPE;
	public static final long BCV_ERR_INACCESSIBLE_CLASS;
	public static final long BCV_ERR_INCOMPATIBLE_TYPE;
	public static final long BCV_ERR_INIT_NOT_CALL_INIT;
	public static final long BCV_ERR_INSUFFICIENT_MEMORY;
	public static final long BCV_ERR_INTERNAL_ERROR;
	public static final long BCV_ERR_INVALID_ARRAY_REFERENCE;
	public static final long BCV_ERR_JSR_ILLEGAL_LOAD_OPERATION;
	public static final long BCV_ERR_JSR_RET_ADDRESS_ON_STACK;
	public static final long BCV_ERR_JSR_STACK_OVERFLOW;
	public static final long BCV_ERR_JSR_STACK_UNDERFLOW;
	public static final long BCV_ERR_NO_STACKMAP_FRAME;
	public static final long BCV_ERR_STACKMAP_FRAME_LOCALS_OVERFLOW;
	public static final long BCV_ERR_STACKMAP_FRAME_LOCALS_UNDERFLOW;
	public static final long BCV_ERR_STACKMAP_FRAME_STACK_OVERFLOW;
	public static final long BCV_ERR_STACK_OVERFLOW;
	public static final long BCV_ERR_STACK_SIZE_MISMATCH;
	public static final long BCV_ERR_STACK_UNDERFLOW;
	public static final long BCV_ERR_UNEXPECTED_EOF;
	public static final long BCV_ERR_UNUSED_19;
	public static final long BCV_ERR_WRONG_RETURN_TYPE;
	public static final long BCV_ERR_WRONG_STACKMAP_FRAME;
	public static final long BCV_ERR_WRONG_TOP_TYPE;
	public static final long BCV_FAIL;
	public static final long BCV_NOT_FOUND;
	public static final long BCV_SUCCESS;
	public static final long J9VMGC_SIZECLASSES_ARRAYLET;
	public static final long J9VMGC_SIZECLASSES_LARGE;
	public static final long J9VMGC_SIZECLASSES_LOG_LARGEST;
	public static final long J9VMGC_SIZECLASSES_LOG_SMALLEST;
	public static final long J9VMGC_SIZECLASSES_MAX;
	public static final long J9VMGC_SIZECLASSES_MAX_SMALL;
	public static final long J9VMGC_SIZECLASSES_MAX_SMALL_SIZE_BYTES;
	public static final long J9VMGC_SIZECLASSES_MAX_SMALL_SLOT_COUNT;
	public static final long J9VMGC_SIZECLASSES_MIN;
	public static final long J9VMGC_SIZECLASSES_MIN_SMALL;
	public static final long J9VMGC_SIZECLASSES_MULTI_FREE;
	public static final long J9VMGC_SIZECLASSES_NUM_SMALL;
	public static final long J9VMGC_SIZECLASSES_SINGLE_FREE;
	public static final long J9_BCLOOP_CHECK_ASYNC;
	public static final long J9_BCLOOP_ENTER_METHOD_MONITOR;
	public static final long J9_BCLOOP_EXECUTE_BYTECODE;
	public static final long J9_BCLOOP_EXIT_INTERPRETER;
	public static final long J9_BCLOOP_FILL_OSR_BUFFER;
	public static final long J9_BCLOOP_HANDLE_POP_FRAMES;
	public static final long J9_BCLOOP_I2J_TRANSITION;
	public static final long J9_BCLOOP_J2I_INVOKE_EXACT;
	public static final long J9_BCLOOP_J2I_TRANSITION;
	public static final long J9_BCLOOP_J2I_VIRTUAL;
	public static final long J9_BCLOOP_JUMP_BYTECODE_PROTOTYPE;
	public static final long J9_BCLOOP_LOAD_PRESERVED_AND_BRANCH;
	public static final long J9_BCLOOP_REPORT_METHOD_ENTER;
	public static final long J9_BCLOOP_RETURN_FROM_JIT;
	public static final long J9_BCLOOP_RETURN_FROM_JIT_CTOR;
	public static final long J9_BCLOOP_RUN_EXCEPTION_HANDLER;
	public static final long J9_BCLOOP_RUN_JNI_NATIVE;
	public static final long J9_BCLOOP_RUN_METHOD;
	public static final long J9_BCLOOP_RUN_METHOD_COMPILED;
	public static final long J9_BCLOOP_RUN_METHOD_HANDLE;
	public static final long J9_BCLOOP_RUN_METHOD_HANDLE_COMPILED;
	public static final long J9_BCLOOP_RUN_METHOD_INTERPRETED;
	public static final long J9_BCLOOP_SEND_TARGET_SHIFT;
	public static final long J9_BCLOOP_SEND_TARGET_TAG;
	public static final long J9_BCLOOP_STACK_OVERFLOW;
	public static final long J9_BCLOOP_THROW_CURRENT_EXCEPTION;
	public static final long J9_CHECK_ASYNC_NO_ACTION;
	public static final long J9_CHECK_ASYNC_POP_FRAMES;
	public static final long J9_CHECK_ASYNC_THROW_EXCEPTION;
	public static final long J9_EXCEPTION_INDEX_MASK;
	public static final long J9_EXCEPTION_INDEX_SHIFT;
	public static final long J9_EXCEPT_SEARCH_JAVA_HANDLER;
	public static final long J9_EXCEPT_SEARCH_JIT_HANDLER;
	public static final long J9_EXCEPT_SEARCH_JNI_HANDLER;
	public static final long J9_EXCEPT_SEARCH_NO_HANDLER;
	public static final long J9_EXCEPT_SEARCH_NO_UNWIND;
	public static final long J9_EXTENDED_RUNTIME2_COMPRESS_OBJECT_REFERENCES;
	public static final long J9_EXTENDED_RUNTIME_ALLOW_APPLICATION_CONTENDED_FIELDS;
	public static final long J9_EXTENDED_RUNTIME_ALLOW_CONTENDED_FIELDS;
	public static final long J9_EXTENDED_RUNTIME_ALLOW_NON_VIRTUAL_CALLS;
	public static final long J9_EXTENDED_RUNTIME_ALWAYS_USE_JNI_CRITICAL;
	public static final long J9_EXTENDED_RUNTIME_CHECK_DEBUG_INFO_COMPRESSION;
	public static final long J9_EXTENDED_RUNTIME_CLASSLOADER_LOCKING_ENABLED;
	public static final long J9_EXTENDED_RUNTIME_CLASS_OBJECT_ASSIGNED;
	public static final long J9_EXTENDED_RUNTIME_DEBUG_MODE;
	public static final long J9_EXTENDED_RUNTIME_DEBUG_VM_ACCESS;
	public static final long J9_EXTENDED_RUNTIME_DISABLE_FAST_CLASS_HASH_TABLE;
	public static final long J9_EXTENDED_RUNTIME_ENABLE_CPU_MONITOR;
	public static final long J9_EXTENDED_RUNTIME_ENABLE_HCR;
	public static final long J9_EXTENDED_RUNTIME_FAST_CLASS_HASH_TABLE;
	public static final long J9_EXTENDED_RUNTIME_FLAG_JSCRATCH_ADV_ON_FREE;
	public static final long J9_EXTENDED_RUNTIME_FORCE_CLASSFILE_AS_INTERMEDIATE_DATA;
	public static final long J9_EXTENDED_RUNTIME_FOUND_JAVA_ASSERT_OPTION;
	public static final long J9_EXTENDED_RUNTIME_HANDLE_SIGXFSZ;
	public static final long J9_EXTENDED_RUNTIME_I2J_MH_TRANSITION_ENABLED;
	public static final long J9_EXTENDED_RUNTIME_LAZY_SYMBOL_RESOLUTION;
	public static final long J9_EXTENDED_RUNTIME_METHOD_TRACE_ENABLED;
	public static final long J9_EXTENDED_RUNTIME_OSR_SAFE_POINT;
	public static final long J9_EXTENDED_RUNTIME_OSR_SAFE_POINT_FV;
	public static final long J9_EXTENDED_RUNTIME_PAGE_ALIGN_DIRECT_MEMORY;
	public static final long J9_EXTENDED_RUNTIME_POSITIVE_HASHCODE;
	public static final long J9_EXTENDED_RUNTIME_RECREATE_CLASSFILE_ONLOAD;
	public static final long J9_EXTENDED_RUNTIME_REDUCE_CPU_MONITOR_OVERHEAD;
	public static final long J9_EXTENDED_RUNTIME_RESTRICT_IFA;
	public static final long J9_EXTENDED_RUNTIME_SET_HW_PREFETCH;
	public static final long J9_EXTENDED_RUNTIME_USE_J9JIMAGE_READER;
	public static final long J9_EXTENDED_RUNTIME_USE_VECTOR_REGISTERS;
	public static final long J9_EX_CTOR_CLASS;
	public static final long J9_EX_CTOR_CLASS_CLASS;
	public static final long J9_EX_CTOR_INT;
	public static final long J9_EX_CTOR_STRING;
	public static final long J9_EX_CTOR_THROWABLE;
	public static final long J9_EX_CTOR_TYPE_MASK;
	public static final long J9_EX_OOM_JAVA_HEAP;
	public static final long J9_EX_OOM_OS_HEAP;
	public static final long J9_EX_OOM_SHIFT;
	public static final long J9_EX_OOM_THREAD;
	public static final long J9_EX_OOM_TYPE_MASK;
	public static final long J9_FINDCLASS_FLAG_ANON;
	public static final long J9_FINDCLASS_FLAG_CHECK_PKG_ACCESS;
	public static final long J9_FINDCLASS_FLAG_EXISTING_ONLY;
	public static final long J9_FINDCLASS_FLAG_FAST_HCR;
	public static final long J9_FINDCLASS_FLAG_FIND_MODULE_ON_FAIL;
	public static final long J9_FINDCLASS_FLAG_NO_CHECK_FOR_EXISTING_CLASS;
	public static final long J9_FINDCLASS_FLAG_NO_DEBUG_EVENTS;
	public static final long J9_FINDCLASS_FLAG_NO_ISOLATION;
	public static final long J9_FINDCLASS_FLAG_NO_SUBCLASS_LINK;
	public static final long J9_FINDCLASS_FLAG_REDEFINING;
	public static final long J9_FINDCLASS_FLAG_RETRANSFORMING;
	public static final long J9_FINDCLASS_FLAG_SHRC_ROMCLASS_EXISTS;
	public static final long J9_FINDCLASS_FLAG_THROW_ON_FAIL;
	public static final long J9_FINDCLASS_FLAG_UNSAFE;
	public static final long J9_FINDCLASS_FLAG_USE_LOADER_CP_ENTRIES;
	public static final long J9_FINDKNOWNCLASS_FLAG_EXISTING_ONLY;
	public static final long J9_FINDKNOWNCLASS_FLAG_INITIALIZE;
	public static final long J9_FINDKNOWNCLASS_FLAG_NON_FATAL;
	public static final long J9_GC_ARRAYLET_LAYOUT_DATA_IN_SPINE_BIT;
	public static final long J9_GC_ARRAYLET_LAYOUT_DISCONTIGUOUS_BIT;
	public static final long J9_GC_ARRAYLET_LAYOUT_MASK;
	public static final long J9_GC_ARRAYLET_MINIMUM_ALIGNMENT;
	public static final long J9_GC_COLLECT_REF_PHANTOM;
	public static final long J9_GC_COLLECT_REF_SOFT;
	public static final long J9_GC_COLLECT_REF_WEAK;
	public static final long J9_GC_MARK_MAP_LOG_SIZEOF_UDATA;
	public static final long J9_GC_MARK_MAP_UDATA_MASK;
	public static final long J9_GC_MINIMUM_OBJECT_SIZE;
	public static final long J9_GC_MULTI_SLOT_HOLE;
	public static final long J9_GC_OBJ_HEAP_HOLE;
	public static final long J9_GC_OBJ_HEAP_HOLE_MASK;
	public static final long J9_GC_SINGLE_SLOT_HOLE;
	public static final long J9_IDLE_TUNING_COMPACT_ON_IDLE;
	public static final long J9_IDLE_TUNING_GC_ON_IDLE;
	public static final long J9_IDLE_TUNING_IGNORE_UNRECOGNIZED_OPTIONS;
	public static final long J9_INLINE_JNI_MAX_ARG_COUNT;
	public static final long J9_ITABLE_INDEX_METHOD_INDEX;
	public static final long J9_ITABLE_INDEX_OBJECT;
	public static final long J9_ITABLE_INDEX_SHIFT;
	public static final long J9_ITABLE_INDEX_TAG_BITS;
	public static final long J9_ITABLE_INDEX_UNRESOLVED;
	public static final long J9_ITABLE_OFFSET_DIRECT;
	public static final long J9_ITABLE_OFFSET_TAG_BITS;
	public static final long J9_ITABLE_OFFSET_VIRTUAL;
	public static final long J9_JAVA_CLASS_ARRAY;
	public static final long J9_JAVA_CLASS_DEPTH_MASK;
	public static final long J9_JAVA_CLASS_DYING;
	public static final long J9_JAVA_CLASS_GC_SPECIAL;
	public static final long J9_JAVA_CLASS_HOT_SWAPPED_OUT;
	public static final long J9_JAVA_CLASS_RAM_ARRAY;
	public static final long J9_JAVA_CLASS_RAM_SHAPE_SHIFT;
	public static final long J9_JAVA_CLASS_REFERENCE_MASK;
	public static final long J9_JAVA_INTERFACE;
	public static final long J9_JAVA_NATIVE;
	public static final long J9_JAVA_STATIC;
	public static final long J9_JCL_FLAG_COM_SUN_MANAGEMENT_PROP;
	public static final long J9_JCL_FLAG_FINALIZATION;
	public static final long J9_JCL_FLAG_JDK_MODULE_PATCH_PROP;
	public static final long J9_JCL_FLAG_REFERENCE_OBJECTS;
	public static final long J9_JCL_FLAG_THREADGROUPS;
	public static final long J9_JIT_DCE_AOT_METHOD_HEADER;
	public static final long J9_JIT_DCE_AOT_PERSISTENT_INFO;
	public static final long J9_JIT_DCE_EXCEPTION_INFO;
	public static final long J9_JIT_DCE_HASH_TABLE;
	public static final long J9_JIT_DCE_IN_USE;
	public static final long J9_JIT_DCE_MCC_HT_ENTRY;
	public static final long J9_JIT_DCE_RELOCATION_DATA;
	public static final long J9_JIT_DCE_STACK_ATLAS;
	public static final long J9_JIT_DCE_THUNK_MAPPING;
	public static final long J9_JIT_DCE_THUNK_MAPPING_LIST;
	public static final long J9_JIT_DCE_UNALLOCATED;
	public static final long J9_JIT_METADATA_HAS_BYTECODE_PC;
	public static final long J9_JIT_METADATA_WIDE_EXCEPTIONS;
	public static final long J9_JIT_NEVER_TRANSLATE;
	public static final long J9_JIT_QUEUED_FOR_COMPILATION;
	public static final long J9_JIT_RESOLVE_FAIL_COMPILE;
	public static final long J9_JIT_RETURN_TYPES_SIZE;
	public static final long J9_JIT_TOGGLE_RI_IN_COMPILED_CODE;
	public static final long J9_JIT_TOGGLE_RI_ON_TRANSITION;
	public static final long J9_JIT_TRANSITION_METHOD_ENTER;
	public static final long J9_JIT_TRANSITION_METHOD_EXIT;
	public static final long J9_JNI_OFFLOAD_SWITCH_CREATE_JAVA_VM;
	public static final long J9_JNI_OFFLOAD_SWITCH_DEALLOCATE_VM_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_GC_DISPATCHER_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_GC_HELPER_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_ARRAY_ELEMENTS;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_ARRAY_REGION;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_STRING_CHARS;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_STRING_REGION;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_STRING_UTF_CHARS;
	public static final long J9_JNI_OFFLOAD_SWITCH_GET_STRING_UTF_REGION;
	public static final long J9_JNI_OFFLOAD_SWITCH_INTERPRETER;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_COMPILING_END;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_COMPILING_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_GC_CYCLE_FINISH;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_GC_CYCLE_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_INSTRUMENTABLE_OBJECT_ALLOC;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_VM_DUMP_END;
	public static final long J9_JNI_OFFLOAD_SWITCH_J9JVMTI_VM_DUMP_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_JIT_COMPILATION_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JIT_HARDWARE_PROFILER_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JIT_IPROFILER_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JIT_SAMPLER_THREAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_BREAKPOINT;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_FILE_LOAD_HOOK;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_LOAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_PREPARE;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_COMPILED_METHOD_LOAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_COMPILED_METHOD_UNLOAD;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_DATA_DUMP_REQUEST;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_DYNAMIC_CODE_GENERATED;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_EXCEPTION;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_EXCEPTION_CATCH;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_FIELD_ACCESS;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_FIELD_MODIFICATION;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_FRAME_POP;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_GC_FINISH;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_GC_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_METHOD_ENTRY;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_METHOD_EXIT;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_CONTENDED_ENTER;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_CONTENDED_ENTERED;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_WAIT;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_WAITED;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_NATIVE_METHOD_BIND;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_OBJECT_FREE;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_RESOURCE_EXHAUSTED;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_SINGLE_STEP;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_THREAD_END;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_THREAD_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_DEATH;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_INIT;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_OBJECT_ALLOC;
	public static final long J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_START;
	public static final long J9_JNI_OFFLOAD_SWITCH_NEW_STRING_UTF;
	public static final long J9_JNI_OFFLOAD_SWITCH_RELEASE_ARRAY_ELEMENTS;
	public static final long J9_JNI_OFFLOAD_SWITCH_SET_ARRAY_REGION;
	public static final long J9_JNI_OFFLOAD_SWITCH_THRESHOLD;
	public static final long J9_JNI_OFFLOAD_SWITCH_TRACE_SUBSCRIBER_THREAD;
	public static final long J9_LOOK_CLCONSTRAINTS;
	public static final long J9_LOOK_DIRECT_NAS;
	public static final long J9_LOOK_HANDLE_DEFAULT_METHOD_CONFLICTS;
	public static final long J9_LOOK_INTERFACE;
	public static final long J9_LOOK_JNI;
	public static final long J9_LOOK_NEW_INSTANCE;
	public static final long J9_LOOK_NO_CLIMB;
	public static final long J9_LOOK_NO_INTERFACE;
	public static final long J9_LOOK_NO_JLOBJECT;
	public static final long J9_LOOK_NO_THROW;
	public static final long J9_LOOK_PARTIAL_SIGNATURE;
	public static final long J9_LOOK_REFLECT_CALL;
	public static final long J9_LOOK_STATIC;
	public static final long J9_LOOK_VIRTUAL;
	public static final long J9_METHOD_ENTER_DEBUG_FRAME_BUILD;
	public static final long J9_METHOD_ENTER_DEBUG_METHOD_ENTER;
	public static final long J9_METHOD_ENTER_NEW_HOOK_INTERFACE;
	public static final long J9_METHOD_ENTER_PROFILER;
	public static final long J9_METHOD_ENTER_RASTRACE;
	public static final long J9_METHOD_HANDLE_COMPILE_CUSTOM;
	public static final long J9_METHOD_HANDLE_COMPILE_SHARED;
	public static final long J9_METHOD_HANDLE_COMPILE_SYNC;
	public static final long J9_METHOD_HANDLE_INVOCATION_COMPILE_COUNT;
	public static final long J9_METHOD_TYPE_ORIGIN_INVOKE;
	public static final long J9_METHOD_TYPE_ORIGIN_INVOKE_EXACT;
	public static final long J9_METHOD_TYPE_ORIGIN_LDC;
	public static final long J9_MODULE_NAME_IS_J9UTF8;
	public static final long J9_NATIVE_LIBRARY_SWITCH_JDBC;
	public static final long J9_NATIVE_LIBRARY_SWITCH_REQUIRED;
	public static final long J9_NATIVE_METHOD_BIND_ALLOW_JNI;
	public static final long J9_NATIVE_METHOD_BIND_CAN_RUN_JAVA_CODE;
	public static final long J9_NATIVE_METHOD_BIND_FAIL;
	public static final long J9_NATIVE_METHOD_BIND_OUT_OF_MEMORY;
	public static final long J9_NATIVE_METHOD_BIND_RECURSIVE;
	public static final long J9_NATIVE_METHOD_BIND_SUCCESS;
	public static final long J9_NATIVE_TYPE_BOOLEAN;
	public static final long J9_NATIVE_TYPE_BYTE;
	public static final long J9_NATIVE_TYPE_CHAR;
	public static final long J9_NATIVE_TYPE_CLASS;
	public static final long J9_NATIVE_TYPE_DOUBLE;
	public static final long J9_NATIVE_TYPE_FLOAT;
	public static final long J9_NATIVE_TYPE_INT;
	public static final long J9_NATIVE_TYPE_LONG;
	public static final long J9_NATIVE_TYPE_OBJECT;
	public static final long J9_NATIVE_TYPE_SHORT;
	public static final long J9_NATIVE_TYPE_VOID;
	public static final long J9_OBJECT_DESCRIPTION_SIZE;
	public static final long J9_OBJECT_HEADER_AGE_DEFAULT;
	public static final long J9_OBJECT_HEADER_INDEXABLE;
	public static final long J9_OBJECT_HEADER_REMEMBERED_BITS_TO_SET;
	public static final long J9_OBJECT_HEADER_REMEMBERED_MASK_FOR_CLEAR;
	public static final long J9_OBJECT_HEADER_REMEMBERED_MASK_FOR_TEST;
	public static final long J9_OBJECT_HEADER_SHAPE_MASK;
	public static final long J9_OBJECT_HEADER_STACK_ALLOCATED;
	public static final long J9_PRIVATE_FLAGS2_UNSAFE_HANDLE_SIGBUS;
	public static final long J9_PRIVATE_FLAGS_ATTACHED_THREAD;
	public static final long J9_PRIVATE_FLAGS_CLOAD_NO_MEM;
	public static final long J9_PRIVATE_FLAGS_CONCURRENT_MARK_ACTIVE;
	public static final long J9_PRIVATE_FLAGS_CONSTRUCTING_EXCEPTION;
	public static final long J9_PRIVATE_FLAGS_DAEMON_THREAD;
	public static final long J9_PRIVATE_FLAGS_FAILED_LOADING_REQUIRED_CLASS;
	public static final long J9_PRIVATE_FLAGS_FILL_EXISTING_TRACE;
	public static final long J9_PRIVATE_FLAGS_FINAL_CALL_OUT_OF_MEMORY;
	public static final long J9_PRIVATE_FLAGS_FREE_OS_THREAD;
	public static final long J9_PRIVATE_FLAGS_IN_RESOLVE;
	public static final long J9_PRIVATE_FLAGS_LOADING_KNOWN_CLASS;
	public static final long J9_PRIVATE_FLAGS_NO_EXCEPTION_IN_START_JAVA_THREAD;
	public static final long J9_PRIVATE_FLAGS_NO_OBJECT;
	public static final long J9_PRIVATE_FLAGS_OSR_IN_PROGRESS;
	public static final long J9_PRIVATE_FLAGS_OUT_OF_MEMORY;
	public static final long J9_PRIVATE_FLAGS_REALTIME_THREAD;
	public static final long J9_PRIVATE_FLAGS_REPORT_ERROR_LOADING_CLASS;
	public static final long J9_PRIVATE_FLAGS_REPORT_EXCEPTION_THROW;
	public static final long J9_PRIVATE_FLAGS_RI_INITIALIZED;
	public static final long J9_PRIVATE_FLAGS_SCAV;
	public static final long J9_PRIVATE_FLAGS_SKIP_THREAD_SIGNAL_PROTECTION;
	public static final long J9_PRIVATE_FLAGS_STACKS_OUT_OF_SYNC;
	public static final long J9_PRIVATE_FLAGS_STACK_OVERFLOW;
	public static final long J9_PRIVATE_FLAGS_SYSTEM_THREAD;
	public static final long J9_PRIVATE_FLAGS_USE_BOOTSTRAP_LOADER;
	public static final long J9_PRIVATE_FLAGS_WALKED_FOR_CCR;
	public static final long J9_PUBLIC_FLAGS_DEBUG_VM_ACCESS;
	public static final long J9_PUBLIC_FLAGS_EXCLUSIVE_RESPONSE_MASK;
	public static final long J9_PUBLIC_FLAGS_HALTED_AT_SAFE_POINT;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_ANY;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_ANY_NO_JAVA_SUSPEND;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_EXCLUSIVE;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_INSPECTION;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_JAVA_SUSPEND;
	public static final long J9_PUBLIC_FLAGS_HALT_THREAD_SUSPEND_ANY;
	public static final long J9_PUBLIC_FLAGS_HALT_VM_DUTIES;
	public static final long J9_PUBLIC_FLAGS_JNI_CRITICAL_ACCESS;
	public static final long J9_PUBLIC_FLAGS_JNI_CRITICAL_REGION;
	public static final long J9_PUBLIC_FLAGS_NOT_AT_SAFE_POINT;
	public static final long J9_PUBLIC_FLAGS_POP_FRAMES_INTERRUPT;
	public static final long J9_PUBLIC_FLAGS_QUEUED_FOR_EXCLUSIVE;
	public static final long J9_PUBLIC_FLAGS_RELEASE_ACCESS_REQUIRED_MASK;
	public static final long J9_PUBLIC_FLAGS_REQUEST_SAFE_POINT;
	public static final long J9_PUBLIC_FLAGS_STOP;
	public static final long J9_PUBLIC_FLAGS_STOPPED;
	public static final long J9_PUBLIC_FLAGS_THREAD_BLOCKED;
	public static final long J9_PUBLIC_FLAGS_THREAD_PARKED;
	public static final long J9_PUBLIC_FLAGS_THREAD_SLEEPING;
	public static final long J9_PUBLIC_FLAGS_THREAD_TIMED;
	public static final long J9_PUBLIC_FLAGS_THREAD_WAITING;
	public static final long J9_PUBLIC_FLAGS_VMACCESS_ACQUIRE_BITS;
	public static final long J9_PUBLIC_FLAGS_VMACCESS_OUTOFLINE_MASK;
	public static final long J9_PUBLIC_FLAGS_VMACCESS_RELEASE_BITS;
	public static final long J9_PUBLIC_FLAGS_VM_ACCESS;
	public static final long J9_RAS_MASK;
	public static final long J9_RAS_METHOD_SEEN;
	public static final long J9_RAS_METHOD_TRACE_ARGS;
	public static final long J9_RAS_METHOD_TRACING;
	public static final long J9_RAS_METHOD_TRIGGERING;
	public static final long J9_RAS_METHOD_UNSEEN;
	public static final long J9_REQUIRED_CLASS_ALIGNMENT;
	public static final long J9_REQUIRED_CLASS_SHIFT;
	public static final long J9_RESOLVE_FLAG_CHECK_CLINIT;
	public static final long J9_RESOLVE_FLAG_FIELD_SETTER;
	public static final long J9_RESOLVE_FLAG_INIT_CLASS;
	public static final long J9_RESOLVE_FLAG_INSTANTIABLE;
	public static final long J9_RESOLVE_FLAG_JCL_CONSTANT_POOL;
	public static final long J9_RESOLVE_FLAG_JIT_COMPILE_TIME;
	public static final long J9_RESOLVE_FLAG_NO_CLASS_INIT;
	public static final long J9_RESOLVE_FLAG_NO_THROW_ON_FAIL;
	public static final long J9_RESOLVE_FLAG_REDEFINE_CLASS;
	public static final long J9_RESOLVE_FLAG_RUNTIME_RESOLVE;
	public static final long J9_RESOLVE_STATIC_FIELD_TAG_FROM_CLINIT;
	public static final long J9_RESOLVE_STATIC_FIELD_TAG_IS_ISOLATED;
	public static final long J9_RUNTIME_AGGRESSIVE;
	public static final long J9_RUNTIME_ALWAYS_COPY_JNI_CRITICAL;
	public static final long J9_RUNTIME_ARGENCODING_LATIN;
	public static final long J9_RUNTIME_ARGENCODING_UNICODE;
	public static final long J9_RUNTIME_ARGENCODING_UTF8;
	public static final long J9_RUNTIME_CLEANUP;
	public static final long J9_RUNTIME_DISABLE_VM_SHUTDOWN;
	public static final long J9_RUNTIME_EXIT_STARTED;
	public static final long J9_RUNTIME_EXTENDED_METHOD_BLOCK;
	public static final long J9_RUNTIME_INITIALIZED;
	public static final long J9_RUNTIME_JAVA_BASE_MODULE_CREATED;
	public static final long J9_RUNTIME_JIT_ACTIVE;
	public static final long J9_RUNTIME_NO_PRIORITIES;
	public static final long J9_RUNTIME_OMIT_STACK_TRACES;
	public static final long J9_RUNTIME_PAINT_STACK;
	public static final long J9_RUNTIME_REPORT_STACK_USE;
	public static final long J9_RUNTIME_SHOW_VERSION;
	public static final long J9_RUNTIME_SHUTDOWN;
	public static final long J9_RUNTIME_SHUTDOWN_STARTED;
	public static final long J9_RUNTIME_SNIFF_AND_WHACK;
	public static final long J9_RUNTIME_STACK_FILL;
	public static final long J9_RUNTIME_STRING_BYTE_ARRAY;
	public static final long J9_RUNTIME_TUNE_VIRTUALIZED;
	public static final long J9_RUNTIME_VERIFY;
	public static final long J9_RUNTIME_XFUTURE;
	public static final long J9_SIGBYTE_ARRAY;
	public static final long J9_SIGBYTE_BOOLEAN;
	public static final long J9_SIGBYTE_BYTE;
	public static final long J9_SIGBYTE_CHAR;
	public static final long J9_SIGBYTE_DOUBLE;
	public static final long J9_SIGBYTE_FLOAT;
	public static final long J9_SIGBYTE_INT;
	public static final long J9_SIGBYTE_LONG;
	public static final long J9_SIGBYTE_OBJECT;
	public static final long J9_SIGBYTE_OBJECT_END;
	public static final long J9_SIGBYTE_SHORT;
	public static final long J9_SIGBYTE_SIG_BEGIN;
	public static final long J9_SIGBYTE_SIG_END;
	public static final long J9_SIGBYTE_VOID;
	public static final long J9_SIG_NO_SIG_CHAIN;
	public static final long J9_SIG_NO_SIG_INT;
	public static final long J9_SIG_NO_SIG_QUIT;
	public static final long J9_SIG_PERCOLATE_CONDITIONS;
	public static final long J9_SIG_POSIX_COOPERATIVE_SHUTDOWN;
	public static final long J9_SIG_XRS_ASYNC;
	public static final long J9_SIG_XRS_SYNC;
	public static final long J9_SIG_ZOS_CEEHDLR;
	public static final long J9_SLOT_VALIDATE_ERROR_INVALID_SLOT;
	public static final long J9_SLOT_VALIDATE_ERROR_LOCAL_MAP_ERROR;
	public static final long J9_SLOT_VALIDATE_ERROR_LOCAL_MAP_MISMATCH;
	public static final long J9_SLOT_VALIDATE_ERROR_NATIVE_METHOD;
	public static final long J9_SLOT_VALIDATE_ERROR_NONE;
	public static final long J9_SLOT_VALIDATE_ERROR_OUT_OF_MEMORY;
	public static final long J9_SLOT_VALIDATE_ERROR_TYPE_MISMATCH;
	public static final long J9_SPECIAL_SPLIT_TABLE_INDEX_FLAG;
	public static final long J9_SPLIT_TABLE_INDEX_MASK;
	public static final long J9_SSF_CALL_OUT_FRAME_ALLOC;
	public static final long J9_SSF_CO_REF_SLOT_CNT;
	public static final long J9_SSF_EXIT_TRC_L3;
	public static final long J9_SSF_JIT_CALLIN;
	public static final long J9_SSF_JIT_CALLIN_METHODTYPE;
	public static final long J9_SSF_JIT_JNI_CALLOUT;
	public static final long J9_SSF_JIT_JNI_FRAME_COLLAPSE_BITS;
	public static final long J9_SSF_JIT_NATIVE_TRANSITION_FRAME;
	public static final long J9_SSF_JIT_RESOLVE;
	public static final long J9_SSF_JIT_RESOLVE_ALLOCATION;
	public static final long J9_SSF_JIT_RESOLVE_BEFORE_ANEWARRAY;
	public static final long J9_SSF_JIT_RESOLVE_BEFORE_MULTIANEWARRAY;
	public static final long J9_SSF_JIT_RESOLVE_DATA;
	public static final long J9_SSF_JIT_RESOLVE_INDUCE_OSR;
	public static final long J9_SSF_JIT_RESOLVE_INTERFACE_LOOKUP;
	public static final long J9_SSF_JIT_RESOLVE_INTERFACE_METHOD;
	public static final long J9_SSF_JIT_RESOLVE_MON_ENT;
	public static final long J9_SSF_JIT_RESOLVE_RECOMPILATION;
	public static final long J9_SSF_JIT_RESOLVE_RUNTIME_HELPER;
	public static final long J9_SSF_JIT_RESOLVE_SPECIAL_METHOD;
	public static final long J9_SSF_JIT_RESOLVE_STACK_OVERFLOW;
	public static final long J9_SSF_JIT_RESOLVE_STATIC_METHOD;
	public static final long J9_SSF_JIT_RESOLVE_VIRTUAL_METHOD;
	public static final long J9_SSF_JNI_PUSHED_REF_COUNT_MASK;
	public static final long J9_SSF_JNI_REFS_REDIRECTED;
	public static final long J9_SSF_METHOD_ENTRY;
	public static final long J9_SSF_REL_VM_ACC;
	public static final long J9_SSF_RETURNS_OBJECT;
	public static final long J9_SSF_USE_SPEC_CL;
	public static final long J9_STACKWALK_CACHE_ALLOCATED;
	public static final long J9_STACKWALK_CACHE_CPS;
	public static final long J9_STACKWALK_CACHE_MASK;
	public static final long J9_STACKWALK_CACHE_PCS;
	public static final long J9_STACKWALK_CHECK_I_SLOTS_FOR_OBJECTS;
	public static final long J9_STACKWALK_COUNT_SPECIFIED;
	public static final long J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK;
	public static final long J9_STACKWALK_HIDE_EXCEPTION_FRAMES;
	public static final long J9_STACKWALK_INCLUDE_CALL_IN_FRAMES;
	public static final long J9_STACKWALK_INCLUDE_NATIVES;
	public static final long J9_STACKWALK_ITERATE_FRAMES;
	public static final long J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES;
	public static final long J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS;
	public static final long J9_STACKWALK_ITERATE_O_SLOTS;
	public static final long J9_STACKWALK_KEEP_ITERATING;
	public static final long J9_STACKWALK_LINEAR;
	public static final long J9_STACKWALK_MAINTAIN_REGISTER_MAP;
	public static final long J9_STACKWALK_RC_BAD_STATE_BUFFER;
	public static final long J9_STACKWALK_RC_FRAME_NOT_FOUND;
	public static final long J9_STACKWALK_RC_NONE;
	public static final long J9_STACKWALK_RC_NO_MEMORY;
	public static final long J9_STACKWALK_RC_STACK_CORRUPT;
	public static final long J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
	public static final long J9_STACKWALK_RESUME;
	public static final long J9_STACKWALK_SAVE_STACKED_REGISTERS;
	public static final long J9_STACKWALK_SKIP_INLINES;
	public static final long J9_STACKWALK_START_AT_JIT_FRAME;
	public static final long J9_STACKWALK_STOP_ITERATING;
	public static final long J9_STACKWALK_VISIBLE_ONLY;
	public static final long J9_STACKWALK_WALK_TRANSLATE_PC;
	public static final long J9_STACK_OVERFLOW_AND_HEADER_SIZE;
	public static final long J9_STACK_OVERFLOW_RESERVED_SIZE;
	public static final long J9_STARTPC_DLT_READY;
	public static final long J9_STARTPC_JNI_NATIVE;
	public static final long J9_STARTPC_METHOD_BREAKPOINTED;
	public static final long J9_STARTPC_METHOD_IS_OVERRIDDEN;
	public static final long J9_STARTPC_NATIVE_REQUIRES_SWITCHING;
	public static final long J9_STARTPC_NOT_TRANSLATED;
	public static final long J9_STARTPC_STATUS;
	public static final long J9_STATIC_SPLIT_TABLE_INDEX_FLAG;
	public static final long J9_STR_ANON_CLASS_NAME;
	public static final long J9_STR_INSTRUMENTABLE;
	public static final long J9_STR_INTERN;
	public static final long J9_STR_NONE;
	public static final long J9_STR_TENURE;
	public static final long J9_STR_UNICODE;
	public static final long J9_STR_XLAT;
	public static final long J9_SUN_FIELD_OFFSET_MASK;
	public static final long J9_SUN_STATIC_FIELD_OFFSET_TAG;
	public static final long J9_THREAD_START_FAILED_LOCK_OBJECT_ALLOCATION;
	public static final long J9_THREAD_START_FAILED_OOM_ALLOCATION;
	public static final long J9_THREAD_START_FAILED_TO_FORK_THREAD;
	public static final long J9_THREAD_START_FAILED_VMTHREAD_ALLOC;
	public static final long J9_THREAD_START_NO_ERROR;
	public static final long J9_THREAD_START_THROW_CURRENT_EXCEPTION;
	public static final long J9_THREAD_START_UNSPECIFIED_ERROR;
	public static final long J9_VERIFY_BOOTCLASSPATH_STATIC;
	public static final long J9_VERIFY_DO_PROTECTED_ACCESS_CHECK;
	public static final long J9_VERIFY_ERROR_DETAILS;
	public static final long J9_VERIFY_EXCLUDE_ATTRIBUTE;
	public static final long J9_VERIFY_IGNORE_STACK_MAPS;
	public static final long J9_VERIFY_NO_FALLBACK;
	public static final long J9_VERIFY_OPTIMIZE;
	public static final long J9_VERIFY_SKIP_BOOTSTRAP_CLASSES;
	public static final long J9_VERIFY_VERBOSE_VERIFICATION;
	public static final long J9_XACCESS_EXCLUSIVE;
	public static final long J9_XACCESS_HANDED_OFF;
	public static final long J9_XACCESS_HANDING_OFF;
	public static final long J9_XACCESS_HANDING_OFF_FROM_EXTERNAL_THREAD;
	public static final long J9_XACCESS_NONE;
	public static final long J9_XACCESS_PENDING;
	public static final long PREVIEW_MINOR_VERSION;
	public static final long STRICT_FIELDS_MAJOR_VERSION;
	public static final long VALUE_TYPES_MAJOR_VERSION;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		BCV_ERR_ARGUMENTS_MISMATCH = 0;
		BCV_ERR_ARRAY_ARITY_OVERFLOW = 0;
		BCV_ERR_ARRAY_DIMENSION_MISMATCH = 0;
		BCV_ERR_BAD_ACCESS_PROTECTED = 0;
		BCV_ERR_BAD_BYTECODE = 0;
		BCV_ERR_BAD_INIT_OBJECT = 0;
		BCV_ERR_BAD_INVOKESPECIAL = 0;
		BCV_ERR_DEAD_CODE = 0;
		BCV_ERR_EXPECT_STACKMAP_FRAME = 0;
		BCV_ERR_FRAMES_INCOMPATIBLE_TYPE = 0;
		BCV_ERR_INACCESSIBLE_CLASS = 0;
		BCV_ERR_INCOMPATIBLE_TYPE = 0;
		BCV_ERR_INIT_NOT_CALL_INIT = 0;
		BCV_ERR_INSUFFICIENT_MEMORY = 0;
		BCV_ERR_INTERNAL_ERROR = 0;
		BCV_ERR_INVALID_ARRAY_REFERENCE = 0;
		BCV_ERR_JSR_ILLEGAL_LOAD_OPERATION = 0;
		BCV_ERR_JSR_RET_ADDRESS_ON_STACK = 0;
		BCV_ERR_JSR_STACK_OVERFLOW = 0;
		BCV_ERR_JSR_STACK_UNDERFLOW = 0;
		BCV_ERR_NO_STACKMAP_FRAME = 0;
		BCV_ERR_STACKMAP_FRAME_LOCALS_OVERFLOW = 0;
		BCV_ERR_STACKMAP_FRAME_LOCALS_UNDERFLOW = 0;
		BCV_ERR_STACKMAP_FRAME_STACK_OVERFLOW = 0;
		BCV_ERR_STACK_OVERFLOW = 0;
		BCV_ERR_STACK_SIZE_MISMATCH = 0;
		BCV_ERR_STACK_UNDERFLOW = 0;
		BCV_ERR_UNEXPECTED_EOF = 0;
		BCV_ERR_UNUSED_19 = 0;
		BCV_ERR_WRONG_RETURN_TYPE = 0;
		BCV_ERR_WRONG_STACKMAP_FRAME = 0;
		BCV_ERR_WRONG_TOP_TYPE = 0;
		BCV_FAIL = 0;
		BCV_NOT_FOUND = 0;
		BCV_SUCCESS = 0;
		J9VMGC_SIZECLASSES_ARRAYLET = 0;
		J9VMGC_SIZECLASSES_LARGE = 0;
		J9VMGC_SIZECLASSES_LOG_LARGEST = 0;
		J9VMGC_SIZECLASSES_LOG_SMALLEST = 0;
		J9VMGC_SIZECLASSES_MAX = 0;
		J9VMGC_SIZECLASSES_MAX_SMALL = 0;
		J9VMGC_SIZECLASSES_MAX_SMALL_SIZE_BYTES = 0;
		J9VMGC_SIZECLASSES_MAX_SMALL_SLOT_COUNT = 0;
		J9VMGC_SIZECLASSES_MIN = 0;
		J9VMGC_SIZECLASSES_MIN_SMALL = 0;
		J9VMGC_SIZECLASSES_MULTI_FREE = 0;
		J9VMGC_SIZECLASSES_NUM_SMALL = 0;
		J9VMGC_SIZECLASSES_SINGLE_FREE = 0;
		J9_BCLOOP_CHECK_ASYNC = 0;
		J9_BCLOOP_ENTER_METHOD_MONITOR = 0;
		J9_BCLOOP_EXECUTE_BYTECODE = 0;
		J9_BCLOOP_EXIT_INTERPRETER = 0;
		J9_BCLOOP_FILL_OSR_BUFFER = 0;
		J9_BCLOOP_HANDLE_POP_FRAMES = 0;
		J9_BCLOOP_I2J_TRANSITION = 0;
		J9_BCLOOP_J2I_INVOKE_EXACT = 0;
		J9_BCLOOP_J2I_TRANSITION = 0;
		J9_BCLOOP_J2I_VIRTUAL = 0;
		J9_BCLOOP_JUMP_BYTECODE_PROTOTYPE = 0;
		J9_BCLOOP_LOAD_PRESERVED_AND_BRANCH = 0;
		J9_BCLOOP_REPORT_METHOD_ENTER = 0;
		J9_BCLOOP_RETURN_FROM_JIT = 0;
		J9_BCLOOP_RETURN_FROM_JIT_CTOR = 0;
		J9_BCLOOP_RUN_EXCEPTION_HANDLER = 0;
		J9_BCLOOP_RUN_JNI_NATIVE = 0;
		J9_BCLOOP_RUN_METHOD = 0;
		J9_BCLOOP_RUN_METHOD_COMPILED = 0;
		J9_BCLOOP_RUN_METHOD_HANDLE = 0;
		J9_BCLOOP_RUN_METHOD_HANDLE_COMPILED = 0;
		J9_BCLOOP_RUN_METHOD_INTERPRETED = 0;
		J9_BCLOOP_SEND_TARGET_SHIFT = 0;
		J9_BCLOOP_SEND_TARGET_TAG = 0;
		J9_BCLOOP_STACK_OVERFLOW = 0;
		J9_BCLOOP_THROW_CURRENT_EXCEPTION = 0;
		J9_CHECK_ASYNC_NO_ACTION = 0;
		J9_CHECK_ASYNC_POP_FRAMES = 0;
		J9_CHECK_ASYNC_THROW_EXCEPTION = 0;
		J9_EXCEPTION_INDEX_MASK = 0;
		J9_EXCEPTION_INDEX_SHIFT = 0;
		J9_EXCEPT_SEARCH_JAVA_HANDLER = 0;
		J9_EXCEPT_SEARCH_JIT_HANDLER = 0;
		J9_EXCEPT_SEARCH_JNI_HANDLER = 0;
		J9_EXCEPT_SEARCH_NO_HANDLER = 0;
		J9_EXCEPT_SEARCH_NO_UNWIND = 0;
		J9_EXTENDED_RUNTIME2_COMPRESS_OBJECT_REFERENCES = 0;
		J9_EXTENDED_RUNTIME_ALLOW_APPLICATION_CONTENDED_FIELDS = 0;
		J9_EXTENDED_RUNTIME_ALLOW_CONTENDED_FIELDS = 0;
		J9_EXTENDED_RUNTIME_ALLOW_NON_VIRTUAL_CALLS = 0;
		J9_EXTENDED_RUNTIME_ALWAYS_USE_JNI_CRITICAL = 0;
		J9_EXTENDED_RUNTIME_CHECK_DEBUG_INFO_COMPRESSION = 0;
		J9_EXTENDED_RUNTIME_CLASSLOADER_LOCKING_ENABLED = 0;
		J9_EXTENDED_RUNTIME_CLASS_OBJECT_ASSIGNED = 0;
		J9_EXTENDED_RUNTIME_DEBUG_MODE = 0;
		J9_EXTENDED_RUNTIME_DEBUG_VM_ACCESS = 0;
		J9_EXTENDED_RUNTIME_DISABLE_FAST_CLASS_HASH_TABLE = 0;
		J9_EXTENDED_RUNTIME_ENABLE_CPU_MONITOR = 0;
		J9_EXTENDED_RUNTIME_ENABLE_HCR = 0;
		J9_EXTENDED_RUNTIME_FAST_CLASS_HASH_TABLE = 0;
		J9_EXTENDED_RUNTIME_FLAG_JSCRATCH_ADV_ON_FREE = 0;
		J9_EXTENDED_RUNTIME_FORCE_CLASSFILE_AS_INTERMEDIATE_DATA = 0;
		J9_EXTENDED_RUNTIME_FOUND_JAVA_ASSERT_OPTION = 0;
		J9_EXTENDED_RUNTIME_HANDLE_SIGXFSZ = 0;
		J9_EXTENDED_RUNTIME_I2J_MH_TRANSITION_ENABLED = 0;
		J9_EXTENDED_RUNTIME_LAZY_SYMBOL_RESOLUTION = 0;
		J9_EXTENDED_RUNTIME_METHOD_TRACE_ENABLED = 0;
		J9_EXTENDED_RUNTIME_OSR_SAFE_POINT = 0;
		J9_EXTENDED_RUNTIME_OSR_SAFE_POINT_FV = 0;
		J9_EXTENDED_RUNTIME_PAGE_ALIGN_DIRECT_MEMORY = 0;
		J9_EXTENDED_RUNTIME_POSITIVE_HASHCODE = 0;
		J9_EXTENDED_RUNTIME_RECREATE_CLASSFILE_ONLOAD = 0;
		J9_EXTENDED_RUNTIME_REDUCE_CPU_MONITOR_OVERHEAD = 0;
		J9_EXTENDED_RUNTIME_RESTRICT_IFA = 0;
		J9_EXTENDED_RUNTIME_SET_HW_PREFETCH = 0;
		J9_EXTENDED_RUNTIME_USE_J9JIMAGE_READER = 0;
		J9_EXTENDED_RUNTIME_USE_VECTOR_REGISTERS = 0;
		J9_EX_CTOR_CLASS = 0;
		J9_EX_CTOR_CLASS_CLASS = 0;
		J9_EX_CTOR_INT = 0;
		J9_EX_CTOR_STRING = 0;
		J9_EX_CTOR_THROWABLE = 0;
		J9_EX_CTOR_TYPE_MASK = 0;
		J9_EX_OOM_JAVA_HEAP = 0;
		J9_EX_OOM_OS_HEAP = 0;
		J9_EX_OOM_SHIFT = 0;
		J9_EX_OOM_THREAD = 0;
		J9_EX_OOM_TYPE_MASK = 0;
		J9_FINDCLASS_FLAG_ANON = 0;
		J9_FINDCLASS_FLAG_CHECK_PKG_ACCESS = 0;
		J9_FINDCLASS_FLAG_EXISTING_ONLY = 0;
		J9_FINDCLASS_FLAG_FAST_HCR = 0;
		J9_FINDCLASS_FLAG_FIND_MODULE_ON_FAIL = 0;
		J9_FINDCLASS_FLAG_NO_CHECK_FOR_EXISTING_CLASS = 0;
		J9_FINDCLASS_FLAG_NO_DEBUG_EVENTS = 0;
		J9_FINDCLASS_FLAG_NO_ISOLATION = 0;
		J9_FINDCLASS_FLAG_NO_SUBCLASS_LINK = 0;
		J9_FINDCLASS_FLAG_REDEFINING = 0;
		J9_FINDCLASS_FLAG_RETRANSFORMING = 0;
		J9_FINDCLASS_FLAG_SHRC_ROMCLASS_EXISTS = 0;
		J9_FINDCLASS_FLAG_THROW_ON_FAIL = 0;
		J9_FINDCLASS_FLAG_UNSAFE = 0;
		J9_FINDCLASS_FLAG_USE_LOADER_CP_ENTRIES = 0;
		J9_FINDKNOWNCLASS_FLAG_EXISTING_ONLY = 0;
		J9_FINDKNOWNCLASS_FLAG_INITIALIZE = 0;
		J9_FINDKNOWNCLASS_FLAG_NON_FATAL = 0;
		J9_GC_ARRAYLET_LAYOUT_DATA_IN_SPINE_BIT = 0;
		J9_GC_ARRAYLET_LAYOUT_DISCONTIGUOUS_BIT = 0;
		J9_GC_ARRAYLET_LAYOUT_MASK = 0;
		J9_GC_ARRAYLET_MINIMUM_ALIGNMENT = 0;
		J9_GC_COLLECT_REF_PHANTOM = 0;
		J9_GC_COLLECT_REF_SOFT = 0;
		J9_GC_COLLECT_REF_WEAK = 0;
		J9_GC_MARK_MAP_LOG_SIZEOF_UDATA = 0;
		J9_GC_MARK_MAP_UDATA_MASK = 0;
		J9_GC_MINIMUM_OBJECT_SIZE = 0;
		J9_GC_MULTI_SLOT_HOLE = 0;
		J9_GC_OBJ_HEAP_HOLE = 0;
		J9_GC_OBJ_HEAP_HOLE_MASK = 0;
		J9_GC_SINGLE_SLOT_HOLE = 0;
		J9_IDLE_TUNING_COMPACT_ON_IDLE = 0;
		J9_IDLE_TUNING_GC_ON_IDLE = 0;
		J9_IDLE_TUNING_IGNORE_UNRECOGNIZED_OPTIONS = 0;
		J9_INLINE_JNI_MAX_ARG_COUNT = 0;
		J9_ITABLE_INDEX_METHOD_INDEX = 0;
		J9_ITABLE_INDEX_OBJECT = 0;
		J9_ITABLE_INDEX_SHIFT = 0;
		J9_ITABLE_INDEX_TAG_BITS = 0;
		J9_ITABLE_INDEX_UNRESOLVED = 0;
		J9_ITABLE_OFFSET_DIRECT = 0;
		J9_ITABLE_OFFSET_TAG_BITS = 0;
		J9_ITABLE_OFFSET_VIRTUAL = 0;
		J9_JAVA_CLASS_ARRAY = 0;
		J9_JAVA_CLASS_DEPTH_MASK = 0;
		J9_JAVA_CLASS_DYING = 0;
		J9_JAVA_CLASS_GC_SPECIAL = 0;
		J9_JAVA_CLASS_HOT_SWAPPED_OUT = 0;
		J9_JAVA_CLASS_RAM_ARRAY = 0;
		J9_JAVA_CLASS_RAM_SHAPE_SHIFT = 0;
		J9_JAVA_CLASS_REFERENCE_MASK = 0;
		J9_JAVA_INTERFACE = 0;
		J9_JAVA_NATIVE = 0;
		J9_JAVA_STATIC = 0;
		J9_JCL_FLAG_COM_SUN_MANAGEMENT_PROP = 0;
		J9_JCL_FLAG_FINALIZATION = 0;
		J9_JCL_FLAG_JDK_MODULE_PATCH_PROP = 0;
		J9_JCL_FLAG_REFERENCE_OBJECTS = 0;
		J9_JCL_FLAG_THREADGROUPS = 0;
		J9_JIT_DCE_AOT_METHOD_HEADER = 0;
		J9_JIT_DCE_AOT_PERSISTENT_INFO = 0;
		J9_JIT_DCE_EXCEPTION_INFO = 0;
		J9_JIT_DCE_HASH_TABLE = 0;
		J9_JIT_DCE_IN_USE = 0;
		J9_JIT_DCE_MCC_HT_ENTRY = 0;
		J9_JIT_DCE_RELOCATION_DATA = 0;
		J9_JIT_DCE_STACK_ATLAS = 0;
		J9_JIT_DCE_THUNK_MAPPING = 0;
		J9_JIT_DCE_THUNK_MAPPING_LIST = 0;
		J9_JIT_DCE_UNALLOCATED = 0;
		J9_JIT_METADATA_HAS_BYTECODE_PC = 0;
		J9_JIT_METADATA_WIDE_EXCEPTIONS = 0;
		J9_JIT_NEVER_TRANSLATE = 0;
		J9_JIT_QUEUED_FOR_COMPILATION = 0;
		J9_JIT_RESOLVE_FAIL_COMPILE = 0;
		J9_JIT_RETURN_TYPES_SIZE = 0;
		J9_JIT_TOGGLE_RI_IN_COMPILED_CODE = 0;
		J9_JIT_TOGGLE_RI_ON_TRANSITION = 0;
		J9_JIT_TRANSITION_METHOD_ENTER = 0;
		J9_JIT_TRANSITION_METHOD_EXIT = 0;
		J9_JNI_OFFLOAD_SWITCH_CREATE_JAVA_VM = 0;
		J9_JNI_OFFLOAD_SWITCH_DEALLOCATE_VM_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_GC_DISPATCHER_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_GC_HELPER_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_ARRAY_ELEMENTS = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_ARRAY_REGION = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_STRING_CHARS = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_STRING_REGION = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_STRING_UTF_CHARS = 0;
		J9_JNI_OFFLOAD_SWITCH_GET_STRING_UTF_REGION = 0;
		J9_JNI_OFFLOAD_SWITCH_INTERPRETER = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_COMPILING_END = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_COMPILING_START = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_GC_CYCLE_FINISH = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_GC_CYCLE_START = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_INSTRUMENTABLE_OBJECT_ALLOC = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_VM_DUMP_END = 0;
		J9_JNI_OFFLOAD_SWITCH_J9JVMTI_VM_DUMP_START = 0;
		J9_JNI_OFFLOAD_SWITCH_JIT_COMPILATION_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JIT_HARDWARE_PROFILER_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JIT_IPROFILER_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JIT_SAMPLER_THREAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_BREAKPOINT = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_FILE_LOAD_HOOK = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_LOAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_CLASS_PREPARE = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_COMPILED_METHOD_LOAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_COMPILED_METHOD_UNLOAD = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_DATA_DUMP_REQUEST = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_DYNAMIC_CODE_GENERATED = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_EXCEPTION = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_EXCEPTION_CATCH = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_FIELD_ACCESS = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_FIELD_MODIFICATION = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_FRAME_POP = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_GC_FINISH = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_GC_START = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_METHOD_ENTRY = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_METHOD_EXIT = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_CONTENDED_ENTER = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_CONTENDED_ENTERED = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_WAIT = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_MONITOR_WAITED = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_NATIVE_METHOD_BIND = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_OBJECT_FREE = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_RESOURCE_EXHAUSTED = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_SINGLE_STEP = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_THREAD_END = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_THREAD_START = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_DEATH = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_INIT = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_OBJECT_ALLOC = 0;
		J9_JNI_OFFLOAD_SWITCH_JVMTI_VM_START = 0;
		J9_JNI_OFFLOAD_SWITCH_NEW_STRING_UTF = 0;
		J9_JNI_OFFLOAD_SWITCH_RELEASE_ARRAY_ELEMENTS = 0;
		J9_JNI_OFFLOAD_SWITCH_SET_ARRAY_REGION = 0;
		J9_JNI_OFFLOAD_SWITCH_THRESHOLD = 0;
		J9_JNI_OFFLOAD_SWITCH_TRACE_SUBSCRIBER_THREAD = 0;
		J9_LOOK_CLCONSTRAINTS = 0;
		J9_LOOK_DIRECT_NAS = 0;
		J9_LOOK_HANDLE_DEFAULT_METHOD_CONFLICTS = 0;
		J9_LOOK_INTERFACE = 0;
		J9_LOOK_JNI = 0;
		J9_LOOK_NEW_INSTANCE = 0;
		J9_LOOK_NO_CLIMB = 0;
		J9_LOOK_NO_INTERFACE = 0;
		J9_LOOK_NO_JLOBJECT = 0;
		J9_LOOK_NO_THROW = 0;
		J9_LOOK_PARTIAL_SIGNATURE = 0;
		J9_LOOK_REFLECT_CALL = 0;
		J9_LOOK_STATIC = 0;
		J9_LOOK_VIRTUAL = 0;
		J9_METHOD_ENTER_DEBUG_FRAME_BUILD = 0;
		J9_METHOD_ENTER_DEBUG_METHOD_ENTER = 0;
		J9_METHOD_ENTER_NEW_HOOK_INTERFACE = 0;
		J9_METHOD_ENTER_PROFILER = 0;
		J9_METHOD_ENTER_RASTRACE = 0;
		J9_METHOD_HANDLE_COMPILE_CUSTOM = 0;
		J9_METHOD_HANDLE_COMPILE_SHARED = 0;
		J9_METHOD_HANDLE_COMPILE_SYNC = 0;
		J9_METHOD_HANDLE_INVOCATION_COMPILE_COUNT = 0;
		J9_METHOD_TYPE_ORIGIN_INVOKE = 0;
		J9_METHOD_TYPE_ORIGIN_INVOKE_EXACT = 0;
		J9_METHOD_TYPE_ORIGIN_LDC = 0;
		J9_MODULE_NAME_IS_J9UTF8 = 0;
		J9_NATIVE_LIBRARY_SWITCH_JDBC = 0;
		J9_NATIVE_LIBRARY_SWITCH_REQUIRED = 0;
		J9_NATIVE_METHOD_BIND_ALLOW_JNI = 0;
		J9_NATIVE_METHOD_BIND_CAN_RUN_JAVA_CODE = 0;
		J9_NATIVE_METHOD_BIND_FAIL = 0;
		J9_NATIVE_METHOD_BIND_OUT_OF_MEMORY = 0;
		J9_NATIVE_METHOD_BIND_RECURSIVE = 0;
		J9_NATIVE_METHOD_BIND_SUCCESS = 0;
		J9_NATIVE_TYPE_BOOLEAN = 0;
		J9_NATIVE_TYPE_BYTE = 0;
		J9_NATIVE_TYPE_CHAR = 0;
		J9_NATIVE_TYPE_CLASS = 0;
		J9_NATIVE_TYPE_DOUBLE = 0;
		J9_NATIVE_TYPE_FLOAT = 0;
		J9_NATIVE_TYPE_INT = 0;
		J9_NATIVE_TYPE_LONG = 0;
		J9_NATIVE_TYPE_OBJECT = 0;
		J9_NATIVE_TYPE_SHORT = 0;
		J9_NATIVE_TYPE_VOID = 0;
		J9_OBJECT_DESCRIPTION_SIZE = 0;
		J9_OBJECT_HEADER_AGE_DEFAULT = 0;
		J9_OBJECT_HEADER_INDEXABLE = 0;
		J9_OBJECT_HEADER_REMEMBERED_BITS_TO_SET = 0;
		J9_OBJECT_HEADER_REMEMBERED_MASK_FOR_CLEAR = 0;
		J9_OBJECT_HEADER_REMEMBERED_MASK_FOR_TEST = 0;
		J9_OBJECT_HEADER_SHAPE_MASK = 0;
		J9_OBJECT_HEADER_STACK_ALLOCATED = 0;
		J9_PRIVATE_FLAGS2_UNSAFE_HANDLE_SIGBUS = 0;
		J9_PRIVATE_FLAGS_ATTACHED_THREAD = 0;
		J9_PRIVATE_FLAGS_CLOAD_NO_MEM = 0;
		J9_PRIVATE_FLAGS_CONCURRENT_MARK_ACTIVE = 0;
		J9_PRIVATE_FLAGS_CONSTRUCTING_EXCEPTION = 0;
		J9_PRIVATE_FLAGS_DAEMON_THREAD = 0;
		J9_PRIVATE_FLAGS_FAILED_LOADING_REQUIRED_CLASS = 0;
		J9_PRIVATE_FLAGS_FILL_EXISTING_TRACE = 0;
		J9_PRIVATE_FLAGS_FINAL_CALL_OUT_OF_MEMORY = 0;
		J9_PRIVATE_FLAGS_FREE_OS_THREAD = 0;
		J9_PRIVATE_FLAGS_IN_RESOLVE = 0;
		J9_PRIVATE_FLAGS_LOADING_KNOWN_CLASS = 0;
		J9_PRIVATE_FLAGS_NO_EXCEPTION_IN_START_JAVA_THREAD = 0;
		J9_PRIVATE_FLAGS_NO_OBJECT = 0;
		J9_PRIVATE_FLAGS_OSR_IN_PROGRESS = 0;
		J9_PRIVATE_FLAGS_OUT_OF_MEMORY = 0;
		J9_PRIVATE_FLAGS_REALTIME_THREAD = 0;
		J9_PRIVATE_FLAGS_REPORT_ERROR_LOADING_CLASS = 0;
		J9_PRIVATE_FLAGS_REPORT_EXCEPTION_THROW = 0;
		J9_PRIVATE_FLAGS_RI_INITIALIZED = 0;
		J9_PRIVATE_FLAGS_SCAV = 0;
		J9_PRIVATE_FLAGS_SKIP_THREAD_SIGNAL_PROTECTION = 0;
		J9_PRIVATE_FLAGS_STACKS_OUT_OF_SYNC = 0;
		J9_PRIVATE_FLAGS_STACK_OVERFLOW = 0;
		J9_PRIVATE_FLAGS_SYSTEM_THREAD = 0;
		J9_PRIVATE_FLAGS_USE_BOOTSTRAP_LOADER = 0;
		J9_PRIVATE_FLAGS_WALKED_FOR_CCR = 0;
		J9_PUBLIC_FLAGS_DEBUG_VM_ACCESS = 0;
		J9_PUBLIC_FLAGS_EXCLUSIVE_RESPONSE_MASK = 0;
		J9_PUBLIC_FLAGS_HALTED_AT_SAFE_POINT = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_ANY = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_ANY_NO_JAVA_SUSPEND = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_EXCLUSIVE = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_INSPECTION = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_JAVA_SUSPEND = 0;
		J9_PUBLIC_FLAGS_HALT_THREAD_SUSPEND_ANY = 0;
		J9_PUBLIC_FLAGS_HALT_VM_DUTIES = 0;
		J9_PUBLIC_FLAGS_JNI_CRITICAL_ACCESS = 0;
		J9_PUBLIC_FLAGS_JNI_CRITICAL_REGION = 0;
		J9_PUBLIC_FLAGS_NOT_AT_SAFE_POINT = 0;
		J9_PUBLIC_FLAGS_POP_FRAMES_INTERRUPT = 0;
		J9_PUBLIC_FLAGS_QUEUED_FOR_EXCLUSIVE = 0;
		J9_PUBLIC_FLAGS_RELEASE_ACCESS_REQUIRED_MASK = 0;
		J9_PUBLIC_FLAGS_REQUEST_SAFE_POINT = 0;
		J9_PUBLIC_FLAGS_STOP = 0;
		J9_PUBLIC_FLAGS_STOPPED = 0;
		J9_PUBLIC_FLAGS_THREAD_BLOCKED = 0;
		J9_PUBLIC_FLAGS_THREAD_PARKED = 0;
		J9_PUBLIC_FLAGS_THREAD_SLEEPING = 0;
		J9_PUBLIC_FLAGS_THREAD_TIMED = 0;
		J9_PUBLIC_FLAGS_THREAD_WAITING = 0;
		J9_PUBLIC_FLAGS_VMACCESS_ACQUIRE_BITS = 0;
		J9_PUBLIC_FLAGS_VMACCESS_OUTOFLINE_MASK = 0;
		J9_PUBLIC_FLAGS_VMACCESS_RELEASE_BITS = 0;
		J9_PUBLIC_FLAGS_VM_ACCESS = 0;
		J9_RAS_MASK = 0;
		J9_RAS_METHOD_SEEN = 0;
		J9_RAS_METHOD_TRACE_ARGS = 0;
		J9_RAS_METHOD_TRACING = 0;
		J9_RAS_METHOD_TRIGGERING = 0;
		J9_RAS_METHOD_UNSEEN = 0;
		J9_REQUIRED_CLASS_ALIGNMENT = 0;
		J9_REQUIRED_CLASS_SHIFT = 0;
		J9_RESOLVE_FLAG_CHECK_CLINIT = 0;
		J9_RESOLVE_FLAG_FIELD_SETTER = 0;
		J9_RESOLVE_FLAG_INIT_CLASS = 0;
		J9_RESOLVE_FLAG_INSTANTIABLE = 0;
		J9_RESOLVE_FLAG_JCL_CONSTANT_POOL = 0;
		J9_RESOLVE_FLAG_JIT_COMPILE_TIME = 0;
		J9_RESOLVE_FLAG_NO_CLASS_INIT = 0;
		J9_RESOLVE_FLAG_NO_THROW_ON_FAIL = 0;
		J9_RESOLVE_FLAG_REDEFINE_CLASS = 0;
		J9_RESOLVE_FLAG_RUNTIME_RESOLVE = 0;
		J9_RESOLVE_STATIC_FIELD_TAG_FROM_CLINIT = 0;
		J9_RESOLVE_STATIC_FIELD_TAG_IS_ISOLATED = 0;
		J9_RUNTIME_AGGRESSIVE = 0;
		J9_RUNTIME_ALWAYS_COPY_JNI_CRITICAL = 0;
		J9_RUNTIME_ARGENCODING_LATIN = 0;
		J9_RUNTIME_ARGENCODING_UNICODE = 0;
		J9_RUNTIME_ARGENCODING_UTF8 = 0;
		J9_RUNTIME_CLEANUP = 0;
		J9_RUNTIME_DISABLE_VM_SHUTDOWN = 0;
		J9_RUNTIME_EXIT_STARTED = 0;
		J9_RUNTIME_EXTENDED_METHOD_BLOCK = 0;
		J9_RUNTIME_INITIALIZED = 0;
		J9_RUNTIME_JAVA_BASE_MODULE_CREATED = 0;
		J9_RUNTIME_JIT_ACTIVE = 0;
		J9_RUNTIME_NO_PRIORITIES = 0;
		J9_RUNTIME_OMIT_STACK_TRACES = 0;
		J9_RUNTIME_PAINT_STACK = 0;
		J9_RUNTIME_REPORT_STACK_USE = 0;
		J9_RUNTIME_SHOW_VERSION = 0;
		J9_RUNTIME_SHUTDOWN = 0;
		J9_RUNTIME_SHUTDOWN_STARTED = 0;
		J9_RUNTIME_SNIFF_AND_WHACK = 0;
		J9_RUNTIME_STACK_FILL = 0;
		J9_RUNTIME_STRING_BYTE_ARRAY = 0;
		J9_RUNTIME_TUNE_VIRTUALIZED = 0;
		J9_RUNTIME_VERIFY = 0;
		J9_RUNTIME_XFUTURE = 0;
		J9_SIGBYTE_ARRAY = 0;
		J9_SIGBYTE_BOOLEAN = 0;
		J9_SIGBYTE_BYTE = 0;
		J9_SIGBYTE_CHAR = 0;
		J9_SIGBYTE_DOUBLE = 0;
		J9_SIGBYTE_FLOAT = 0;
		J9_SIGBYTE_INT = 0;
		J9_SIGBYTE_LONG = 0;
		J9_SIGBYTE_OBJECT = 0;
		J9_SIGBYTE_OBJECT_END = 0;
		J9_SIGBYTE_SHORT = 0;
		J9_SIGBYTE_SIG_BEGIN = 0;
		J9_SIGBYTE_SIG_END = 0;
		J9_SIGBYTE_VOID = 0;
		J9_SIG_NO_SIG_CHAIN = 0;
		J9_SIG_NO_SIG_INT = 0;
		J9_SIG_NO_SIG_QUIT = 0;
		J9_SIG_PERCOLATE_CONDITIONS = 0;
		J9_SIG_POSIX_COOPERATIVE_SHUTDOWN = 0;
		J9_SIG_XRS_ASYNC = 0;
		J9_SIG_XRS_SYNC = 0;
		J9_SIG_ZOS_CEEHDLR = 0;
		J9_SLOT_VALIDATE_ERROR_INVALID_SLOT = 0;
		J9_SLOT_VALIDATE_ERROR_LOCAL_MAP_ERROR = 0;
		J9_SLOT_VALIDATE_ERROR_LOCAL_MAP_MISMATCH = 0;
		J9_SLOT_VALIDATE_ERROR_NATIVE_METHOD = 0;
		J9_SLOT_VALIDATE_ERROR_NONE = 0;
		J9_SLOT_VALIDATE_ERROR_OUT_OF_MEMORY = 0;
		J9_SLOT_VALIDATE_ERROR_TYPE_MISMATCH = 0;
		J9_SPECIAL_SPLIT_TABLE_INDEX_FLAG = 0;
		J9_SPLIT_TABLE_INDEX_MASK = 0;
		J9_SSF_CALL_OUT_FRAME_ALLOC = 0;
		J9_SSF_CO_REF_SLOT_CNT = 0;
		J9_SSF_EXIT_TRC_L3 = 0;
		J9_SSF_JIT_CALLIN = 0;
		J9_SSF_JIT_CALLIN_METHODTYPE = 0;
		J9_SSF_JIT_JNI_CALLOUT = 0;
		J9_SSF_JIT_JNI_FRAME_COLLAPSE_BITS = 0;
		J9_SSF_JIT_NATIVE_TRANSITION_FRAME = 0;
		J9_SSF_JIT_RESOLVE = 0;
		J9_SSF_JIT_RESOLVE_ALLOCATION = 0;
		J9_SSF_JIT_RESOLVE_BEFORE_ANEWARRAY = 0;
		J9_SSF_JIT_RESOLVE_BEFORE_MULTIANEWARRAY = 0;
		J9_SSF_JIT_RESOLVE_DATA = 0;
		J9_SSF_JIT_RESOLVE_INDUCE_OSR = 0;
		J9_SSF_JIT_RESOLVE_INTERFACE_LOOKUP = 0;
		J9_SSF_JIT_RESOLVE_INTERFACE_METHOD = 0;
		J9_SSF_JIT_RESOLVE_MON_ENT = 0;
		J9_SSF_JIT_RESOLVE_RECOMPILATION = 0;
		J9_SSF_JIT_RESOLVE_RUNTIME_HELPER = 0;
		J9_SSF_JIT_RESOLVE_SPECIAL_METHOD = 0;
		J9_SSF_JIT_RESOLVE_STACK_OVERFLOW = 0;
		J9_SSF_JIT_RESOLVE_STATIC_METHOD = 0;
		J9_SSF_JIT_RESOLVE_VIRTUAL_METHOD = 0;
		J9_SSF_JNI_PUSHED_REF_COUNT_MASK = 0;
		J9_SSF_JNI_REFS_REDIRECTED = 0;
		J9_SSF_METHOD_ENTRY = 0;
		J9_SSF_REL_VM_ACC = 0;
		J9_SSF_RETURNS_OBJECT = 0;
		J9_SSF_USE_SPEC_CL = 0;
		J9_STACKWALK_CACHE_ALLOCATED = 0;
		J9_STACKWALK_CACHE_CPS = 0;
		J9_STACKWALK_CACHE_MASK = 0;
		J9_STACKWALK_CACHE_PCS = 0;
		J9_STACKWALK_CHECK_I_SLOTS_FOR_OBJECTS = 0;
		J9_STACKWALK_COUNT_SPECIFIED = 0;
		J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK = 0;
		J9_STACKWALK_HIDE_EXCEPTION_FRAMES = 0;
		J9_STACKWALK_INCLUDE_CALL_IN_FRAMES = 0;
		J9_STACKWALK_INCLUDE_NATIVES = 0;
		J9_STACKWALK_ITERATE_FRAMES = 0;
		J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES = 0;
		J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS = 0;
		J9_STACKWALK_ITERATE_O_SLOTS = 0;
		J9_STACKWALK_KEEP_ITERATING = 0;
		J9_STACKWALK_LINEAR = 0;
		J9_STACKWALK_MAINTAIN_REGISTER_MAP = 0;
		J9_STACKWALK_RC_BAD_STATE_BUFFER = 0;
		J9_STACKWALK_RC_FRAME_NOT_FOUND = 0;
		J9_STACKWALK_RC_NONE = 0;
		J9_STACKWALK_RC_NO_MEMORY = 0;
		J9_STACKWALK_RC_STACK_CORRUPT = 0;
		J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET = 0;
		J9_STACKWALK_RESUME = 0;
		J9_STACKWALK_SAVE_STACKED_REGISTERS = 0;
		J9_STACKWALK_SKIP_INLINES = 0;
		J9_STACKWALK_START_AT_JIT_FRAME = 0;
		J9_STACKWALK_STOP_ITERATING = 0;
		J9_STACKWALK_VISIBLE_ONLY = 0;
		J9_STACKWALK_WALK_TRANSLATE_PC = 0;
		J9_STACK_OVERFLOW_AND_HEADER_SIZE = 0;
		J9_STACK_OVERFLOW_RESERVED_SIZE = 0;
		J9_STARTPC_DLT_READY = 0;
		J9_STARTPC_JNI_NATIVE = 0;
		J9_STARTPC_METHOD_BREAKPOINTED = 0;
		J9_STARTPC_METHOD_IS_OVERRIDDEN = 0;
		J9_STARTPC_NATIVE_REQUIRES_SWITCHING = 0;
		J9_STARTPC_NOT_TRANSLATED = 0;
		J9_STARTPC_STATUS = 0;
		J9_STATIC_SPLIT_TABLE_INDEX_FLAG = 0;
		J9_STR_ANON_CLASS_NAME = 0;
		J9_STR_INSTRUMENTABLE = 0;
		J9_STR_INTERN = 0;
		J9_STR_NONE = 0;
		J9_STR_TENURE = 0;
		J9_STR_UNICODE = 0;
		J9_STR_XLAT = 0;
		J9_SUN_FIELD_OFFSET_MASK = 0;
		J9_SUN_STATIC_FIELD_OFFSET_TAG = 0;
		J9_THREAD_START_FAILED_LOCK_OBJECT_ALLOCATION = 0;
		J9_THREAD_START_FAILED_OOM_ALLOCATION = 0;
		J9_THREAD_START_FAILED_TO_FORK_THREAD = 0;
		J9_THREAD_START_FAILED_VMTHREAD_ALLOC = 0;
		J9_THREAD_START_NO_ERROR = 0;
		J9_THREAD_START_THROW_CURRENT_EXCEPTION = 0;
		J9_THREAD_START_UNSPECIFIED_ERROR = 0;
		J9_VERIFY_BOOTCLASSPATH_STATIC = 0;
		J9_VERIFY_DO_PROTECTED_ACCESS_CHECK = 0;
		J9_VERIFY_ERROR_DETAILS = 0;
		J9_VERIFY_EXCLUDE_ATTRIBUTE = 0;
		J9_VERIFY_IGNORE_STACK_MAPS = 0;
		J9_VERIFY_NO_FALLBACK = 0;
		J9_VERIFY_OPTIMIZE = 0;
		J9_VERIFY_SKIP_BOOTSTRAP_CLASSES = 0;
		J9_VERIFY_VERBOSE_VERIFICATION = 0;
		J9_XACCESS_EXCLUSIVE = 0;
		J9_XACCESS_HANDED_OFF = 0;
		J9_XACCESS_HANDING_OFF = 0;
		J9_XACCESS_HANDING_OFF_FROM_EXTERNAL_THREAD = 0;
		J9_XACCESS_NONE = 0;
		J9_XACCESS_PENDING = 0;
		PREVIEW_MINOR_VERSION = 0;
		STRICT_FIELDS_MAJOR_VERSION = 0;
		VALUE_TYPES_MAJOR_VERSION = 0;
	}

}
