/*
 * Copyright IBM Corp. and others 1998
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution and
 * is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package java.security;

import com.ibm.oti.util.Msg;

import jdk.internal.reflect.CallerSensitive;

/**
 * Checks access to system resources. Supports marking of code
 * as privileged. Makes context snapshots to allow checking from
 * other contexts.
 *
 * @author      OTI
 * @version     initial
 */
@Deprecated(since="17", forRemoval=true)
@SuppressWarnings("removal")
public final class AccessController {
	private static final AccessControlContext ACC_NO_PERM = new AccessControlContext(
			new ProtectionDomain[] { new ProtectionDomain(null, null) });

/**
 * Prevents this class from being instantiated.
 */
private AccessController() {
	super();
}

/**
 * Throws AccessControlException
 *
 * @param       perm                    is ignored
 * @exception   AccessControlException  is always thrown
 */
public static void checkPermission(Permission perm) throws AccessControlException {
	// K002e = checking permissions is not supported
	throw new AccessControlException(Msg.getString("K002e")); //$NON-NLS-1$
}

/**
 * @return an AccessControlContext with no permissions
 */
public static AccessControlContext getContext() {
	return ACC_NO_PERM;
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted. In other words, the check stops here.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * @param <T> the type of value returned by PrivilegedAction.run
 *
 * @param action The PrivilegedAction to performed
 *
 * @return the result of the PrivilegedAction
 *
 * @exception   NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivileged(PrivilegedAction<T> action) {
	return action.run();
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted iff it is granted by the AccessControlContext
 * <code>context</code>. In other words, no more checking of the current stack
 * is performed. Instead, the passed in context is checked.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * @param <T> the type of value returned by PrivilegedAction.run
 *
 * @param action The PrivilegedAction to performed
 * @param context The AccessControlContext to check
 *
 * @return the result of the PrivilegedAction
 *
 * @exception   NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
	return action.run();
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted. In other words, the check stops here.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * However, checked exceptions will be caught an re-thrown as PrivilegedActionExceptions
 * @param <T> the type of value returned by PrivilegedExceptionAction.run
 *
 * @param action The PrivilegedExceptionAction to performed
 *
 * @return the result of the PrivilegedExceptionAction
 *
 * @throws PrivilegedActionException when a checked exception occurs when performing the action
 *          NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivileged(PrivilegedExceptionAction<T> action)
	throws PrivilegedActionException
{
	try {
		return action.run();
	} catch (RuntimeException ex) {
		throw ex;
	} catch (Exception ex) {
		throw new PrivilegedActionException(ex);
	}
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted iff it is granted by the AccessControlContext
 * <code>context</code>. In other words, no more checking of the current stack
 * is performed. Instead, the passed in context is checked.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * However, checked exceptions will be caught an re-thrown as PrivilegedActionExceptions
 * @param <T> the type of value returned by PrivilegedExceptionAction.run
 *
 * @param action The PrivilegedExceptionAction to performed
 * @param context The AccessControlContext to check
 *
 * @return the result of the PrivilegedExceptionAction
 *
 * @throws PrivilegedActionException when a checked exception occurs when performing the action
 *          NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivileged (PrivilegedExceptionAction<T> action, AccessControlContext context)
	throws PrivilegedActionException
{
	try {
		return action.run();
	} catch (RuntimeException ex) {
		throw ex;
	} catch (Exception ex) {
		throw new PrivilegedActionException(ex);
	}
}

/**
 * Performs the privileged action specified by <code>action</code>, retaining
 * any current DomainCombiner.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted. In other words, the check stops here.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * @param <T> the type of value returned by PrivilegedAction.run
 *
 * @param action The PrivilegedAction to performed
 *
 * @return the result of the PrivilegedAction
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
	return doPrivileged(action, null);
}

/**
 * Performs the privileged action specified by <code>action</code>, retaining
 * any current DomainCombiner.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted. In other words, the check stops here.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * However, checked exceptions will be caught an re-thrown as PrivilegedActionExceptions
 * @param <T> the type of value returned by PrivilegedExceptionAction.run
 *
 * @param action The PrivilegedExceptionAction to performed
 *
 * @return the result of the PrivilegedExceptionAction
 *
 * @throws PrivilegedActionException when a checked exception occurs when performing the action
 *
 * @see         #doPrivileged(PrivilegedAction)
 */
@CallerSensitive
public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action)
	throws PrivilegedActionException
{
	return doPrivileged(action, null);
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted iff it is granted by the AccessControlContext
 * <code>context</code> and also granted by one of the permissions arguments.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * @param <T> the type of value returned by PrivilegedAction.run
 *
 * @param action The PrivilegedAction to performed
 * @param context The AccessControlContext to check
 * @param perms The Permission arguments to limit the scope of the caller's privileges.
 *
 * @return the result of the PrivilegedAction
 * @since 1.8
 *
 * @exception   NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 * @see         #doPrivileged(PrivilegedAction, AccessControlContext)
 */
@CallerSensitive
public static <T> T doPrivileged(PrivilegedAction<T> action,
		AccessControlContext context, Permission... perms)
{
	return action.run();
}

/**
 * Performs the privileged action specified by <code>action</code>, retaining
 * any current DomainCombiner.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted iff it is granted by one of the permissions arguments.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * @param <T> the type of value returned by PrivilegedAction.run
 *
 * @param action The PrivilegedAction to performed
 * @param context The AccessControlContext to check
 * @param perms The Permission arguments to limit the scope of the caller's privileges.
 *
 * @return the result of the PrivilegedAction
 * @since 1.8
 *
 * @see         #doPrivileged(PrivilegedAction)
 * @see         #doPrivileged(PrivilegedAction, AccessControlContext)
 */
@CallerSensitive
public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action,
		AccessControlContext context, Permission... perms)
{
	return doPrivileged(action, context, perms);
}

/**
 * Performs the privileged action specified by <code>action</code>.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted iff it is granted by the AccessControlContext
 * <code>context</code> and also granted by one of the permissions arguments.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * However, checked exceptions will be caught an re-thrown as PrivilegedActionExceptions
 * @param <T> the type of value returned by PrivilegedExceptionAction.run
 *
 * @param action The PrivilegedExceptionAction to performed
 * @param context The AccessControlContext to check
 * @param perms The Permission arguments to limit the scope of the caller's privileges.
 *
 * @return the result of the PrivilegedExceptionAction
 * @since 1.8
 *
 * @throws PrivilegedActionException when a checked exception occurs when performing the action
 *          NullPointerException if action is null
 *
 * @see         #doPrivileged(PrivilegedAction)
 * @see         #doPrivileged(PrivilegedAction, AccessControlContext)
 */
@CallerSensitive
public static <T> T doPrivileged(PrivilegedExceptionAction<T> action,
		AccessControlContext context, Permission... perms)
	throws PrivilegedActionException
{
	try {
		return action.run();
	} catch (RuntimeException ex) {
		throw ex;
	} catch (Exception ex) {
		throw new PrivilegedActionException(ex);
	}
}

/**
 * Performs the privileged action specified by <code>action</code>, retaining
 * any current DomainCombiner.
 * <p>
 * When permission checks are made, if the permission has been granted by all
 * frames below and including the one representing the call to this method,
 * then the permission is granted and also granted by one of the permissions arguments.
 *
 * Any unchecked exception generated by this method will propagate up the chain.
 * However, checked exceptions will be caught an re-thrown as PrivilegedActionExceptions
 * @param <T> the type of value returned by PrivilegedExceptionAction.run
 *
 * @param action The PrivilegedExceptionAction to performed
 * @param context The AccessControlContext to check
 * @param perms The Permission arguments to limit the scope of the caller's privileges.
 *
 * @return the result of the PrivilegedExceptionAction
 * @since 1.8
 *
 * @throws PrivilegedActionException when a checked exception occurs when performing the action
 *
 * @see         #doPrivileged(PrivilegedAction)
 * @see         #doPrivileged(PrivilegedAction, AccessControlContext)
 */
public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action,
		AccessControlContext context, Permission... perms)
	throws PrivilegedActionException
{
	return doPrivileged(action, context, perms);
}

}
