/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CudaConfigPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CudaConfigPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CudaConfig.class)
public class J9CudaConfigPointer extends StructurePointer {

	// NULL
	public static final J9CudaConfigPointer NULL = new J9CudaConfigPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CudaConfigPointer(long address) {
		super(address);
	}

	public static J9CudaConfigPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CudaConfigPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CudaConfigPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9CudaConfigPointer(address);
	}

	public J9CudaConfigPointer add(long count) {
		return J9CudaConfigPointer.cast(address + (J9CudaConfig.SIZEOF * count));
	}

	public J9CudaConfigPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CudaConfigPointer addOffset(long offset) {
		return J9CudaConfigPointer.cast(address + offset);
	}

	public J9CudaConfigPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CudaConfigPointer sub(long count) {
		return J9CudaConfigPointer.cast(address - (J9CudaConfig.SIZEOF * count));
	}

	public J9CudaConfigPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CudaConfigPointer subOffset(long offset) {
		return J9CudaConfigPointer.cast(address - offset);
	}

	public J9CudaConfigPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CudaConfigPointer untag(long mask) {
		return J9CudaConfigPointer.cast(address & ~mask);
	}

	public J9CudaConfigPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CudaConfig.SIZEOF;
	}

	// Implementation methods

	// void* getDeviceData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_getDeviceDataOffset_", declaredType="void*")
	public VoidPointer getDeviceData() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CudaConfig._getDeviceDataOffset_));
	}

	// void* getDeviceData
	public PointerPointer getDeviceDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaConfig._getDeviceDataOffset_));
	}

	// void* getSummaryData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_getSummaryDataOffset_", declaredType="void*")
	public VoidPointer getSummaryData() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CudaConfig._getSummaryDataOffset_));
	}

	// void* getSummaryData
	public PointerPointer getSummaryDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaConfig._getSummaryDataOffset_));
	}

}
