/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ConcurrentGCIncrementalUpdatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ConcurrentGCIncrementalUpdatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ConcurrentGCIncrementalUpdate.class)
public class MM_ConcurrentGCIncrementalUpdatePointer extends MM_ConcurrentGCPointer {

	// NULL
	public static final MM_ConcurrentGCIncrementalUpdatePointer NULL = new MM_ConcurrentGCIncrementalUpdatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ConcurrentGCIncrementalUpdatePointer(long address) {
		super(address);
	}

	public static MM_ConcurrentGCIncrementalUpdatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ConcurrentGCIncrementalUpdatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ConcurrentGCIncrementalUpdatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ConcurrentGCIncrementalUpdatePointer(address);
	}

	public MM_ConcurrentGCIncrementalUpdatePointer add(long count) {
		return MM_ConcurrentGCIncrementalUpdatePointer.cast(address + (MM_ConcurrentGCIncrementalUpdate.SIZEOF * count));
	}

	public MM_ConcurrentGCIncrementalUpdatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ConcurrentGCIncrementalUpdatePointer addOffset(long offset) {
		return MM_ConcurrentGCIncrementalUpdatePointer.cast(address + offset);
	}

	public MM_ConcurrentGCIncrementalUpdatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ConcurrentGCIncrementalUpdatePointer sub(long count) {
		return MM_ConcurrentGCIncrementalUpdatePointer.cast(address - (MM_ConcurrentGCIncrementalUpdate.SIZEOF * count));
	}

	public MM_ConcurrentGCIncrementalUpdatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ConcurrentGCIncrementalUpdatePointer subOffset(long offset) {
		return MM_ConcurrentGCIncrementalUpdatePointer.cast(address - offset);
	}

	public MM_ConcurrentGCIncrementalUpdatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ConcurrentGCIncrementalUpdatePointer untag(long mask) {
		return MM_ConcurrentGCIncrementalUpdatePointer.cast(address & ~mask);
	}

	public MM_ConcurrentGCIncrementalUpdatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ConcurrentGCIncrementalUpdate.SIZEOF;
	}

	// Implementation methods

	// U64 _allocToTraceRateCardCleanPass2Boost
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__allocToTraceRateCardCleanPass2BoostOffset_", declaredType="U64")
	public UDATA _allocToTraceRateCardCleanPass2Boost() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__allocToTraceRateCardCleanPass2BoostOffset_));
	}

	// U64 _allocToTraceRateCardCleanPass2Boost
	public UDATAPointer _allocToTraceRateCardCleanPass2BoostEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__allocToTraceRateCardCleanPass2BoostOffset_));
	}

	// U64 _bytesToCleanPass1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bytesToCleanPass1Offset_", declaredType="U64")
	public UDATA _bytesToCleanPass1() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__bytesToCleanPass1Offset_));
	}

	// U64 _bytesToCleanPass1
	public UDATAPointer _bytesToCleanPass1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__bytesToCleanPass1Offset_));
	}

	// U64 _bytesToCleanPass2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bytesToCleanPass2Offset_", declaredType="U64")
	public UDATA _bytesToCleanPass2() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__bytesToCleanPass2Offset_));
	}

	// U64 _bytesToCleanPass2
	public UDATAPointer _bytesToCleanPass2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__bytesToCleanPass2Offset_));
	}

	// U64 _bytesToTracePass1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bytesToTracePass1Offset_", declaredType="U64")
	public UDATA _bytesToTracePass1() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__bytesToTracePass1Offset_));
	}

	// U64 _bytesToTracePass1
	public UDATAPointer _bytesToTracePass1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__bytesToTracePass1Offset_));
	}

	// U64 _bytesToTracePass2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bytesToTracePass2Offset_", declaredType="U64")
	public UDATA _bytesToTracePass2() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__bytesToTracePass2Offset_));
	}

	// U64 _bytesToTracePass2
	public UDATAPointer _bytesToTracePass2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__bytesToTracePass2Offset_));
	}

	// float _bytesTracedInPass1Factor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bytesTracedInPass1FactorOffset_", declaredType="float")
	public float _bytesTracedInPass1Factor() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__bytesTracedInPass1FactorOffset_);
	}

	// float _bytesTracedInPass1Factor
	public FloatPointer _bytesTracedInPass1FactorEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__bytesTracedInPass1FactorOffset_));
	}

	// float _cardCleaningFactorPass1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cardCleaningFactorPass1Offset_", declaredType="float")
	public float _cardCleaningFactorPass1() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__cardCleaningFactorPass1Offset_);
	}

	// float _cardCleaningFactorPass1
	public FloatPointer _cardCleaningFactorPass1EA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__cardCleaningFactorPass1Offset_));
	}

	// float _cardCleaningFactorPass2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cardCleaningFactorPass2Offset_", declaredType="float")
	public float _cardCleaningFactorPass2() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__cardCleaningFactorPass2Offset_);
	}

	// float _cardCleaningFactorPass2
	public FloatPointer _cardCleaningFactorPass2EA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__cardCleaningFactorPass2Offset_));
	}

	// float _cardCleaningThresholdFactor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cardCleaningThresholdFactorOffset_", declaredType="float")
	public float _cardCleaningThresholdFactor() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__cardCleaningThresholdFactorOffset_);
	}

	// float _cardCleaningThresholdFactor
	public FloatPointer _cardCleaningThresholdFactorEA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__cardCleaningThresholdFactorOffset_));
	}

	// MM_ConcurrentCardTable* _cardTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cardTableOffset_", declaredType="MM_ConcurrentCardTable*")
	public MM_ConcurrentCardTablePointer _cardTable() throws CorruptDataException {
		return MM_ConcurrentCardTablePointer.cast(getPointerAtOffset(MM_ConcurrentGCIncrementalUpdate.__cardTableOffset_));
	}

	// MM_ConcurrentCardTable* _cardTable
	public PointerPointer _cardTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__cardTableOffset_));
	}

	// float _maxCardCleaningFactorPass1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__maxCardCleaningFactorPass1Offset_", declaredType="float")
	public float _maxCardCleaningFactorPass1() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__maxCardCleaningFactorPass1Offset_);
	}

	// float _maxCardCleaningFactorPass1
	public FloatPointer _maxCardCleaningFactorPass1EA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__maxCardCleaningFactorPass1Offset_));
	}

	// float _maxCardCleaningFactorPass2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__maxCardCleaningFactorPass2Offset_", declaredType="float")
	public float _maxCardCleaningFactorPass2() throws CorruptDataException {
		return getFloatAtOffset(MM_ConcurrentGCIncrementalUpdate.__maxCardCleaningFactorPass2Offset_);
	}

	// float _maxCardCleaningFactorPass2
	public FloatPointer _maxCardCleaningFactorPass2EA() throws CorruptDataException {
		return FloatPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__maxCardCleaningFactorPass2Offset_));
	}

	// bool _pass2Started
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__pass2StartedOffset_", declaredType="bool")
	public boolean _pass2Started() throws CorruptDataException {
		return getBoolAtOffset(MM_ConcurrentGCIncrementalUpdate.__pass2StartedOffset_);
	}

	// bool _pass2Started
	public BoolPointer _pass2StartedEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__pass2StartedOffset_));
	}

	// bool _secondCardCleanPass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__secondCardCleanPassOffset_", declaredType="bool")
	public boolean _secondCardCleanPass() throws CorruptDataException {
		return getBoolAtOffset(MM_ConcurrentGCIncrementalUpdate.__secondCardCleanPassOffset_);
	}

	// bool _secondCardCleanPass
	public BoolPointer _secondCardCleanPassEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__secondCardCleanPassOffset_));
	}

	// U64 _totalCleanedAtPass2KO
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__totalCleanedAtPass2KOOffset_", declaredType="U64")
	public UDATA _totalCleanedAtPass2KO() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__totalCleanedAtPass2KOOffset_));
	}

	// U64 _totalCleanedAtPass2KO
	public UDATAPointer _totalCleanedAtPass2KOEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__totalCleanedAtPass2KOOffset_));
	}

	// U64 _totalTracedAtPass2KO
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__totalTracedAtPass2KOOffset_", declaredType="U64")
	public UDATA _totalTracedAtPass2KO() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__totalTracedAtPass2KOOffset_));
	}

	// U64 _totalTracedAtPass2KO
	public UDATAPointer _totalTracedAtPass2KOEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__totalTracedAtPass2KOOffset_));
	}

	// U64 _traceTargetPass1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__traceTargetPass1Offset_", declaredType="U64")
	public UDATA _traceTargetPass1() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__traceTargetPass1Offset_));
	}

	// U64 _traceTargetPass1
	public UDATAPointer _traceTargetPass1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__traceTargetPass1Offset_));
	}

	// U64 _traceTargetPass2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__traceTargetPass2Offset_", declaredType="U64")
	public UDATA _traceTargetPass2() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ConcurrentGCIncrementalUpdate.__traceTargetPass2Offset_));
	}

	// U64 _traceTargetPass2
	public UDATAPointer _traceTargetPass2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ConcurrentGCIncrementalUpdate.__traceTargetPass2Offset_));
	}

}
