/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pt_regsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pt_regsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pt_regs.class)
public class pt_regsPointer extends StructurePointer {

	// NULL
	public static final pt_regsPointer NULL = new pt_regsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pt_regsPointer(long address) {
		super(address);
	}

	public static pt_regsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pt_regsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pt_regsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pt_regsPointer(address);
	}

	public pt_regsPointer add(long count) {
		return pt_regsPointer.cast(address + (pt_regs.SIZEOF * count));
	}

	public pt_regsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public pt_regsPointer addOffset(long offset) {
		return pt_regsPointer.cast(address + offset);
	}

	public pt_regsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pt_regsPointer sub(long count) {
		return pt_regsPointer.cast(address - (pt_regs.SIZEOF * count));
	}

	public pt_regsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pt_regsPointer subOffset(long offset) {
		return pt_regsPointer.cast(address - offset);
	}

	public pt_regsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pt_regsPointer untag(long mask) {
		return pt_regsPointer.cast(address & ~mask);
	}

	public pt_regsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pt_regs.SIZEOF;
	}

	// Implementation methods

	// U64 ccr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ccrOffset_", declaredType="U64")
	public UDATA ccr() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._ccrOffset_));
	}

	// U64 ccr
	public UDATAPointer ccrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._ccrOffset_));
	}

	// U64 ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctrOffset_", declaredType="U64")
	public UDATA ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._ctrOffset_));
	}

	// U64 ctr
	public UDATAPointer ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._ctrOffset_));
	}

	// U64 dar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_darOffset_", declaredType="U64")
	public UDATA dar() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._darOffset_));
	}

	// U64 dar
	public UDATAPointer darEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._darOffset_));
	}

	// U64 dsisr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dsisrOffset_", declaredType="U64")
	public UDATA dsisr() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._dsisrOffset_));
	}

	// U64 dsisr
	public UDATAPointer dsisrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._dsisrOffset_));
	}

	// U64[] gpr
	public UDATAPointer gprEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(pt_regs._gprOffset_));
	}

	// U64 link
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_linkOffset_", declaredType="U64")
	public UDATA link() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._linkOffset_));
	}

	// U64 link
	public UDATAPointer linkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._linkOffset_));
	}

	// U64 msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msrOffset_", declaredType="U64")
	public UDATA msr() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._msrOffset_));
	}

	// U64 msr
	public UDATAPointer msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._msrOffset_));
	}

	// U64 nip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nipOffset_", declaredType="U64")
	public UDATA nip() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._nipOffset_));
	}

	// U64 nip
	public UDATAPointer nipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._nipOffset_));
	}

	// U64 orig_gpr3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_orig_gpr3Offset_", declaredType="U64")
	public UDATA orig_gpr3() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._orig_gpr3Offset_));
	}

	// U64 orig_gpr3
	public UDATAPointer orig_gpr3EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._orig_gpr3Offset_));
	}

	// U64 result
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_resultOffset_", declaredType="U64")
	public UDATA result() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._resultOffset_));
	}

	// U64 result
	public UDATAPointer resultEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._resultOffset_));
	}

	// U64 softe
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_softeOffset_", declaredType="U64")
	public UDATA softe() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._softeOffset_));
	}

	// U64 softe
	public UDATAPointer softeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._softeOffset_));
	}

	// U64 trap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_trapOffset_", declaredType="U64")
	public UDATA trap() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._trapOffset_));
	}

	// U64 trap
	public UDATAPointer trapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._trapOffset_));
	}

	// U64 xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xerOffset_", declaredType="U64")
	public UDATA xer() throws CorruptDataException {
		return new U64(getLongAtOffset(pt_regs._xerOffset_));
	}

	// U64 xer
	public UDATAPointer xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pt_regs._xerOffset_));
	}

}
