/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: pthread_cond_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the pthread_cond_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=pthread_cond_t.class)
public class pthread_cond_tPointer extends StructurePointer {

	// NULL
	public static final pthread_cond_tPointer NULL = new pthread_cond_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected pthread_cond_tPointer(long address) {
		super(address);
	}

	public static pthread_cond_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static pthread_cond_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static pthread_cond_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new pthread_cond_tPointer(address);
	}

	public pthread_cond_tPointer add(long count) {
		return pthread_cond_tPointer.cast(address + (pthread_cond_t.SIZEOF * count));
	}

	public pthread_cond_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public pthread_cond_tPointer addOffset(long offset) {
		return pthread_cond_tPointer.cast(address + offset);
	}

	public pthread_cond_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public pthread_cond_tPointer sub(long count) {
		return pthread_cond_tPointer.cast(address - (pthread_cond_t.SIZEOF * count));
	}

	public pthread_cond_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public pthread_cond_tPointer subOffset(long offset) {
		return pthread_cond_tPointer.cast(address - offset);
	}

	public pthread_cond_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public pthread_cond_tPointer untag(long mask) {
		return pthread_cond_tPointer.cast(address & ~mask);
	}

	public pthread_cond_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return pthread_cond_t.SIZEOF;
	}

	// Implementation methods

	// I64 __align
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___alignOffset_", declaredType="I64")
	public IDATA __align() throws CorruptDataException {
		return new I64(getLongAtOffset(pthread_cond_t.___alignOffset_));
	}

	// I64 __align
	public IDATAPointer __alignEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___alignOffset_));
	}

	// U32 __data.__broadcast_seq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__broadcast_seqOffset_", declaredType="U32")
	public UDATA __data$__broadcast_seq() throws CorruptDataException {
		return new U32(getIntAtOffset(pthread_cond_t.___data$__broadcast_seqOffset_));
	}

	// U32 __data.__broadcast_seq
	public UDATAPointer __data$__broadcast_seqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__broadcast_seqOffset_));
	}

	// U32 __data.__futex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__futexOffset_", declaredType="U32")
	public UDATA __data$__futex() throws CorruptDataException {
		return new U32(getIntAtOffset(pthread_cond_t.___data$__futexOffset_));
	}

	// U32 __data.__futex
	public UDATAPointer __data$__futexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__futexOffset_));
	}

	// I32 __data.__lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__lockOffset_", declaredType="I32")
	public IDATA __data$__lock() throws CorruptDataException {
		return new I32(getIntAtOffset(pthread_cond_t.___data$__lockOffset_));
	}

	// I32 __data.__lock
	public IDATAPointer __data$__lockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__lockOffset_));
	}

	// void* __data.__mutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__mutexOffset_", declaredType="void*")
	public VoidPointer __data$__mutex() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(pthread_cond_t.___data$__mutexOffset_));
	}

	// void* __data.__mutex
	public PointerPointer __data$__mutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__mutexOffset_));
	}

	// U32 __data.__nwaiters
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__nwaitersOffset_", declaredType="U32")
	public UDATA __data$__nwaiters() throws CorruptDataException {
		return new U32(getIntAtOffset(pthread_cond_t.___data$__nwaitersOffset_));
	}

	// U32 __data.__nwaiters
	public UDATAPointer __data$__nwaitersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__nwaitersOffset_));
	}

	// U64 __data.__total_seq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__total_seqOffset_", declaredType="U64")
	public UDATA __data$__total_seq() throws CorruptDataException {
		return new U64(getLongAtOffset(pthread_cond_t.___data$__total_seqOffset_));
	}

	// U64 __data.__total_seq
	public UDATAPointer __data$__total_seqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__total_seqOffset_));
	}

	// U64 __data.__wakeup_seq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__wakeup_seqOffset_", declaredType="U64")
	public UDATA __data$__wakeup_seq() throws CorruptDataException {
		return new U64(getLongAtOffset(pthread_cond_t.___data$__wakeup_seqOffset_));
	}

	// U64 __data.__wakeup_seq
	public UDATAPointer __data$__wakeup_seqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__wakeup_seqOffset_));
	}

	// U64 __data.__woken_seq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___data$__woken_seqOffset_", declaredType="U64")
	public UDATA __data$__woken_seq() throws CorruptDataException {
		return new U64(getLongAtOffset(pthread_cond_t.___data$__woken_seqOffset_));
	}

	// U64 __data.__woken_seq
	public UDATAPointer __data$__woken_seqEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(pthread_cond_t.___data$__woken_seqOffset_));
	}

	// U8[] __size
	public U8Pointer __sizeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(pthread_cond_t.___sizeOffset_));
	}

}
