/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: u64u32dbl_tagPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the u64u32dbl_tagPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=u64u32dbl_tag.class)
public class u64u32dbl_tagPointer extends StructurePointer {

	// NULL
	public static final u64u32dbl_tagPointer NULL = new u64u32dbl_tagPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected u64u32dbl_tagPointer(long address) {
		super(address);
	}

	public static u64u32dbl_tagPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static u64u32dbl_tagPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static u64u32dbl_tagPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new u64u32dbl_tagPointer(address);
	}

	public u64u32dbl_tagPointer add(long count) {
		return u64u32dbl_tagPointer.cast(address + (u64u32dbl_tag.SIZEOF * count));
	}

	public u64u32dbl_tagPointer add(Scalar count) {
		return add(count.longValue());
	}

	public u64u32dbl_tagPointer addOffset(long offset) {
		return u64u32dbl_tagPointer.cast(address + offset);
	}

	public u64u32dbl_tagPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public u64u32dbl_tagPointer sub(long count) {
		return u64u32dbl_tagPointer.cast(address - (u64u32dbl_tag.SIZEOF * count));
	}

	public u64u32dbl_tagPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public u64u32dbl_tagPointer subOffset(long offset) {
		return u64u32dbl_tagPointer.cast(address - offset);
	}

	public u64u32dbl_tagPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public u64u32dbl_tagPointer untag(long mask) {
		return u64u32dbl_tagPointer.cast(address & ~mask);
	}

	public u64u32dbl_tagPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return u64u32dbl_tag.SIZEOF;
	}

	// Implementation methods

	// double dval
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dvalOffset_", declaredType="double")
	public double dval() throws CorruptDataException {
		return getDoubleAtOffset(u64u32dbl_tag._dvalOffset_);
	}

	// double dval
	public DoublePointer dvalEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(u64u32dbl_tag._dvalOffset_));
	}

	// I32[] i32val
	public IDATAPointer i32valEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(u64u32dbl_tag._i32valOffset_));
	}

	// U32[] u32val
	public UDATAPointer u32valEA() throws CorruptDataException {
		return U32Pointer.cast(nonNullFieldEA(u64u32dbl_tag._u32valOffset_));
	}

	// U64 u64val
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_u64valOffset_", declaredType="U64")
	public UDATA u64val() throws CorruptDataException {
		return new U64(getLongAtOffset(u64u32dbl_tag._u64valOffset_));
	}

	// U64 u64val
	public UDATAPointer u64valEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(u64u32dbl_tag._u64valOffset_));
	}

}
