/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucontextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucontextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucontext.class)
public class ucontextPointer extends StructurePointer {

	// NULL
	public static final ucontextPointer NULL = new ucontextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucontextPointer(long address) {
		super(address);
	}

	public static ucontextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucontextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucontextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucontextPointer(address);
	}

	public ucontextPointer add(long count) {
		return ucontextPointer.cast(address + (ucontext.SIZEOF * count));
	}

	public ucontextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucontextPointer addOffset(long offset) {
		return ucontextPointer.cast(address + offset);
	}

	public ucontextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucontextPointer sub(long count) {
		return ucontextPointer.cast(address - (ucontext.SIZEOF * count));
	}

	public ucontextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucontextPointer subOffset(long offset) {
		return ucontextPointer.cast(address - offset);
	}

	public ucontextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucontextPointer untag(long mask) {
		return ucontextPointer.cast(address & ~mask);
	}

	public ucontextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucontext.SIZEOF;
	}

	// Implementation methods

	// U64 uc_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_flagsOffset_", declaredType="U64")
	public UDATA uc_flags() throws CorruptDataException {
		return new U64(getLongAtOffset(ucontext._uc_flagsOffset_));
	}

	// U64 uc_flags
	public UDATAPointer uc_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ucontext._uc_flagsOffset_));
	}

	// ucontext* uc_link
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_linkOffset_", declaredType="ucontext*")
	public ucontextPointer uc_link() throws CorruptDataException {
		return ucontextPointer.cast(getPointerAtOffset(ucontext._uc_linkOffset_));
	}

	// ucontext* uc_link
	public PointerPointer uc_linkEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext._uc_linkOffset_));
	}

	// mcontext_t uc_mcontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_mcontextOffset_", declaredType="mcontext_t")
	public mcontext_tPointer uc_mcontext() throws CorruptDataException {
		return mcontext_tPointer.cast(nonNullFieldEA(ucontext._uc_mcontextOffset_));
	}

	// mcontext_t uc_mcontext
	public PointerPointer uc_mcontextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext._uc_mcontextOffset_));
	}

	// sigset_t uc_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_sigmaskOffset_", declaredType="sigset_t")
	public __sigset_tPointer uc_sigmask() throws CorruptDataException {
		return __sigset_tPointer.cast(nonNullFieldEA(ucontext._uc_sigmaskOffset_));
	}

	// sigset_t uc_sigmask
	public PointerPointer uc_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext._uc_sigmaskOffset_));
	}

	// stack_t uc_stack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_stackOffset_", declaredType="stack_t")
	public sigaltstackPointer uc_stack() throws CorruptDataException {
		return sigaltstackPointer.cast(nonNullFieldEA(ucontext._uc_stackOffset_));
	}

	// stack_t uc_stack
	public PointerPointer uc_stackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext._uc_stackOffset_));
	}

}
