/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OMR_TI
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OMR_TI {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _BindCurrentThreadOffset_;
	public static final int _DeregisterRecordSubscriberOffset_;
	public static final int _FlushTraceDataOffset_;
	public static final int _GetFreePhysicalMemorySizeOffset_;
	public static final int _GetMemoryCategoriesOffset_;
	public static final int _GetMethodDescriptionsOffset_;
	public static final int _GetMethodPropertiesOffset_;
	public static final int _GetProcessCpuLoadOffset_;
	public static final int _GetProcessPhysicalMemorySizeOffset_;
	public static final int _GetProcessPrivateMemorySizeOffset_;
	public static final int _GetProcessVirtualMemorySizeOffset_;
	public static final int _GetSystemCpuLoadOffset_;
	public static final int _GetTraceMetadataOffset_;
	public static final int _RegisterRecordSubscriberOffset_;
	public static final int _SetTraceOptionsOffset_;
	public static final int _UnbindCurrentThreadOffset_;
	public static final int _internalDataOffset_;
	public static final int _versionOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_BindCurrentThreadOffset_ = 0;
		_DeregisterRecordSubscriberOffset_ = 0;
		_FlushTraceDataOffset_ = 0;
		_GetFreePhysicalMemorySizeOffset_ = 0;
		_GetMemoryCategoriesOffset_ = 0;
		_GetMethodDescriptionsOffset_ = 0;
		_GetMethodPropertiesOffset_ = 0;
		_GetProcessCpuLoadOffset_ = 0;
		_GetProcessPhysicalMemorySizeOffset_ = 0;
		_GetProcessPrivateMemorySizeOffset_ = 0;
		_GetProcessVirtualMemorySizeOffset_ = 0;
		_GetSystemCpuLoadOffset_ = 0;
		_GetTraceMetadataOffset_ = 0;
		_RegisterRecordSubscriberOffset_ = 0;
		_SetTraceOptionsOffset_ = 0;
		_UnbindCurrentThreadOffset_ = 0;
		_internalDataOffset_ = 0;
		_versionOffset_ = 0;
	}

}
