/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: UtTracePointIterator
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class UtTracePointIterator {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _bufferOffset_;
	public static final int _currentPosOffset_;
	public static final int _currentUpperTimeWordOffset_;
	public static final int _dataLengthOffset_;
	public static final int _endOffset_;
	public static final int _endPlatformOffset_;
	public static final int _endSystemOffset_;
	public static final int _getFormatStringFnOffset_;
	public static final int _isBigEndianOffset_;
	public static final int _isCircularBufferOffset_;
	public static final int _iteratorHasWrappedOffset_;
	public static final int _longTracePointLengthOffset_;
	public static final int _numberOfBytesInPlatformPtrOffset_;
	public static final int _numberOfBytesInPlatformShortOffset_;
	public static final int _numberOfBytesInPlatformUDATAOffset_;
	public static final int _portLibOffset_;
	public static final int _processingIncompleteDueToPartialTracePointOffset_;
	public static final int _recordLengthOffset_;
	public static final int _startOffset_;
	public static final int _startPlatformOffset_;
	public static final int _startSystemOffset_;
	public static final int _tempBuffForWrappedTPOffset_;
	public static final int _timeConversionOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_bufferOffset_ = 0;
		_currentPosOffset_ = 0;
		_currentUpperTimeWordOffset_ = 0;
		_dataLengthOffset_ = 0;
		_endOffset_ = 0;
		_endPlatformOffset_ = 0;
		_endSystemOffset_ = 0;
		_getFormatStringFnOffset_ = 0;
		_isBigEndianOffset_ = 0;
		_isCircularBufferOffset_ = 0;
		_iteratorHasWrappedOffset_ = 0;
		_longTracePointLengthOffset_ = 0;
		_numberOfBytesInPlatformPtrOffset_ = 0;
		_numberOfBytesInPlatformShortOffset_ = 0;
		_numberOfBytesInPlatformUDATAOffset_ = 0;
		_portLibOffset_ = 0;
		_processingIncompleteDueToPartialTracePointOffset_ = 0;
		_recordLengthOffset_ = 0;
		_startOffset_ = 0;
		_startPlatformOffset_ = 0;
		_startSystemOffset_ = 0;
		_tempBuffForWrappedTPOffset_ = 0;
		_timeConversionOffset_ = 0;
	}

}
