/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_SparseVirtualMemoryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_SparseVirtualMemoryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_SparseVirtualMemory.class)
public class MM_SparseVirtualMemoryPointer extends MM_VirtualMemoryPointer {

	// NULL
	public static final MM_SparseVirtualMemoryPointer NULL = new MM_SparseVirtualMemoryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_SparseVirtualMemoryPointer(long address) {
		super(address);
	}

	public static MM_SparseVirtualMemoryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_SparseVirtualMemoryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_SparseVirtualMemoryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_SparseVirtualMemoryPointer(address);
	}

	public MM_SparseVirtualMemoryPointer add(long count) {
		return MM_SparseVirtualMemoryPointer.cast(address + (MM_SparseVirtualMemory.SIZEOF * count));
	}

	public MM_SparseVirtualMemoryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_SparseVirtualMemoryPointer addOffset(long offset) {
		return MM_SparseVirtualMemoryPointer.cast(address + offset);
	}

	public MM_SparseVirtualMemoryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_SparseVirtualMemoryPointer sub(long count) {
		return MM_SparseVirtualMemoryPointer.cast(address - (MM_SparseVirtualMemory.SIZEOF * count));
	}

	public MM_SparseVirtualMemoryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_SparseVirtualMemoryPointer subOffset(long offset) {
		return MM_SparseVirtualMemoryPointer.cast(address - offset);
	}

	public MM_SparseVirtualMemoryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_SparseVirtualMemoryPointer untag(long mask) {
		return MM_SparseVirtualMemoryPointer.cast(address & ~mask);
	}

	public MM_SparseVirtualMemoryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_SparseVirtualMemory.SIZEOF;
	}

	// Implementation methods

	// MM_Heap* _heap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapOffset_", declaredType="MM_Heap*")
	public MM_HeapPointer _heap() throws CorruptDataException {
		return MM_HeapPointer.cast(getPointerAtOffset(MM_SparseVirtualMemory.__heapOffset_));
	}

	// MM_Heap* _heap
	public PointerPointer _heapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseVirtualMemory.__heapOffset_));
	}

	// omrthread_monitor_t _largeObjectVirtualMemoryMutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__largeObjectVirtualMemoryMutexOffset_", declaredType="omrthread_monitor_t")
	public J9ThreadMonitorPointer _largeObjectVirtualMemoryMutex() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(MM_SparseVirtualMemory.__largeObjectVirtualMemoryMutexOffset_));
	}

	// omrthread_monitor_t _largeObjectVirtualMemoryMutex
	public PointerPointer _largeObjectVirtualMemoryMutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseVirtualMemory.__largeObjectVirtualMemoryMutexOffset_));
	}

	// MM_SparseAddressOrderedFixedSizeDataPool* _sparseDataPool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sparseDataPoolOffset_", declaredType="MM_SparseAddressOrderedFixedSizeDataPool*")
	public MM_SparseAddressOrderedFixedSizeDataPoolPointer _sparseDataPool() throws CorruptDataException, NoSuchFieldException {
	try {
		return MM_SparseAddressOrderedFixedSizeDataPoolPointer.cast(getPointerAtOffset(MM_SparseVirtualMemory.__sparseDataPoolOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

	// MM_SparseAddressOrderedFixedSizeDataPool* _sparseDataPool
	public PointerPointer _sparseDataPoolEA() throws CorruptDataException, NoSuchFieldException {
	try {
		return PointerPointer.cast(nonNullFieldEA(MM_SparseVirtualMemory.__sparseDataPoolOffset_));
	} catch (NoClassDefFoundError | NoSuchFieldError e) {
		throw new NoSuchFieldException();
	}
	}

}
