/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: statfsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the statfsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=statfs.class)
public class statfsPointer extends StructurePointer {

	// NULL
	public static final statfsPointer NULL = new statfsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected statfsPointer(long address) {
		super(address);
	}

	public static statfsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static statfsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static statfsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new statfsPointer(address);
	}

	public statfsPointer add(long count) {
		return statfsPointer.cast(address + (statfs.SIZEOF * count));
	}

	public statfsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public statfsPointer addOffset(long offset) {
		return statfsPointer.cast(address + offset);
	}

	public statfsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public statfsPointer sub(long count) {
		return statfsPointer.cast(address - (statfs.SIZEOF * count));
	}

	public statfsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public statfsPointer subOffset(long offset) {
		return statfsPointer.cast(address - offset);
	}

	public statfsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public statfsPointer untag(long mask) {
		return statfsPointer.cast(address & ~mask);
	}

	public statfsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return statfs.SIZEOF;
	}

	// Implementation methods

	// __fsblkcnt64_t f_bavail
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_bavailOffset_", declaredType="__fsblkcnt64_t")
	public UDATA f_bavail() throws CorruptDataException {
		return new U64(getLongAtOffset(statfs._f_bavailOffset_));
	}

	// __fsblkcnt64_t f_bavail
	public UDATAPointer f_bavailEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(statfs._f_bavailOffset_));
	}

	// __fsblkcnt64_t f_bfree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_bfreeOffset_", declaredType="__fsblkcnt64_t")
	public UDATA f_bfree() throws CorruptDataException {
		return new U64(getLongAtOffset(statfs._f_bfreeOffset_));
	}

	// __fsblkcnt64_t f_bfree
	public UDATAPointer f_bfreeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(statfs._f_bfreeOffset_));
	}

	// __fsblkcnt64_t f_blocks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_blocksOffset_", declaredType="__fsblkcnt64_t")
	public UDATA f_blocks() throws CorruptDataException {
		return new U64(getLongAtOffset(statfs._f_blocksOffset_));
	}

	// __fsblkcnt64_t f_blocks
	public UDATAPointer f_blocksEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(statfs._f_blocksOffset_));
	}

	// __fsword_t f_bsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_bsizeOffset_", declaredType="__fsword_t")
	public IDATA f_bsize() throws CorruptDataException {
		return new I64(getLongAtOffset(statfs._f_bsizeOffset_));
	}

	// __fsword_t f_bsize
	public IDATAPointer f_bsizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(statfs._f_bsizeOffset_));
	}

	// __fsfilcnt64_t f_ffree
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_ffreeOffset_", declaredType="__fsfilcnt64_t")
	public UDATA f_ffree() throws CorruptDataException {
		return new U64(getLongAtOffset(statfs._f_ffreeOffset_));
	}

	// __fsfilcnt64_t f_ffree
	public UDATAPointer f_ffreeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(statfs._f_ffreeOffset_));
	}

	// __fsfilcnt64_t f_files
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_filesOffset_", declaredType="__fsfilcnt64_t")
	public UDATA f_files() throws CorruptDataException {
		return new U64(getLongAtOffset(statfs._f_filesOffset_));
	}

	// __fsfilcnt64_t f_files
	public UDATAPointer f_filesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(statfs._f_filesOffset_));
	}

	// __fsword_t f_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_flagsOffset_", declaredType="__fsword_t")
	public IDATA f_flags() throws CorruptDataException {
		return new I64(getLongAtOffset(statfs._f_flagsOffset_));
	}

	// __fsword_t f_flags
	public IDATAPointer f_flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(statfs._f_flagsOffset_));
	}

	// __fsword_t f_frsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_frsizeOffset_", declaredType="__fsword_t")
	public IDATA f_frsize() throws CorruptDataException {
		return new I64(getLongAtOffset(statfs._f_frsizeOffset_));
	}

	// __fsword_t f_frsize
	public IDATAPointer f_frsizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(statfs._f_frsizeOffset_));
	}

	// __fsid_t f_fsid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_fsidOffset_", declaredType="__fsid_t")
	public __fsid_tPointer f_fsid() throws CorruptDataException {
		return __fsid_tPointer.cast(nonNullFieldEA(statfs._f_fsidOffset_));
	}

	// __fsid_t f_fsid
	public PointerPointer f_fsidEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(statfs._f_fsidOffset_));
	}

	// __fsword_t f_namelen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_namelenOffset_", declaredType="__fsword_t")
	public IDATA f_namelen() throws CorruptDataException {
		return new I64(getLongAtOffset(statfs._f_namelenOffset_));
	}

	// __fsword_t f_namelen
	public IDATAPointer f_namelenEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(statfs._f_namelenOffset_));
	}

	// __fsword_t[] f_spare
	public IDATAPointer f_spareEA() throws CorruptDataException {
		return I64Pointer.cast(nonNullFieldEA(statfs._f_spareOffset_));
	}

	// __fsword_t f_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_f_typeOffset_", declaredType="__fsword_t")
	public IDATA f_type() throws CorruptDataException {
		return new I64(getLongAtOffset(statfs._f_typeOffset_));
	}

	// __fsword_t f_type
	public IDATAPointer f_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(statfs._f_typeOffset_));
	}

}
