/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9PortLibrary
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9PortLibrary {

	// VM Constants

	public static final long SIZEOF;
	public static final long EsIsDir;
	public static final long EsIsFile;
	public static final long EsMaxPath;
	public static final long EsOpenAppend;
	public static final long EsOpenAsynchronous;
	public static final long EsOpenCreate;
	public static final long EsOpenCreateAlways;
	public static final long EsOpenCreateNew;
	public static final long EsOpenCreateNoTag;
	public static final long EsOpenForInherit;
	public static final long EsOpenForMapping;
	public static final long EsOpenRead;
	public static final long EsOpenShareDelete;
	public static final long EsOpenSync;
	public static final long EsOpenText;
	public static final long EsOpenTruncate;
	public static final long EsOpenWrite;
	public static final long FLG_ACQUIRE_LOCK_NOWAIT;
	public static final long FLG_ACQUIRE_LOCK_WAIT;
	public static final long J9GP_CONTROL;
	public static final long J9GP_CONTROL_PC;
	public static final long J9GP_FPR;
	public static final long J9GP_GPR;
	public static final long J9GP_MODULE;
	public static final long J9GP_MODULE_NAME;
	public static final long J9GP_NUM_CATEGORIES;
	public static final long J9GP_OTHER;
	public static final long J9GP_SIGNAL;
	public static final long J9GP_VALUE_16;
	public static final long J9GP_VALUE_32;
	public static final long J9GP_VALUE_64;
	public static final long J9GP_VALUE_ADDRESS;
	public static final long J9GP_VALUE_FLOAT_64;
	public static final long J9GP_VALUE_STRING;
	public static final long J9GP_VALUE_UNDEFINED;
	public static final long J9MEMTAG_EYECATCHER_ALLOC_FOOTER;
	public static final long J9MEMTAG_EYECATCHER_ALLOC_HEADER;
	public static final long J9MEMTAG_EYECATCHER_FREED_FOOTER;
	public static final long J9MEMTAG_EYECATCHER_FREED_HEADER;
	public static final long J9MEMTAG_PADDING_BYTE;
	public static final long J9MEMTAG_TAG_CORRUPTION;
	public static final long J9MEMTAG_VERSION;
	public static final long J9MEM_CATEGORIES_KEEP_ITERATING;
	public static final long J9MEM_CATEGORIES_STOP_ITERATING;
	public static final long J9NLS_BEGIN_MULTI_LINE;
	public static final long J9NLS_CONFIG;
	public static final long J9NLS_DO_NOT_APPEND_NEWLINE;
	public static final long J9NLS_DO_NOT_PRINT_MESSAGE_TAG;
	public static final long J9NLS_END_MULTI_LINE;
	public static final long J9NLS_ERROR;
	public static final long J9NLS_INFO;
	public static final long J9NLS_MULTI_LINE;
	public static final long J9NLS_STDERR;
	public static final long J9NLS_STDOUT;
	public static final long J9NLS_VITAL;
	public static final long J9NLS_WARNING;
	public static final long J9OSDUMP_EYECATCHER;
	public static final long J9OSDUMP_SIZE;
	public static final long J9PORT_CACHEINFO_DCACHE;
	public static final long J9PORT_CACHEINFO_ICACHE;
	public static final long J9PORT_CACHEINFO_TCACHE;
	public static final long J9PORT_CACHEINFO_UCACHE;
	public static final long J9PORT_CAPABILITY_ALLOCATE_TOP_DOWN;
	public static final long J9PORT_CAPABILITY_BASE;
	public static final long J9PORT_CAPABILITY_CAN_RESERVE_SPECIFIC_ADDRESS;
	public static final long J9PORT_CAPABILITY_STANDARD;
	public static final long J9PORT_INFO_CONTROL_FILE_NOT_UNLINKED;
	public static final long J9PORT_INFO_CONTROL_FILE_UNLINKED;
	public static final long J9PORT_INFO_CONTROL_FILE_UNLINK_FAILED;
	public static final long J9PORT_INFO_SHMEM_BASE;
	public static final long J9PORT_INFO_SHMEM_CREATED;
	public static final long J9PORT_INFO_SHMEM_OPENED;
	public static final long J9PORT_INFO_SHMEM_OPENED_STALE;
	public static final long J9PORT_INFO_SHMEM_OPEN_UNLINKED;
	public static final long J9PORT_INFO_SHMEM_PARTIAL;
	public static final long J9PORT_INFO_SHMEM_STAT_PASSED;
	public static final long J9PORT_INFO_SHSEM_BASE;
	public static final long J9PORT_INFO_SHSEM_CREATED;
	public static final long J9PORT_INFO_SHSEM_OPENED;
	public static final long J9PORT_INFO_SHSEM_OPENED_STALE;
	public static final long J9PORT_INFO_SHSEM_OPEN_UNLINKED;
	public static final long J9PORT_INFO_SHSEM_PARTIAL;
	public static final long J9PORT_INFO_SHSEM_STAT_PASSED;
	public static final long J9PORT_INVALID_FD;
	public static final long J9PORT_MAJOR_VERSION_NUMBER;
	public static final long J9PORT_MINOR_VERSION_NUMBER;
	public static final long J9PORT_PROCESS_CREATE_NEW_PROCESS_GROUP;
	public static final long J9PORT_PROCESS_DO_NOT_CLOSE_STREAMS;
	public static final long J9PORT_PROCESS_IGNORE_OUTPUT;
	public static final long J9PORT_PROCESS_INHERIT_STDERR;
	public static final long J9PORT_PROCESS_INHERIT_STDIN;
	public static final long J9PORT_PROCESS_INHERIT_STDOUT;
	public static final long J9PORT_PROCESS_NONBLOCKING_IO;
	public static final long J9PORT_PROCESS_PIPE_TO_PARENT;
	public static final long J9PORT_PROCESS_REDIRECT_STDERR_TO_STDOUT;
	public static final long J9PORT_PROCESS_STDERR;
	public static final long J9PORT_PROCESS_STDIN;
	public static final long J9PORT_PROCESS_STDOUT;
	public static final long J9PORT_SHMEM_EYECATCHER_LENGTH;
	public static final long J9PORT_SHSEM_MODE_DEFAULT;
	public static final long J9PORT_SHSEM_MODE_NOWAIT;
	public static final long J9PORT_SHSEM_MODE_UNDO;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_ERROR;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_MODEL;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_NOT_AVAILABLE;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_SUCCESS;
	public static final long J9PORT_SYSINFO_HW_INFO_MODEL_BUF_LENGTH;
	public static final long J9SHMEM_NO_FLAGS;
	public static final long J9SHMEM_OPEN_DO_NOT_CREATE;
	public static final long J9SHMEM_OPEN_FOR_DESTROY;
	public static final long J9SHMEM_OPEN_FOR_STATS;
	public static final long J9SHMEM_PRINT_STORAGE_KEY_WARNING;
	public static final long J9SHMEM_STORAGE_KEY_TESTING;
	public static final long J9SHMEM_STORAGE_KEY_TESTING_MASK;
	public static final long J9SHSEM_NO_FLAGS;
	public static final long J9SHSEM_OPEN_DO_NOT_CREATE;
	public static final long J9SHSEM_OPEN_FOR_DESTROY;
	public static final long J9SHSEM_OPEN_FOR_STATS;
	public static final long J9SH_BASEFILEPERM;
	public static final long J9SH_BASEFILEPERM_GROUP_RW_ACCESS;
	public static final long J9SH_DIRPERM;
	public static final long J9SH_DIRPERM_ABSENT;
	public static final long J9SH_DIRPERM_DEFAULT;
	public static final long J9SH_DIRPERM_DEFAULT_WITH_STICKYBIT;
	public static final long J9SH_MAX_PROJ_ID;
	public static final long J9SH_PARENTDIRPERM;
	public static final long J9SH_SHMEM_PERM_READ;
	public static final long J9SH_SHMEM_PERM_READ_WRITE;
	public static final long J9SH_SYSV_OLDER_CONTROL_FILE;
	public static final long J9SH_SYSV_OLDER_EMPTY_CONTROL_FILE;
	public static final long J9SH_SYSV_REGULAR_CONTROL_FILE;
	public static final long J9STR_CODE_EBCDIC;
	public static final long J9STR_CODE_LATIN1;
	public static final long J9STR_CODE_MUTF8;
	public static final long J9STR_CODE_PLATFORM_OMR_INTERNAL;
	public static final long J9STR_CODE_PLATFORM_RAW;
	public static final long J9STR_CODE_UTF8;
	public static final long J9STR_CODE_WIDE;
	public static final long J9STR_CODE_WINDEFAULTACP;
	public static final long J9STR_CODE_WINTHREADACP;
	public static final long LS_INITIALIZED;
	public static final long LS_INITIALIZING;
	public static final long LS_LOCKED;
	public static final long LS_UNINITIALIZED;
	public static final long MAX_SIZE_TOTAL_GPINFO;
	public static final long MAX_STRING_TERMINATOR_LENGTH;
	public static final long NANOSECS_PER_USEC;
	public static final long OMRMEM_CATEGORY_PORT_LIBRARY;
	public static final long OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS;
	public static final long OMRMEM_CATEGORY_UNKNOWN;
	public static final long OMRPORT_CPU_BOUND;
	public static final long OMRPORT_CPU_ONLINE;
	public static final long OMRPORT_CPU_PHYSICAL;
	public static final long OMRPORT_CPU_TARGET;
	public static final long OMRPORT_DISABLE_ENSURE_CAP32;
	public static final long OMRPORT_ENABLE_ENSURE_CAP32;
	public static final long OMRPORT_ENSURE_CAPACITY_FAILED;
	public static final long OMRPORT_ENSURE_CAPACITY_NOT_REQUIRED;
	public static final long OMRPORT_ENSURE_CAPACITY_SUCCESS;
	public static final long OMRPORT_FILE_NOWAIT_FOR_LOCK;
	public static final long OMRPORT_FILE_READ_LOCK;
	public static final long OMRPORT_FILE_WAIT_FOR_LOCK;
	public static final long OMRPORT_FILE_WRITE_LOCK;
	public static final long OMRPORT_INVALID_FD;
	public static final long OMRPORT_LIMIT_BASE;
	public static final long OMRPORT_LIMIT_HARD;
	public static final long OMRPORT_LIMIT_LIMITED;
	public static final long OMRPORT_LIMIT_SOFT;
	public static final long OMRPORT_LIMIT_UNKNOWN;
	public static final long OMRPORT_LIMIT_UNLIMITED;
	public static final long OMRPORT_MEMINFO_NOT_AVAILABLE;
	public static final long OMRPORT_MMAP_CAPABILITY_COPYONWRITE;
	public static final long OMRPORT_MMAP_CAPABILITY_MSYNC;
	public static final long OMRPORT_MMAP_CAPABILITY_PROTECT;
	public static final long OMRPORT_MMAP_CAPABILITY_READ;
	public static final long OMRPORT_MMAP_CAPABILITY_UMAP_REQUIRES_SIZE;
	public static final long OMRPORT_MMAP_CAPABILITY_WRITE;
	public static final long OMRPORT_MMAP_FLAG_COPYONWRITE;
	public static final long OMRPORT_MMAP_FLAG_CREATE_FILE;
	public static final long OMRPORT_MMAP_FLAG_EXECUTABLE;
	public static final long OMRPORT_MMAP_FLAG_PRIVATE;
	public static final long OMRPORT_MMAP_FLAG_READ;
	public static final long OMRPORT_MMAP_FLAG_SHARED;
	public static final long OMRPORT_MMAP_FLAG_WRITE;
	public static final long OMRPORT_MMAP_SYNC_ASYNC;
	public static final long OMRPORT_MMAP_SYNC_INVALIDATE;
	public static final long OMRPORT_MMAP_SYNC_WAIT;
	public static final long OMRPORT_PAGE_PROTECT_EXEC;
	public static final long OMRPORT_PAGE_PROTECT_NONE;
	public static final long OMRPORT_PAGE_PROTECT_NOT_SUPPORTED;
	public static final long OMRPORT_PAGE_PROTECT_READ;
	public static final long OMRPORT_PAGE_PROTECT_WRITE;
	public static final long OMRPORT_PROCINFO_NOT_AVAILABLE;
	public static final long OMRPORT_PROCINFO_PROC_OFFLINE;
	public static final long OMRPORT_PROCINFO_PROC_ONLINE;
	public static final long OMRPORT_RESOURCE_ADDRESS_SPACE;
	public static final long OMRPORT_RESOURCE_CORE_FILE;
	public static final long OMRPORT_RESOURCE_CORE_FLAGS;
	public static final long OMRPORT_RESOURCE_FILE_DESCRIPTORS;
	public static final long OMRPORT_RESOURCE_SHARED_MEMORY;
	public static final long OMRPORT_SIG_CONTROL;
	public static final long OMRPORT_SIG_CONTROL_BP;
	public static final long OMRPORT_SIG_CONTROL_PC;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_CR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_CTR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_DAR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_DSIR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_FPSCR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_LR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_MQ;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_MSR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_XER;
	public static final long OMRPORT_SIG_CONTROL_S390_BEA;
	public static final long OMRPORT_SIG_CONTROL_S390_FPC;
	public static final long OMRPORT_SIG_CONTROL_S390_GPR7;
	public static final long OMRPORT_SIG_CONTROL_SP;
	public static final long OMRPORT_SIG_CONTROL_X86_EFLAGS;
	public static final long OMRPORT_SIG_ERROR;
	public static final long OMRPORT_SIG_EXCEPTION_CONTINUE_EXECUTION;
	public static final long OMRPORT_SIG_EXCEPTION_CONTINUE_SEARCH;
	public static final long OMRPORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN;
	public static final long OMRPORT_SIG_EXCEPTION_OCCURRED;
	public static final long OMRPORT_SIG_EXCEPTION_RETURN;
	public static final long OMRPORT_SIG_FLAG_MAY_CONTINUE_EXECUTION;
	public static final long OMRPORT_SIG_FLAG_MAY_RETURN;
	public static final long OMRPORT_SIG_FLAG_SIGABEND;
	public static final long OMRPORT_SIG_FLAG_SIGABRT;
	public static final long OMRPORT_SIG_FLAG_SIGALLASYNC;
	public static final long OMRPORT_SIG_FLAG_SIGALLSYNC;
	public static final long OMRPORT_SIG_FLAG_SIGBUS;
	public static final long OMRPORT_SIG_FLAG_SIGFPE;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_INT_OVERFLOW;
	public static final long OMRPORT_SIG_FLAG_SIGILL;
	public static final long OMRPORT_SIG_FLAG_SIGINT;
	public static final long OMRPORT_SIG_FLAG_SIGQUIT;
	public static final long OMRPORT_SIG_FLAG_SIGRECONFIG;
	public static final long OMRPORT_SIG_FLAG_SIGSEGV;
	public static final long OMRPORT_SIG_FLAG_SIGTERM;
	public static final long OMRPORT_SIG_FLAG_SIGTRAP;
	public static final long OMRPORT_SIG_FLAG_SIGUSR2;
	public static final long OMRPORT_SIG_FLAG_SIGXFSZ;
	public static final long OMRPORT_SIG_FPR;
	public static final long OMRPORT_SIG_GPR;
	public static final long OMRPORT_SIG_GPR_AMD64_R10;
	public static final long OMRPORT_SIG_GPR_AMD64_R11;
	public static final long OMRPORT_SIG_GPR_AMD64_R12;
	public static final long OMRPORT_SIG_GPR_AMD64_R13;
	public static final long OMRPORT_SIG_GPR_AMD64_R14;
	public static final long OMRPORT_SIG_GPR_AMD64_R15;
	public static final long OMRPORT_SIG_GPR_AMD64_R8;
	public static final long OMRPORT_SIG_GPR_AMD64_R9;
	public static final long OMRPORT_SIG_GPR_AMD64_RAX;
	public static final long OMRPORT_SIG_GPR_AMD64_RBX;
	public static final long OMRPORT_SIG_GPR_AMD64_RCX;
	public static final long OMRPORT_SIG_GPR_AMD64_RDI;
	public static final long OMRPORT_SIG_GPR_AMD64_RDX;
	public static final long OMRPORT_SIG_GPR_AMD64_RSI;
	public static final long OMRPORT_SIG_GPR_ARM_R0;
	public static final long OMRPORT_SIG_GPR_ARM_R1;
	public static final long OMRPORT_SIG_GPR_ARM_R10;
	public static final long OMRPORT_SIG_GPR_ARM_R2;
	public static final long OMRPORT_SIG_GPR_ARM_R3;
	public static final long OMRPORT_SIG_GPR_ARM_R4;
	public static final long OMRPORT_SIG_GPR_ARM_R5;
	public static final long OMRPORT_SIG_GPR_ARM_R6;
	public static final long OMRPORT_SIG_GPR_ARM_R7;
	public static final long OMRPORT_SIG_GPR_ARM_R8;
	public static final long OMRPORT_SIG_GPR_ARM_R9;
	public static final long OMRPORT_SIG_GPR_X86_EAX;
	public static final long OMRPORT_SIG_GPR_X86_EBX;
	public static final long OMRPORT_SIG_GPR_X86_ECX;
	public static final long OMRPORT_SIG_GPR_X86_EDI;
	public static final long OMRPORT_SIG_GPR_X86_EDX;
	public static final long OMRPORT_SIG_GPR_X86_ESI;
	public static final long OMRPORT_SIG_MODULE;
	public static final long OMRPORT_SIG_MODULE_FUNCTION_NAME;
	public static final long OMRPORT_SIG_MODULE_NAME;
	public static final long OMRPORT_SIG_NO_EXCEPTION;
	public static final long OMRPORT_SIG_NUM_CATEGORIES;
	public static final long OMRPORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN;
	public static final long OMRPORT_SIG_OPTIONS_OMRSIG_NO_CHAIN;
	public static final long OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS;
	public static final long OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS;
	public static final long OMRPORT_SIG_OPTIONS_SIGXFSZ;
	public static final long OMRPORT_SIG_OPTIONS_ZOS_USE_CEEHDLR;
	public static final long OMRPORT_SIG_OTHER;
	public static final long OMRPORT_SIG_SIGNAL;
	public static final long OMRPORT_SIG_SIGNAL_ADDRESS;
	public static final long OMRPORT_SIG_SIGNAL_CODE;
	public static final long OMRPORT_SIG_SIGNAL_ERROR_VALUE;
	public static final long OMRPORT_SIG_SIGNAL_HANDLER;
	public static final long OMRPORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS;
	public static final long OMRPORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE;
	public static final long OMRPORT_SIG_SIGNAL_TYPE;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY;
	public static final long OMRPORT_SIG_VALUE_128;
	public static final long OMRPORT_SIG_VALUE_16;
	public static final long OMRPORT_SIG_VALUE_32;
	public static final long OMRPORT_SIG_VALUE_64;
	public static final long OMRPORT_SIG_VALUE_ADDRESS;
	public static final long OMRPORT_SIG_VALUE_FLOAT_64;
	public static final long OMRPORT_SIG_VALUE_STRING;
	public static final long OMRPORT_SIG_VALUE_UNDEFINED;
	public static final long OMRPORT_SIG_VR;
	public static final long OMRPORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER;
	public static final long OMRPORT_SLOPEN_DECORATE;
	public static final long OMRPORT_SLOPEN_LAZY;
	public static final long OMRPORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND;
	public static final long OMRPORT_SLOPEN_OPEN_EXECUTABLE;
	public static final long OMRPORT_SL_FOUND;
	public static final long OMRPORT_SL_INVALID;
	public static final long OMRPORT_SL_NOT_FOUND;
	public static final long OMRPORT_SL_UNKNOWN;
	public static final long OMRPORT_SL_UNSUPPORTED;
	public static final long OMRPORT_SYSINFO_OS_FEATURES_SIZE;
	public static final long OMRPORT_TIME_DELTA_IN_MICROSECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_MILLISECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_NANOSECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_SECONDS;
	public static final long OMRPORT_TIME_HIRES_MICROTIME_DIVISOR;
	public static final long OMRPORT_TIME_HIRES_MILLITIME_DIVISOR;
	public static final long OMRPORT_TIME_HIRES_NANOTIME_DENOMINATOR;
	public static final long OMRPORT_TIME_HIRES_NANOTIME_NUMERATOR;
	public static final long OMRPORT_TIME_NS_PER_MS;
	public static final long OMRPORT_TIME_US_PER_SEC;
	public static final long OMRPORT_TTY_ERR;
	public static final long OMRPORT_TTY_IN;
	public static final long OMRPORT_TTY_OUT;
	public static final long OMRPORT_VMEM_ALLOCATE_PERSIST;
	public static final long OMRPORT_VMEM_ALLOCATE_TOP_DOWN;
	public static final long OMRPORT_VMEM_ALLOC_DIR_BOTTOM_UP;
	public static final long OMRPORT_VMEM_ALLOC_DIR_TOP_DOWN;
	public static final long OMRPORT_VMEM_ALLOC_QUICK;
	public static final long OMRPORT_VMEM_MEMORY_MODE_COMMIT;
	public static final long OMRPORT_VMEM_MEMORY_MODE_EXECUTE;
	public static final long OMRPORT_VMEM_MEMORY_MODE_READ;
	public static final long OMRPORT_VMEM_MEMORY_MODE_VIRTUAL;
	public static final long OMRPORT_VMEM_MEMORY_MODE_WRITE;
	public static final long OMRPORT_VMEM_PAGE_FLAG_FIXED;
	public static final long OMRPORT_VMEM_PAGE_FLAG_NOT_USED;
	public static final long OMRPORT_VMEM_PAGE_FLAG_PAGEABLE;
	public static final long OMRPORT_VMEM_PAGE_FLAG_SUPERPAGE_ANY;
	public static final long OMRPORT_VMEM_PAGE_FLAG_TYPE_MASK;
	public static final long OMRPORT_VMEM_RESERVE_USED_INVALID;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_BELOW_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_IN_2TO32G_AREA;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_FIXED_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGEABLE_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGES_BELOW_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9MEM_ALLOCATE_MEMORY;
	public static final long OMRPORT_VMEM_RESERVE_USED_MALLOC31;
	public static final long OMRPORT_VMEM_RESERVE_USED_MMAP;
	public static final long OMRPORT_VMEM_RESERVE_USED_MOSERVICES;
	public static final long OMRPORT_VMEM_RESERVE_USED_SHM;
	public static final long OMRPORT_VMEM_STRICT_ADDRESS;
	public static final long OMRPORT_VMEM_STRICT_PAGE_SIZE;
	public static final long OMRPORT_VMEM_ZOS_USE2TO32G_AREA;
	public static final long OMRPORT_VMEM_ZTPF_USE_31BIT_MALLOC;
	public static final long OMRPORT_ZOS_FEATURE_RMODE64;
	public static final long OMRTIME_HIRES_CLOCK_FREQUENCY;
	public static final long SIG_RI_INTERRUPT_INDEX;
	public static final long UNICODE_REPLACEMENT_CHARACTER;

	// Offsets

	public static final int _gp_handler_functionOffset_;
	public static final int _gp_infoOffset_;
	public static final int _gp_info_countOffset_;
	public static final int _gp_protectOffset_;
	public static final int _gp_register_handlerOffset_;
	public static final int _gp_shutdownOffset_;
	public static final int _gp_startupOffset_;
	public static final int _gs_deinitializeOffset_;
	public static final int _gs_disableOffset_;
	public static final int _gs_enableOffset_;
	public static final int _gs_initializeOffset_;
	public static final int _gs_isEnabledOffset_;
	public static final int _gs_params_initOffset_;
	public static final int _hypervisor_get_guest_memory_usageOffset_;
	public static final int _hypervisor_get_guest_processor_usageOffset_;
	public static final int _hypervisor_get_hypervisor_infoOffset_;
	public static final int _hypervisor_hypervisor_presentOffset_;
	public static final int _hypervisor_shutdownOffset_;
	public static final int _hypervisor_startupOffset_;
	public static final int _ipcmutex_acquireOffset_;
	public static final int _ipcmutex_releaseOffset_;
	public static final int _ipcmutex_shutdownOffset_;
	public static final int _ipcmutex_startupOffset_;
	public static final int _isCheckPointAllowedOffset_;
	public static final int _nanoTimeMonotonicClockDeltaOffset_;
	public static final int _omrPortLibraryOffset_;
	public static final int _portGlobalsOffset_;
	public static final int _portVersionOffset_;
	public static final int _port_controlOffset_;
	public static final int _port_create_libraryOffset_;
	public static final int _port_init_libraryOffset_;
	public static final int _port_isFunctionOverriddenOffset_;
	public static final int _port_shutdown_libraryOffset_;
	public static final int _port_startup_libraryOffset_;
	public static final int _process_closeOffset_;
	public static final int _process_createOffset_;
	public static final int _process_getStreamOffset_;
	public static final int _process_get_availableOffset_;
	public static final int _process_get_exitCodeOffset_;
	public static final int _process_isCompleteOffset_;
	public static final int _process_readOffset_;
	public static final int _process_terminateOffset_;
	public static final int _process_waitforOffset_;
	public static final int _process_writeOffset_;
	public static final int _ri_deinitializeOffset_;
	public static final int _ri_disableOffset_;
	public static final int _ri_disableRISupportOffset_;
	public static final int _ri_enableOffset_;
	public static final int _ri_enableRISupportOffset_;
	public static final int _ri_initializeOffset_;
	public static final int _ri_params_initOffset_;
	public static final int _self_handleOffset_;
	public static final int _shmem_attachOffset_;
	public static final int _shmem_closeOffset_;
	public static final int _shmem_createDirOffset_;
	public static final int _shmem_destroyOffset_;
	public static final int _shmem_destroyDeprecatedOffset_;
	public static final int _shmem_detachOffset_;
	public static final int _shmem_findcloseOffset_;
	public static final int _shmem_findfirstOffset_;
	public static final int _shmem_findnextOffset_;
	public static final int _shmem_getDirOffset_;
	public static final int _shmem_getFilepathOffset_;
	public static final int _shmem_get_region_granularityOffset_;
	public static final int _shmem_getidOffset_;
	public static final int _shmem_handle_statOffset_;
	public static final int _shmem_openOffset_;
	public static final int _shmem_openDeprecatedOffset_;
	public static final int _shmem_protectOffset_;
	public static final int _shmem_shutdownOffset_;
	public static final int _shmem_startupOffset_;
	public static final int _shmem_statOffset_;
	public static final int _shmem_statDeprecatedOffset_;
	public static final int _shsem_closeOffset_;
	public static final int _shsem_deprecated_closeOffset_;
	public static final int _shsem_deprecated_destroyOffset_;
	public static final int _shsem_deprecated_destroyDeprecatedOffset_;
	public static final int _shsem_deprecated_getValOffset_;
	public static final int _shsem_deprecated_getidOffset_;
	public static final int _shsem_deprecated_handle_statOffset_;
	public static final int _shsem_deprecated_openOffset_;
	public static final int _shsem_deprecated_openDeprecatedOffset_;
	public static final int _shsem_deprecated_postOffset_;
	public static final int _shsem_deprecated_setValOffset_;
	public static final int _shsem_deprecated_shutdownOffset_;
	public static final int _shsem_deprecated_startupOffset_;
	public static final int _shsem_deprecated_waitOffset_;
	public static final int _shsem_destroyOffset_;
	public static final int _shsem_getValOffset_;
	public static final int _shsem_openOffset_;
	public static final int _shsem_params_initOffset_;
	public static final int _shsem_postOffset_;
	public static final int _shsem_setValOffset_;
	public static final int _shsem_shutdownOffset_;
	public static final int _shsem_startupOffset_;
	public static final int _shsem_waitOffset_;
	public static final int _sock_error_messageOffset_;
	public static final int _sock_freeaddrinfoOffset_;
	public static final int _sock_getaddrinfoOffset_;
	public static final int _sock_getaddrinfo_addressOffset_;
	public static final int _sock_getaddrinfo_create_hintsOffset_;
	public static final int _sock_getaddrinfo_familyOffset_;
	public static final int _sock_getaddrinfo_lengthOffset_;
	public static final int _sock_getaddrinfo_nameOffset_;
	public static final int _sock_gethostbyaddrOffset_;
	public static final int _sock_gethostbynameOffset_;
	public static final int _sock_inetaddrOffset_;
	public static final int _sock_shutdownOffset_;
	public static final int _sock_startupOffset_;
	public static final int _sysinfo_DLPAR_enabledOffset_;
	public static final int _sysinfo_DLPAR_max_CPUsOffset_;
	public static final int _sysinfo_get_cache_infoOffset_;
	public static final int _sysinfo_get_classpathSeparatorOffset_;
	public static final int _sysinfo_get_hw_infoOffset_;
	public static final int _sysinfo_get_processing_capacityOffset_;
	public static final int _sysinfo_shutdownOffset_;
	public static final int _sysinfo_startupOffset_;
	public static final int _sysinfo_weak_memory_consistencyOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		EsIsDir = 0;
		EsIsFile = 0;
		EsMaxPath = 0;
		EsOpenAppend = 0;
		EsOpenAsynchronous = 0;
		EsOpenCreate = 0;
		EsOpenCreateAlways = 0;
		EsOpenCreateNew = 0;
		EsOpenCreateNoTag = 0;
		EsOpenForInherit = 0;
		EsOpenForMapping = 0;
		EsOpenRead = 0;
		EsOpenShareDelete = 0;
		EsOpenSync = 0;
		EsOpenText = 0;
		EsOpenTruncate = 0;
		EsOpenWrite = 0;
		FLG_ACQUIRE_LOCK_NOWAIT = 0;
		FLG_ACQUIRE_LOCK_WAIT = 0;
		J9GP_CONTROL = 0;
		J9GP_CONTROL_PC = 0;
		J9GP_FPR = 0;
		J9GP_GPR = 0;
		J9GP_MODULE = 0;
		J9GP_MODULE_NAME = 0;
		J9GP_NUM_CATEGORIES = 0;
		J9GP_OTHER = 0;
		J9GP_SIGNAL = 0;
		J9GP_VALUE_16 = 0;
		J9GP_VALUE_32 = 0;
		J9GP_VALUE_64 = 0;
		J9GP_VALUE_ADDRESS = 0;
		J9GP_VALUE_FLOAT_64 = 0;
		J9GP_VALUE_STRING = 0;
		J9GP_VALUE_UNDEFINED = 0;
		J9MEMTAG_EYECATCHER_ALLOC_FOOTER = 0;
		J9MEMTAG_EYECATCHER_ALLOC_HEADER = 0;
		J9MEMTAG_EYECATCHER_FREED_FOOTER = 0;
		J9MEMTAG_EYECATCHER_FREED_HEADER = 0;
		J9MEMTAG_PADDING_BYTE = 0;
		J9MEMTAG_TAG_CORRUPTION = 0;
		J9MEMTAG_VERSION = 0;
		J9MEM_CATEGORIES_KEEP_ITERATING = 0;
		J9MEM_CATEGORIES_STOP_ITERATING = 0;
		J9NLS_BEGIN_MULTI_LINE = 0;
		J9NLS_CONFIG = 0;
		J9NLS_DO_NOT_APPEND_NEWLINE = 0;
		J9NLS_DO_NOT_PRINT_MESSAGE_TAG = 0;
		J9NLS_END_MULTI_LINE = 0;
		J9NLS_ERROR = 0;
		J9NLS_INFO = 0;
		J9NLS_MULTI_LINE = 0;
		J9NLS_STDERR = 0;
		J9NLS_STDOUT = 0;
		J9NLS_VITAL = 0;
		J9NLS_WARNING = 0;
		J9OSDUMP_EYECATCHER = 0;
		J9OSDUMP_SIZE = 0;
		J9PORT_CACHEINFO_DCACHE = 0;
		J9PORT_CACHEINFO_ICACHE = 0;
		J9PORT_CACHEINFO_TCACHE = 0;
		J9PORT_CACHEINFO_UCACHE = 0;
		J9PORT_CAPABILITY_ALLOCATE_TOP_DOWN = 0;
		J9PORT_CAPABILITY_BASE = 0;
		J9PORT_CAPABILITY_CAN_RESERVE_SPECIFIC_ADDRESS = 0;
		J9PORT_CAPABILITY_STANDARD = 0;
		J9PORT_INFO_CONTROL_FILE_NOT_UNLINKED = 0;
		J9PORT_INFO_CONTROL_FILE_UNLINKED = 0;
		J9PORT_INFO_CONTROL_FILE_UNLINK_FAILED = 0;
		J9PORT_INFO_SHMEM_BASE = 0;
		J9PORT_INFO_SHMEM_CREATED = 0;
		J9PORT_INFO_SHMEM_OPENED = 0;
		J9PORT_INFO_SHMEM_OPENED_STALE = 0;
		J9PORT_INFO_SHMEM_OPEN_UNLINKED = 0;
		J9PORT_INFO_SHMEM_PARTIAL = 0;
		J9PORT_INFO_SHMEM_STAT_PASSED = 0;
		J9PORT_INFO_SHSEM_BASE = 0;
		J9PORT_INFO_SHSEM_CREATED = 0;
		J9PORT_INFO_SHSEM_OPENED = 0;
		J9PORT_INFO_SHSEM_OPENED_STALE = 0;
		J9PORT_INFO_SHSEM_OPEN_UNLINKED = 0;
		J9PORT_INFO_SHSEM_PARTIAL = 0;
		J9PORT_INFO_SHSEM_STAT_PASSED = 0;
		J9PORT_INVALID_FD = 0;
		J9PORT_MAJOR_VERSION_NUMBER = 0;
		J9PORT_MINOR_VERSION_NUMBER = 0;
		J9PORT_PROCESS_CREATE_NEW_PROCESS_GROUP = 0;
		J9PORT_PROCESS_DO_NOT_CLOSE_STREAMS = 0;
		J9PORT_PROCESS_IGNORE_OUTPUT = 0;
		J9PORT_PROCESS_INHERIT_STDERR = 0;
		J9PORT_PROCESS_INHERIT_STDIN = 0;
		J9PORT_PROCESS_INHERIT_STDOUT = 0;
		J9PORT_PROCESS_NONBLOCKING_IO = 0;
		J9PORT_PROCESS_PIPE_TO_PARENT = 0;
		J9PORT_PROCESS_REDIRECT_STDERR_TO_STDOUT = 0;
		J9PORT_PROCESS_STDERR = 0;
		J9PORT_PROCESS_STDIN = 0;
		J9PORT_PROCESS_STDOUT = 0;
		J9PORT_SHMEM_EYECATCHER_LENGTH = 0;
		J9PORT_SHSEM_MODE_DEFAULT = 0;
		J9PORT_SHSEM_MODE_NOWAIT = 0;
		J9PORT_SHSEM_MODE_UNDO = 0;
		J9PORT_SYSINFO_GET_HW_INFO_ERROR = 0;
		J9PORT_SYSINFO_GET_HW_INFO_MODEL = 0;
		J9PORT_SYSINFO_GET_HW_INFO_NOT_AVAILABLE = 0;
		J9PORT_SYSINFO_GET_HW_INFO_SUCCESS = 0;
		J9PORT_SYSINFO_HW_INFO_MODEL_BUF_LENGTH = 0;
		J9SHMEM_NO_FLAGS = 0;
		J9SHMEM_OPEN_DO_NOT_CREATE = 0;
		J9SHMEM_OPEN_FOR_DESTROY = 0;
		J9SHMEM_OPEN_FOR_STATS = 0;
		J9SHMEM_PRINT_STORAGE_KEY_WARNING = 0;
		J9SHMEM_STORAGE_KEY_TESTING = 0;
		J9SHMEM_STORAGE_KEY_TESTING_MASK = 0;
		J9SHSEM_NO_FLAGS = 0;
		J9SHSEM_OPEN_DO_NOT_CREATE = 0;
		J9SHSEM_OPEN_FOR_DESTROY = 0;
		J9SHSEM_OPEN_FOR_STATS = 0;
		J9SH_BASEFILEPERM = 0;
		J9SH_BASEFILEPERM_GROUP_RW_ACCESS = 0;
		J9SH_DIRPERM = 0;
		J9SH_DIRPERM_ABSENT = 0;
		J9SH_DIRPERM_DEFAULT = 0;
		J9SH_DIRPERM_DEFAULT_WITH_STICKYBIT = 0;
		J9SH_MAX_PROJ_ID = 0;
		J9SH_PARENTDIRPERM = 0;
		J9SH_SHMEM_PERM_READ = 0;
		J9SH_SHMEM_PERM_READ_WRITE = 0;
		J9SH_SYSV_OLDER_CONTROL_FILE = 0;
		J9SH_SYSV_OLDER_EMPTY_CONTROL_FILE = 0;
		J9SH_SYSV_REGULAR_CONTROL_FILE = 0;
		J9STR_CODE_EBCDIC = 0;
		J9STR_CODE_LATIN1 = 0;
		J9STR_CODE_MUTF8 = 0;
		J9STR_CODE_PLATFORM_OMR_INTERNAL = 0;
		J9STR_CODE_PLATFORM_RAW = 0;
		J9STR_CODE_UTF8 = 0;
		J9STR_CODE_WIDE = 0;
		J9STR_CODE_WINDEFAULTACP = 0;
		J9STR_CODE_WINTHREADACP = 0;
		LS_INITIALIZED = 0;
		LS_INITIALIZING = 0;
		LS_LOCKED = 0;
		LS_UNINITIALIZED = 0;
		MAX_SIZE_TOTAL_GPINFO = 0;
		MAX_STRING_TERMINATOR_LENGTH = 0;
		NANOSECS_PER_USEC = 0;
		OMRMEM_CATEGORY_PORT_LIBRARY = 0;
		OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS = 0;
		OMRMEM_CATEGORY_UNKNOWN = 0;
		OMRPORT_CPU_BOUND = 0;
		OMRPORT_CPU_ONLINE = 0;
		OMRPORT_CPU_PHYSICAL = 0;
		OMRPORT_CPU_TARGET = 0;
		OMRPORT_DISABLE_ENSURE_CAP32 = 0;
		OMRPORT_ENABLE_ENSURE_CAP32 = 0;
		OMRPORT_ENSURE_CAPACITY_FAILED = 0;
		OMRPORT_ENSURE_CAPACITY_NOT_REQUIRED = 0;
		OMRPORT_ENSURE_CAPACITY_SUCCESS = 0;
		OMRPORT_FILE_NOWAIT_FOR_LOCK = 0;
		OMRPORT_FILE_READ_LOCK = 0;
		OMRPORT_FILE_WAIT_FOR_LOCK = 0;
		OMRPORT_FILE_WRITE_LOCK = 0;
		OMRPORT_INVALID_FD = 0;
		OMRPORT_LIMIT_BASE = 0;
		OMRPORT_LIMIT_HARD = 0;
		OMRPORT_LIMIT_LIMITED = 0;
		OMRPORT_LIMIT_SOFT = 0;
		OMRPORT_LIMIT_UNKNOWN = 0;
		OMRPORT_LIMIT_UNLIMITED = 0;
		OMRPORT_MEMINFO_NOT_AVAILABLE = 0;
		OMRPORT_MMAP_CAPABILITY_COPYONWRITE = 0;
		OMRPORT_MMAP_CAPABILITY_MSYNC = 0;
		OMRPORT_MMAP_CAPABILITY_PROTECT = 0;
		OMRPORT_MMAP_CAPABILITY_READ = 0;
		OMRPORT_MMAP_CAPABILITY_UMAP_REQUIRES_SIZE = 0;
		OMRPORT_MMAP_CAPABILITY_WRITE = 0;
		OMRPORT_MMAP_FLAG_COPYONWRITE = 0;
		OMRPORT_MMAP_FLAG_CREATE_FILE = 0;
		OMRPORT_MMAP_FLAG_EXECUTABLE = 0;
		OMRPORT_MMAP_FLAG_PRIVATE = 0;
		OMRPORT_MMAP_FLAG_READ = 0;
		OMRPORT_MMAP_FLAG_SHARED = 0;
		OMRPORT_MMAP_FLAG_WRITE = 0;
		OMRPORT_MMAP_SYNC_ASYNC = 0;
		OMRPORT_MMAP_SYNC_INVALIDATE = 0;
		OMRPORT_MMAP_SYNC_WAIT = 0;
		OMRPORT_PAGE_PROTECT_EXEC = 0;
		OMRPORT_PAGE_PROTECT_NONE = 0;
		OMRPORT_PAGE_PROTECT_NOT_SUPPORTED = 0;
		OMRPORT_PAGE_PROTECT_READ = 0;
		OMRPORT_PAGE_PROTECT_WRITE = 0;
		OMRPORT_PROCINFO_NOT_AVAILABLE = 0;
		OMRPORT_PROCINFO_PROC_OFFLINE = 0;
		OMRPORT_PROCINFO_PROC_ONLINE = 0;
		OMRPORT_RESOURCE_ADDRESS_SPACE = 0;
		OMRPORT_RESOURCE_CORE_FILE = 0;
		OMRPORT_RESOURCE_CORE_FLAGS = 0;
		OMRPORT_RESOURCE_FILE_DESCRIPTORS = 0;
		OMRPORT_RESOURCE_SHARED_MEMORY = 0;
		OMRPORT_SIG_CONTROL = 0;
		OMRPORT_SIG_CONTROL_BP = 0;
		OMRPORT_SIG_CONTROL_PC = 0;
		OMRPORT_SIG_CONTROL_POWERPC_CR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_CTR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_DAR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_DSIR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_FPSCR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_LR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_MQ = 0;
		OMRPORT_SIG_CONTROL_POWERPC_MSR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_XER = 0;
		OMRPORT_SIG_CONTROL_S390_BEA = 0;
		OMRPORT_SIG_CONTROL_S390_FPC = 0;
		OMRPORT_SIG_CONTROL_S390_GPR7 = 0;
		OMRPORT_SIG_CONTROL_SP = 0;
		OMRPORT_SIG_CONTROL_X86_EFLAGS = 0;
		OMRPORT_SIG_ERROR = 0;
		OMRPORT_SIG_EXCEPTION_CONTINUE_EXECUTION = 0;
		OMRPORT_SIG_EXCEPTION_CONTINUE_SEARCH = 0;
		OMRPORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN = 0;
		OMRPORT_SIG_EXCEPTION_OCCURRED = 0;
		OMRPORT_SIG_EXCEPTION_RETURN = 0;
		OMRPORT_SIG_FLAG_MAY_CONTINUE_EXECUTION = 0;
		OMRPORT_SIG_FLAG_MAY_RETURN = 0;
		OMRPORT_SIG_FLAG_SIGABEND = 0;
		OMRPORT_SIG_FLAG_SIGABRT = 0;
		OMRPORT_SIG_FLAG_SIGALLASYNC = 0;
		OMRPORT_SIG_FLAG_SIGALLSYNC = 0;
		OMRPORT_SIG_FLAG_SIGBUS = 0;
		OMRPORT_SIG_FLAG_SIGFPE = 0;
		OMRPORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 0;
		OMRPORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 0;
		OMRPORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0;
		OMRPORT_SIG_FLAG_SIGILL = 0;
		OMRPORT_SIG_FLAG_SIGINT = 0;
		OMRPORT_SIG_FLAG_SIGQUIT = 0;
		OMRPORT_SIG_FLAG_SIGRECONFIG = 0;
		OMRPORT_SIG_FLAG_SIGSEGV = 0;
		OMRPORT_SIG_FLAG_SIGTERM = 0;
		OMRPORT_SIG_FLAG_SIGTRAP = 0;
		OMRPORT_SIG_FLAG_SIGUSR2 = 0;
		OMRPORT_SIG_FLAG_SIGXFSZ = 0;
		OMRPORT_SIG_FPR = 0;
		OMRPORT_SIG_GPR = 0;
		OMRPORT_SIG_GPR_AMD64_R10 = 0;
		OMRPORT_SIG_GPR_AMD64_R11 = 0;
		OMRPORT_SIG_GPR_AMD64_R12 = 0;
		OMRPORT_SIG_GPR_AMD64_R13 = 0;
		OMRPORT_SIG_GPR_AMD64_R14 = 0;
		OMRPORT_SIG_GPR_AMD64_R15 = 0;
		OMRPORT_SIG_GPR_AMD64_R8 = 0;
		OMRPORT_SIG_GPR_AMD64_R9 = 0;
		OMRPORT_SIG_GPR_AMD64_RAX = 0;
		OMRPORT_SIG_GPR_AMD64_RBX = 0;
		OMRPORT_SIG_GPR_AMD64_RCX = 0;
		OMRPORT_SIG_GPR_AMD64_RDI = 0;
		OMRPORT_SIG_GPR_AMD64_RDX = 0;
		OMRPORT_SIG_GPR_AMD64_RSI = 0;
		OMRPORT_SIG_GPR_ARM_R0 = 0;
		OMRPORT_SIG_GPR_ARM_R1 = 0;
		OMRPORT_SIG_GPR_ARM_R10 = 0;
		OMRPORT_SIG_GPR_ARM_R2 = 0;
		OMRPORT_SIG_GPR_ARM_R3 = 0;
		OMRPORT_SIG_GPR_ARM_R4 = 0;
		OMRPORT_SIG_GPR_ARM_R5 = 0;
		OMRPORT_SIG_GPR_ARM_R6 = 0;
		OMRPORT_SIG_GPR_ARM_R7 = 0;
		OMRPORT_SIG_GPR_ARM_R8 = 0;
		OMRPORT_SIG_GPR_ARM_R9 = 0;
		OMRPORT_SIG_GPR_X86_EAX = 0;
		OMRPORT_SIG_GPR_X86_EBX = 0;
		OMRPORT_SIG_GPR_X86_ECX = 0;
		OMRPORT_SIG_GPR_X86_EDI = 0;
		OMRPORT_SIG_GPR_X86_EDX = 0;
		OMRPORT_SIG_GPR_X86_ESI = 0;
		OMRPORT_SIG_MODULE = 0;
		OMRPORT_SIG_MODULE_FUNCTION_NAME = 0;
		OMRPORT_SIG_MODULE_NAME = 0;
		OMRPORT_SIG_NO_EXCEPTION = 0;
		OMRPORT_SIG_NUM_CATEGORIES = 0;
		OMRPORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN = 0;
		OMRPORT_SIG_OPTIONS_OMRSIG_NO_CHAIN = 0;
		OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS = 0;
		OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS = 0;
		OMRPORT_SIG_OPTIONS_SIGXFSZ = 0;
		OMRPORT_SIG_OPTIONS_ZOS_USE_CEEHDLR = 0;
		OMRPORT_SIG_OTHER = 0;
		OMRPORT_SIG_SIGNAL = 0;
		OMRPORT_SIG_SIGNAL_ADDRESS = 0;
		OMRPORT_SIG_SIGNAL_CODE = 0;
		OMRPORT_SIG_SIGNAL_ERROR_VALUE = 0;
		OMRPORT_SIG_SIGNAL_HANDLER = 0;
		OMRPORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS = 0;
		OMRPORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE = 0;
		OMRPORT_SIG_SIGNAL_TYPE = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY = 0;
		OMRPORT_SIG_VALUE_128 = 0;
		OMRPORT_SIG_VALUE_16 = 0;
		OMRPORT_SIG_VALUE_32 = 0;
		OMRPORT_SIG_VALUE_64 = 0;
		OMRPORT_SIG_VALUE_ADDRESS = 0;
		OMRPORT_SIG_VALUE_FLOAT_64 = 0;
		OMRPORT_SIG_VALUE_STRING = 0;
		OMRPORT_SIG_VALUE_UNDEFINED = 0;
		OMRPORT_SIG_VR = 0;
		OMRPORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER = 0;
		OMRPORT_SLOPEN_DECORATE = 0;
		OMRPORT_SLOPEN_LAZY = 0;
		OMRPORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND = 0;
		OMRPORT_SLOPEN_OPEN_EXECUTABLE = 0;
		OMRPORT_SL_FOUND = 0;
		OMRPORT_SL_INVALID = 0;
		OMRPORT_SL_NOT_FOUND = 0;
		OMRPORT_SL_UNKNOWN = 0;
		OMRPORT_SL_UNSUPPORTED = 0;
		OMRPORT_SYSINFO_OS_FEATURES_SIZE = 0;
		OMRPORT_TIME_DELTA_IN_MICROSECONDS = 0;
		OMRPORT_TIME_DELTA_IN_MILLISECONDS = 0;
		OMRPORT_TIME_DELTA_IN_NANOSECONDS = 0;
		OMRPORT_TIME_DELTA_IN_SECONDS = 0;
		OMRPORT_TIME_HIRES_MICROTIME_DIVISOR = 0;
		OMRPORT_TIME_HIRES_MILLITIME_DIVISOR = 0;
		OMRPORT_TIME_HIRES_NANOTIME_DENOMINATOR = 0;
		OMRPORT_TIME_HIRES_NANOTIME_NUMERATOR = 0;
		OMRPORT_TIME_NS_PER_MS = 0;
		OMRPORT_TIME_US_PER_SEC = 0;
		OMRPORT_TTY_ERR = 0;
		OMRPORT_TTY_IN = 0;
		OMRPORT_TTY_OUT = 0;
		OMRPORT_VMEM_ALLOCATE_PERSIST = 0;
		OMRPORT_VMEM_ALLOCATE_TOP_DOWN = 0;
		OMRPORT_VMEM_ALLOC_DIR_BOTTOM_UP = 0;
		OMRPORT_VMEM_ALLOC_DIR_TOP_DOWN = 0;
		OMRPORT_VMEM_ALLOC_QUICK = 0;
		OMRPORT_VMEM_MEMORY_MODE_COMMIT = 0;
		OMRPORT_VMEM_MEMORY_MODE_EXECUTE = 0;
		OMRPORT_VMEM_MEMORY_MODE_READ = 0;
		OMRPORT_VMEM_MEMORY_MODE_VIRTUAL = 0;
		OMRPORT_VMEM_MEMORY_MODE_WRITE = 0;
		OMRPORT_VMEM_PAGE_FLAG_FIXED = 0;
		OMRPORT_VMEM_PAGE_FLAG_NOT_USED = 0;
		OMRPORT_VMEM_PAGE_FLAG_PAGEABLE = 0;
		OMRPORT_VMEM_PAGE_FLAG_SUPERPAGE_ANY = 0;
		OMRPORT_VMEM_PAGE_FLAG_TYPE_MASK = 0;
		OMRPORT_VMEM_RESERVE_USED_INVALID = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_BELOW_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_IN_2TO32G_AREA = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_FIXED_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGEABLE_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGES_BELOW_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9MEM_ALLOCATE_MEMORY = 0;
		OMRPORT_VMEM_RESERVE_USED_MALLOC31 = 0;
		OMRPORT_VMEM_RESERVE_USED_MMAP = 0;
		OMRPORT_VMEM_RESERVE_USED_MOSERVICES = 0;
		OMRPORT_VMEM_RESERVE_USED_SHM = 0;
		OMRPORT_VMEM_STRICT_ADDRESS = 0;
		OMRPORT_VMEM_STRICT_PAGE_SIZE = 0;
		OMRPORT_VMEM_ZOS_USE2TO32G_AREA = 0;
		OMRPORT_VMEM_ZTPF_USE_31BIT_MALLOC = 0;
		OMRPORT_ZOS_FEATURE_RMODE64 = 0;
		OMRTIME_HIRES_CLOCK_FREQUENCY = 0;
		SIG_RI_INTERRUPT_INDEX = 0;
		UNICODE_REPLACEMENT_CHARACTER = 0;
		_gp_handler_functionOffset_ = 0;
		_gp_infoOffset_ = 0;
		_gp_info_countOffset_ = 0;
		_gp_protectOffset_ = 0;
		_gp_register_handlerOffset_ = 0;
		_gp_shutdownOffset_ = 0;
		_gp_startupOffset_ = 0;
		_gs_deinitializeOffset_ = 0;
		_gs_disableOffset_ = 0;
		_gs_enableOffset_ = 0;
		_gs_initializeOffset_ = 0;
		_gs_isEnabledOffset_ = 0;
		_gs_params_initOffset_ = 0;
		_hypervisor_get_guest_memory_usageOffset_ = 0;
		_hypervisor_get_guest_processor_usageOffset_ = 0;
		_hypervisor_get_hypervisor_infoOffset_ = 0;
		_hypervisor_hypervisor_presentOffset_ = 0;
		_hypervisor_shutdownOffset_ = 0;
		_hypervisor_startupOffset_ = 0;
		_ipcmutex_acquireOffset_ = 0;
		_ipcmutex_releaseOffset_ = 0;
		_ipcmutex_shutdownOffset_ = 0;
		_ipcmutex_startupOffset_ = 0;
		_isCheckPointAllowedOffset_ = 0;
		_nanoTimeMonotonicClockDeltaOffset_ = 0;
		_omrPortLibraryOffset_ = 0;
		_portGlobalsOffset_ = 0;
		_portVersionOffset_ = 0;
		_port_controlOffset_ = 0;
		_port_create_libraryOffset_ = 0;
		_port_init_libraryOffset_ = 0;
		_port_isFunctionOverriddenOffset_ = 0;
		_port_shutdown_libraryOffset_ = 0;
		_port_startup_libraryOffset_ = 0;
		_process_closeOffset_ = 0;
		_process_createOffset_ = 0;
		_process_getStreamOffset_ = 0;
		_process_get_availableOffset_ = 0;
		_process_get_exitCodeOffset_ = 0;
		_process_isCompleteOffset_ = 0;
		_process_readOffset_ = 0;
		_process_terminateOffset_ = 0;
		_process_waitforOffset_ = 0;
		_process_writeOffset_ = 0;
		_ri_deinitializeOffset_ = 0;
		_ri_disableOffset_ = 0;
		_ri_disableRISupportOffset_ = 0;
		_ri_enableOffset_ = 0;
		_ri_enableRISupportOffset_ = 0;
		_ri_initializeOffset_ = 0;
		_ri_params_initOffset_ = 0;
		_self_handleOffset_ = 0;
		_shmem_attachOffset_ = 0;
		_shmem_closeOffset_ = 0;
		_shmem_createDirOffset_ = 0;
		_shmem_destroyOffset_ = 0;
		_shmem_destroyDeprecatedOffset_ = 0;
		_shmem_detachOffset_ = 0;
		_shmem_findcloseOffset_ = 0;
		_shmem_findfirstOffset_ = 0;
		_shmem_findnextOffset_ = 0;
		_shmem_getDirOffset_ = 0;
		_shmem_getFilepathOffset_ = 0;
		_shmem_get_region_granularityOffset_ = 0;
		_shmem_getidOffset_ = 0;
		_shmem_handle_statOffset_ = 0;
		_shmem_openOffset_ = 0;
		_shmem_openDeprecatedOffset_ = 0;
		_shmem_protectOffset_ = 0;
		_shmem_shutdownOffset_ = 0;
		_shmem_startupOffset_ = 0;
		_shmem_statOffset_ = 0;
		_shmem_statDeprecatedOffset_ = 0;
		_shsem_closeOffset_ = 0;
		_shsem_deprecated_closeOffset_ = 0;
		_shsem_deprecated_destroyOffset_ = 0;
		_shsem_deprecated_destroyDeprecatedOffset_ = 0;
		_shsem_deprecated_getValOffset_ = 0;
		_shsem_deprecated_getidOffset_ = 0;
		_shsem_deprecated_handle_statOffset_ = 0;
		_shsem_deprecated_openOffset_ = 0;
		_shsem_deprecated_openDeprecatedOffset_ = 0;
		_shsem_deprecated_postOffset_ = 0;
		_shsem_deprecated_setValOffset_ = 0;
		_shsem_deprecated_shutdownOffset_ = 0;
		_shsem_deprecated_startupOffset_ = 0;
		_shsem_deprecated_waitOffset_ = 0;
		_shsem_destroyOffset_ = 0;
		_shsem_getValOffset_ = 0;
		_shsem_openOffset_ = 0;
		_shsem_params_initOffset_ = 0;
		_shsem_postOffset_ = 0;
		_shsem_setValOffset_ = 0;
		_shsem_shutdownOffset_ = 0;
		_shsem_startupOffset_ = 0;
		_shsem_waitOffset_ = 0;
		_sock_error_messageOffset_ = 0;
		_sock_freeaddrinfoOffset_ = 0;
		_sock_getaddrinfoOffset_ = 0;
		_sock_getaddrinfo_addressOffset_ = 0;
		_sock_getaddrinfo_create_hintsOffset_ = 0;
		_sock_getaddrinfo_familyOffset_ = 0;
		_sock_getaddrinfo_lengthOffset_ = 0;
		_sock_getaddrinfo_nameOffset_ = 0;
		_sock_gethostbyaddrOffset_ = 0;
		_sock_gethostbynameOffset_ = 0;
		_sock_inetaddrOffset_ = 0;
		_sock_shutdownOffset_ = 0;
		_sock_startupOffset_ = 0;
		_sysinfo_DLPAR_enabledOffset_ = 0;
		_sysinfo_DLPAR_max_CPUsOffset_ = 0;
		_sysinfo_get_cache_infoOffset_ = 0;
		_sysinfo_get_classpathSeparatorOffset_ = 0;
		_sysinfo_get_hw_infoOffset_ = 0;
		_sysinfo_get_processing_capacityOffset_ = 0;
		_sysinfo_shutdownOffset_ = 0;
		_sysinfo_startupOffset_ = 0;
		_sysinfo_weak_memory_consistencyOffset_ = 0;
	}

}
