/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.SocketChannel;
import jdk.test.lib.Platform;
import jtreg.SkippedException;

public class IPSupport {
    private static final boolean hasIPv4 = IPSupport.isSupported(Inet4Address.class);
    private static final boolean hasIPv6 = IPSupport.isSupported(Inet6Address.class);
    private static final boolean preferIPv4Stack = Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack"));
    private static final boolean preferIPv6Addresses = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses"));
    private static final int IPV4_SNDBUF = 65507;
    private static final int IPV6_SNDBUF = 65527;
    private static final int IPV6_SNDBUF_AIX = 65487;

    private static boolean isSupported(Class<? extends InetAddress> addressType) {
        boolean bl;
        block8: {
            StandardProtocolFamily family = addressType == Inet4Address.class ? StandardProtocolFamily.INET : StandardProtocolFamily.INET6;
            SocketChannel sc = SocketChannel.open(family);
            try {
                bl = true;
                if (sc == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sc != null) {
                        try {
                            sc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UnsupportedOperationException ex) {
                    return false;
                }
            }
            sc.close();
        }
        return bl;
    }

    private IPSupport() {
    }

    public static final boolean hasIPv4() {
        return hasIPv4;
    }

    public static final boolean hasIPv6() {
        return hasIPv6;
    }

    public static final boolean preferIPv4Stack() {
        return preferIPv4Stack;
    }

    public static final boolean preferIPv6Addresses() {
        return preferIPv6Addresses;
    }

    public static final boolean currentConfigurationIsValid() {
        return IPSupport.hasIPv4() || IPSupport.hasIPv6();
    }

    public static void throwSkippedExceptionIfNonOperational() throws SkippedException {
        if (!IPSupport.currentConfigurationIsValid()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.println("Invalid networking configuration");
            IPSupport.printPlatformSupport(ps);
            throw new SkippedException(os.toString());
        }
    }

    public static void printPlatformSupport(PrintStream out) {
        out.println("IPSupport - IPv4: " + IPSupport.hasIPv4());
        out.println("IPSupport - IPv6: " + IPSupport.hasIPv6());
        out.println("preferIPv4Stack: " + IPSupport.preferIPv4Stack());
        out.println("preferIPv6Addresses: " + IPSupport.preferIPv6Addresses());
    }

    public static final int getMaxUDPSendBufSizeIPv4() {
        return 65507;
    }

    public static final int getMaxUDPSendBufSizeIPv6() {
        if (Platform.isAix()) {
            return 65487;
        }
        return 65527;
    }

    static {
        if (!(preferIPv4Stack || hasIPv4 || hasIPv6)) {
            throw new AssertionError((Object)"IPv4 and IPv6 both not available and java.net.preferIPv4Stack is not true");
        }
    }
}

