/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: LinuxStaticInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the LinuxStaticInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=LinuxStaticInfo.class)
public class LinuxStaticInfoPointer extends StructurePointer {

	// NULL
	public static final LinuxStaticInfoPointer NULL = new LinuxStaticInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected LinuxStaticInfoPointer(long address) {
		super(address);
	}

	public static LinuxStaticInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static LinuxStaticInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static LinuxStaticInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new LinuxStaticInfoPointer(address);
	}

	public LinuxStaticInfoPointer add(long count) {
		return LinuxStaticInfoPointer.cast(address + (LinuxStaticInfo.SIZEOF * count));
	}

	public LinuxStaticInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public LinuxStaticInfoPointer addOffset(long offset) {
		return LinuxStaticInfoPointer.cast(address + offset);
	}

	public LinuxStaticInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public LinuxStaticInfoPointer sub(long count) {
		return LinuxStaticInfoPointer.cast(address - (LinuxStaticInfo.SIZEOF * count));
	}

	public LinuxStaticInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public LinuxStaticInfoPointer subOffset(long offset) {
		return LinuxStaticInfoPointer.cast(address - offset);
	}

	public LinuxStaticInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public LinuxStaticInfoPointer untag(long mask) {
		return LinuxStaticInfoPointer.cast(address & ~mask);
	}

	public LinuxStaticInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return LinuxStaticInfo.SIZEOF;
	}

	// Implementation methods

	// U8[] VMName
	public U8Pointer VMNameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(LinuxStaticInfo._VMNameOffset_));
	}

	// U64 cpuClockSpeedMHz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpuClockSpeedMHzOffset_", declaredType="U64")
	public UDATA cpuClockSpeedMHz() throws CorruptDataException {
		return new U64(getLongAtOffset(LinuxStaticInfo._cpuClockSpeedMHzOffset_));
	}

	// U64 cpuClockSpeedMHz
	public UDATAPointer cpuClockSpeedMHzEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(LinuxStaticInfo._cpuClockSpeedMHzOffset_));
	}

	// omrthread_monitor_t hyperMonitor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hyperMonitorOffset_", declaredType="omrthread_monitor_t")
	public J9ThreadMonitorPointer hyperMonitor() throws CorruptDataException {
		return J9ThreadMonitorPointer.cast(getPointerAtOffset(LinuxStaticInfo._hyperMonitorOffset_));
	}

	// omrthread_monitor_t hyperMonitor
	public PointerPointer hyperMonitorEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(LinuxStaticInfo._hyperMonitorOffset_));
	}

	// U8* hypfsDir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hypfsDirOffset_", declaredType="U8*")
	public U8Pointer hypfsDir() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(LinuxStaticInfo._hypfsDirOffset_));
	}

	// U8* hypfsDir
	public PointerPointer hypfsDirEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(LinuxStaticInfo._hypfsDirOffset_));
	}

	// U8[] machType
	public U8Pointer machTypeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(LinuxStaticInfo._machTypeOffset_));
	}

}
