/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: mntentPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the mntentPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=mntent.class)
public class mntentPointer extends StructurePointer {

	// NULL
	public static final mntentPointer NULL = new mntentPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected mntentPointer(long address) {
		super(address);
	}

	public static mntentPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static mntentPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static mntentPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new mntentPointer(address);
	}

	public mntentPointer add(long count) {
		return mntentPointer.cast(address + (mntent.SIZEOF * count));
	}

	public mntentPointer add(Scalar count) {
		return add(count.longValue());
	}

	public mntentPointer addOffset(long offset) {
		return mntentPointer.cast(address + offset);
	}

	public mntentPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public mntentPointer sub(long count) {
		return mntentPointer.cast(address - (mntent.SIZEOF * count));
	}

	public mntentPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public mntentPointer subOffset(long offset) {
		return mntentPointer.cast(address - offset);
	}

	public mntentPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public mntentPointer untag(long mask) {
		return mntentPointer.cast(address & ~mask);
	}

	public mntentPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return mntent.SIZEOF;
	}

	// Implementation methods

	// U8* mnt_dir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_dirOffset_", declaredType="U8*")
	public U8Pointer mnt_dir() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(mntent._mnt_dirOffset_));
	}

	// U8* mnt_dir
	public PointerPointer mnt_dirEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mntent._mnt_dirOffset_));
	}

	// I32 mnt_freq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_freqOffset_", declaredType="I32")
	public IDATA mnt_freq() throws CorruptDataException {
		return new I32(getIntAtOffset(mntent._mnt_freqOffset_));
	}

	// I32 mnt_freq
	public IDATAPointer mnt_freqEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mntent._mnt_freqOffset_));
	}

	// U8* mnt_fsname
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_fsnameOffset_", declaredType="U8*")
	public U8Pointer mnt_fsname() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(mntent._mnt_fsnameOffset_));
	}

	// U8* mnt_fsname
	public PointerPointer mnt_fsnameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mntent._mnt_fsnameOffset_));
	}

	// U8* mnt_opts
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_optsOffset_", declaredType="U8*")
	public U8Pointer mnt_opts() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(mntent._mnt_optsOffset_));
	}

	// U8* mnt_opts
	public PointerPointer mnt_optsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mntent._mnt_optsOffset_));
	}

	// I32 mnt_passno
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_passnoOffset_", declaredType="I32")
	public IDATA mnt_passno() throws CorruptDataException {
		return new I32(getIntAtOffset(mntent._mnt_passnoOffset_));
	}

	// I32 mnt_passno
	public IDATAPointer mnt_passnoEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(mntent._mnt_passnoOffset_));
	}

	// U8* mnt_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mnt_typeOffset_", declaredType="U8*")
	public U8Pointer mnt_type() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(mntent._mnt_typeOffset_));
	}

	// U8* mnt_type
	public PointerPointer mnt_typeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(mntent._mnt_typeOffset_));
	}

}
