/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_nqo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "\u07ca\u07d0\u07d8" },
            { "AFN", "\u07ca\u07dd\u07ca" },
            { "ALL", "\u07ca\u07df\u07df" },
            { "AMD", "\u07ca\u07e1\u07d8" },
            { "ANG", "\u07ca\u07f2\u07d5\u07dd" },
            { "AOA", "\u07ca\u07f2\u07dc\u07ed\u07ce" },
            { "AON", "\u07ca\u07dc\u07ed\u07de" },
            { "AOR", "\u07ca\u07dc\u07ed\u07dd" },
            { "ARS", "\u07ca\u07d6\u07ed\u07d4" },
            { "AUD", "$\u07d0" },
            { "AWG", "\u07ca\u07e5\u07d6\u07ed" },
            { "AZN", "\u07ca\u07d6\u07e3" },
            { "BAM", "\u07d3\u07cd\u07e1" },
            { "BBD", "\u07d3\u07d3\u07d8" },
            { "BDT", "\u07d3\u07d8\u07d5" },
            { "BGN", "\u07d3\u07dc\u07ed\u07df" },
            { "BHD", "\u07d3\u07e4\u07d8" },
            { "BIF", "\u07d3\u07d9\u07dd" },
            { "BMD", "\u07d3\u07e1\u07d8" },
            { "BND", "\u07d3\u07e3\u07d8" },
            { "BOB", "\u07d3\u07cf\u07d3" },
            { "BSD", "\u07d3\u07db\u07d8" },
            { "BTN", "\u07d3\u07d5\u07d2" },
            { "BWP", "\u07d3\u07e5\u07d4" },
            { "BYN", "\u07d3\u07cc\u07d9" },
            { "CDF", "\u07de\u07dd" },
            { "CHF", "\u07db\u07e5\u07dd" },
            { "CLP", "\u07db\u07df\u07d4" },
            { "CNH", "\u07db\u07e6\u07e4" },
            { "CNY", "\u07db\u07e3\u07e6" },
            { "COP", "\u07de\u07d0\u07d4" },
            { "CRC", "\u07de\u07d9\u07de" },
            { "CUC", "\u07de\u07ce\u07f3\u07de" },
            { "CUP", "\u07de\u07ce\u07f3\u07d4" },
            { "CVE", "\u07cd\u07db\u07de" },
            { "CZK", "\u07d7\u07de\u07de" },
            { "DJF", "\u07d6\u07d3\u07dd" },
            { "DKK", "\u07d8\u07de\u07de" },
            { "DOP", "\u07d8\u07cf\u07d4" },
            { "DZD", "\u07ca\u07df\u07d8" },
            { "EGP", "\u07e1\u07db\u07d4" },
            { "ERN", "\u07cb\u07d9\u07dd" },
            { "ETB", "\u07cb\u07d7\u07d3" },
            { "FJD", "$ \u07dd\u07d6" },
            { "FKP", "\u07dd\u07de\u07d4" },
            { "GEL", "\u07d6\u07ed\u07d0\u07df" },
            { "GHS", "\u07dc\u07ed\u07db\u07d8" },
            { "GIP", "\u07d6\u07ed\u07d3\u07d4\u00a3" },
            { "GMD", "\u07dc\u07ed\u07d3\u07d8" },
            { "GNF", "\u07ff" },
            { "GNS", "\u07d6\u07db\u07fe" },
            { "GQE", "\u07d5\u07d6\u07cb" },
            { "GTQ", "\u07dc\u07ed\u07d5\u07de" },
            { "GWE", "\u07d6\u07d3\u07cd" },
            { "GWP", "\u07d6\u07d3\u07d4" },
            { "GYD", "\u07dc\u07ed\u07ce\u07f3\u07d8" },
            { "HKD", "\u07e4\u07de\u07d8" },
            { "HNL", "\u07e4\u07d8\u07df" },
            { "HRK", "\u07de\u07db\u07de" },
            { "HTG", "\u07e4\u07d5\u07dc\u07ed" },
            { "HUF", "\u07e4\u07dc\u07ed\u07dd" },
            { "IDR", "\u07cd\u07f2\u07d8\u07d9" },
            { "IQD", "\u07cc\u07de\u07d8" },
            { "IRR", "\u07cc\u07d9\u07d9" },
            { "ISK", "\u07cc\u07db\u07de" },
            { "JMD", "\u07d6\u07e1\u07d8" },
            { "JOD", "\u07d6\u07d0\u07d8" },
            { "JPY", "\u07d7\u07ed\u07d4\u07e6" },
            { "KES", "\u07de\u07cb\u07db" },
            { "KGS", "\u07de\u07dc\u07ed\u07db" },
            { "KHR", "\u07de\u07d3\u07d9" },
            { "KMF", "\u07de\u07e1\u07dd" },
            { "KPW", "\u07de\u07de\u07e5" },
            { "KWD", "\u07de\u07e5\u07d8" },
            { "KYD", "\u07de\u07cc\u07d8" },
            { "KZT", "\u07de\u07d7\u07ed\u07d5" },
            { "LAK", "\u07df\u07ca\u07de" },
            { "LBP", "\u07df\u07d3\u00a3" },
            { "LKR", "\u07df\u07de\u07d9" },
            { "LRD", "\u07df\u07fe" },
            { "LSL", "\u07df\u07db\u07df" },
            { "LYD", "\u07df\u07d3\u07d8" },
            { "MAD", "\u07e1\u07d8\u07e4" },
            { "MAF", "\u07e1\u07d9\u07dd" },
            { "MDL", "\u07e1\u07d8\u07df" },
            { "MGA", "\u07e1\u07d8\u07d9" },
            { "MGF", "\u07e1\u07d8\u07dd" },
            { "MKD", "\u07e1\u07de\u07d8" },
            { "MLF", "\u07e1\u07dd" },
            { "MMK", "\u07e1\u07e1\u07de" },
            { "MNT", "\u07e1\u07e3\u07d5" },
            { "MOP", "\u07e1\u07cf\u07d4" },
            { "MRO", "\u07e1\u07d9\u07cf" },
            { "MRU", "\u07e1\u07ce\u07dc\u07ed" },
            { "MUR", "\u07e1\u07d9\u07d4" },
            { "MVR", "\u07e1\u07dd\u07ed\u07d9" },
            { "MWK", "\u07e1\u07df\u07de" },
            { "MXN", "\u07e1\u07de$" },
            { "MYR", "\u07e1\u07e6\u07d9" },
            { "MZE", "\u07e1\u07d6\u07ed\u07cb" },
            { "MZM", "\u07e1\u07d6\u07e1" },
            { "MZN", "\u07e1\u07d6\u07ed\u07e1" },
            { "NAD", "\u07e3\u07e1\u07d8" },
            { "NGN", "\u07d6\u07e3" },
            { "NIO", "\u07e3\u07cc\u07cf" },
            { "NOK", "\u07e3\u07d0\u07de" },
            { "NPR", "\u07e3\u07d4\u07d9" },
            { "NZD", "$\u07e3\u07d6\u07ed" },
            { "OMR", "\u07cf\u07e1\u07d9" },
            { "PAB", "\u07d4\u07ca\u07d3" },
            { "PEN", "\u07d4\u07cb\u07db" },
            { "PGK", "\u07d4\u07d6\u07de" },
            { "PKR", "\u07d4\u07de\u07d9" },
            { "PLN", "\u07d4\u07df\u07d7\u07ed" },
            { "PYG", "\u07d4\u07d9\u07dc\u07ed" },
            { "QAR", "\u07de\u07ca\u07d9" },
            { "RHD", "\u07d6\u07ed\u07d3\u07d8" },
            { "RON", "\u07d9\u07ce\u07df" },
            { "RSD", "\u07d9\u07db\u07d8" },
            { "RUB", "\u07cc\u07ce\u07d9" },
            { "RWF", "\u07d9\u07e5\u07dd" },
            { "SAR", "\u07db\u07ca\u07d9" },
            { "SBD", "\u07db\u07d3\u07d8" },
            { "SCR", "\u07db\u07db\u07e5" },
            { "SDD", "\u07db\u07d8\u07d8" },
            { "SDG", "\u07db\u07d8\u07dc\u07ed" },
            { "SDP", "\u07db\u07d8\u07d4" },
            { "SEK", "\u07db\u07e5\u07de" },
            { "SGD", "\u07db\u07dc\u07ed\u07d8" },
            { "SHP", "\u07db\u07e4\u07d4" },
            { "SLE", "\u07db\u07d9\u07d4" },
            { "SLL", "\u07db\u07df\u07df" },
            { "SOS", "\u07db\u07e1\u07db" },
            { "SRD", "\u07db\u07ce\u07d8" },
            { "SSP", "\u07db\u07db\u07d4" },
            { "STD", "\u07db\u07d5\u07d8" },
            { "STN", "\u07db\u07d4\u07d8" },
            { "SYP", "\u07db\u07cc\u07d4" },
            { "SZL", "\u07db\u07d6\u07ed\u07df" },
            { "THB", "\u07d5\u07d8\u07d3" },
            { "TJS", "\u07d5\u07d6\u07db" },
            { "TMT", "\u07d5\u07e1\u07d5" },
            { "TND", "\u07d5\u07e3\u07d8" },
            { "TOP", "\u07d5\u07cf\u07d4" },
            { "TRY", "\u07d5\u07ce\u07df" },
            { "TTD", "\u07d5\u07d5\u07d8" },
            { "TWD", "\u07d5\u07e5\u07d8" },
            { "TZS", "\u07d5\u07d6\u07ed\u07db" },
            { "UAH", "\u07cc\u07de\u07e4" },
            { "UGS", "\u07ce\u07dc\u07ed\u07e5" },
            { "UGX", "\u07ce\u07dc\u07ed\u07db" },
            { "USD", "\u07ca\u07de\u07d8$" },
            { "UYU", "\u07ce\u07f3\u07d4" },
            { "UZS", "\u07ce\u07d7\u07ed\u07db" },
            { "VES", "\u07dd\u07ed\u07cb\u07d3" },
            { "VUV", "\u07dd\u07ed\u07d5\u07dd\u07ed" },
            { "WST", "$\u07e5\u07db" },
            { "XAF", "\u07dd\u07db\u07dd" },
            { "XCD", "\u07db\u07df\u07d8" },
            { "XOF", "\u07fe" },
            { "XPF", "\u07fe \u07dd\u07db\u07dd" },
            { "YER", "\u07e6\u07e1\u07d9" },
            { "ZAR", "\u07e5\u07dd\u07d9" },
            { "ZMK", "\u07d6\u07ed\u07d3\u07de" },
            { "ZMW", "\u07d6\u07ed\u07d3\u07e5" },
            { "ZRN", "\u07d6\u07ed\u07d9" },
            { "ZRZ", "\u07d6\u07ed\u07d9\u07d6\u07ed" },
            { "ZWD", "\u07d6\u07ed\u07e5\u07d8" },
            { "ZWL", "\u07d6\u07ed\u07e5\u07df" },
            { "ZWR", "\u07d6\u07ed\u07e5\u07d9" },
            { "aed", "\u07ca\u07d9\u07ca\u07d3\u07ce\u07df\u07ca\u07eb \u07e1\u07ca\u07f2\u07ec\u07db\u07ca\u07ec\u07d9\u07cb\u07ec\u07e0\u07ca \u07df\u07ca\u07d8\u07cd\u07ec\u07e3\u07cd\u07f2 \u07d8\u07cc\u07ec\u07d9\u07d1\u07e4\u07ca\u07e1" },
            { "afn", "\u07ca\u07dd\u07ce\u07dc\u07ed\u07ca\u07e3\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07ca\u07dd\u07d1\u07dc\u07ed\u07ca\u07e3\u07cc\u07db" },
            { "all", "\u07ca\u07df\u07d1\u07d3\u07ca\u07e3\u07cc\u07eb \u07df\u07cd\u07de" },
            { "amd", "\u07ca\u07d9\u07d1\u07e1\u07cb\u07e3\u07cc\u07eb \u07d8\u07cc\u07ec\u07d9\u07d1\u07e4\u07ca\u07e1" },
            { "ang", "\u07de\u07ce\u07d9\u07ca\u07db\u07ca\u07e5\u07cf\u07eb \u07ca\u07f2\u07d5\u07cc\u07eb \u07dd\u07d1\u07df\u07cf\u07d9\u07cc\u07f2\u07db" },
            { "aoa", "\u07ca\u07f2\u07dc\u07ed\u07cf\u07df\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07ca\u07f2\u07d6\u07ed\u07ca" },
            { "aok", "\u07ca\u07f2\u07dc\u07ed\u07cf\u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07ca\u07f2\u07d6\u07ed\u07ca ( \u07c1\u07c9\u07c7\u07c7\u2013\u07c1\u07c9\u07c9\u07c0 )" },
            { "aon", "\u07ca\u07f2\u07dc\u07ed\u07cf\u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07ca\u07d6\u07ed\u07ca\u07eb \u07de\u07ce\u07d8\u07ca ( \u07c1\u07c9\u07c9\u07c0\u2013\u07c2\u07c0\u07c0\u07c0 )" },
            { "aor", "\u07ca\u07f2\u07dc\u07ed\u07cf\u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07ca\u07d6\u07ed\u07ca \u07dd\u07ca\u07f2\u07ec\u07de\u07ca\u07d8\u07cf\u07f2\u07ec\u07e3\u07cd\u07f2 ( \u07c1\u07c9\u07c9\u07c5\u2013\u07c1\u07c9\u07c9\u07c9 )" },
            { "ars", "\u07ca\u07d9\u07d1\u07d6\u07ed\u07ca\u07f2\u07d5\u07cc\u07f2\u07eb \u07d4\u07cb\u07db\u07cf" },
            { "aud", "\u07d0\u07db\u07d1\u07d5\u07d9\u07ca\u07df\u07cc\u07eb \u07d8\u07df\u07ca" },
            { "awg", "\u07ca\u07d9\u07ce\u07d3\u07ca\u07eb \u07dd\u07d1\u07df\u07cf\u07d9\u07cc\u07f2\u07db" },
            { "azn", "\u07ca\u07d6\u07cd\u07d9\u07d1\u07d3\u07ca\u07e6\u07cc\u07d6\u07ca\u07f2\u07eb \u07ca\u07d7\u07ed\u07cb\u07d9\u07cc" },
            { "bam", "\u07d3\u07d0\u07db\u07d1\u07e3\u07cc\u07eb \u07cd\u07d9\u07d1\u07d7\u07ed\u07cb\u07dc\u07ed\u07cf\u07dd\u07ed\u07cc\u07e3 \u07e1\u07ca\u07d9\u07de \u07dd\u07ca\u07ec\u07df\u07cb\u07f2\u07ec\u07d5\u07ca" },
            { "bbd", "\u07d3\u07ca\u07d9\u07d1\u07d3\u07ca\u07d8\u07d0\u07db \u07d8\u07df\u07ca" },
            { "bdt", "\u07d3\u07ca\u07f2\u07dc\u07ed\u07d1\u07df\u07ca\u07d8\u07cd\u07db \u07d5\u07de\u07ca" },
            { "bgn", "\u07d3\u07ce\u07f3\u07df\u07d1\u07dc\u07ed\u07ca\u07d9\u07cc\u07eb \u07df\u07cd\u07dd\u07ed" },
            { "bhd", "\u07d3\u07e4\u07ca\u07ec\u07d9\u07ca\u07e6\u07cc\u07e3 \u07d8\u07cc\u07ec\u07e3\u07ca\u07d9" },
            { "bif", "\u07d3\u07ce\u07d9\u07ce\u07f2\u07d8\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "bmd", "\u07d3\u07cd\u07d9\u07d1\u07e1\u07ce\u07d8\u07ca\u07eb \u07d8\u07df\u07ca" },
            { "bnd", "\u07d3\u07d9\u07ce\u07e3\u07cc\u07eb \u07d8\u07df\u07ca" },
            { "bob", "\u07d3\u07cf\u07df\u07dd\u07ed\u07cc\u07eb \u07d3\u07cf\u07df\u07dd\u07ed\u07cc\u07e6\u07ca\u07e3\u07cf\u07ec" },
            { "brl", "\u07d3\u07d9\u07cb\u07d6\u07ed\u07cc\u07df \u07d9\u07cb\u07e6\u07ca\u07df" },
            { "bsd", "\u07d3\u07e4\u07ca\u07e1\u07ca\u07db \u07d8\u07df\u07ca" },
            { "btn", "\u07d3\u07ce\u07d5\u07ca\u07f2\u07eb \u07d2\u07dc\u07ed\u07ce\u07df\u07d1\u07d5\u07d9\u07ce\u07e1" },
            { "bwp", "\u07d3\u07d0\u07db\u07ce\u07e5\u07e3\u07ca\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07ce\u07df\u07ca" },
            { "byn", "\u07d3\u07cc\u07df\u07cf\u07d9\u07cc\u07db \u07d9\u07d3\u07ce\u07df" },
            { "bzd", "\u07d3\u07d9\u07cb\u07d6\u07ed\u07cc\u07df \u07d8\u07df\u07ca" },
            { "cdf", "\u07de\u07cf\u07f2\u07ec\u07dc\u07ed\u07cf\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "chf", "\u07db\u07ce\u07e5\u07cc\u07db \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "clp", "\u07db\u07ed\u07df\u07cc\u07eb \u07d4\u07cb\u07db\u07cf" },
            { "cnh", "\u07db\u07cc\u07e3 \u07e6\u07ce\u07e5\u07ca\u07e3 (\u07dd\u07ca\u07f2\u07ec\u07d5\u07d9\u07ca \u07d6\u07cc\u07d8\u07ca)" },
            { "cny", "\u07e6\u07ce\u07e5\u07ca\u07e3 \u07d9\u07ca\u07f2\u07e1\u07cc\u07f2\u07d3\u07cc\u07eb" },
            { "cop", "\u07de\u07d0\u07df\u07d0\u07f2\u07d3\u07cc\u07eb \u07d4\u07cb\u07db\u07cf" },
            { "crc", "\u07de\u07d0\u07db\u07d1\u07d5\u07ca\u07d9\u07cc\u07de\u07ca\u07eb \u07de\u07d0\u07df\u07d0\u07e3" },
            { "cuc", "\u07de\u07ce\u07f3\u07d3\u07ca\u07eb \u07d4\u07cb\u07db\u07cf\u07eb \u07dd\u07ca\u07ec\u07df\u07cb\u07f2\u07ec\u07d5\u07ca" },
            { "cup", "\u07de\u07ce\u07f3\u07d3\u07ca\u07eb \u07d4\u07cb\u07db\u07cf\u07eb\u07eb" },
            { "cve", "\u07dc\u07d9\u07cb\u07de\u07ce\u07f2\u07eb \u07dd\u07d9\u07cc\u07db\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07cd\u07db\u07d1\u07de\u07ce\u07d8\u07d0\u07db" },
            { "czk", "\u07d7\u07cb\u07de\u07cf\u07db\u07df\u07cf\u07dd\u07ed\u07ca\u07de\u07cc\u07eb \u07de\u07ce\u07d9\u07d0\u07e3" },
            { "djf", "\u07d6\u07cc\u07d3\u07ce\u07d5\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "dkk", "\u07d8\u07ca\u07e3\u07cc\u07e1\u07ca\u07d9\u07de \u07de\u07ce\u07d9\u07d0\u07e3" },
            { "dop", "\u07d8\u07cf\u07e1\u07e3\u07cc\u07de \u07de\u07ca\u07f2\u07d3\u07cd\u07f2 \u07d4\u07cb\u07db\u07cf" },
            { "dzd", "\u07ca\u07df\u07cc\u07d6\u07ed\u07cb\u07d9\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cc\u07ec\u07e3\u07ca\u07ef\u07d9\u07cc" },
            { "egp", "\u07e1\u07cc\u07db\u07cc\u07d9\u07ca\u07f2\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "ern", "\u07cb\u07d9\u07cc\u07d5\u07d9\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07e3\u07ca\u07dd\u07d1\u07de\u07ca" },
            { "etb", "\u07cb\u07d7\u07cf\u07d4\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d3\u07cc\u07d9\u07d1\u07db" },
            { "eur", "\u07cb\u07d9\u07cf" },
            { "fjd", "\u07dd\u07d6\u07cc\u07eb \u07d8\u07df\u07ca" },
            { "fkp", "\u07dd\u07ca\u07df\u07de\u07d1\u07df\u07ca\u07f2\u07d8 \u07cc\u07db\u07d1\u07df\u07ca\u07f2\u07d8 \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "gbp", "\u07e1\u07ca\u07ec\u07db\u07ca\u07ec\u07df\u07ca\u07eb-\u07d8\u07cd\u07ec\u07e3\u07cd\u07f2 \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "gel", "\u07d6\u07ed\u07d0\u07d9\u07d1\u07d6\u07cc\u07eb \u07df\u07ca\u07d9\u07cc" },
            { "ghc", "\u07db\u07d8\u07cc" },
            { "ghs", "\u07dc\u07ed\u07ca\u07ef\u07e3\u07ca\u07eb \u07db\u07d8\u07cc" },
            { "gip", "\u07d6\u07ed\u07cc\u07d3\u07d1\u07d9\u07ca\u07df\u07d1\u07d5\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "gmd", "\u07dc\u07ed\u07ca\u07f2\u07d3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07df\u07ca\u07db\u07cc\u07eb" },
            { "gnf", "\u07d6\u07cc\u07ec\u07e3\u07cd\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "gns", "\u07d6\u07cc\u07ec\u07e3\u07cd\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07df\u07cc" },
            { "gqe", "\u07d5\u07cd\u07e1\u07ca\u07d3\u07ca\u07f2\u07ee \u07d6\u07cc\u07ec\u07e3\u07cd\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07cb\u07de\u07e5\u07cb\u07df\u07cb" },
            { "gtq", "\u07dc\u07ed\u07ce\u07e5\u07ca\u07d5\u07cb\u07e1\u07df\u07ca\u07eb \u07de\u07cb\u07d5\u07d1\u07d7\u07ed\u07ca\u07df" },
            { "gwe", "\u07d6\u07cc\u07e3\u07cd\u07eb \u07d3\u07cc\u07db\u07ca\u07e5\u07cf\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07cd\u07db\u07d1\u07de\u07ce\u07d8\u07d0\u07db" },
            { "gwp", "\u07d6\u07cc\u07e3\u07cd\u07eb \u07d3\u07cc\u07db\u07ca\u07e5\u07cf\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07cb\u07d6\u07ed\u07cf" },
            { "gyd", "\u07dc\u07ed\u07ce\u07f3\u07e6\u07ca\u07e3 \u07d8\u07df\u07ca" },
            { "hkd", "\u07e4\u07d0\u07f2\u07de\u07d0\u07f2\u07eb \u07d8\u07df\u07ca" },
            { "hnl", "\u07e4\u07d0\u07f2\u07d8\u07ce\u07d9\u07ca\u07eb \u07df\u07cb\u07f2\u07d4\u07cc\u07d9\u07ca" },
            { "hrk", "\u07de\u07d9\u07cf\u07e5\u07ca\u07db\u07cc\u07eb \u07de\u07ce\u07e3\u07ca\u07ec" },
            { "htg", "\u07e4\u07ca\u07e6\u07d5\u07cc\u07eb \u07dc\u07ed\u07ce\u07d9\u07d1\u07d8" },
            { "huf", "\u07e2\u07d0\u07f2\u07dc\u07ed\u07d9\u07cc\u07eb \u07dd\u07cf\u07d9\u07cd\u07f2\u07d5" },
            { "idr", "\u07cd\u07f2\u07d8\u07e3\u07cf\u07db\u07cc\u07eb \u07d9\u07ce\u07d4\u07cc" },
            { "ils", "\u07cc\u07db\u07d1\u07d9\u07ca\u07cd\u07df \u07db\u07cc\u07de\u07cd\u07df \u07de\u07ce\u07d8\u07ca" },
            { "inr", "\u07e4\u07cc\u07f2\u07d8\u07ce\u07ec \u07d9\u07ce\u07d4\u07cc" },
            { "iqd", "\u07cc\u07d9\u07ca\u07de\u07cc\u07ec \u07d8\u07cc\u07ec\u07e3\u07ca\u07d9" },
            { "irr", "\u07cc\u07d9\u07ca\u07f2\u07eb \u07d9\u07cc\u07ec\u07e6\u07ca\u07df" },
            { "isk", "\u07cc\u07db\u07d1\u07df\u07ca\u07f2\u07d8 \u07de\u07ce\u07d9\u07d0\u07e3" },
            { "jmd", "\u07d6\u07e1\u07ca\u07e6\u07cc\u07de \u07d8\u07df\u07ca" },
            { "jod", "\u07d6\u07d0\u07d9\u07d1\u07d8\u07ca\u07e3\u07cc\u07eb \u07d8\u07cc\u07ec\u07e3\u07ca\u07d9" },
            { "jpy", "\u07e3\u07cc\u07d4\u07d0\u07f2\u07eb \u07e6\u07cd\u07e3" },
            { "kes", "\u07dd\u07cb\u07e3\u07cc\u07e6\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07cc\u07df\u07cc\u07f2\u07dc\u07ed" },
            { "kgs", "\u07de\u07cc\u07d9\u07dc\u07ed\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07db\u07d0\u07e1" },
            { "khr", "\u07de\u07ca\u07f2\u07d3\u07d0\u07d8\u07d1\u07d6 \u07d9\u07cc\u07e6\u07cd\u07df" },
            { "kmf", "\u07de\u07d0\u07e1\u07f2\u07ef\u07d9\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "kpw", "\u07de\u07d0\u07ec\u07d8\u07ce\u07ee-\u07de\u07cf\u07d9\u07cb\u07eb \u07e5\u07d0\u07e3" },
            { "krw", "\u07e5\u07d9\u07cf\u07ec\u07d8\u07ce\u07ee-\u07de\u07cf\u07d9\u07cb\u07eb \u07e5\u07d0\u07e3" },
            { "kwd", "\u07de\u07ce\u07ec\u07e5\u07cd\u07d5 \u07d8\u07cc\u07ec\u07e3\u07ca\u07d9" },
            { "kyd", "\u07de\u07ca\u07e6\u07cc\u07e1\u07ca\u07f2\u07eb \u07cc\u07db\u07d1\u07df\u07ca\u07f2\u07d8 \u07d8\u07df\u07ca" },
            { "kzt", "\u07de\u07d7\u07ed\u07ca\u07de\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07d5\u07ca\u07f2\u07d6\u07ed" },
            { "lak", "\u07df\u07ca\u07cf\u07d5\u07cc\u07eb \u07de\u07cc\u07d4" },
            { "lbp", "\u07df\u07cc\u07d3\u07ca\u07f2\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "lkr", "\u07db\u07d9\u07cc\u07eb \u07df\u07ca\u07f2\u07de\u07ca\u07eb \u07d9\u07ce\u07d4\u07cc" },
            { "lrd", "\u07df\u07cc\u07d3\u07cb\u07d9\u07cc\u07e6\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07d9" },
            { "lsl", "\u07df\u07cb\u07db\u07d5\u07cf\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07df\u07cf\u07d5\u07cc" },
            { "lyd", "\u07df\u07d3\u07cc\u07eb \u07d8\u07cc\u07ec\u07e3\u07ca\u07ef\u07d9" },
            { "mad", "\u07e1\u07ca\u07ec\u07d9\u07d0\u07de\u07ce\u07ec \u07d8\u07cc\u07ec\u07d9\u07d1\u07e4\u07ca\u07e1" },
            { "maf", "\u07e1\u07ca\u07ec\u07d9\u07d0\u07ec\u07de\u07ce\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "mdl", "\u07dd\u07d0\u07df\u07d1\u07d8\u07ca\u07dd\u07ed\u07cc\u07eb \u07df\u07cb\u07f3" },
            { "mga", "\u07e1\u07d8\u07ca\u07dc\u07ed\u07ca\u07db\u07d1\u07de\u07ca\u07ef\u07d9\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07ca\u07d9\u07cc\u07e6\u07ca\u07d9\u07cc" },
            { "mgf", "\u07e1\u07d8\u07ca\u07dc\u07ed\u07ca\u07d1\u07de\u07ca\u07ef\u07d9\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "mkd", "\u07e1\u07ca\u07db\u07cb\u07d8\u07cf\u07e3\u07cc\u07eb \u07d8\u07cb\u07e3\u07ca\u07d9" },
            { "mlf", "\u07e1\u07ca\u07df\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "mmk", "\u07e1\u07cc\u07e6\u07ca\u07f2\u07e1\u07ca\u07d9 \u07de\u07cc\u07e6\u07ca\u07d5" },
            { "mnt", "\u07e1\u07d0\u07f2\u07dc\u07ed\u07d0\u07df\u07cc\u07eb \u07d5\u07ce\u07dc\u07ed\u07d9\u07cc\u07de" },
            { "mop", "\u07e1\u07de\u07ca\u07e5\u07cf\u07eb \u07d4\u07d5\u07ca\u07de\u07ca\u07eb" },
            { "mro", "\u07e1\u07cf\u07d9\u07cc\u07d5\u07ca\u07e3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07ce\u07ec\u07dc\u07ed\u07cc\u07e6\u07ca ( \u07c1\u07c9\u07c7\u07c3\u2013\u07c2\u07c0\u07c1\u07c7 )" },
            { "mru", "\u07e1\u07cf\u07d9\u07cc\u07d5\u07ca\u07e3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07ce\u07ec\u07dc\u07ed\u07cc\u07e6\u07ca" },
            { "mur", "\u07e1\u07cf\u07d9\u07db\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d9\u07d4\u07ce" },
            { "mvr", "\u07e1\u07ca\u07df\u07d1\u07d8\u07dd\u07ed\u07cc\u07eb \u07d9\u07ce\u07dd\u07cc\u07e6\u07ca" },
            { "mwk", "\u07e1\u07df\u07ca\u07e5\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07db\u07ca" },
            { "mxn", "\u07e1\u07cd\u07de\u07d1\u07db\u07cc\u07de \u07d4\u07cb\u07db\u07cf" },
            { "myr", "\u07e1\u07ca\u07df\u07cd\u07d8\u07ce\u07ef \u07d9\u07cc\u07f2\u07d6\u07ed\u07cc" },
            { "mze", "\u07e1\u07cf\u07d6\u07ed\u07ca\u07f2\u07d3\u07de\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07cd\u07db\u07d1\u07de\u07ce\u07d8\u07cf\u07db" },
            { "mzm", "\u07e1\u07cf\u07d6\u07ed\u07ca\u07f2\u07d3\u07de\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07e1\u07cb\u07d5\u07cc\u07de ( \u07c1\u07c9\u07c8\u07c0\u2013\u07c2\u07c0\u07c0\u07c6 )" },
            { "mzn", "\u07e1\u07cf\u07d6\u07ed\u07ca\u07f2\u07d3\u07de\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07e1\u07cb\u07d5\u07cc\u07de\u07ca\u07df" },
            { "nad", "\u07e3\u07ca\u07e1\u07cc\u07f2\u07d3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07ef\u07d9" },
            { "ngn", "\u07d6\u07cb\u07ec\u07df\u07cc\u07ec\u07d3\u07ca\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07e3\u07cd\u07d9\u07ca" },
            { "nio", "\u07e3\u07cc\u07de\u07d9\u07ca\u07dc\u07ed\u07ce\u07e5\u07ca\u07eb \u07de\u07d0\u07d9\u07d1\u07d8\u07cf\u07d3\u07ca\u07eb \u07cf\u07d9\u07cf\u07eb" },
            { "nok", "\u07e3\u07d0\u07d9\u07d1\u07dd\u07ed\u07cd\u07db \u07de\u07ce\u07d9\u07d0\u07e3" },
            { "npr", "\u07e3\u07cb\u07d4\u07ca\u07df \u07d9\u07ce\u07d4\u07cc" },
            { "nzd", "\u07e3\u07cc\u07e6\u07ce\u07d6\u07ed\u07cc\u07df\u07ca\u07f2\u07d8\u07cc\u07eb \u07d8\u07df\u07ca" },
            { "omr", "\u07cf\u07e1\u07ca\u07e3 \u07d9\u07cc\u07ec\u07e6\u07ca\u07df" },
            { "pab", "\u07d4\u07e3\u07ca\u07e1\u07ca\u07eb \u07d3\u07ca\u07df\u07d1\u07d3\u07cf\u07e5\u07ca\u07eb" },
            { "pen", "\u07d4\u07cb\u07d9\u07ce\u07eb \u07db\u07d0\u07df" },
            { "pgk", "\u07d4\u07ca\u07d4\u07ce\u07e5\u07ca\u07eb \u07d6\u07cc\u07ec\u07e3\u07cd\u07ec \u07de\u07ce\u07d8\u07ca\u07eb \u07de\u07cc\u07e3\u07ca" },
            { "php", "\u07dd\u07df\u07cc\u07d4\u07cc\u07e3 \u07d4\u07cb\u07db\u07cf" },
            { "pkr", "\u07d4\u07ca\u07de\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07d9\u07ce\u07d4\u07cc" },
            { "pln", "\u07d4\u07cf\u07df\u07d0\u07e2 \u07d7\u07ed\u07d1\u07df\u07cf\u07d5\u07cc\u07eb" },
            { "pyg", "\u07d4\u07d9\u07ca\u07dc\u07ed\u07cf\u07e6\u07cb\u07eb \u07dc\u07ed\u07ce\u07d9\u07ca\u07e3\u07ca\u07db" },
            { "qar", "\u07de\u07d5\u07ca\u07d9 \u07d9\u07cc\u07ec\u07e6\u07ca\u07df" },
            { "rhd", "\u07d6\u07ed\u07cc\u07f2\u07d3\u07ca\u07d3\u07cf\u07e6\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07ef\u07d9" },
            { "ron", "\u07d9\u07ce\u07e1\u07ca\u07e3\u07cc\u07eb \u07df\u07cb\u07f3" },
            { "rsd", "\u07db\u07cd\u07d9\u07d1\u07d3\u07cc\u07eb \u07d8\u07cb\u07e3\u07ca\u07d9" },
            { "rub", "\u07cc\u07ec\u07d9\u07cc\u07ec\u07db\u07cc\u07eb \u07d9\u07ce\u07d3\u07ce\u07df" },
            { "rwf", "\u07d9\u07ce\u07e5\u07ca\u07f2\u07d8\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07dd\u07ca\u07d9\u07ca\u07f2" },
            { "sar", "\u07db\u07ce\u07f0\u07d8\u07ce\u07ec\u07df\u07ca\u07eb \u07d9\u07cc\u07ec\u07e6\u07ca\u07df" },
            { "sbd", "\u07db\u07df\u07cf\u07ec\u07e1\u07e3\u07ca\u07ec \u07d5\u07cc\u07f2 \u07e0\u07ce\u07ec \u07d8\u07df\u07ca" },
            { "scr", "\u07db\u07cb\u07e6\u07cc\u07db\u07cd\u07df\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d9\u07ce\u07d4\u07cc" },
            { "sdd", "\u07db\u07ce\u07ec\u07d8\u07ca\u07f2\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07d8\u07cc\u07ec\u07e3\u07ca\u07ef\u07d9 ( \u07c1\u07c9\u07c9\u07c2\u2013\u07c2\u07c0\u07c0\u07c7 )" },
            { "sdg", "\u07db\u07ce\u07d8\u07ca\u07f2\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "sdp", "\u07db\u07ce\u07ec\u07d8\u07f2\u07ca\u07ec\u07de\u07ca \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec ( \u07c1\u07c9\u07c5\u07c6\u2013\u07c2\u07c0\u07c0\u07c7 )" },
            { "sek", "\u07db\u07ce\u07e5\u07cd\u07d8 \u07de\u07ce\u07d9\u07d0\u07e3" },
            { "sgd", "\u07db\u07cd\u07f2\u07dc\u07ed\u07ca\u07d4\u07ce\u07d9 \u07d8\u07df\u07ca" },
            { "shp", "\u07db\u07cd\u07f2\u07d5 \u07e4\u07cc\u07df\u07cb\u07e3\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "sle", "\u07db\u07d9\u07ca\u07ec\u07df\u07cf\u07f2\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "sll", "\u07db\u07d9\u07ca\u07ec\u07df\u07cf\u07f2\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec - 1964-2022" },
            { "sos", "\u07db\u07cf\u07e1\u07ca\u07df\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07cc\u07df\u07cc\u07f2\u07dc\u07ed" },
            { "srd", "\u07db\u07ce\u07d9\u07cc\u07e3\u07ca\u07e1\u07cd\u07db \u07d8\u07df\u07ca" },
            { "ssp", "\u07db\u07ce\u07ec\u07d8\u07ca\u07f2\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "std", "\u07db\u07ca\u07cf\u07d5\u07cf\u07e1\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07d3\u07d9\u07ca\u07db ( \u07c1\u07c9\u07c7\u07c7\u2013 \u07c2\u07c0\u07c1\u07c7 )" },
            { "stn", "\u07db\u07ca\u07cf\u07d5\u07cf\u07e1\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07d3\u07d9\u07ca\u07db" },
            { "syp", "\u07db\u07cc\u07ef\u07d9\u07cc\u07eb \u07d4\u07d0\u07e3\u07cc\u07ec" },
            { "szl", "\u07db\u07d1\u07e5\u07ca\u07d5\u07e3\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07cc\u07df\u07ca\u07f2\u07d6\u07ed\u07cb\u07e3\u07cc\u07db" },
            { "thb", "\u07d5\u07ca\u07e6\u07cc\u07d8\u07ce\u07ef \u07d3\u07ca\u07d8" },
            { "tjs", "\u07d5\u07ca\u07d6\u07de\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07db\u07e1\u07cf\u07e3\u07cc" },
            { "tmt", "\u07d5\u07ce\u07d9\u07d1\u07de\u07cc\u07e1\u07cb\u07e3\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07e1\u07e3\u07ca\u07eb \u07de\u07ce\u07d8\u07ca" },
            { "tnd", "\u07d5\u07ce\u07e3\u07db\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cc\u07ec\u07e3\u07ca\u07ef\u07d9" },
            { "top", "\u07d5\u07cf\u07f2\u07dc\u07ed\u07ca\u07f2\u07eb \u07d3\u07ca\u07f2\u07dc\u07ed\u07ca\u07eb" },
            { "try", "\u07d5\u07ce\u07d9\u07d1\u07de\u07cc\u07eb \u07df\u07cc\u07d9\u07ca\u07ec" },
            { "ttd", "\u07d5\u07d9\u07cc\u07d8\u07ca\u07d8 \u07e3\u07cc\u07eb \u07d5\u07cf\u07d3\u07ca\u07dc\u07ed\u07cf\u07eb \u07d8\u07df\u07ca" },
            { "twd", "\u07d5\u07ca\u07e6\u07cc\u07e5\u07ca\u07f2\u07eb \u07d8\u07df\u07ca\u07eb \u07de\u07ce\u07d8\u07ca" },
            { "tzs", "\u07d5\u07ca\u07f2\u07d6\u07ed\u07ca\u07ef\u07e3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07cc\u07df\u07cc\u07f2\u07dc\u07ed" },
            { "uah", "\u07cc\u07de\u07d1\u07d9\u07cd\u07e3 \u07e4\u07d9\u07cc\u07dd\u07ed\u07e3\u07cc\u07e6\u07ca\u07db" },
            { "ugs", "\u07ce\u07dc\u07ed\u07ca\u07f2\u07d8\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07cc\u07df\u07cc\u07f2\u07dc\u07ed ( \u07c1\u07c9\u07c6\u07c6\u2013\u07c1\u07c9\u07c8\u07c7 )" },
            { "ugx", "\u07ce\u07dc\u07ed\u07ca\u07f2\u07d8\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07db\u07cc\u07df\u07cc\u07f2\u07dc\u07ed" },
            { "usd", "\u07ca\u07e1\u07cb\u07d9\u07cc\u07de\u07cc\u07ec\u07ec \u07de\u07ca\u07ec\u07dd\u07cf\u07eb \u07d8\u07cd\u07ec\u07e3\u07cd\u07f2 \u07d8\u07df\u07ca" },
            { "uyu", "\u07ce\u07f3\u07dc\u07ed\u07cb\u07e6\u07cc\u07eb \u07d4\u07cb\u07db\u07cf" },
            { "uzs", "\u07ce\u07d7\u07ed\u07d1\u07d3\u07cb\u07de\u07cc\u07db\u07d1\u07d5\u07ca\u07f2\u07eb \u07db\u07ce\u07e1" },
            { "ves", "\u07dd\u07ed\u07e3\u07cb\u07d7\u07ed\u07ce\u07e6\u07cb\u07df\u07ca\u07eb \u07d3\u07cf\u07df\u07cc\u07dd\u07ed\u07ca\u07d9" },
            { "vnd", "\u07dd\u07ed\u07cc\u07e6\u07cd\u07d5\u07d1\u07e3\u07ca\u07e1 \u07d8\u07d0\u07f2\u07dc\u07ed" },
            { "vuv", "\u07dd\u07ed\u07ca\u07e3\u07ce\u07e6\u07ca\u07d5\u07ce\u07eb \u07dd\u07ed\u07ca\u07d5\u07ce" },
            { "wst", "\u07db\u07ca\u07e1\u07cf\u07e5\u07ca\u07f2\u07eb \u07d5\u07df\u07ca" },
            { "xaf", "\u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07ca\u07eb \u07d5\u07ca\u07f2\u07d3\u07ca\u07f2 \u07e0\u07ce\u07ec \u07dd\u07ca\u07d9\u07ca\u07f2\u07eb \u07db\u07cd\u07dd\u07ca" },
            { "xcd", "\u07db\u07cd\u07d5 \u07df\u07ce\u07db\u07cc\u07e6\u07ca\u07eb" },
            { "xof", "\u07dd\u07ca\u07d9\u07ca\u07f2\u07eb \u07db\u07cd\u07dd\u07ca" },
            { "xpf", "\u07dd\u07d1\u07d9\u07ca\u07f2\u07eb \u07db\u07cd\u07dd\u07ca" },
            { "xxx", "\u07dd\u07ca\u07ec\u07d8\u07ca\u07f2\u07ec\u07de\u07ca\u07eb \u07df\u07d0\u07f2\u07d3\u07ca\u07df\u07cc" },
            { "yer", "\u07e6\u07e1\u07ca\u07e3\u07cc\u07f2\u07eb \u07d9\u07cc\u07ec\u07e6\u07ca\u07df" },
            { "zar", "\u07e5\u07d9\u07cf\u07ec\u07d8\u07ce\u07ee \u07dd\u07d8\u07ca\u07ec\u07dd\u07cc\u07f2\u07ec\u07e0\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d9\u07ca\u07f2\u07d8" },
            { "zmk", "\u07d6\u07ed\u07ca\u07f2\u07d3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07db\u07ca ( \u07c1\u07c9\u07c6\u07c8\u2013\u07c2\u07c0\u07c1\u07c2 )" },
            { "zmw", "\u07d6\u07ed\u07ca\u07f2\u07d3\u07cc\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07de\u07ce\u07e5\u07db\u07ca" },
            { "zrn", "\u07d6\u07ed\u07ca\u07ec\u07e6\u07cc\u07ec\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d6\u07ed\u07ca\u07ec\u07e6\u07cc\u07d9 ( \u07c1\u07c9\u07c9\u07c3\u2013\u07c1\u07c9\u07c9\u07c8 )" },
            { "zrz", "\u07d6\u07ed\u07ca\u07e6\u07d9\u07cc\u07de\u07ca \u07df\u07ce\u07eb \u07df\u07ca\u07eb \u07d6\u07ed\u07ca\u07ec\u07e6\u07cc\u07d9 ( \u07c1\u07c9\u07c7\u07c1\u2013\u07c1\u07c9\u07c9\u07c3 )" },
            { "zwd", "\u07d6\u07cc\u07f2\u07d3\u07ca\u07d3\u07cf\u07e6\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07ef\u07d9 (\u07c1\u07c9\u07c8\u07c0\u2013\u07c2\u07c0\u07c0\u07c8 )" },
            { "zwl", "\u07d6\u07ed\u07cc\u07f2\u07d3\u07ca\u07d3\u07cf\u07e6\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07ef\u07d9 ( \u07c2\u07c0\u07c0\u07c9 )" },
            { "zwr", "\u07d6\u07ed\u07cc\u07f2\u07d3\u07ca\u07d3\u07cf\u07e6\u07cb\u07de\u07ca \u07df\u07ce\u07ec \u07df\u07ca\u07eb \u07d8\u07cf\u07df\u07ca\u07ef\u07d9 ( \u07c2\u07c0\u07c0\u07c8 )" },
        };
        return data;
    }
}
