/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_to extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "houa fakakiliniuisi m\u0101lie",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "houa faka\u02bbakel\u012b taimi totonu",
               "",
               "houa faka\u02bbakel\u012b taimi liliu",
               "",
               "houa faka\u02bbakel\u012b",
               "",
            };
        final String[] Apia = new String[] {
               "houa fakaapia taimi totonu",
               "",
               "houa fakaapia taimi liliu",
               "",
               "houa fakaapia",
               "",
            };
        final String[] Cook = new String[] {
               "houa faka\u02bbotumotukuki taimi totonu",
               "",
               "houa faka\u02bbotumotukuki taimi liliu",
               "",
               "houa faka\u02bbotumotukuki",
               "",
            };
        final String[] Cuba = new String[] {
               "houa fakakiupa taimi totonu",
               "CST",
               "houa fakakiupa taimi liliu",
               "CDT",
               "houa fakakiupa",
               "CT",
            };
        final String[] Fiji = new String[] {
               "houa fakafisi taimi totonu",
               "",
               "houa fakafisi taimi liliu",
               "",
               "houa fakafisi",
               "",
            };
        final String[] Gulf = new String[] {
               "houa fakak\u016blifi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "houa fakahovite taimi totonu",
               "",
               "houa fakahovite taimi liliu",
               "",
               "houa fakahovite",
               "",
            };
        final String[] Iran = new String[] {
               "houa faka\u02bbilaani taimi totonu",
               "",
               "houa faka\u02bbilaani taimi liliu",
               "",
               "houa faka\u02bbilaani",
               "",
            };
        final String[] Niue = new String[] {
               "houa fakaniu\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "houa fakal\u016bsia-\u02bbomisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbomisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbomisiki",
               "",
            };
        final String[] Peru = new String[] {
               "houa fakapel\u016b taimi totonu",
               "",
               "houa fakapel\u016b taimi liliu",
               "",
               "houa fakapel\u016b",
               "",
            };
        final String[] Truk = new String[] {
               "houa fakat\u016bke",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "houa fakamotuueke",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "houa fakasili taimi totonu",
               "",
               "houa fakasili taimi liliu",
               "",
               "houa fakasili",
               "",
            };
        final String[] China = new String[] {
               "houa fakasiaina taimi totonu",
               "CST",
               "houa fakasiaina taimi liliu",
               "CDT",
               "houa fakasiaina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "houa fakamotukokosi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "houa fakatavisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "houa faka\u02bbinitia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "houa fakasiapani taimi totonu",
               "JST",
               "houa fakasiapani taimi liliu",
               "JDT",
               "houa fakasiapani",
               "JT",
            };
        final String[] Korea = new String[] {
               "houa fakak\u014dlea taimi totonu",
               "KST",
               "houa fakak\u014dlea taimi liliu",
               "KST",
               "houa fakak\u014dlea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "houa fakanaulu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "houa fakanepali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "houa fakapalau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "houa fakaha\u02bbamoa taimi totonu",
               "SST",
               "houa fakaha\u02bbamoa taimi liliu",
               "SST",
               "houa fakaha\u02bbamoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "houa fakasioua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "houa fakatonga taimi totonu",
               "",
               "houa fakatonga taimi liliu",
               "",
               "houa fakatonga",
               "",
            };
        final String[] Yukon = new String[] {
               "houa fakaiukoni",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "houa faka\u02bbalasika taimi totonu",
               "AKST",
               "houa faka\u02bbalasika taimi liliu",
               "AKDT",
               "houa faka\u02bbalasika",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "houa faka\u02bbamas\u014dne taimi totonu",
               "",
               "houa faka\u02bbamas\u014dne taimi liliu",
               "",
               "houa faka\u02bbamas\u014dne",
               "",
            };
        final String[] Anadyr = new String[] {
               "houa fakal\u016bsia-\u02bbanatili taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbanatili taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbanatili",
               "",
            };
        final String[] Azores = new String[] {
               "houa faka\u02bb\u0101solesi taimi totonu",
               "",
               "houa faka\u02bb\u0101solesi taimi liliu",
               "",
               "houa faka\u02bb\u0101solesi",
               "",
            };
        final String[] Bhutan = new String[] {
               "houa fakap\u016btani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "houa fakapulunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "houa fakalapanui taimi totonu",
               "",
               "houa fakalapanui taimi liliu",
               "",
               "houa fakalapanui",
               "",
            };
        final String[] Guyana = new String[] {
               "houa fakakuiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "houa faka\u02bbisileli taimi totonu",
               "IST",
               "houa faka\u02bbisileli taimi liliu",
               "IDT",
               "houa faka\u02bbisileli",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "houa fakakosilae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "houa fakamausoni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "houa fakal\u016bsia-mosikou taimi totonu",
               "MSK",
               "houa fakal\u016bsia-mosikou taimi liliu",
               "MSK",
               "houa fakal\u016bsia-mosikou",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "houa fakap\u014dnap\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "houa fakal\u016bsia-samala taimi totonu",
               "",
               "houa fakal\u016bsia-samala taimi liliu",
               "",
               "houa fakal\u016bsia-samala",
               "",
            };
        final String[] Tahiti = new String[] {
               "houa fakatahisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "houa fakataipei taimi totonu",
               "CST",
               "houa fakataipei taimi liliu",
               "CDT",
               "houa fakataipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "houa fakat\u016bvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "houa fakavositoki",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "houa faka\u02bbuvea mo futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "houa faka\u02bbalepea taimi totonu",
               "",
               "houa faka\u02bbalepea taimi liliu",
               "",
               "houa faka\u02bbalepea",
               "",
            };
        final String[] Armenia = new String[] {
               "houa faka\u02bb\u0101menia taimi totonu",
               "",
               "houa faka\u02bb\u0101menia taimi liliu",
               "",
               "houa faka\u02bb\u0101menia",
               "",
            };
        final String[] Bolivia = new String[] {
               "houa fakapol\u012bvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "houa fakasatihami taimi totonu",
               "",
               "houa fakasatihami taimi liliu",
               "",
               "houa fakasatihami",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "taimi fakaem\u0101mani",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "houa faka\u02bbekuetoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "houa fakakamipi\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "houa fakase\u014dsia taimi totonu",
               "",
               "houa fakase\u014dsia taimi liliu",
               "",
               "houa fakase\u014dsia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bb\u012bkutisiki",
               "",
            };
        final String[] Magadan = new String[] {
               "houa fakal\u016bsia-makatani taimi totonu",
               "",
               "houa fakal\u016bsia-makatani taimi liliu",
               "",
               "houa fakal\u016bsia-makatani",
               "",
            };
        final String[] Myanmar = new String[] {
               "houa fakapema",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "houa fakanoaf\u014dki taimi totonu",
               "",
               "houa fakanoaf\u014dki taimi liliu",
               "",
               "houa fakanoaf\u014dki",
               "",
            };
        final String[] Noronha = new String[] {
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi totonu",
               "",
               "houa fakaf\u0113nanito-te-nol\u014dnia taimi liliu",
               "",
               "houa fakaf\u0113nanito-te-nol\u014dnia",
               "",
            };
        final String[] Reunion = new String[] {
               "houa fakal\u0113unioni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "houa fakalotela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "houa faka\u02bbotumotusolomone",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "houa fakatokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "houa faka\u02bbulukuai taimi totonu",
               "",
               "houa faka\u02bbulukuai taimi liliu",
               "",
               "houa faka\u02bbulukuai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "houa fakavanuatu taimi totonu",
               "",
               "houa fakavanuatu taimi liliu",
               "",
               "houa fakavanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbi\u0101kutisiki",
               "",
            };
        final String[] Atlantic = new String[] {
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi totonu",
               "AST",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki taimi liliu",
               "AST",
               "houa faka\u02bbamelika-tokelau \u02bbatalanitiki",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "houa fakapal\u0101sila taimi totonu",
               "",
               "houa fakapal\u0101sila taimi liliu",
               "",
               "houa fakapal\u0101sila",
               "",
            };
        final String[] Chamorro = new String[] {
               "houa fakakamolo",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "houa fakakolomipia taimi totonu",
               "",
               "houa fakakolomipia taimi liliu",
               "",
               "houa fakakolomipia",
               "",
            };
        final String[] Falkland = new String[] {
               "houa faka\u02bbotumotu-fokulani taimi totonu",
               "",
               "houa faka\u02bbotumotu-fokulani taimi liliu",
               "",
               "houa faka\u02bbotumotu-fokulani",
               "",
            };
        final String[] Malaysia = new String[] {
               "houa fakamaleisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "houa fakamalativisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi totonu",
               "",
               "houa faka\u02bbul\u0101nip\u0101t\u0101 taimi liliu",
               "",
               "houa faka\u02bbul\u0101nip\u0101t\u0101",
               "",
            };
        final String[] Pakistan = new String[] {
               "houa fakap\u0101kisitani taimi totonu",
               "PKT",
               "houa fakap\u0101kisitani taimi liliu",
               "PKST",
               "houa fakap\u0101kisitani",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "houa fakapalakuai taimi totonu",
               "",
               "houa fakapalakuai taimi liliu",
               "",
               "houa fakapalakuai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "houa fakapitikani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "houa fakal\u016bsia-sak\u0101line taimi totonu",
               "",
               "houa fakal\u016bsia-sak\u0101line taimi liliu",
               "",
               "houa fakal\u016bsia-sak\u0101line",
               "",
            };
        final String[] Suriname = new String[] {
               "houa fakasuliname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "houa faka\u02bbasenitina taimi totonu",
               "",
               "houa faka\u02bbasenitina taimi liliu",
               "",
               "houa faka\u02bbasenitina",
               "",
            };
        final String[] Christmas = new String[] {
               "houa fakamotukilisimasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "houa fakakalapakosi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "houa fakahongi-kongi taimi totonu",
               "HKT",
               "houa fakahongi-kongi taimi liliu",
               "HKST",
               "houa fakahongi-kongi",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "houa faka\u02bbinitosiaina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "houa fakal\u016bsia-petelopavilovisiki taimi totonu",
               "",
               "houa fakal\u016bsia-petelopavilovisiki taimi liliu",
               "",
               "houa fakal\u016bsia-petelopavilovisiki",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "houa fakak\u012bkisitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "houa fakamotu\u02bbeikihoue taimi totonu",
               "",
               "houa fakamotu\u02bbeikihoue taimi liliu",
               "",
               "houa fakamotu\u02bbeikihoue",
               "",
            };
        final String[] Marquesas = new String[] {
               "houa fakam\u0101kesasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "houa fakamaulitiusi taimi totonu",
               "",
               "houa fakamaulitiusi taimi liliu",
               "",
               "houa fakamaulitiusi",
               "",
            };
        final String[] Singapore = new String[] {
               "houa fakasingapoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "houa fakavenesuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "houa fakal\u016bsia-volikokalati taimi totonu",
               "MSK",
               "houa fakal\u016bsia-volikokalati taimi liliu",
               "MSK",
               "houa fakal\u016bsia-volikokalati",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "houa faka\u02bbasapaisani taimi totonu",
               "",
               "houa faka\u02bbasapaisani taimi liliu",
               "",
               "houa faka\u02bbasapaisani",
               "",
            };
        final String[] Bangladesh = new String[] {
               "houa fakap\u0101ngil\u0101tesi taimi totonu",
               "",
               "houa fakap\u0101ngil\u0101tesi taimi liliu",
               "",
               "houa fakap\u0101ngil\u0101tesi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "houa fakamui\u02bbi-v\u0113te taimi totonu",
               "",
               "houa fakamui\u02bbi-v\u0113te taimi liliu",
               "",
               "houa fakamui\u02bbi-v\u0113te",
               "",
            };
        final String[] East_Timor = new String[] {
               "houa fakatimoa-hahake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "houa fakakasakitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "houa faka\u02bbotumotu-seiseli",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "houa fakatasikitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "houa faka\u02bbusipekitani taimi totonu",
               "",
               "houa faka\u02bbusipekitani taimi liliu",
               "",
               "houa faka\u02bbusipekitani",
               "",
            };
        final String[] Afghanistan = new String[] {
               "houa faka\u02bbafik\u0101nisitani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi totonu",
               "",
               "houa fakal\u016bsia-kalasinoi\u0101siki taimi liliu",
               "",
               "houa fakal\u016bsia-kalasinoi\u0101siki",
               "",
            };
        final String[] New_Zealand = new String[] {
               "houa fakanu\u02bbusila taimi totonu",
               "NZST",
               "houa fakanu\u02bbusila taimi liliu",
               "NZDT",
               "houa fakanu\u02bbusila",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "houa fakal\u016bsia-novosip\u012bsiki taimi totonu",
               "",
               "houa fakal\u016bsia-novosip\u012bsiki taimi liliu",
               "",
               "houa fakal\u016bsia-novosip\u012bsiki",
               "",
            };
        final String[] Philippines = new String[] {
               "houa fakafilipaine taimi totonu",
               "PST",
               "houa fakafilipaine taimi liliu",
               "PDT",
               "houa fakafilipaine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "houa fakal\u016bsia-valativositoki taimi totonu",
               "",
               "houa fakal\u016bsia-valativositoki taimi liliu",
               "",
               "houa fakal\u016bsia-valativositoki",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "houa fakamoana\u02bbinitia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "houa faka\u02bbotumotulaine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "houa fakafonua\u02bbilofo\u02bbou taimi totonu",
               "NST",
               "houa fakafonua\u02bbilofo\u02bbou taimi liliu",
               "NDT",
               "houa fakafonua\u02bbilofo\u02bbou",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "houa fakat\u016bkimenisitani taimi totonu",
               "",
               "houa fakat\u016bkimenisitani taimi liliu",
               "",
               "houa fakat\u016bkimenisitani",
               "",
            };
        final String[] French_Guiana = new String[] {
               "houa fakakuiana-fakafalanis\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "houa fakakalet\u014dniafo\u02bbou taimi totonu",
               "",
               "houa fakakalet\u014dniafo\u02bbou taimi liliu",
               "",
               "houa fakakalet\u014dniafo\u02bbou",
               "",
            };
        final String[] South_Georgia = new String[] {
               "houa fakasiosiatonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi totonu",
               "",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki taimi liliu",
               "",
               "houa fakal\u016bsia-\u02bbiekatelinep\u016bki",
               "",
            };
        final String[] Africa_Central = new String[] {
               "houa faka\u02bbafelika-loto",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "houa faka\u02bbafelika-hahake",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "houa faka\u02bbafelika-hihifo taimi totonu",
               "WAT",
               "houa faka\u02bbafelika-hihifo taimi liliu",
               "WAT",
               "houa faka\u02bbafelika-hihifo",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "houa fakat\u016bmoni-t\u016bvile",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "houa faka\u02bbeulope-loto taimi totonu",
               "CET",
               "houa faka\u02bbeulope-loto taimi liliu",
               "CEST",
               "houa faka\u02bbeulope-loto",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "houa faka\u02bbeulope-hahake taimi totonu",
               "EET",
               "houa faka\u02bbeulope-hahake taimi liliu",
               "EEST",
               "houa faka\u02bbeulope-hahake",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "houa faka\u02bbeulope-hihifo taimi totonu",
               "WET",
               "houa faka\u02bbeulope-hihifo taimi liliu",
               "WEST",
               "houa faka\u02bbeulope-hihifo",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "houa fakamekisikou-pasifika taimi totonu",
               "MST",
               "houa fakamekisikou-pasifika taimi liliu",
               "MDT",
               "houa fakamekisikou-pasifika",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "houa faka\u02bbafelika-tonga",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "houa faka\u02bbamelika-tokelau loto taimi totonu",
               "CST",
               "houa faka\u02bbamelika-tokelau loto taimi liliu",
               "CDT",
               "houa faka\u02bbamelika-tokelau loto",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "houa faka\u02bbamelika-tokelau hahake taimi totonu",
               "EST",
               "houa faka\u02bbamelika-tokelau hahake taimi liliu",
               "EST",
               "houa faka\u02bbamelika-tokelau hahake",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "houa faka\u02bbamelika-tokelau pasifika taimi totonu",
               "PST",
               "houa faka\u02bbamelika-tokelau pasifika taimi liliu",
               "PDT",
               "houa faka\u02bbamelika-tokelau pasifika",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "houa faka\u02bbanet\u0101tikafalanis\u0113",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "houa fakakilipasi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "houa fakahauai\u02bbi-aleuti taimi totonu",
               "HST",
               "houa fakahauai\u02bbi-aleuti taimi liliu",
               "HST",
               "houa fakahauai\u02bbi-aleuti",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "houa faka\u02bbotumotufoinikisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "houa fakas\u0101-piea-mo-mikeloni taimi totonu",
               "",
               "houa fakas\u0101-piea-mo-mikeloni taimi liliu",
               "",
               "houa fakas\u0101-piea-mo-mikeloni",
               "",
            };
        final String[] America_Mountain = new String[] {
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi totonu",
               "MST",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga taimi liliu",
               "MST",
               "houa faka\u02bbamelika-tokelau mo\u02bbunga",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "houa faka\u02bbotumotumasolo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "houa fakapapuaniukini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto taimi totonu",
               "ACST",
               "houa faka\u02bbaositel\u0113lia-loto taimi liliu",
               "ACDT",
               "houa faka\u02bbaositel\u0113lia-loto",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "houa faka\u02bbaositel\u0113lia-hahake taimi totonu",
               "AEST",
               "houa faka\u02bbaositel\u0113lia-hahake taimi liliu",
               "AEDT",
               "houa faka\u02bbaositel\u0113lia-hahake",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "houa faka\u02bbaositel\u0113lia-hihifo taimi totonu",
               "AWST",
               "houa faka\u02bbaositel\u0113lia-hihifo taimi liliu",
               "AWDT",
               "houa faka\u02bbaositel\u0113lia-hihifo",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "houa faka\u02bbinitonisia-loto",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "houa faka\u02bbinitonisia-hahake",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "houa faka\u02bbinitonisia-hihifo",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi totonu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo taimi liliu",
               "",
               "houa faka\u02bbaositel\u0113lia-loto-hihifo",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa faka\u02bbaealani taimi totonu",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "taimi fakaem\u0101mani",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa faka\u02bbaealani taimi totonu",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "houa fakakiliniuisi m\u0101lie",
                    "GMT",
                    "houa fakapilit\u0101nia taimi liliu",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hebron", "Hepeloni" },
            { "timezone.excity.Etc/Unknown", "Feitu\u02bbu ta\u02bbe\u02bbiloa" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Loma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Europe/Paris", "Palesi" },
            { "timezone.excity.Pacific/Fiji", "Fisi" },
            { "timezone.excity.Pacific/Guam", "Kuami" },
            { "timezone.excity.Pacific/Niue", "Niu\u0113" },
            { "timezone.excity.Pacific/Truk", "T\u016bke" },
            { "timezone.excity.Pacific/Wake", "Ueke" },
            { "timezone.excity.Europe/Athens", "\u02bbAtenisi" },
            { "timezone.excity.Europe/London", "Lonitoni" },
            { "timezone.excity.Europe/Moscow", "Mosikou" },
            { "timezone.excity.Pacific/Nauru", "Naulu" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Sel\u016bsalema" },
            { "timezone.excity.Europe/Vatican", "Vatikani" },
            { "timezone.excity.Pacific/Easter", "Lapanui" },
            { "timezone.excity.Pacific/Kanton", "Kanitoni" },
            { "timezone.excity.Pacific/Kosrae", "Kosilae" },
            { "timezone.excity.Pacific/Majuro", "Masulo" },
            { "timezone.excity.Pacific/Midway", "Mitiuai" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Ponape", "Ponap\u0113" },
            { "timezone.excity.Pacific/Saipan", "Sa\u02bbipani" },
            { "timezone.excity.Pacific/Tahiti", "Tahisi" },
            { "timezone.excity.Pacific/Tarawa", "Talava" },
            { "timezone.excity.Pacific/Wallis", "\u02bbUvea" },
            { "timezone.excity.Africa/Sao_Tome", "Sao Tom\u00e9" },
            { "timezone.excity.Pacific/Gambier", "Kamipi\u0113" },
            { "timezone.excity.Pacific/Norfolk", "Noaf\u014dki" },
            { "timezone.excity.America/New_York", "Niu \u02bbIoke" },
            { "timezone.excity.Australia/Sydney", "Sen\u0113" },
            { "timezone.excity.Pacific/Auckland", "\u02bbAokalani" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitikeni" },
            { "timezone.excity.Pacific/Enderbury", "\u02bbEnitipul\u012b" },
            { "timezone.excity.Pacific/Kwajalein", "Kuasaleni" },
            { "timezone.excity.Pacific/Marquesas", "Malikuesa" },
            { "timezone.excity.Pacific/Pago_Pago", "Pangopango" },
            { "timezone.excity.Pacific/Rarotonga", "Lalotonga" },
            { "timezone.excity.Australia/Adelaide", "Atelaite" },
            { "timezone.excity.Australia/Brisbane", "Pelisipane" },
            { "timezone.excity.Pacific/Kiritimati", "Kilisimasi" },
            { "timezone.excity.Australia/Melbourne", "Melipoane" },
            { "timezone.excity.Pacific/Guadalcanal", "Kuat\u0101kanali" },
            { "timezone.excity.Pacific/Bougainville", "Pukanivila" },
            { "timezone.excity.Pacific/Port_Moresby", "Taulanga Molesipi" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
        };
        return data;
    }
}
