/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: Elf64_SymPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the Elf64_SymPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=Elf64_Sym.class)
public class Elf64_SymPointer extends StructurePointer {

	// NULL
	public static final Elf64_SymPointer NULL = new Elf64_SymPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected Elf64_SymPointer(long address) {
		super(address);
	}

	public static Elf64_SymPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static Elf64_SymPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static Elf64_SymPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new Elf64_SymPointer(address);
	}

	public Elf64_SymPointer add(long count) {
		return Elf64_SymPointer.cast(address + (Elf64_Sym.SIZEOF * count));
	}

	public Elf64_SymPointer add(Scalar count) {
		return add(count.longValue());
	}

	public Elf64_SymPointer addOffset(long offset) {
		return Elf64_SymPointer.cast(address + offset);
	}

	public Elf64_SymPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public Elf64_SymPointer sub(long count) {
		return Elf64_SymPointer.cast(address - (Elf64_Sym.SIZEOF * count));
	}

	public Elf64_SymPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public Elf64_SymPointer subOffset(long offset) {
		return Elf64_SymPointer.cast(address - offset);
	}

	public Elf64_SymPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public Elf64_SymPointer untag(long mask) {
		return Elf64_SymPointer.cast(address & ~mask);
	}

	public Elf64_SymPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return Elf64_Sym.SIZEOF;
	}

	// Implementation methods

	// U8 st_info
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_infoOffset_", declaredType="U8")
	public U8 st_info() throws CorruptDataException {
		return new U8(getByteAtOffset(Elf64_Sym._st_infoOffset_));
	}

	// U8 st_info
	public U8Pointer st_infoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(Elf64_Sym._st_infoOffset_));
	}

	// Elf64_Word st_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_nameOffset_", declaredType="Elf64_Word")
	public UDATA st_name() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf64_Sym._st_nameOffset_));
	}

	// Elf64_Word st_name
	public UDATAPointer st_nameEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Sym._st_nameOffset_));
	}

	// U8 st_other
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_otherOffset_", declaredType="U8")
	public U8 st_other() throws CorruptDataException {
		return new U8(getByteAtOffset(Elf64_Sym._st_otherOffset_));
	}

	// U8 st_other
	public U8Pointer st_otherEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(Elf64_Sym._st_otherOffset_));
	}

	// Elf64_Section st_shndx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_shndxOffset_", declaredType="Elf64_Section")
	public U16 st_shndx() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf64_Sym._st_shndxOffset_));
	}

	// Elf64_Section st_shndx
	public U16Pointer st_shndxEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf64_Sym._st_shndxOffset_));
	}

	// Elf64_Xword st_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_sizeOffset_", declaredType="Elf64_Xword")
	public UDATA st_size() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Sym._st_sizeOffset_));
	}

	// Elf64_Xword st_size
	public UDATAPointer st_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Sym._st_sizeOffset_));
	}

	// Elf64_Addr st_value
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_st_valueOffset_", declaredType="Elf64_Addr")
	public UDATA st_value() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Sym._st_valueOffset_));
	}

	// Elf64_Addr st_value
	public UDATAPointer st_valueEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Sym._st_valueOffset_));
	}

}
