/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HumanInputStream
extends InputStream {
    byte[] src;
    int pos;
    int length;
    boolean inLine;
    int stopIt;

    public HumanInputStream(String input) {
        this.src = input.getBytes();
        this.pos = 0;
        this.length = this.src.length;
        this.stopIt = 0;
        this.inLine = false;
    }

    @Override
    public int read() throws IOException {
        int re;
        if (this.pos < this.length) {
            re = this.src[this.pos];
            if (this.inLine) {
                if (this.stopIt > 0) {
                    --this.stopIt;
                    re = -1;
                } else {
                    if (re == 10) {
                        this.stopIt = 2;
                    }
                    ++this.pos;
                }
            } else {
                ++this.pos;
            }
        } else {
            re = -1;
        }
        return re;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) {
        this.inLine = true;
        try {
            int n = super.read(buffer, offset, len);
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("HumanInputStream error");
        }
        finally {
            this.inLine = false;
        }
    }

    @Override
    public int available() {
        if (this.pos < this.length) {
            return 1;
        }
        return 0;
    }

    static void assertTrue(boolean bool) {
        if (!bool) {
            throw new RuntimeException();
        }
    }

    public static void test() throws Exception {
        class Tester {
            HumanInputStream is;
            BufferedReader reader;

            Tester(String s) {
                this.is = new HumanInputStream(s);
                this.reader = new BufferedReader(new InputStreamReader(this.is));
            }

            void testStreamReadOnce(int expection) throws Exception {
                HumanInputStream.assertTrue(this.is.read() == expection);
            }

            void testStreamReadMany(String expectation) throws Exception {
                char[] keys;
                for (char key : keys = expectation.toCharArray()) {
                    HumanInputStream.assertTrue(this.is.read() == key);
                }
            }

            void testReaderReadline(String expectation) throws Exception {
                String s = new BufferedReader(new InputStreamReader(this.is)).readLine();
                if (s == null) {
                    HumanInputStream.assertTrue(expectation == null);
                } else {
                    HumanInputStream.assertTrue(s.equals(expectation));
                }
            }

            void testReaderReadline2(String expectation) throws Exception {
                String s = this.reader.readLine();
                if (s == null) {
                    HumanInputStream.assertTrue(expectation == null);
                } else {
                    HumanInputStream.assertTrue(s.equals(expectation));
                }
            }
        }
        Tester test = new Tester("111\n222\n\n444\n\n");
        test.testReaderReadline("111");
        test.testReaderReadline("222");
        test.testReaderReadline("");
        test.testReaderReadline("444");
        test.testReaderReadline("");
        test.testReaderReadline(null);
        test = new Tester("111\n222\n\n444\n\n");
        test.testReaderReadline2("111");
        test.testReaderReadline2("222");
        test.testReaderReadline2("");
        test.testReaderReadline2("444");
        test.testReaderReadline2("");
        test.testReaderReadline2(null);
        test = new Tester("111\n222\n\n444\n\n");
        test.testReaderReadline2("111");
        test.testReaderReadline("222");
        test.testReaderReadline2("");
        test.testReaderReadline2("444");
        test.testReaderReadline("");
        test.testReaderReadline2(null);
        test = new Tester("1\n2");
        test.testStreamReadMany("1\n2");
        test.testStreamReadOnce(-1);
        test = new Tester("12\n234");
        test.testStreamReadOnce(49);
        test.testReaderReadline("2");
        test.testStreamReadOnce(50);
        test.testReaderReadline2("34");
        test.testReaderReadline2(null);
        test = new Tester("changeit\n");
        test.testStreamReadMany("changeit\n");
        test.testReaderReadline(null);
        test = new Tester("changeit\nName\nCountry\nYes\n");
        test.testStreamReadMany("changeit\n");
        test.testReaderReadline("Name");
        test.testReaderReadline("Country");
        test.testReaderReadline("Yes");
        test.testReaderReadline(null);
        test = new Tester("Me\nHere\n");
        test.testReaderReadline2("Me");
        test.testReaderReadline2("Here");
    }
}

