/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: sigcontext
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class sigcontext {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int ___pad0Offset_;
	public static final int ___reserved1Offset_;
	public static final int _cr2Offset_;
	public static final int _csOffset_;
	public static final int _eflagsOffset_;
	public static final int _errOffset_;
	public static final int _fsOffset_;
	public static final int _gsOffset_;
	public static final int _oldmaskOffset_;
	public static final int _r10Offset_;
	public static final int _r11Offset_;
	public static final int _r12Offset_;
	public static final int _r13Offset_;
	public static final int _r14Offset_;
	public static final int _r15Offset_;
	public static final int _r8Offset_;
	public static final int _r9Offset_;
	public static final int _raxOffset_;
	public static final int _rbpOffset_;
	public static final int _rbxOffset_;
	public static final int _rcxOffset_;
	public static final int _rdiOffset_;
	public static final int _rdxOffset_;
	public static final int _ripOffset_;
	public static final int _rsiOffset_;
	public static final int _rspOffset_;
	public static final int _trapnoOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		___pad0Offset_ = 0;
		___reserved1Offset_ = 0;
		_cr2Offset_ = 0;
		_csOffset_ = 0;
		_eflagsOffset_ = 0;
		_errOffset_ = 0;
		_fsOffset_ = 0;
		_gsOffset_ = 0;
		_oldmaskOffset_ = 0;
		_r10Offset_ = 0;
		_r11Offset_ = 0;
		_r12Offset_ = 0;
		_r13Offset_ = 0;
		_r14Offset_ = 0;
		_r15Offset_ = 0;
		_r8Offset_ = 0;
		_r9Offset_ = 0;
		_raxOffset_ = 0;
		_rbpOffset_ = 0;
		_rbxOffset_ = 0;
		_rcxOffset_ = 0;
		_rdiOffset_ = 0;
		_rdxOffset_ = 0;
		_ripOffset_ = 0;
		_rsiOffset_ = 0;
		_rspOffset_ = 0;
		_trapnoOffset_ = 0;
	}

}
