/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9DDRFieldDeclarationPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9DDRFieldDeclarationPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9DDRFieldDeclaration.class)
public class J9DDRFieldDeclarationPointer extends StructurePointer {

	// NULL
	public static final J9DDRFieldDeclarationPointer NULL = new J9DDRFieldDeclarationPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9DDRFieldDeclarationPointer(long address) {
		super(address);
	}

	public static J9DDRFieldDeclarationPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9DDRFieldDeclarationPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9DDRFieldDeclarationPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9DDRFieldDeclarationPointer(address);
	}

	public J9DDRFieldDeclarationPointer add(long count) {
		return J9DDRFieldDeclarationPointer.cast(address + (J9DDRFieldDeclaration.SIZEOF * count));
	}

	public J9DDRFieldDeclarationPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9DDRFieldDeclarationPointer addOffset(long offset) {
		return J9DDRFieldDeclarationPointer.cast(address + offset);
	}

	public J9DDRFieldDeclarationPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9DDRFieldDeclarationPointer sub(long count) {
		return J9DDRFieldDeclarationPointer.cast(address - (J9DDRFieldDeclaration.SIZEOF * count));
	}

	public J9DDRFieldDeclarationPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9DDRFieldDeclarationPointer subOffset(long offset) {
		return J9DDRFieldDeclarationPointer.cast(address - offset);
	}

	public J9DDRFieldDeclarationPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9DDRFieldDeclarationPointer untag(long mask) {
		return J9DDRFieldDeclarationPointer.cast(address & ~mask);
	}

	public J9DDRFieldDeclarationPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9DDRFieldDeclaration.SIZEOF;
	}

	// Implementation methods

	// const U8* name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="const U8*")
	public U8Pointer name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9DDRFieldDeclaration._nameOffset_));
	}

	// const U8* name
	public PointerPointer nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9DDRFieldDeclaration._nameOffset_));
	}

	// U32 offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_offsetOffset_", declaredType="U32")
	public UDATA offset() throws CorruptDataException {
		return new U32(getIntAtOffset(J9DDRFieldDeclaration._offsetOffset_));
	}

	// U32 offset
	public UDATAPointer offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9DDRFieldDeclaration._offsetOffset_));
	}

	// const U8* type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="const U8*")
	public U8Pointer type() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9DDRFieldDeclaration._typeOffset_));
	}

	// const U8* type
	public PointerPointer typeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9DDRFieldDeclaration._typeOffset_));
	}

}
