/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ConcurrentStatus
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ConcurrentStatus {

	// VM Constants

	public static final long SIZEOF;
	public static final long CONCURRENT_CLEAN_TRACE;
	public static final long CONCURRENT_EXHAUSTED;
	public static final long CONCURRENT_FINAL_COLLECTION;
	public static final long CONCURRENT_INIT_COMPLETE;
	public static final long CONCURRENT_INIT_RUNNING;
	public static final long CONCURRENT_OFF;
	public static final long CONCURRENT_ROOT_TRACING;
	public static final long CONCURRENT_TRACE_ONLY;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CONCURRENT_CLEAN_TRACE = 0;
		CONCURRENT_EXHAUSTED = 0;
		CONCURRENT_FINAL_COLLECTION = 0;
		CONCURRENT_INIT_COMPLETE = 0;
		CONCURRENT_INIT_RUNNING = 0;
		CONCURRENT_OFF = 0;
		CONCURRENT_ROOT_TRACING = 0;
		CONCURRENT_TRACE_ONLY = 0;
	}

}
