/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9JVMTIEnv
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9JVMTIEnv {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _breakpointsOffset_;
	public static final int _callbacksOffset_;
	public static final int _capabilitiesOffset_;
	public static final int _environmentLocalStorageOffset_;
	public static final int _extensionCallbacksOffset_;
	public static final int _flagsOffset_;
	public static final int _functionsOffset_;
	public static final int _gcHookOffset_;
	public static final int _gcOmrHookOffset_;
	public static final int _globalEventEnableOffset_;
	public static final int _jitHookOffset_;
	public static final int _libraryOffset_;
	public static final int _linkNextOffset_;
	public static final int _linkPreviousOffset_;
	public static final int _mutexOffset_;
	public static final int _objectTagTableOffset_;
	public static final int _prefixCountOffset_;
	public static final int _prefixesOffset_;
	public static final int _threadDataPoolOffset_;
	public static final int _threadDataPoolMutexOffset_;
	public static final int _tlsKeyOffset_;
	public static final int _vmOffset_;
	public static final int _vmHookOffset_;
	public static final int _watchedClassesOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_breakpointsOffset_ = 0;
		_callbacksOffset_ = 0;
		_capabilitiesOffset_ = 0;
		_environmentLocalStorageOffset_ = 0;
		_extensionCallbacksOffset_ = 0;
		_flagsOffset_ = 0;
		_functionsOffset_ = 0;
		_gcHookOffset_ = 0;
		_gcOmrHookOffset_ = 0;
		_globalEventEnableOffset_ = 0;
		_jitHookOffset_ = 0;
		_libraryOffset_ = 0;
		_linkNextOffset_ = 0;
		_linkPreviousOffset_ = 0;
		_mutexOffset_ = 0;
		_objectTagTableOffset_ = 0;
		_prefixCountOffset_ = 0;
		_prefixesOffset_ = 0;
		_threadDataPoolOffset_ = 0;
		_threadDataPoolMutexOffset_ = 0;
		_tlsKeyOffset_ = 0;
		_vmOffset_ = 0;
		_vmHookOffset_ = 0;
		_watchedClassesOffset_ = 0;
	}

}
