/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __pthread_mutex_sPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __pthread_mutex_sPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__pthread_mutex_s.class)
public class __pthread_mutex_sPointer extends StructurePointer {

	// NULL
	public static final __pthread_mutex_sPointer NULL = new __pthread_mutex_sPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __pthread_mutex_sPointer(long address) {
		super(address);
	}

	public static __pthread_mutex_sPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __pthread_mutex_sPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __pthread_mutex_sPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __pthread_mutex_sPointer(address);
	}

	public __pthread_mutex_sPointer add(long count) {
		return __pthread_mutex_sPointer.cast(address + (__pthread_mutex_s.SIZEOF * count));
	}

	public __pthread_mutex_sPointer add(Scalar count) {
		return add(count.longValue());
	}

	public __pthread_mutex_sPointer addOffset(long offset) {
		return __pthread_mutex_sPointer.cast(address + offset);
	}

	public __pthread_mutex_sPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __pthread_mutex_sPointer sub(long count) {
		return __pthread_mutex_sPointer.cast(address - (__pthread_mutex_s.SIZEOF * count));
	}

	public __pthread_mutex_sPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __pthread_mutex_sPointer subOffset(long offset) {
		return __pthread_mutex_sPointer.cast(address - offset);
	}

	public __pthread_mutex_sPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __pthread_mutex_sPointer untag(long mask) {
		return __pthread_mutex_sPointer.cast(address & ~mask);
	}

	public __pthread_mutex_sPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __pthread_mutex_s.SIZEOF;
	}

	// Implementation methods

	// U32 __count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___countOffset_", declaredType="U32")
	public UDATA __count() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthread_mutex_s.___countOffset_));
	}

	// U32 __count
	public UDATAPointer __countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthread_mutex_s.___countOffset_));
	}

	// I16 __elision
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___elisionOffset_", declaredType="I16")
	public I16 __elision() throws CorruptDataException {
		return new I16(getShortAtOffset(__pthread_mutex_s.___elisionOffset_));
	}

	// I16 __elision
	public I16Pointer __elisionEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(__pthread_mutex_s.___elisionOffset_));
	}

	// I32 __kind
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___kindOffset_", declaredType="I32")
	public IDATA __kind() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthread_mutex_s.___kindOffset_));
	}

	// I32 __kind
	public IDATAPointer __kindEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthread_mutex_s.___kindOffset_));
	}

	// __pthread_list_t __list
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___listOffset_", declaredType="__pthread_list_t")
	public __pthread_internal_listPointer __list() throws CorruptDataException {
		return __pthread_internal_listPointer.cast(nonNullFieldEA(__pthread_mutex_s.___listOffset_));
	}

	// __pthread_list_t __list
	public PointerPointer __listEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__pthread_mutex_s.___listOffset_));
	}

	// I32 __lock
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___lockOffset_", declaredType="I32")
	public IDATA __lock() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthread_mutex_s.___lockOffset_));
	}

	// I32 __lock
	public IDATAPointer __lockEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthread_mutex_s.___lockOffset_));
	}

	// U32 __nusers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___nusersOffset_", declaredType="U32")
	public UDATA __nusers() throws CorruptDataException {
		return new U32(getIntAtOffset(__pthread_mutex_s.___nusersOffset_));
	}

	// U32 __nusers
	public UDATAPointer __nusersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__pthread_mutex_s.___nusersOffset_));
	}

	// I32 __owner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ownerOffset_", declaredType="I32")
	public IDATA __owner() throws CorruptDataException {
		return new I32(getIntAtOffset(__pthread_mutex_s.___ownerOffset_));
	}

	// I32 __owner
	public IDATAPointer __ownerEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__pthread_mutex_s.___ownerOffset_));
	}

	// I16 __spins
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___spinsOffset_", declaredType="I16")
	public I16 __spins() throws CorruptDataException {
		return new I16(getShortAtOffset(__pthread_mutex_s.___spinsOffset_));
	}

	// I16 __spins
	public I16Pointer __spinsEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(__pthread_mutex_s.___spinsOffset_));
	}

}
