/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import com.sun.tools.attach.VirtualMachine;
import java.nio.file.Path;
import java.nio.file.Paths;

public class StreamingUtils {
    public static Path getJfrRepository(Process process) throws Exception {
        while (true) {
            if (!process.isAlive()) {
                Object msg = String.format("Process (pid = %d) is no longer alive, exit value = %d\n", process.pid(), process.exitValue());
                msg = (String)msg + "Stderr: " + new String(process.getErrorStream().readAllBytes()) + "\n";
                msg = (String)msg + "Stdout: " + new String(process.getInputStream().readAllBytes()) + "\n";
                throw new RuntimeException((String)msg);
            }
            try {
                VirtualMachine vm = VirtualMachine.attach(String.valueOf(process.pid()));
                String repo = vm.getSystemProperties().getProperty("jdk.jfr.repository");
                vm.detach();
                if (repo != null) {
                    System.out.println("JFR repository: " + repo);
                    return Paths.get(repo, new String[0]);
                }
            }
            catch (Exception e) {
                System.out.println("Attach failed: " + e.getMessage());
                System.out.println("Retrying...");
            }
            Thread.sleep(500L);
        }
    }
}

