/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Objects;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Balls
extends AnimatingControlsSurface {
    private static Color[] colors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN.darker(), Color.BLUE, new Color(75, 0, 82), new Color(238, 130, 238)};
    private long now;
    private long deltaT;
    private long lasttime;
    private boolean active;
    protected Ball[] balls = new Ball[colors.length];
    protected boolean clearToggle;
    protected JComboBox<String> combo;

    public Balls() {
        this.setBackground(Color.WHITE);
        for (int i = 0; i < colors.length; ++i) {
            this.balls[i] = new Ball(colors[i], 30);
        }
        this.balls[0].isSelected = true;
        this.balls[3].isSelected = true;
        this.balls[4].isSelected = true;
        this.balls[6].isSelected = true;
        this.setControls(new Component[]{new DemoControls(this, this)});
    }

    @Override
    public void reset(int w, int h) {
        if (w > 400 && h > 100) {
            this.combo.setSelectedIndex(5);
        }
    }

    @Override
    public void step(int w, int h) {
        if (this.lasttime == 0L) {
            this.lasttime = System.currentTimeMillis();
        }
        this.now = System.currentTimeMillis();
        this.deltaT = this.now - this.lasttime;
        this.active = false;
        for (Ball ball : this.balls) {
            if (ball == null) {
                return;
            }
            ball.step(this.deltaT, w, h);
            if (!((double)ball.Vy > 0.02) && !((double)(-ball.Vy) > 0.02) && !(ball.y + (float)ball.bsize < (float)h)) continue;
            this.active = true;
        }
        if (!this.active) {
            for (Ball ball : this.balls) {
                ball.Vx = (float)Math.random() / 4.0f - 0.125f;
                ball.Vy = -((float)Math.random()) / 4.0f - 0.2f;
            }
            this.clearToggle = true;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        for (Ball b : this.balls) {
            if (b == null || b.imgs[b.index] == null || !b.isSelected) continue;
            g2.drawImage((Image)b.imgs[b.index], (int)b.x, (int)b.y, this);
        }
        this.lasttime = this.now;
    }

    public static void main(String[] argv) {
        Balls.createDemoFrame(new Balls());
    }

    protected static final class Ball {
        public static final int nImgs = 5;
        public int bsize;
        public float x;
        public float y;
        public float Vx = 0.1f;
        public float Vy = 0.05f;
        public BufferedImage[] imgs;
        public int index = (int)(Math.random() * 4.0);
        private static final float inelasticity = 0.96f;
        private static final float Ax = 0.0f;
        private static final float Ay = 2.0E-4f;
        private static final int UP = 0;
        private static final int DOWN = 1;
        private int indexDirection = 0;
        private float jitter;
        private Color color;
        private boolean isSelected;

        public Ball(Color color, int bsize) {
            this.color = color;
            this.makeImages(bsize);
        }

        public void makeImages(int bsize) {
            this.bsize = bsize * 2;
            int R = bsize;
            byte[] data = new byte[R * 2 * R * 2];
            int maxr = 0;
            int Y = 2 * R;
            while (--Y >= 0) {
                int x0 = (int)(Math.sqrt(R * R - (Y - R) * (Y - R)) + 0.5);
                int p = Y * (R * 2) + R - x0;
                for (int X = -x0; X < x0; ++X) {
                    int xx = X + 15;
                    int yy = Y - R + 15;
                    int r = (int)(Math.hypot(xx, yy) + 0.5);
                    if (r > maxr) {
                        maxr = r;
                    }
                    data[p++] = r <= 0 ? (byte)1 : (byte)r;
                }
            }
            this.imgs = new BufferedImage[5];
            int bg = 255;
            byte[] red = new byte[256];
            red[0] = (byte)bg;
            byte[] green = new byte[256];
            green[0] = (byte)bg;
            byte[] blue = new byte[256];
            blue[0] = (byte)bg;
            for (int r = 0; r < this.imgs.length; ++r) {
                float b = 0.5f + ((float)r + 1.0f) / (float)this.imgs.length / 2.0f;
                for (int i = maxr; i >= 1; --i) {
                    float d = (float)i / (float)maxr;
                    red[i] = (byte)this.blend(this.blend(this.color.getRed(), 255, d), bg, b);
                    green[i] = (byte)this.blend(this.blend(this.color.getGreen(), 255, d), bg, b);
                    blue[i] = (byte)this.blend(this.blend(this.color.getBlue(), 255, d), bg, b);
                }
                IndexColorModel icm = new IndexColorModel(8, maxr + 1, red, green, blue, 0);
                DataBufferByte dbb = new DataBufferByte(data, data.length);
                int[] bandOffsets = new int[]{0};
                WritableRaster wr = Raster.createInterleavedRaster(dbb, R * 2, R * 2, R * 2, 1, bandOffsets, null);
                this.imgs[r] = new BufferedImage(icm, wr, icm.isAlphaPremultiplied(), null);
            }
        }

        private int blend(int fg, int bg, float fgfactor) {
            return (int)((float)bg + (float)(fg - bg) * fgfactor);
        }

        public void step(long deltaT, int w, int h) {
            this.jitter = (float)Math.random() * 0.01f - 0.005f;
            this.x = (float)((double)this.x + ((double)(this.Vx * (float)deltaT) + 0.0 * (double)deltaT * (double)deltaT));
            this.y = (float)((double)this.y + ((double)(this.Vy * (float)deltaT) + (double)1.0E-4f * (double)deltaT * (double)deltaT));
            if (this.x <= 0.0f) {
                this.x = 0.0f;
                this.Vx = -this.Vx * 0.96f + this.jitter;
            }
            if (this.x + (float)this.bsize >= (float)w) {
                this.x = w - this.bsize;
                this.Vx = -this.Vx * 0.96f + this.jitter;
            }
            if (this.y <= 0.0f) {
                this.y = 0.0f;
                this.Vy = -this.Vy * 0.96f + this.jitter;
            }
            if (this.y + (float)this.bsize >= (float)h) {
                this.y = h - this.bsize;
                this.Vx *= 0.96f;
                this.Vy = -this.Vy * 0.96f + this.jitter;
            }
            this.Vy += 2.0E-4f * (float)deltaT;
            this.Vx += 0.0f * (float)deltaT;
            if (this.indexDirection == 0) {
                ++this.index;
            }
            if (this.indexDirection == 1) {
                --this.index;
            }
            if (this.index + 1 == 5) {
                this.indexDirection = 1;
            }
            if (this.index == 0) {
                this.indexDirection = 0;
            }
        }
    }

    final class DemoControls
    extends CustomControls
    implements ActionListener {
        Balls demo;
        JToolBar toolbar;
        final /* synthetic */ Balls this$0;

        public DemoControls(Balls this$0, Balls demo) {
            Balls balls = this$0;
            Objects.requireNonNull(balls);
            this.this$0 = balls;
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Clear", true);
            this.addTool("R", demo.balls[0].isSelected);
            this.addTool("O", demo.balls[1].isSelected);
            this.addTool("Y", demo.balls[2].isSelected);
            this.addTool("G", demo.balls[3].isSelected);
            this.addTool("B", demo.balls[4].isSelected);
            this.addTool("I", demo.balls[5].isSelected);
            this.addTool("V", demo.balls[6].isSelected);
            this$0.combo = new JComboBox();
            this.add(this$0.combo);
            this$0.combo.addItem("10");
            this$0.combo.addItem("20");
            this$0.combo.addItem("30");
            this$0.combo.addItem("40");
            this$0.combo.addItem("50");
            this$0.combo.addItem("60");
            this$0.combo.addItem("70");
            this$0.combo.addItem("80");
            this$0.combo.setSelectedIndex(2);
            this$0.combo.addActionListener(this);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                int size = Integer.parseInt((String)this.this$0.combo.getSelectedItem());
                for (Ball ball : this.demo.balls) {
                    ball.makeImages(size);
                }
                return;
            }
            JToggleButton b = (JToggleButton)e.getSource();
            if (b.getText().equals("Clear")) {
                this.demo.clearSurface = b.isSelected();
            } else {
                int index = this.toolbar.getComponentIndex(b) - 1;
                this.demo.balls[index].isSelected = b.isSelected();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (Exception e) {
                return;
            }
            Thread me = Thread.currentThread();
            ((AbstractButton)this.toolbar.getComponentAtIndex(2)).doClick();
            while (this.thread == me) {
                try {
                    Thread.sleep(222L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (!this.demo.clearToggle) continue;
                if (this.demo.clearSurface) {
                    this.this$0.combo.setSelectedIndex((int)(Math.random() * 5.0));
                }
                ((AbstractButton)this.toolbar.getComponentAtIndex(0)).doClick();
                this.demo.clearToggle = false;
            }
            this.thread = null;
        }
    }
}

