/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CudaGlobalDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CudaGlobalDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CudaGlobalData.class)
public class J9CudaGlobalDataPointer extends StructurePointer {

	// NULL
	public static final J9CudaGlobalDataPointer NULL = new J9CudaGlobalDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CudaGlobalDataPointer(long address) {
		super(address);
	}

	public static J9CudaGlobalDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CudaGlobalDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CudaGlobalDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9CudaGlobalDataPointer(address);
	}

	public J9CudaGlobalDataPointer add(long count) {
		return J9CudaGlobalDataPointer.cast(address + (J9CudaGlobalData.SIZEOF * count));
	}

	public J9CudaGlobalDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CudaGlobalDataPointer addOffset(long offset) {
		return J9CudaGlobalDataPointer.cast(address + offset);
	}

	public J9CudaGlobalDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CudaGlobalDataPointer sub(long count) {
		return J9CudaGlobalDataPointer.cast(address - (J9CudaGlobalData.SIZEOF * count));
	}

	public J9CudaGlobalDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CudaGlobalDataPointer subOffset(long offset) {
		return J9CudaGlobalDataPointer.cast(address - offset);
	}

	public J9CudaGlobalDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CudaGlobalDataPointer untag(long mask) {
		return J9CudaGlobalDataPointer.cast(address & ~mask);
	}

	public J9CudaGlobalDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CudaGlobalData.SIZEOF;
	}

	// Implementation methods

	// U32 deviceCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deviceCountOffset_", declaredType="U32")
	public UDATA deviceCount() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaGlobalData._deviceCountOffset_));
	}

	// U32 deviceCount
	public UDATAPointer deviceCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._deviceCountOffset_));
	}

	// U64 driverHandle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_driverHandleOffset_", declaredType="U64")
	public UDATA driverHandle() throws CorruptDataException {
		return new U64(getLongAtOffset(J9CudaGlobalData._driverHandleOffset_));
	}

	// U64 driverHandle
	public UDATAPointer driverHandleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._driverHandleOffset_));
	}

	// U32 driverVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_driverVersionOffset_", declaredType="U32")
	public UDATA driverVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaGlobalData._driverVersionOffset_));
	}

	// U32 driverVersion
	public UDATAPointer driverVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._driverVersionOffset_));
	}

	// void*[] functionTable
	public PointerPointer functionTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaGlobalData._functionTableOffset_));
	}

	// U64 runtimeHandle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runtimeHandleOffset_", declaredType="U64")
	public UDATA runtimeHandle() throws CorruptDataException {
		return new U64(getLongAtOffset(J9CudaGlobalData._runtimeHandleOffset_));
	}

	// U64 runtimeHandle
	public UDATAPointer runtimeHandleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._runtimeHandleOffset_));
	}

	// U32 runtimeVersion
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_runtimeVersionOffset_", declaredType="U32")
	public UDATA runtimeVersion() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaGlobalData._runtimeVersionOffset_));
	}

	// U32 runtimeVersion
	public UDATAPointer runtimeVersionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._runtimeVersionOffset_));
	}

	// U32 state
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stateOffset_", declaredType="U32")
	public UDATA state() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CudaGlobalData._stateOffset_));
	}

	// U32 state
	public UDATAPointer stateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._stateOffset_));
	}

	// MUTEX stateMutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stateMutexOffset_", declaredType="MUTEX")
	public pthread_mutex_tPointer stateMutex() throws CorruptDataException {
		return pthread_mutex_tPointer.cast(nonNullFieldEA(J9CudaGlobalData._stateMutexOffset_));
	}

	// MUTEX stateMutex
	public PointerPointer stateMutexEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CudaGlobalData._stateMutexOffset_));
	}

	// omrthread_tls_key_t tlsKey
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tlsKeyOffset_", declaredType="omrthread_tls_key_t")
	public UDATA tlsKey() throws CorruptDataException {
		return new U64(getLongAtOffset(J9CudaGlobalData._tlsKeyOffset_));
	}

	// omrthread_tls_key_t tlsKey
	public UDATAPointer tlsKeyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CudaGlobalData._tlsKeyOffset_));
	}

}
