/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MethodEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MethodEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MethodEntry.class)
public class MethodEntryPointer extends StructurePointer {

	// NULL
	public static final MethodEntryPointer NULL = new MethodEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MethodEntryPointer(long address) {
		super(address);
	}

	public static MethodEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MethodEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MethodEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MethodEntryPointer(address);
	}

	public MethodEntryPointer add(long count) {
		return MethodEntryPointer.cast(address + (MethodEntry.SIZEOF * count));
	}

	public MethodEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MethodEntryPointer addOffset(long offset) {
		return MethodEntryPointer.cast(address + offset);
	}

	public MethodEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MethodEntryPointer sub(long count) {
		return MethodEntryPointer.cast(address - (MethodEntry.SIZEOF * count));
	}

	public MethodEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MethodEntryPointer subOffset(long offset) {
		return MethodEntryPointer.cast(address - offset);
	}

	public MethodEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MethodEntryPointer untag(long mask) {
		return MethodEntryPointer.cast(address & ~mask);
	}

	public MethodEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MethodEntry.SIZEOF;
	}

	// Implementation methods

	// U32 classIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classIndexOffset_", declaredType="U32")
	public UDATA classIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._classIndexOffset_));
	}

	// U32 classIndex
	public UDATAPointer classIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._classIndexOffset_));
	}

	// U32 descriptorStringUTF8Index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_descriptorStringUTF8IndexOffset_", declaredType="U32")
	public UDATA descriptorStringUTF8Index() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._descriptorStringUTF8IndexOffset_));
	}

	// U32 descriptorStringUTF8Index
	public UDATAPointer descriptorStringUTF8IndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._descriptorStringUTF8IndexOffset_));
	}

	// BOOLEAN hidden
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hiddenOffset_", declaredType="BOOLEAN")
	public UDATA hidden() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._hiddenOffset_));
	}

	// BOOLEAN hidden
	public UDATAPointer hiddenEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._hiddenOffset_));
	}

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._indexOffset_));
	}

	// U32 modifiers
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_modifiersOffset_", declaredType="U32")
	public UDATA modifiers() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._modifiersOffset_));
	}

	// U32 modifiers
	public UDATAPointer modifiersEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._modifiersOffset_));
	}

	// U32 nameStringUTF8Index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameStringUTF8IndexOffset_", declaredType="U32")
	public UDATA nameStringUTF8Index() throws CorruptDataException {
		return new U32(getIntAtOffset(MethodEntry._nameStringUTF8IndexOffset_));
	}

	// U32 nameStringUTF8Index
	public UDATAPointer nameStringUTF8IndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MethodEntry._nameStringUTF8IndexOffset_));
	}

	// MethodEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="MethodEntry*")
	public MethodEntryPointer next() throws CorruptDataException {
		return MethodEntryPointer.cast(getPointerAtOffset(MethodEntry._nextOffset_));
	}

	// MethodEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MethodEntry._nextOffset_));
	}

	// J9ROMMethod* romMethod
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_romMethodOffset_", declaredType="J9ROMMethod*")
	public J9ROMMethodPointer romMethod() throws CorruptDataException {
		return J9ROMMethodPointer.cast(getPointerAtOffset(MethodEntry._romMethodOffset_));
	}

	// J9ROMMethod* romMethod
	public PointerPointer romMethodEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MethodEntry._romMethodOffset_));
	}

}
