/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: VM_JFRConstantPoolTypesPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the VM_JFRConstantPoolTypesPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=VM_JFRConstantPoolTypes.class)
public class VM_JFRConstantPoolTypesPointer extends StructurePointer {

	// NULL
	public static final VM_JFRConstantPoolTypesPointer NULL = new VM_JFRConstantPoolTypesPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected VM_JFRConstantPoolTypesPointer(long address) {
		super(address);
	}

	public static VM_JFRConstantPoolTypesPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static VM_JFRConstantPoolTypesPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static VM_JFRConstantPoolTypesPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new VM_JFRConstantPoolTypesPointer(address);
	}

	public VM_JFRConstantPoolTypesPointer add(long count) {
		return VM_JFRConstantPoolTypesPointer.cast(address + (VM_JFRConstantPoolTypes.SIZEOF * count));
	}

	public VM_JFRConstantPoolTypesPointer add(Scalar count) {
		return add(count.longValue());
	}

	public VM_JFRConstantPoolTypesPointer addOffset(long offset) {
		return VM_JFRConstantPoolTypesPointer.cast(address + offset);
	}

	public VM_JFRConstantPoolTypesPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public VM_JFRConstantPoolTypesPointer sub(long count) {
		return VM_JFRConstantPoolTypesPointer.cast(address - (VM_JFRConstantPoolTypes.SIZEOF * count));
	}

	public VM_JFRConstantPoolTypesPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public VM_JFRConstantPoolTypesPointer subOffset(long offset) {
		return VM_JFRConstantPoolTypesPointer.cast(address - offset);
	}

	public VM_JFRConstantPoolTypesPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public VM_JFRConstantPoolTypesPointer untag(long mask) {
		return VM_JFRConstantPoolTypesPointer.cast(address & ~mask);
	}

	public VM_JFRConstantPoolTypesPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return VM_JFRConstantPoolTypes.SIZEOF;
	}

	// Implementation methods

	// JfrBuildResult _buildResult
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__buildResultOffset_", declaredType="JfrBuildResult")
	public long _buildResult() throws CorruptDataException {
		if (JfrBuildResult.SIZEOF == 1) {
			return getByteAtOffset(VM_JFRConstantPoolTypes.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 2) {
			return getShortAtOffset(VM_JFRConstantPoolTypes.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 4) {
			return getIntAtOffset(VM_JFRConstantPoolTypes.__buildResultOffset_);
		} else if (JfrBuildResult.SIZEOF == 8) {
			return getLongAtOffset(VM_JFRConstantPoolTypes.__buildResultOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// JfrBuildResult _buildResult
	public EnumPointer _buildResultEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__buildResultOffset_), JfrBuildResult.class);
	}

	// U32 _classCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classCountOffset_", declaredType="U32")
	public UDATA _classCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__classCountOffset_));
	}

	// U32 _classCount
	public UDATAPointer _classCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classCountOffset_));
	}

	// U32 _classLoaderCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classLoaderCountOffset_", declaredType="U32")
	public UDATA _classLoaderCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__classLoaderCountOffset_));
	}

	// U32 _classLoaderCount
	public UDATAPointer _classLoaderCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classLoaderCountOffset_));
	}

	// J9HashTable* _classLoaderTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classLoaderTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _classLoaderTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__classLoaderTableOffset_));
	}

	// J9HashTable* _classLoaderTable
	public PointerPointer _classLoaderTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classLoaderTableOffset_));
	}

	// UDATA _classLoadingStatisticsCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classLoadingStatisticsCountOffset_", declaredType="UDATA")
	public UDATA _classLoadingStatisticsCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__classLoadingStatisticsCountOffset_);
	}

	// UDATA _classLoadingStatisticsCount
	public UDATAPointer _classLoadingStatisticsCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classLoadingStatisticsCountOffset_));
	}

	// J9Pool* _classLoadingStatisticsTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classLoadingStatisticsTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _classLoadingStatisticsTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__classLoadingStatisticsTableOffset_));
	}

	// J9Pool* _classLoadingStatisticsTable
	public PointerPointer _classLoadingStatisticsTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classLoadingStatisticsTableOffset_));
	}

	// J9HashTable* _classTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__classTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _classTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__classTableOffset_));
	}

	// J9HashTable* _classTable
	public PointerPointer _classTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__classTableOffset_));
	}

	// UDATA _cpuLoadCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cpuLoadCountOffset_", declaredType="UDATA")
	public UDATA _cpuLoadCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__cpuLoadCountOffset_);
	}

	// UDATA _cpuLoadCount
	public UDATAPointer _cpuLoadCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__cpuLoadCountOffset_));
	}

	// J9Pool* _cpuLoadTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cpuLoadTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _cpuLoadTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__cpuLoadTableOffset_));
	}

	// J9Pool* _cpuLoadTable
	public PointerPointer _cpuLoadTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__cpuLoadTableOffset_));
	}

	// U32 _currentFrameCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentFrameCountOffset_", declaredType="U32")
	public UDATA _currentFrameCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__currentFrameCountOffset_));
	}

	// U32 _currentFrameCount
	public UDATAPointer _currentFrameCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__currentFrameCountOffset_));
	}

	// StackFrame* _currentStackFrameBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentStackFrameBufferOffset_", declaredType="StackFrame*")
	public StackFramePointer _currentStackFrameBuffer() throws CorruptDataException {
		return StackFramePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__currentStackFrameBufferOffset_));
	}

	// StackFrame* _currentStackFrameBuffer
	public PointerPointer _currentStackFrameBufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__currentStackFrameBufferOffset_));
	}

	// J9VMThread* _currentThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__currentThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer _currentThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__currentThreadOffset_));
	}

	// J9VMThread* _currentThread
	public PointerPointer _currentThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__currentThreadOffset_));
	}

	// bool _debug
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__debugOffset_", declaredType="bool")
	public boolean _debug() throws CorruptDataException {
		return getBoolAtOffset(VM_JFRConstantPoolTypes.__debugOffset_);
	}

	// bool _debug
	public BoolPointer _debugEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__debugOffset_));
	}

	// ClassEntry _defaultClassEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultClassEntryOffset_", declaredType="ClassEntry")
	public ClassEntryPointer _defaultClassEntry() throws CorruptDataException {
		return ClassEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultClassEntryOffset_));
	}

	// ClassEntry _defaultClassEntry
	public PointerPointer _defaultClassEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultClassEntryOffset_));
	}

	// MethodEntry _defaultMethodEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultMethodEntryOffset_", declaredType="MethodEntry")
	public MethodEntryPointer _defaultMethodEntry() throws CorruptDataException {
		return MethodEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultMethodEntryOffset_));
	}

	// MethodEntry _defaultMethodEntry
	public PointerPointer _defaultMethodEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultMethodEntryOffset_));
	}

	// ModuleEntry _defaultModuleEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultModuleEntryOffset_", declaredType="ModuleEntry")
	public ModuleEntryPointer _defaultModuleEntry() throws CorruptDataException {
		return ModuleEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultModuleEntryOffset_));
	}

	// ModuleEntry _defaultModuleEntry
	public PointerPointer _defaultModuleEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultModuleEntryOffset_));
	}

	// PackageEntry _defaultPackageEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultPackageEntryOffset_", declaredType="PackageEntry")
	public PackageEntryPointer _defaultPackageEntry() throws CorruptDataException {
		return PackageEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultPackageEntryOffset_));
	}

	// PackageEntry _defaultPackageEntry
	public PointerPointer _defaultPackageEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultPackageEntryOffset_));
	}

	// StackTraceEntry _defaultStackTraceEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultStackTraceEntryOffset_", declaredType="StackTraceEntry")
	public StackTraceEntryPointer _defaultStackTraceEntry() throws CorruptDataException {
		return StackTraceEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultStackTraceEntryOffset_));
	}

	// StackTraceEntry _defaultStackTraceEntry
	public PointerPointer _defaultStackTraceEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultStackTraceEntryOffset_));
	}

	// StringUTF8Entry _defaultStringUTF8Entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultStringUTF8EntryOffset_", declaredType="StringUTF8Entry")
	public StringUTF8EntryPointer _defaultStringUTF8Entry() throws CorruptDataException {
		return StringUTF8EntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultStringUTF8EntryOffset_));
	}

	// StringUTF8Entry _defaultStringUTF8Entry
	public PointerPointer _defaultStringUTF8EntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultStringUTF8EntryOffset_));
	}

	// ThreadGroupEntry _defaultThreadGroup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__defaultThreadGroupOffset_", declaredType="ThreadGroupEntry")
	public ThreadGroupEntryPointer _defaultThreadGroup() throws CorruptDataException {
		return ThreadGroupEntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultThreadGroupOffset_));
	}

	// ThreadGroupEntry _defaultThreadGroup
	public PointerPointer _defaultThreadGroupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__defaultThreadGroupOffset_));
	}

	// UDATA _executionSampleCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__executionSampleCountOffset_", declaredType="UDATA")
	public UDATA _executionSampleCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__executionSampleCountOffset_);
	}

	// UDATA _executionSampleCount
	public UDATAPointer _executionSampleCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__executionSampleCountOffset_));
	}

	// J9Pool* _executionSampleTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__executionSampleTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _executionSampleTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__executionSampleTableOffset_));
	}

	// J9Pool* _executionSampleTable
	public PointerPointer _executionSampleTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__executionSampleTableOffset_));
	}

	// ClassEntry* _firstClassEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstClassEntryOffset_", declaredType="ClassEntry*")
	public ClassEntryPointer _firstClassEntry() throws CorruptDataException {
		return ClassEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstClassEntryOffset_));
	}

	// ClassEntry* _firstClassEntry
	public PointerPointer _firstClassEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstClassEntryOffset_));
	}

	// ClassloaderEntry* _firstClassloaderEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstClassloaderEntryOffset_", declaredType="ClassloaderEntry*")
	public ClassloaderEntryPointer _firstClassloaderEntry() throws CorruptDataException {
		return ClassloaderEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstClassloaderEntryOffset_));
	}

	// ClassloaderEntry* _firstClassloaderEntry
	public PointerPointer _firstClassloaderEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstClassloaderEntryOffset_));
	}

	// MethodEntry* _firstMethodEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstMethodEntryOffset_", declaredType="MethodEntry*")
	public MethodEntryPointer _firstMethodEntry() throws CorruptDataException {
		return MethodEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstMethodEntryOffset_));
	}

	// MethodEntry* _firstMethodEntry
	public PointerPointer _firstMethodEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstMethodEntryOffset_));
	}

	// ModuleEntry* _firstModuleEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstModuleEntryOffset_", declaredType="ModuleEntry*")
	public ModuleEntryPointer _firstModuleEntry() throws CorruptDataException {
		return ModuleEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstModuleEntryOffset_));
	}

	// ModuleEntry* _firstModuleEntry
	public PointerPointer _firstModuleEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstModuleEntryOffset_));
	}

	// NativeLibraryEntry* _firstNativeLibraryEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstNativeLibraryEntryOffset_", declaredType="NativeLibraryEntry*")
	public NativeLibraryEntryPointer _firstNativeLibraryEntry() throws CorruptDataException {
		return NativeLibraryEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstNativeLibraryEntryOffset_));
	}

	// NativeLibraryEntry* _firstNativeLibraryEntry
	public PointerPointer _firstNativeLibraryEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstNativeLibraryEntryOffset_));
	}

	// PackageEntry* _firstPackageEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstPackageEntryOffset_", declaredType="PackageEntry*")
	public PackageEntryPointer _firstPackageEntry() throws CorruptDataException {
		return PackageEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstPackageEntryOffset_));
	}

	// PackageEntry* _firstPackageEntry
	public PointerPointer _firstPackageEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstPackageEntryOffset_));
	}

	// StackTraceEntry* _firstStackTraceEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstStackTraceEntryOffset_", declaredType="StackTraceEntry*")
	public StackTraceEntryPointer _firstStackTraceEntry() throws CorruptDataException {
		return StackTraceEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstStackTraceEntryOffset_));
	}

	// StackTraceEntry* _firstStackTraceEntry
	public PointerPointer _firstStackTraceEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstStackTraceEntryOffset_));
	}

	// ThreadEntry* _firstThreadEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstThreadEntryOffset_", declaredType="ThreadEntry*")
	public ThreadEntryPointer _firstThreadEntry() throws CorruptDataException {
		return ThreadEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstThreadEntryOffset_));
	}

	// ThreadEntry* _firstThreadEntry
	public PointerPointer _firstThreadEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstThreadEntryOffset_));
	}

	// ThreadGroupEntry* _firstThreadGroupEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstThreadGroupEntryOffset_", declaredType="ThreadGroupEntry*")
	public ThreadGroupEntryPointer _firstThreadGroupEntry() throws CorruptDataException {
		return ThreadGroupEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__firstThreadGroupEntryOffset_));
	}

	// ThreadGroupEntry* _firstThreadGroupEntry
	public PointerPointer _firstThreadGroupEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__firstThreadGroupEntryOffset_));
	}

	// void** _globalStringTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__globalStringTableOffset_", declaredType="void**")
	public PointerPointer _globalStringTable() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__globalStringTableOffset_));
	}

	// void** _globalStringTable
	public PointerPointer _globalStringTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__globalStringTableOffset_));
	}

	// U32 _methodCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__methodCountOffset_", declaredType="U32")
	public UDATA _methodCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__methodCountOffset_));
	}

	// U32 _methodCount
	public UDATAPointer _methodCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__methodCountOffset_));
	}

	// J9HashTable* _methodTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__methodTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _methodTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__methodTableOffset_));
	}

	// J9HashTable* _methodTable
	public PointerPointer _methodTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__methodTableOffset_));
	}

	// U32 _moduleCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleCountOffset_", declaredType="U32")
	public UDATA _moduleCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__moduleCountOffset_));
	}

	// U32 _moduleCount
	public UDATAPointer _moduleCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleCountOffset_));
	}

	// UDATA _moduleExportCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleExportCountOffset_", declaredType="UDATA")
	public UDATA _moduleExportCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__moduleExportCountOffset_);
	}

	// UDATA _moduleExportCount
	public UDATAPointer _moduleExportCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleExportCountOffset_));
	}

	// J9Pool* _moduleExportTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleExportTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _moduleExportTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__moduleExportTableOffset_));
	}

	// J9Pool* _moduleExportTable
	public PointerPointer _moduleExportTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleExportTableOffset_));
	}

	// UDATA _moduleRequireCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleRequireCountOffset_", declaredType="UDATA")
	public UDATA _moduleRequireCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__moduleRequireCountOffset_);
	}

	// UDATA _moduleRequireCount
	public UDATAPointer _moduleRequireCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleRequireCountOffset_));
	}

	// J9Pool* _moduleRequireTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleRequireTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _moduleRequireTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__moduleRequireTableOffset_));
	}

	// J9Pool* _moduleRequireTable
	public PointerPointer _moduleRequireTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleRequireTableOffset_));
	}

	// J9HashTable* _moduleTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__moduleTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _moduleTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__moduleTableOffset_));
	}

	// J9HashTable* _moduleTable
	public PointerPointer _moduleTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__moduleTableOffset_));
	}

	// UDATA _monitorEnterCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__monitorEnterCountOffset_", declaredType="UDATA")
	public UDATA _monitorEnterCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__monitorEnterCountOffset_);
	}

	// UDATA _monitorEnterCount
	public UDATAPointer _monitorEnterCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__monitorEnterCountOffset_));
	}

	// J9Pool* _monitorEnterTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__monitorEnterTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _monitorEnterTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__monitorEnterTableOffset_));
	}

	// J9Pool* _monitorEnterTable
	public PointerPointer _monitorEnterTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__monitorEnterTableOffset_));
	}

	// UDATA _monitorWaitCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__monitorWaitCountOffset_", declaredType="UDATA")
	public UDATA _monitorWaitCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__monitorWaitCountOffset_);
	}

	// UDATA _monitorWaitCount
	public UDATAPointer _monitorWaitCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__monitorWaitCountOffset_));
	}

	// J9Pool* _monitorWaitTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__monitorWaitTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _monitorWaitTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__monitorWaitTableOffset_));
	}

	// J9Pool* _monitorWaitTable
	public PointerPointer _monitorWaitTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__monitorWaitTableOffset_));
	}

	// UDATA _nativeLibrariesCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nativeLibrariesCountOffset_", declaredType="UDATA")
	public UDATA _nativeLibrariesCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__nativeLibrariesCountOffset_);
	}

	// UDATA _nativeLibrariesCount
	public UDATAPointer _nativeLibrariesCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeLibrariesCountOffset_));
	}

	// J9Pool* _nativeLibrariesTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nativeLibrariesTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _nativeLibrariesTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__nativeLibrariesTableOffset_));
	}

	// J9Pool* _nativeLibrariesTable
	public PointerPointer _nativeLibrariesTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeLibrariesTableOffset_));
	}

	// UDATA _nativeLibraryPathSizeTotal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nativeLibraryPathSizeTotalOffset_", declaredType="UDATA")
	public UDATA _nativeLibraryPathSizeTotal() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__nativeLibraryPathSizeTotalOffset_);
	}

	// UDATA _nativeLibraryPathSizeTotal
	public UDATAPointer _nativeLibraryPathSizeTotalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeLibraryPathSizeTotalOffset_));
	}

	// StringUTF8Entry _nativeMethodSignatureStringUTF8Entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nativeMethodSignatureStringUTF8EntryOffset_", declaredType="StringUTF8Entry")
	public StringUTF8EntryPointer _nativeMethodSignatureStringUTF8Entry() throws CorruptDataException {
		return StringUTF8EntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeMethodSignatureStringUTF8EntryOffset_));
	}

	// StringUTF8Entry _nativeMethodSignatureStringUTF8Entry
	public PointerPointer _nativeMethodSignatureStringUTF8EntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeMethodSignatureStringUTF8EntryOffset_));
	}

	// StringUTF8Entry _nativeMethodStringUTF8Entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nativeMethodStringUTF8EntryOffset_", declaredType="StringUTF8Entry")
	public StringUTF8EntryPointer _nativeMethodStringUTF8Entry() throws CorruptDataException {
		return StringUTF8EntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeMethodStringUTF8EntryOffset_));
	}

	// StringUTF8Entry _nativeMethodStringUTF8Entry
	public PointerPointer _nativeMethodStringUTF8EntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__nativeMethodStringUTF8EntryOffset_));
	}

	// U32 _packageCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__packageCountOffset_", declaredType="U32")
	public UDATA _packageCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__packageCountOffset_));
	}

	// U32 _packageCount
	public UDATAPointer _packageCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__packageCountOffset_));
	}

	// U32 _packageNameCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__packageNameCountOffset_", declaredType="U32")
	public UDATA _packageNameCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__packageNameCountOffset_));
	}

	// U32 _packageNameCount
	public UDATAPointer _packageNameCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__packageNameCountOffset_));
	}

	// J9HashTable* _packageTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__packageTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _packageTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__packageTableOffset_));
	}

	// J9HashTable* _packageTable
	public PointerPointer _packageTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__packageTableOffset_));
	}

	// ClassEntry* _previousClassEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousClassEntryOffset_", declaredType="ClassEntry*")
	public ClassEntryPointer _previousClassEntry() throws CorruptDataException {
		return ClassEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousClassEntryOffset_));
	}

	// ClassEntry* _previousClassEntry
	public PointerPointer _previousClassEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousClassEntryOffset_));
	}

	// ClassloaderEntry* _previousClassloaderEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousClassloaderEntryOffset_", declaredType="ClassloaderEntry*")
	public ClassloaderEntryPointer _previousClassloaderEntry() throws CorruptDataException {
		return ClassloaderEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousClassloaderEntryOffset_));
	}

	// ClassloaderEntry* _previousClassloaderEntry
	public PointerPointer _previousClassloaderEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousClassloaderEntryOffset_));
	}

	// MethodEntry* _previousMethodEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousMethodEntryOffset_", declaredType="MethodEntry*")
	public MethodEntryPointer _previousMethodEntry() throws CorruptDataException {
		return MethodEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousMethodEntryOffset_));
	}

	// MethodEntry* _previousMethodEntry
	public PointerPointer _previousMethodEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousMethodEntryOffset_));
	}

	// ModuleEntry* _previousModuleEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousModuleEntryOffset_", declaredType="ModuleEntry*")
	public ModuleEntryPointer _previousModuleEntry() throws CorruptDataException {
		return ModuleEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousModuleEntryOffset_));
	}

	// ModuleEntry* _previousModuleEntry
	public PointerPointer _previousModuleEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousModuleEntryOffset_));
	}

	// NativeLibraryEntry* _previousNativeLibraryEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousNativeLibraryEntryOffset_", declaredType="NativeLibraryEntry*")
	public NativeLibraryEntryPointer _previousNativeLibraryEntry() throws CorruptDataException {
		return NativeLibraryEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousNativeLibraryEntryOffset_));
	}

	// NativeLibraryEntry* _previousNativeLibraryEntry
	public PointerPointer _previousNativeLibraryEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousNativeLibraryEntryOffset_));
	}

	// PackageEntry* _previousPackageEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousPackageEntryOffset_", declaredType="PackageEntry*")
	public PackageEntryPointer _previousPackageEntry() throws CorruptDataException {
		return PackageEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousPackageEntryOffset_));
	}

	// PackageEntry* _previousPackageEntry
	public PointerPointer _previousPackageEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousPackageEntryOffset_));
	}

	// StackTraceEntry* _previousStackTraceEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousStackTraceEntryOffset_", declaredType="StackTraceEntry*")
	public StackTraceEntryPointer _previousStackTraceEntry() throws CorruptDataException {
		return StackTraceEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousStackTraceEntryOffset_));
	}

	// StackTraceEntry* _previousStackTraceEntry
	public PointerPointer _previousStackTraceEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousStackTraceEntryOffset_));
	}

	// ThreadEntry* _previousThreadEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousThreadEntryOffset_", declaredType="ThreadEntry*")
	public ThreadEntryPointer _previousThreadEntry() throws CorruptDataException {
		return ThreadEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousThreadEntryOffset_));
	}

	// ThreadEntry* _previousThreadEntry
	public PointerPointer _previousThreadEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousThreadEntryOffset_));
	}

	// ThreadGroupEntry* _previousThreadGroupEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousThreadGroupEntryOffset_", declaredType="ThreadGroupEntry*")
	public ThreadGroupEntryPointer _previousThreadGroupEntry() throws CorruptDataException {
		return ThreadGroupEntryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__previousThreadGroupEntryOffset_));
	}

	// ThreadGroupEntry* _previousThreadGroupEntry
	public PointerPointer _previousThreadGroupEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__previousThreadGroupEntryOffset_));
	}

	// UDATA _requiredBufferSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__requiredBufferSizeOffset_", declaredType="UDATA")
	public UDATA _requiredBufferSize() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__requiredBufferSizeOffset_);
	}

	// UDATA _requiredBufferSize
	public UDATAPointer _requiredBufferSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__requiredBufferSizeOffset_));
	}

	// U32 _stackFrameCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stackFrameCountOffset_", declaredType="U32")
	public UDATA _stackFrameCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__stackFrameCountOffset_));
	}

	// U32 _stackFrameCount
	public UDATAPointer _stackFrameCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__stackFrameCountOffset_));
	}

	// U32 _stackTraceCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stackTraceCountOffset_", declaredType="U32")
	public UDATA _stackTraceCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__stackTraceCountOffset_));
	}

	// U32 _stackTraceCount
	public UDATAPointer _stackTraceCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__stackTraceCountOffset_));
	}

	// J9HashTable* _stackTraceTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stackTraceTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _stackTraceTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__stackTraceTableOffset_));
	}

	// J9HashTable* _stackTraceTable
	public PointerPointer _stackTraceTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__stackTraceTableOffset_));
	}

	// U32 _stringUTF8Count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stringUTF8CountOffset_", declaredType="U32")
	public UDATA _stringUTF8Count() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__stringUTF8CountOffset_));
	}

	// U32 _stringUTF8Count
	public UDATAPointer _stringUTF8CountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__stringUTF8CountOffset_));
	}

	// J9HashTable* _stringUTF8Table
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stringUTF8TableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _stringUTF8Table() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__stringUTF8TableOffset_));
	}

	// J9HashTable* _stringUTF8Table
	public PointerPointer _stringUTF8TableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__stringUTF8TableOffset_));
	}

	// UDATA _systemGCCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__systemGCCountOffset_", declaredType="UDATA")
	public UDATA _systemGCCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__systemGCCountOffset_);
	}

	// UDATA _systemGCCount
	public UDATAPointer _systemGCCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__systemGCCountOffset_));
	}

	// J9Pool* _systemGCTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__systemGCTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _systemGCTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__systemGCTableOffset_));
	}

	// J9Pool* _systemGCTable
	public PointerPointer _systemGCTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__systemGCTableOffset_));
	}

	// UDATA _systemProcessCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__systemProcessCountOffset_", declaredType="UDATA")
	public UDATA _systemProcessCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__systemProcessCountOffset_);
	}

	// UDATA _systemProcessCount
	public UDATAPointer _systemProcessCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__systemProcessCountOffset_));
	}

	// UDATA _systemProcessStringSizeTotal
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__systemProcessStringSizeTotalOffset_", declaredType="UDATA")
	public UDATA _systemProcessStringSizeTotal() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__systemProcessStringSizeTotalOffset_);
	}

	// UDATA _systemProcessStringSizeTotal
	public UDATAPointer _systemProcessStringSizeTotalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__systemProcessStringSizeTotalOffset_));
	}

	// J9Pool* _systemProcessTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__systemProcessTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _systemProcessTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__systemProcessTableOffset_));
	}

	// J9Pool* _systemProcessTable
	public PointerPointer _systemProcessTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__systemProcessTableOffset_));
	}

	// UDATA _threadCPULoadCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadCPULoadCountOffset_", declaredType="UDATA")
	public UDATA _threadCPULoadCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadCPULoadCountOffset_);
	}

	// UDATA _threadCPULoadCount
	public UDATAPointer _threadCPULoadCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadCPULoadCountOffset_));
	}

	// J9Pool* _threadCPULoadTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadCPULoadTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadCPULoadTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadCPULoadTableOffset_));
	}

	// J9Pool* _threadCPULoadTable
	public PointerPointer _threadCPULoadTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadCPULoadTableOffset_));
	}

	// UDATA _threadContextSwitchRateCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadContextSwitchRateCountOffset_", declaredType="UDATA")
	public UDATA _threadContextSwitchRateCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadContextSwitchRateCountOffset_);
	}

	// UDATA _threadContextSwitchRateCount
	public UDATAPointer _threadContextSwitchRateCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadContextSwitchRateCountOffset_));
	}

	// J9Pool* _threadContextSwitchRateTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadContextSwitchRateTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadContextSwitchRateTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadContextSwitchRateTableOffset_));
	}

	// J9Pool* _threadContextSwitchRateTable
	public PointerPointer _threadContextSwitchRateTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadContextSwitchRateTableOffset_));
	}

	// U32 _threadCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadCountOffset_", declaredType="U32")
	public UDATA _threadCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__threadCountOffset_));
	}

	// U32 _threadCount
	public UDATAPointer _threadCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadCountOffset_));
	}

	// UDATA _threadEndCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadEndCountOffset_", declaredType="UDATA")
	public UDATA _threadEndCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadEndCountOffset_);
	}

	// UDATA _threadEndCount
	public UDATAPointer _threadEndCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadEndCountOffset_));
	}

	// J9Pool* _threadEndTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadEndTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadEndTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadEndTableOffset_));
	}

	// J9Pool* _threadEndTable
	public PointerPointer _threadEndTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadEndTableOffset_));
	}

	// U32 _threadGroupCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadGroupCountOffset_", declaredType="U32")
	public UDATA _threadGroupCount() throws CorruptDataException {
		return new U32(getIntAtOffset(VM_JFRConstantPoolTypes.__threadGroupCountOffset_));
	}

	// U32 _threadGroupCount
	public UDATAPointer _threadGroupCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadGroupCountOffset_));
	}

	// J9HashTable* _threadGroupTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadGroupTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _threadGroupTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadGroupTableOffset_));
	}

	// J9HashTable* _threadGroupTable
	public PointerPointer _threadGroupTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadGroupTableOffset_));
	}

	// UDATA _threadParkCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadParkCountOffset_", declaredType="UDATA")
	public UDATA _threadParkCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadParkCountOffset_);
	}

	// UDATA _threadParkCount
	public UDATAPointer _threadParkCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadParkCountOffset_));
	}

	// J9Pool* _threadParkTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadParkTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadParkTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadParkTableOffset_));
	}

	// J9Pool* _threadParkTable
	public PointerPointer _threadParkTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadParkTableOffset_));
	}

	// UDATA _threadSleepCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadSleepCountOffset_", declaredType="UDATA")
	public UDATA _threadSleepCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadSleepCountOffset_);
	}

	// UDATA _threadSleepCount
	public UDATAPointer _threadSleepCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadSleepCountOffset_));
	}

	// J9Pool* _threadSleepTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadSleepTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadSleepTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadSleepTableOffset_));
	}

	// J9Pool* _threadSleepTable
	public PointerPointer _threadSleepTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadSleepTableOffset_));
	}

	// UDATA _threadStartCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadStartCountOffset_", declaredType="UDATA")
	public UDATA _threadStartCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadStartCountOffset_);
	}

	// UDATA _threadStartCount
	public UDATAPointer _threadStartCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadStartCountOffset_));
	}

	// J9Pool* _threadStartTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadStartTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadStartTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadStartTableOffset_));
	}

	// J9Pool* _threadStartTable
	public PointerPointer _threadStartTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadStartTableOffset_));
	}

	// UDATA _threadStatisticsCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadStatisticsCountOffset_", declaredType="UDATA")
	public UDATA _threadStatisticsCount() throws CorruptDataException {
		return getUDATAAtOffset(VM_JFRConstantPoolTypes.__threadStatisticsCountOffset_);
	}

	// UDATA _threadStatisticsCount
	public UDATAPointer _threadStatisticsCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadStatisticsCountOffset_));
	}

	// J9Pool* _threadStatisticsTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadStatisticsTableOffset_", declaredType="J9Pool*")
	public J9PoolPointer _threadStatisticsTable() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadStatisticsTableOffset_));
	}

	// J9Pool* _threadStatisticsTable
	public PointerPointer _threadStatisticsTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadStatisticsTableOffset_));
	}

	// J9HashTable* _threadTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__threadTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _threadTable() throws CorruptDataException {
		return J9HashTablePointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__threadTableOffset_));
	}

	// J9HashTable* _threadTable
	public PointerPointer _threadTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__threadTableOffset_));
	}

	// StringUTF8Entry _unknownClassStringUTF8Entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__unknownClassStringUTF8EntryOffset_", declaredType="StringUTF8Entry")
	public StringUTF8EntryPointer _unknownClassStringUTF8Entry() throws CorruptDataException {
		return StringUTF8EntryPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__unknownClassStringUTF8EntryOffset_));
	}

	// StringUTF8Entry _unknownClassStringUTF8Entry
	public PointerPointer _unknownClassStringUTF8EntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__unknownClassStringUTF8EntryOffset_));
	}

	// J9JavaVM* _vm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vmOffset_", declaredType="J9JavaVM*")
	public J9JavaVMPointer _vm() throws CorruptDataException {
		return J9JavaVMPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes.__vmOffset_));
	}

	// J9JavaVM* _vm
	public PointerPointer _vmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes.__vmOffset_));
	}

	// J9PortLibrary* privatePortLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_privatePortLibraryOffset_", declaredType="J9PortLibrary*")
	public J9PortLibraryPointer privatePortLibrary() throws CorruptDataException {
		return J9PortLibraryPointer.cast(getPointerAtOffset(VM_JFRConstantPoolTypes._privatePortLibraryOffset_));
	}

	// J9PortLibrary* privatePortLibrary
	public PointerPointer privatePortLibraryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(VM_JFRConstantPoolTypes._privatePortLibraryOffset_));
	}

}
