/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: JNINativeInterface_
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class JNINativeInterface_ {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _AllocObjectOffset_;
	public static final int _CallBooleanMethodOffset_;
	public static final int _CallBooleanMethodAOffset_;
	public static final int _CallBooleanMethodVOffset_;
	public static final int _CallByteMethodOffset_;
	public static final int _CallByteMethodAOffset_;
	public static final int _CallByteMethodVOffset_;
	public static final int _CallCharMethodOffset_;
	public static final int _CallCharMethodAOffset_;
	public static final int _CallCharMethodVOffset_;
	public static final int _CallDoubleMethodOffset_;
	public static final int _CallDoubleMethodAOffset_;
	public static final int _CallDoubleMethodVOffset_;
	public static final int _CallFloatMethodOffset_;
	public static final int _CallFloatMethodAOffset_;
	public static final int _CallFloatMethodVOffset_;
	public static final int _CallIntMethodOffset_;
	public static final int _CallIntMethodAOffset_;
	public static final int _CallIntMethodVOffset_;
	public static final int _CallLongMethodOffset_;
	public static final int _CallLongMethodAOffset_;
	public static final int _CallLongMethodVOffset_;
	public static final int _CallNonvirtualBooleanMethodOffset_;
	public static final int _CallNonvirtualBooleanMethodAOffset_;
	public static final int _CallNonvirtualBooleanMethodVOffset_;
	public static final int _CallNonvirtualByteMethodOffset_;
	public static final int _CallNonvirtualByteMethodAOffset_;
	public static final int _CallNonvirtualByteMethodVOffset_;
	public static final int _CallNonvirtualCharMethodOffset_;
	public static final int _CallNonvirtualCharMethodAOffset_;
	public static final int _CallNonvirtualCharMethodVOffset_;
	public static final int _CallNonvirtualDoubleMethodOffset_;
	public static final int _CallNonvirtualDoubleMethodAOffset_;
	public static final int _CallNonvirtualDoubleMethodVOffset_;
	public static final int _CallNonvirtualFloatMethodOffset_;
	public static final int _CallNonvirtualFloatMethodAOffset_;
	public static final int _CallNonvirtualFloatMethodVOffset_;
	public static final int _CallNonvirtualIntMethodOffset_;
	public static final int _CallNonvirtualIntMethodAOffset_;
	public static final int _CallNonvirtualIntMethodVOffset_;
	public static final int _CallNonvirtualLongMethodOffset_;
	public static final int _CallNonvirtualLongMethodAOffset_;
	public static final int _CallNonvirtualLongMethodVOffset_;
	public static final int _CallNonvirtualObjectMethodOffset_;
	public static final int _CallNonvirtualObjectMethodAOffset_;
	public static final int _CallNonvirtualObjectMethodVOffset_;
	public static final int _CallNonvirtualShortMethodOffset_;
	public static final int _CallNonvirtualShortMethodAOffset_;
	public static final int _CallNonvirtualShortMethodVOffset_;
	public static final int _CallNonvirtualVoidMethodOffset_;
	public static final int _CallNonvirtualVoidMethodAOffset_;
	public static final int _CallNonvirtualVoidMethodVOffset_;
	public static final int _CallObjectMethodOffset_;
	public static final int _CallObjectMethodAOffset_;
	public static final int _CallObjectMethodVOffset_;
	public static final int _CallShortMethodOffset_;
	public static final int _CallShortMethodAOffset_;
	public static final int _CallShortMethodVOffset_;
	public static final int _CallStaticBooleanMethodOffset_;
	public static final int _CallStaticBooleanMethodAOffset_;
	public static final int _CallStaticBooleanMethodVOffset_;
	public static final int _CallStaticByteMethodOffset_;
	public static final int _CallStaticByteMethodAOffset_;
	public static final int _CallStaticByteMethodVOffset_;
	public static final int _CallStaticCharMethodOffset_;
	public static final int _CallStaticCharMethodAOffset_;
	public static final int _CallStaticCharMethodVOffset_;
	public static final int _CallStaticDoubleMethodOffset_;
	public static final int _CallStaticDoubleMethodAOffset_;
	public static final int _CallStaticDoubleMethodVOffset_;
	public static final int _CallStaticFloatMethodOffset_;
	public static final int _CallStaticFloatMethodAOffset_;
	public static final int _CallStaticFloatMethodVOffset_;
	public static final int _CallStaticIntMethodOffset_;
	public static final int _CallStaticIntMethodAOffset_;
	public static final int _CallStaticIntMethodVOffset_;
	public static final int _CallStaticLongMethodOffset_;
	public static final int _CallStaticLongMethodAOffset_;
	public static final int _CallStaticLongMethodVOffset_;
	public static final int _CallStaticObjectMethodOffset_;
	public static final int _CallStaticObjectMethodAOffset_;
	public static final int _CallStaticObjectMethodVOffset_;
	public static final int _CallStaticShortMethodOffset_;
	public static final int _CallStaticShortMethodAOffset_;
	public static final int _CallStaticShortMethodVOffset_;
	public static final int _CallStaticVoidMethodOffset_;
	public static final int _CallStaticVoidMethodAOffset_;
	public static final int _CallStaticVoidMethodVOffset_;
	public static final int _CallVoidMethodOffset_;
	public static final int _CallVoidMethodAOffset_;
	public static final int _CallVoidMethodVOffset_;
	public static final int _DefineClassOffset_;
	public static final int _DeleteGlobalRefOffset_;
	public static final int _DeleteLocalRefOffset_;
	public static final int _DeleteWeakGlobalRefOffset_;
	public static final int _EnsureLocalCapacityOffset_;
	public static final int _ExceptionCheckOffset_;
	public static final int _ExceptionClearOffset_;
	public static final int _ExceptionDescribeOffset_;
	public static final int _ExceptionOccurredOffset_;
	public static final int _FatalErrorOffset_;
	public static final int _FindClassOffset_;
	public static final int _FromReflectedFieldOffset_;
	public static final int _FromReflectedMethodOffset_;
	public static final int _GetArrayLengthOffset_;
	public static final int _GetBooleanArrayElementsOffset_;
	public static final int _GetBooleanArrayRegionOffset_;
	public static final int _GetBooleanFieldOffset_;
	public static final int _GetByteArrayElementsOffset_;
	public static final int _GetByteArrayRegionOffset_;
	public static final int _GetByteFieldOffset_;
	public static final int _GetCharArrayElementsOffset_;
	public static final int _GetCharArrayRegionOffset_;
	public static final int _GetCharFieldOffset_;
	public static final int _GetDirectBufferAddressOffset_;
	public static final int _GetDirectBufferCapacityOffset_;
	public static final int _GetDoubleArrayElementsOffset_;
	public static final int _GetDoubleArrayRegionOffset_;
	public static final int _GetDoubleFieldOffset_;
	public static final int _GetFieldIDOffset_;
	public static final int _GetFloatArrayElementsOffset_;
	public static final int _GetFloatArrayRegionOffset_;
	public static final int _GetFloatFieldOffset_;
	public static final int _GetIntArrayElementsOffset_;
	public static final int _GetIntArrayRegionOffset_;
	public static final int _GetIntFieldOffset_;
	public static final int _GetJavaVMOffset_;
	public static final int _GetLongArrayElementsOffset_;
	public static final int _GetLongArrayRegionOffset_;
	public static final int _GetLongFieldOffset_;
	public static final int _GetMethodIDOffset_;
	public static final int _GetModuleOffset_;
	public static final int _GetObjectArrayElementOffset_;
	public static final int _GetObjectClassOffset_;
	public static final int _GetObjectFieldOffset_;
	public static final int _GetObjectRefTypeOffset_;
	public static final int _GetPrimitiveArrayCriticalOffset_;
	public static final int _GetShortArrayElementsOffset_;
	public static final int _GetShortArrayRegionOffset_;
	public static final int _GetShortFieldOffset_;
	public static final int _GetStaticBooleanFieldOffset_;
	public static final int _GetStaticByteFieldOffset_;
	public static final int _GetStaticCharFieldOffset_;
	public static final int _GetStaticDoubleFieldOffset_;
	public static final int _GetStaticFieldIDOffset_;
	public static final int _GetStaticFloatFieldOffset_;
	public static final int _GetStaticIntFieldOffset_;
	public static final int _GetStaticLongFieldOffset_;
	public static final int _GetStaticMethodIDOffset_;
	public static final int _GetStaticObjectFieldOffset_;
	public static final int _GetStaticShortFieldOffset_;
	public static final int _GetStringCharsOffset_;
	public static final int _GetStringCriticalOffset_;
	public static final int _GetStringLengthOffset_;
	public static final int _GetStringRegionOffset_;
	public static final int _GetStringUTFCharsOffset_;
	public static final int _GetStringUTFLengthOffset_;
	public static final int _GetStringUTFLengthAsLongOffset_;
	public static final int _GetStringUTFRegionOffset_;
	public static final int _GetSuperclassOffset_;
	public static final int _GetVersionOffset_;
	public static final int _IsAssignableFromOffset_;
	public static final int _IsInstanceOfOffset_;
	public static final int _IsSameObjectOffset_;
	public static final int _IsVirtualThreadOffset_;
	public static final int _MonitorEnterOffset_;
	public static final int _MonitorExitOffset_;
	public static final int _NewBooleanArrayOffset_;
	public static final int _NewByteArrayOffset_;
	public static final int _NewCharArrayOffset_;
	public static final int _NewDirectByteBufferOffset_;
	public static final int _NewDoubleArrayOffset_;
	public static final int _NewFloatArrayOffset_;
	public static final int _NewGlobalRefOffset_;
	public static final int _NewIntArrayOffset_;
	public static final int _NewLocalRefOffset_;
	public static final int _NewLongArrayOffset_;
	public static final int _NewObjectOffset_;
	public static final int _NewObjectAOffset_;
	public static final int _NewObjectArrayOffset_;
	public static final int _NewObjectVOffset_;
	public static final int _NewShortArrayOffset_;
	public static final int _NewStringOffset_;
	public static final int _NewStringUTFOffset_;
	public static final int _NewWeakGlobalRefOffset_;
	public static final int _PopLocalFrameOffset_;
	public static final int _PushLocalFrameOffset_;
	public static final int _RegisterNativesOffset_;
	public static final int _ReleaseBooleanArrayElementsOffset_;
	public static final int _ReleaseByteArrayElementsOffset_;
	public static final int _ReleaseCharArrayElementsOffset_;
	public static final int _ReleaseDoubleArrayElementsOffset_;
	public static final int _ReleaseFloatArrayElementsOffset_;
	public static final int _ReleaseIntArrayElementsOffset_;
	public static final int _ReleaseLongArrayElementsOffset_;
	public static final int _ReleasePrimitiveArrayCriticalOffset_;
	public static final int _ReleaseShortArrayElementsOffset_;
	public static final int _ReleaseStringCharsOffset_;
	public static final int _ReleaseStringCriticalOffset_;
	public static final int _ReleaseStringUTFCharsOffset_;
	public static final int _SetBooleanArrayRegionOffset_;
	public static final int _SetBooleanFieldOffset_;
	public static final int _SetByteArrayRegionOffset_;
	public static final int _SetByteFieldOffset_;
	public static final int _SetCharArrayRegionOffset_;
	public static final int _SetCharFieldOffset_;
	public static final int _SetDoubleArrayRegionOffset_;
	public static final int _SetDoubleFieldOffset_;
	public static final int _SetFloatArrayRegionOffset_;
	public static final int _SetFloatFieldOffset_;
	public static final int _SetIntArrayRegionOffset_;
	public static final int _SetIntFieldOffset_;
	public static final int _SetLongArrayRegionOffset_;
	public static final int _SetLongFieldOffset_;
	public static final int _SetObjectArrayElementOffset_;
	public static final int _SetObjectFieldOffset_;
	public static final int _SetShortArrayRegionOffset_;
	public static final int _SetShortFieldOffset_;
	public static final int _SetStaticBooleanFieldOffset_;
	public static final int _SetStaticByteFieldOffset_;
	public static final int _SetStaticCharFieldOffset_;
	public static final int _SetStaticDoubleFieldOffset_;
	public static final int _SetStaticFloatFieldOffset_;
	public static final int _SetStaticIntFieldOffset_;
	public static final int _SetStaticLongFieldOffset_;
	public static final int _SetStaticObjectFieldOffset_;
	public static final int _SetStaticShortFieldOffset_;
	public static final int _ThrowOffset_;
	public static final int _ThrowNewOffset_;
	public static final int _ToReflectedFieldOffset_;
	public static final int _ToReflectedMethodOffset_;
	public static final int _UnregisterNativesOffset_;
	public static final int _reserved0Offset_;
	public static final int _reserved1Offset_;
	public static final int _reserved2Offset_;
	public static final int _reserved3Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_AllocObjectOffset_ = 0;
		_CallBooleanMethodOffset_ = 0;
		_CallBooleanMethodAOffset_ = 0;
		_CallBooleanMethodVOffset_ = 0;
		_CallByteMethodOffset_ = 0;
		_CallByteMethodAOffset_ = 0;
		_CallByteMethodVOffset_ = 0;
		_CallCharMethodOffset_ = 0;
		_CallCharMethodAOffset_ = 0;
		_CallCharMethodVOffset_ = 0;
		_CallDoubleMethodOffset_ = 0;
		_CallDoubleMethodAOffset_ = 0;
		_CallDoubleMethodVOffset_ = 0;
		_CallFloatMethodOffset_ = 0;
		_CallFloatMethodAOffset_ = 0;
		_CallFloatMethodVOffset_ = 0;
		_CallIntMethodOffset_ = 0;
		_CallIntMethodAOffset_ = 0;
		_CallIntMethodVOffset_ = 0;
		_CallLongMethodOffset_ = 0;
		_CallLongMethodAOffset_ = 0;
		_CallLongMethodVOffset_ = 0;
		_CallNonvirtualBooleanMethodOffset_ = 0;
		_CallNonvirtualBooleanMethodAOffset_ = 0;
		_CallNonvirtualBooleanMethodVOffset_ = 0;
		_CallNonvirtualByteMethodOffset_ = 0;
		_CallNonvirtualByteMethodAOffset_ = 0;
		_CallNonvirtualByteMethodVOffset_ = 0;
		_CallNonvirtualCharMethodOffset_ = 0;
		_CallNonvirtualCharMethodAOffset_ = 0;
		_CallNonvirtualCharMethodVOffset_ = 0;
		_CallNonvirtualDoubleMethodOffset_ = 0;
		_CallNonvirtualDoubleMethodAOffset_ = 0;
		_CallNonvirtualDoubleMethodVOffset_ = 0;
		_CallNonvirtualFloatMethodOffset_ = 0;
		_CallNonvirtualFloatMethodAOffset_ = 0;
		_CallNonvirtualFloatMethodVOffset_ = 0;
		_CallNonvirtualIntMethodOffset_ = 0;
		_CallNonvirtualIntMethodAOffset_ = 0;
		_CallNonvirtualIntMethodVOffset_ = 0;
		_CallNonvirtualLongMethodOffset_ = 0;
		_CallNonvirtualLongMethodAOffset_ = 0;
		_CallNonvirtualLongMethodVOffset_ = 0;
		_CallNonvirtualObjectMethodOffset_ = 0;
		_CallNonvirtualObjectMethodAOffset_ = 0;
		_CallNonvirtualObjectMethodVOffset_ = 0;
		_CallNonvirtualShortMethodOffset_ = 0;
		_CallNonvirtualShortMethodAOffset_ = 0;
		_CallNonvirtualShortMethodVOffset_ = 0;
		_CallNonvirtualVoidMethodOffset_ = 0;
		_CallNonvirtualVoidMethodAOffset_ = 0;
		_CallNonvirtualVoidMethodVOffset_ = 0;
		_CallObjectMethodOffset_ = 0;
		_CallObjectMethodAOffset_ = 0;
		_CallObjectMethodVOffset_ = 0;
		_CallShortMethodOffset_ = 0;
		_CallShortMethodAOffset_ = 0;
		_CallShortMethodVOffset_ = 0;
		_CallStaticBooleanMethodOffset_ = 0;
		_CallStaticBooleanMethodAOffset_ = 0;
		_CallStaticBooleanMethodVOffset_ = 0;
		_CallStaticByteMethodOffset_ = 0;
		_CallStaticByteMethodAOffset_ = 0;
		_CallStaticByteMethodVOffset_ = 0;
		_CallStaticCharMethodOffset_ = 0;
		_CallStaticCharMethodAOffset_ = 0;
		_CallStaticCharMethodVOffset_ = 0;
		_CallStaticDoubleMethodOffset_ = 0;
		_CallStaticDoubleMethodAOffset_ = 0;
		_CallStaticDoubleMethodVOffset_ = 0;
		_CallStaticFloatMethodOffset_ = 0;
		_CallStaticFloatMethodAOffset_ = 0;
		_CallStaticFloatMethodVOffset_ = 0;
		_CallStaticIntMethodOffset_ = 0;
		_CallStaticIntMethodAOffset_ = 0;
		_CallStaticIntMethodVOffset_ = 0;
		_CallStaticLongMethodOffset_ = 0;
		_CallStaticLongMethodAOffset_ = 0;
		_CallStaticLongMethodVOffset_ = 0;
		_CallStaticObjectMethodOffset_ = 0;
		_CallStaticObjectMethodAOffset_ = 0;
		_CallStaticObjectMethodVOffset_ = 0;
		_CallStaticShortMethodOffset_ = 0;
		_CallStaticShortMethodAOffset_ = 0;
		_CallStaticShortMethodVOffset_ = 0;
		_CallStaticVoidMethodOffset_ = 0;
		_CallStaticVoidMethodAOffset_ = 0;
		_CallStaticVoidMethodVOffset_ = 0;
		_CallVoidMethodOffset_ = 0;
		_CallVoidMethodAOffset_ = 0;
		_CallVoidMethodVOffset_ = 0;
		_DefineClassOffset_ = 0;
		_DeleteGlobalRefOffset_ = 0;
		_DeleteLocalRefOffset_ = 0;
		_DeleteWeakGlobalRefOffset_ = 0;
		_EnsureLocalCapacityOffset_ = 0;
		_ExceptionCheckOffset_ = 0;
		_ExceptionClearOffset_ = 0;
		_ExceptionDescribeOffset_ = 0;
		_ExceptionOccurredOffset_ = 0;
		_FatalErrorOffset_ = 0;
		_FindClassOffset_ = 0;
		_FromReflectedFieldOffset_ = 0;
		_FromReflectedMethodOffset_ = 0;
		_GetArrayLengthOffset_ = 0;
		_GetBooleanArrayElementsOffset_ = 0;
		_GetBooleanArrayRegionOffset_ = 0;
		_GetBooleanFieldOffset_ = 0;
		_GetByteArrayElementsOffset_ = 0;
		_GetByteArrayRegionOffset_ = 0;
		_GetByteFieldOffset_ = 0;
		_GetCharArrayElementsOffset_ = 0;
		_GetCharArrayRegionOffset_ = 0;
		_GetCharFieldOffset_ = 0;
		_GetDirectBufferAddressOffset_ = 0;
		_GetDirectBufferCapacityOffset_ = 0;
		_GetDoubleArrayElementsOffset_ = 0;
		_GetDoubleArrayRegionOffset_ = 0;
		_GetDoubleFieldOffset_ = 0;
		_GetFieldIDOffset_ = 0;
		_GetFloatArrayElementsOffset_ = 0;
		_GetFloatArrayRegionOffset_ = 0;
		_GetFloatFieldOffset_ = 0;
		_GetIntArrayElementsOffset_ = 0;
		_GetIntArrayRegionOffset_ = 0;
		_GetIntFieldOffset_ = 0;
		_GetJavaVMOffset_ = 0;
		_GetLongArrayElementsOffset_ = 0;
		_GetLongArrayRegionOffset_ = 0;
		_GetLongFieldOffset_ = 0;
		_GetMethodIDOffset_ = 0;
		_GetModuleOffset_ = 0;
		_GetObjectArrayElementOffset_ = 0;
		_GetObjectClassOffset_ = 0;
		_GetObjectFieldOffset_ = 0;
		_GetObjectRefTypeOffset_ = 0;
		_GetPrimitiveArrayCriticalOffset_ = 0;
		_GetShortArrayElementsOffset_ = 0;
		_GetShortArrayRegionOffset_ = 0;
		_GetShortFieldOffset_ = 0;
		_GetStaticBooleanFieldOffset_ = 0;
		_GetStaticByteFieldOffset_ = 0;
		_GetStaticCharFieldOffset_ = 0;
		_GetStaticDoubleFieldOffset_ = 0;
		_GetStaticFieldIDOffset_ = 0;
		_GetStaticFloatFieldOffset_ = 0;
		_GetStaticIntFieldOffset_ = 0;
		_GetStaticLongFieldOffset_ = 0;
		_GetStaticMethodIDOffset_ = 0;
		_GetStaticObjectFieldOffset_ = 0;
		_GetStaticShortFieldOffset_ = 0;
		_GetStringCharsOffset_ = 0;
		_GetStringCriticalOffset_ = 0;
		_GetStringLengthOffset_ = 0;
		_GetStringRegionOffset_ = 0;
		_GetStringUTFCharsOffset_ = 0;
		_GetStringUTFLengthOffset_ = 0;
		_GetStringUTFLengthAsLongOffset_ = 0;
		_GetStringUTFRegionOffset_ = 0;
		_GetSuperclassOffset_ = 0;
		_GetVersionOffset_ = 0;
		_IsAssignableFromOffset_ = 0;
		_IsInstanceOfOffset_ = 0;
		_IsSameObjectOffset_ = 0;
		_IsVirtualThreadOffset_ = 0;
		_MonitorEnterOffset_ = 0;
		_MonitorExitOffset_ = 0;
		_NewBooleanArrayOffset_ = 0;
		_NewByteArrayOffset_ = 0;
		_NewCharArrayOffset_ = 0;
		_NewDirectByteBufferOffset_ = 0;
		_NewDoubleArrayOffset_ = 0;
		_NewFloatArrayOffset_ = 0;
		_NewGlobalRefOffset_ = 0;
		_NewIntArrayOffset_ = 0;
		_NewLocalRefOffset_ = 0;
		_NewLongArrayOffset_ = 0;
		_NewObjectOffset_ = 0;
		_NewObjectAOffset_ = 0;
		_NewObjectArrayOffset_ = 0;
		_NewObjectVOffset_ = 0;
		_NewShortArrayOffset_ = 0;
		_NewStringOffset_ = 0;
		_NewStringUTFOffset_ = 0;
		_NewWeakGlobalRefOffset_ = 0;
		_PopLocalFrameOffset_ = 0;
		_PushLocalFrameOffset_ = 0;
		_RegisterNativesOffset_ = 0;
		_ReleaseBooleanArrayElementsOffset_ = 0;
		_ReleaseByteArrayElementsOffset_ = 0;
		_ReleaseCharArrayElementsOffset_ = 0;
		_ReleaseDoubleArrayElementsOffset_ = 0;
		_ReleaseFloatArrayElementsOffset_ = 0;
		_ReleaseIntArrayElementsOffset_ = 0;
		_ReleaseLongArrayElementsOffset_ = 0;
		_ReleasePrimitiveArrayCriticalOffset_ = 0;
		_ReleaseShortArrayElementsOffset_ = 0;
		_ReleaseStringCharsOffset_ = 0;
		_ReleaseStringCriticalOffset_ = 0;
		_ReleaseStringUTFCharsOffset_ = 0;
		_SetBooleanArrayRegionOffset_ = 0;
		_SetBooleanFieldOffset_ = 0;
		_SetByteArrayRegionOffset_ = 0;
		_SetByteFieldOffset_ = 0;
		_SetCharArrayRegionOffset_ = 0;
		_SetCharFieldOffset_ = 0;
		_SetDoubleArrayRegionOffset_ = 0;
		_SetDoubleFieldOffset_ = 0;
		_SetFloatArrayRegionOffset_ = 0;
		_SetFloatFieldOffset_ = 0;
		_SetIntArrayRegionOffset_ = 0;
		_SetIntFieldOffset_ = 0;
		_SetLongArrayRegionOffset_ = 0;
		_SetLongFieldOffset_ = 0;
		_SetObjectArrayElementOffset_ = 0;
		_SetObjectFieldOffset_ = 0;
		_SetShortArrayRegionOffset_ = 0;
		_SetShortFieldOffset_ = 0;
		_SetStaticBooleanFieldOffset_ = 0;
		_SetStaticByteFieldOffset_ = 0;
		_SetStaticCharFieldOffset_ = 0;
		_SetStaticDoubleFieldOffset_ = 0;
		_SetStaticFloatFieldOffset_ = 0;
		_SetStaticIntFieldOffset_ = 0;
		_SetStaticLongFieldOffset_ = 0;
		_SetStaticObjectFieldOffset_ = 0;
		_SetStaticShortFieldOffset_ = 0;
		_ThrowOffset_ = 0;
		_ThrowNewOffset_ = 0;
		_ToReflectedFieldOffset_ = 0;
		_ToReflectedMethodOffset_ = 0;
		_UnregisterNativesOffset_ = 0;
		_reserved0Offset_ = 0;
		_reserved1Offset_ = 0;
		_reserved2Offset_ = 0;
		_reserved3Offset_ = 0;
	}

}
