/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9UpcallMetaDataPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9UpcallMetaDataPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9UpcallMetaData.class)
public class J9UpcallMetaDataPointer extends StructurePointer {

	// NULL
	public static final J9UpcallMetaDataPointer NULL = new J9UpcallMetaDataPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9UpcallMetaDataPointer(long address) {
		super(address);
	}

	public static J9UpcallMetaDataPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9UpcallMetaDataPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9UpcallMetaDataPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9UpcallMetaDataPointer(address);
	}

	public J9UpcallMetaDataPointer add(long count) {
		return J9UpcallMetaDataPointer.cast(address + (J9UpcallMetaData.SIZEOF * count));
	}

	public J9UpcallMetaDataPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9UpcallMetaDataPointer addOffset(long offset) {
		return J9UpcallMetaDataPointer.cast(address + offset);
	}

	public J9UpcallMetaDataPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9UpcallMetaDataPointer sub(long count) {
		return J9UpcallMetaDataPointer.cast(address - (J9UpcallMetaData.SIZEOF * count));
	}

	public J9UpcallMetaDataPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9UpcallMetaDataPointer subOffset(long offset) {
		return J9UpcallMetaDataPointer.cast(address - offset);
	}

	public J9UpcallMetaDataPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9UpcallMetaDataPointer untag(long mask) {
		return J9UpcallMetaDataPointer.cast(address & ~mask);
	}

	public J9UpcallMetaDataPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9UpcallMetaData.SIZEOF;
	}

	// Implementation methods

	// J9VMThread* downCallThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_downCallThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer downCallThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(J9UpcallMetaData._downCallThreadOffset_));
	}

	// J9VMThread* downCallThread
	public PointerPointer downCallThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._downCallThreadOffset_));
	}

	// UDATA[] functionPtr
	public UDATAPointer functionPtrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9UpcallMetaData._functionPtrOffset_));
	}

	// jobject mhMetaData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mhMetaDataOffset_", declaredType="jobject")
	public _jobjectPointer mhMetaData() throws CorruptDataException {
		return _jobjectPointer.cast(getPointerAtOffset(J9UpcallMetaData._mhMetaDataOffset_));
	}

	// jobject mhMetaData
	public PointerPointer mhMetaDataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._mhMetaDataOffset_));
	}

	// J9UpcallNativeSignature* nativeFuncSignature
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nativeFuncSignatureOffset_", declaredType="J9UpcallNativeSignature*")
	public J9UpcallNativeSignaturePointer nativeFuncSignature() throws CorruptDataException {
		return J9UpcallNativeSignaturePointer.cast(getPointerAtOffset(J9UpcallMetaData._nativeFuncSignatureOffset_));
	}

	// J9UpcallNativeSignature* nativeFuncSignature
	public PointerPointer nativeFuncSignatureEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._nativeFuncSignatureOffset_));
	}

	// void* thunkAddress
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thunkAddressOffset_", declaredType="void*")
	public VoidPointer thunkAddress() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9UpcallMetaData._thunkAddressOffset_));
	}

	// void* thunkAddress
	public PointerPointer thunkAddressEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._thunkAddressOffset_));
	}

	// J9UpcallThunkHeapWrapper* thunkHeapWrapper
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thunkHeapWrapperOffset_", declaredType="J9UpcallThunkHeapWrapper*")
	public J9UpcallThunkHeapWrapperPointer thunkHeapWrapper() throws CorruptDataException {
		return J9UpcallThunkHeapWrapperPointer.cast(getPointerAtOffset(J9UpcallMetaData._thunkHeapWrapperOffset_));
	}

	// J9UpcallThunkHeapWrapper* thunkHeapWrapper
	public PointerPointer thunkHeapWrapperEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._thunkHeapWrapperOffset_));
	}

	// UDATA thunkSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_thunkSizeOffset_", declaredType="UDATA")
	public UDATA thunkSize() throws CorruptDataException {
		return getUDATAAtOffset(J9UpcallMetaData._thunkSizeOffset_);
	}

	// UDATA thunkSize
	public UDATAPointer thunkSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9UpcallMetaData._thunkSizeOffset_));
	}

	// void* upCallCommonDispatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_upCallCommonDispatcherOffset_", declaredType="void*")
	public VoidPointer upCallCommonDispatcher() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9UpcallMetaData._upCallCommonDispatcherOffset_));
	}

	// void* upCallCommonDispatcher
	public PointerPointer upCallCommonDispatcherEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._upCallCommonDispatcherOffset_));
	}

	// J9JavaVM* vm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmOffset_", declaredType="J9JavaVM*")
	public J9JavaVMPointer vm() throws CorruptDataException {
		return J9JavaVMPointer.cast(getPointerAtOffset(J9UpcallMetaData._vmOffset_));
	}

	// J9JavaVM* vm
	public PointerPointer vmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9UpcallMetaData._vmOffset_));
	}

}
