/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRCgroupEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRCgroupEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRCgroupEntry.class)
public class OMRCgroupEntryPointer extends StructurePointer {

	// NULL
	public static final OMRCgroupEntryPointer NULL = new OMRCgroupEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRCgroupEntryPointer(long address) {
		super(address);
	}

	public static OMRCgroupEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRCgroupEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRCgroupEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new OMRCgroupEntryPointer(address);
	}

	public OMRCgroupEntryPointer add(long count) {
		return OMRCgroupEntryPointer.cast(address + (OMRCgroupEntry.SIZEOF * count));
	}

	public OMRCgroupEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRCgroupEntryPointer addOffset(long offset) {
		return OMRCgroupEntryPointer.cast(address + offset);
	}

	public OMRCgroupEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRCgroupEntryPointer sub(long count) {
		return OMRCgroupEntryPointer.cast(address - (OMRCgroupEntry.SIZEOF * count));
	}

	public OMRCgroupEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRCgroupEntryPointer subOffset(long offset) {
		return OMRCgroupEntryPointer.cast(address - offset);
	}

	public OMRCgroupEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRCgroupEntryPointer untag(long mask) {
		return OMRCgroupEntryPointer.cast(address & ~mask);
	}

	public OMRCgroupEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRCgroupEntry.SIZEOF;
	}

	// Implementation methods

	// U8* cgroup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cgroupOffset_", declaredType="U8*")
	public U8Pointer cgroup() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRCgroupEntry._cgroupOffset_));
	}

	// U8* cgroup
	public PointerPointer cgroupEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRCgroupEntry._cgroupOffset_));
	}

	// U64 flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagOffset_", declaredType="U64")
	public UDATA flag() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupEntry._flagOffset_));
	}

	// U64 flag
	public UDATAPointer flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(OMRCgroupEntry._flagOffset_));
	}

	// I32 hierarchyId
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hierarchyIdOffset_", declaredType="I32")
	public IDATA hierarchyId() throws CorruptDataException {
		return new I32(getIntAtOffset(OMRCgroupEntry._hierarchyIdOffset_));
	}

	// I32 hierarchyId
	public IDATAPointer hierarchyIdEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(OMRCgroupEntry._hierarchyIdOffset_));
	}

	// OMRCgroupEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="OMRCgroupEntry*")
	public OMRCgroupEntryPointer next() throws CorruptDataException {
		return OMRCgroupEntryPointer.cast(getPointerAtOffset(OMRCgroupEntry._nextOffset_));
	}

	// OMRCgroupEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRCgroupEntry._nextOffset_));
	}

	// U8* subsystem
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_subsystemOffset_", declaredType="U8*")
	public U8Pointer subsystem() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRCgroupEntry._subsystemOffset_));
	}

	// U8* subsystem
	public PointerPointer subsystemEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(OMRCgroupEntry._subsystemOffset_));
	}

}
