/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: StackIteratorData4ScavengePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the StackIteratorData4ScavengePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=StackIteratorData4Scavenge.class)
public class StackIteratorData4ScavengePointer extends StructurePointer {

	// NULL
	public static final StackIteratorData4ScavengePointer NULL = new StackIteratorData4ScavengePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected StackIteratorData4ScavengePointer(long address) {
		super(address);
	}

	public static StackIteratorData4ScavengePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static StackIteratorData4ScavengePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static StackIteratorData4ScavengePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new StackIteratorData4ScavengePointer(address);
	}

	public StackIteratorData4ScavengePointer add(long count) {
		return StackIteratorData4ScavengePointer.cast(address + (StackIteratorData4Scavenge.SIZEOF * count));
	}

	public StackIteratorData4ScavengePointer add(Scalar count) {
		return add(count.longValue());
	}

	public StackIteratorData4ScavengePointer addOffset(long offset) {
		return StackIteratorData4ScavengePointer.cast(address + offset);
	}

	public StackIteratorData4ScavengePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public StackIteratorData4ScavengePointer sub(long count) {
		return StackIteratorData4ScavengePointer.cast(address - (StackIteratorData4Scavenge.SIZEOF * count));
	}

	public StackIteratorData4ScavengePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public StackIteratorData4ScavengePointer subOffset(long offset) {
		return StackIteratorData4ScavengePointer.cast(address - offset);
	}

	public StackIteratorData4ScavengePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public StackIteratorData4ScavengePointer untag(long mask) {
		return StackIteratorData4ScavengePointer.cast(address & ~mask);
	}

	public StackIteratorData4ScavengePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return StackIteratorData4Scavenge.SIZEOF;
	}

	// Implementation methods

	// MM_EnvironmentStandard* env
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_envOffset_", declaredType="MM_EnvironmentStandard*")
	public MM_EnvironmentStandardPointer env() throws CorruptDataException {
		return MM_EnvironmentStandardPointer.cast(getPointerAtOffset(StackIteratorData4Scavenge._envOffset_));
	}

	// MM_EnvironmentStandard* env
	public PointerPointer envEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4Scavenge._envOffset_));
	}

	// MM_ScavengeScanReason reason
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_reasonOffset_", declaredType="MM_ScavengeScanReason")
	public long reason() throws CorruptDataException {
		if (MM_ScavengeScanReason.SIZEOF == 1) {
			return getByteAtOffset(StackIteratorData4Scavenge._reasonOffset_);
		} else if (MM_ScavengeScanReason.SIZEOF == 2) {
			return getShortAtOffset(StackIteratorData4Scavenge._reasonOffset_);
		} else if (MM_ScavengeScanReason.SIZEOF == 4) {
			return getIntAtOffset(StackIteratorData4Scavenge._reasonOffset_);
		} else if (MM_ScavengeScanReason.SIZEOF == 8) {
			return getLongAtOffset(StackIteratorData4Scavenge._reasonOffset_);
		} else {
			throw new IllegalArgumentException("Unexpected ENUM size in core file");
		}
	}

	// MM_ScavengeScanReason reason
	public EnumPointer reasonEA() throws CorruptDataException {
		return EnumPointer.cast(nonNullFieldEA(StackIteratorData4Scavenge._reasonOffset_), MM_ScavengeScanReason.class);
	}

	// MM_ScavengerDelegate* scavengerDelegate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_scavengerDelegateOffset_", declaredType="MM_ScavengerDelegate*")
	public MM_ScavengerDelegatePointer scavengerDelegate() throws CorruptDataException {
		return MM_ScavengerDelegatePointer.cast(getPointerAtOffset(StackIteratorData4Scavenge._scavengerDelegateOffset_));
	}

	// MM_ScavengerDelegate* scavengerDelegate
	public PointerPointer scavengerDelegateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4Scavenge._scavengerDelegateOffset_));
	}

	// bool* shouldRemember
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shouldRememberOffset_", declaredType="bool*")
	public BoolPointer shouldRemember() throws CorruptDataException {
		return BoolPointer.cast(getPointerAtOffset(StackIteratorData4Scavenge._shouldRememberOffset_));
	}

	// bool* shouldRemember
	public PointerPointer shouldRememberEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(StackIteratorData4Scavenge._shouldRememberOffset_));
	}

}
