/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ConcurrentGCIncrementalUpdate
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ConcurrentGCIncrementalUpdate {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocToTraceRateCardCleanPass2BoostOffset_;
	public static final int __bytesToCleanPass1Offset_;
	public static final int __bytesToCleanPass2Offset_;
	public static final int __bytesToTracePass1Offset_;
	public static final int __bytesToTracePass2Offset_;
	public static final int __bytesTracedInPass1FactorOffset_;
	public static final int __cardCleaningFactorPass1Offset_;
	public static final int __cardCleaningFactorPass2Offset_;
	public static final int __cardCleaningThresholdFactorOffset_;
	public static final int __cardTableOffset_;
	public static final int __maxCardCleaningFactorPass1Offset_;
	public static final int __maxCardCleaningFactorPass2Offset_;
	public static final int __pass2StartedOffset_;
	public static final int __secondCardCleanPassOffset_;
	public static final int __totalCleanedAtPass2KOOffset_;
	public static final int __totalTracedAtPass2KOOffset_;
	public static final int __traceTargetPass1Offset_;
	public static final int __traceTargetPass2Offset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocToTraceRateCardCleanPass2BoostOffset_ = 0;
		__bytesToCleanPass1Offset_ = 0;
		__bytesToCleanPass2Offset_ = 0;
		__bytesToTracePass1Offset_ = 0;
		__bytesToTracePass2Offset_ = 0;
		__bytesTracedInPass1FactorOffset_ = 0;
		__cardCleaningFactorPass1Offset_ = 0;
		__cardCleaningFactorPass2Offset_ = 0;
		__cardCleaningThresholdFactorOffset_ = 0;
		__cardTableOffset_ = 0;
		__maxCardCleaningFactorPass1Offset_ = 0;
		__maxCardCleaningFactorPass2Offset_ = 0;
		__pass2StartedOffset_ = 0;
		__secondCardCleanPassOffset_ = 0;
		__totalCleanedAtPass2KOOffset_ = 0;
		__totalTracedAtPass2KOOffset_ = 0;
		__traceTargetPass1Offset_ = 0;
		__traceTargetPass2Offset_ = 0;
	}

}
