/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: VM_JFRConstantPoolTypes
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class VM_JFRConstantPoolTypes {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __buildResultOffset_;
	public static final int __classCountOffset_;
	public static final int __classLoaderCountOffset_;
	public static final int __classLoaderTableOffset_;
	public static final int __classLoadingStatisticsCountOffset_;
	public static final int __classLoadingStatisticsTableOffset_;
	public static final int __classTableOffset_;
	public static final int __cpuLoadCountOffset_;
	public static final int __cpuLoadTableOffset_;
	public static final int __currentFrameCountOffset_;
	public static final int __currentStackFrameBufferOffset_;
	public static final int __currentThreadOffset_;
	public static final int __debugOffset_;
	public static final int __defaultClassEntryOffset_;
	public static final int __defaultMethodEntryOffset_;
	public static final int __defaultModuleEntryOffset_;
	public static final int __defaultPackageEntryOffset_;
	public static final int __defaultStackTraceEntryOffset_;
	public static final int __defaultStringUTF8EntryOffset_;
	public static final int __defaultThreadGroupOffset_;
	public static final int __executionSampleCountOffset_;
	public static final int __executionSampleTableOffset_;
	public static final int __firstClassEntryOffset_;
	public static final int __firstClassloaderEntryOffset_;
	public static final int __firstMethodEntryOffset_;
	public static final int __firstModuleEntryOffset_;
	public static final int __firstNativeLibraryEntryOffset_;
	public static final int __firstPackageEntryOffset_;
	public static final int __firstStackTraceEntryOffset_;
	public static final int __firstThreadEntryOffset_;
	public static final int __firstThreadGroupEntryOffset_;
	public static final int __globalStringTableOffset_;
	public static final int __methodCountOffset_;
	public static final int __methodTableOffset_;
	public static final int __moduleCountOffset_;
	public static final int __moduleExportCountOffset_;
	public static final int __moduleExportTableOffset_;
	public static final int __moduleRequireCountOffset_;
	public static final int __moduleRequireTableOffset_;
	public static final int __moduleTableOffset_;
	public static final int __monitorEnterCountOffset_;
	public static final int __monitorEnterTableOffset_;
	public static final int __monitorWaitCountOffset_;
	public static final int __monitorWaitTableOffset_;
	public static final int __nativeLibrariesCountOffset_;
	public static final int __nativeLibrariesTableOffset_;
	public static final int __nativeLibraryPathSizeTotalOffset_;
	public static final int __nativeMethodSignatureStringUTF8EntryOffset_;
	public static final int __nativeMethodStringUTF8EntryOffset_;
	public static final int __packageCountOffset_;
	public static final int __packageNameCountOffset_;
	public static final int __packageTableOffset_;
	public static final int __previousClassEntryOffset_;
	public static final int __previousClassloaderEntryOffset_;
	public static final int __previousMethodEntryOffset_;
	public static final int __previousModuleEntryOffset_;
	public static final int __previousNativeLibraryEntryOffset_;
	public static final int __previousPackageEntryOffset_;
	public static final int __previousStackTraceEntryOffset_;
	public static final int __previousThreadEntryOffset_;
	public static final int __previousThreadGroupEntryOffset_;
	public static final int __requiredBufferSizeOffset_;
	public static final int __stackFrameCountOffset_;
	public static final int __stackTraceCountOffset_;
	public static final int __stackTraceTableOffset_;
	public static final int __stringUTF8CountOffset_;
	public static final int __stringUTF8TableOffset_;
	public static final int __systemGCCountOffset_;
	public static final int __systemGCTableOffset_;
	public static final int __systemProcessCountOffset_;
	public static final int __systemProcessStringSizeTotalOffset_;
	public static final int __systemProcessTableOffset_;
	public static final int __threadCPULoadCountOffset_;
	public static final int __threadCPULoadTableOffset_;
	public static final int __threadContextSwitchRateCountOffset_;
	public static final int __threadContextSwitchRateTableOffset_;
	public static final int __threadCountOffset_;
	public static final int __threadEndCountOffset_;
	public static final int __threadEndTableOffset_;
	public static final int __threadGroupCountOffset_;
	public static final int __threadGroupTableOffset_;
	public static final int __threadParkCountOffset_;
	public static final int __threadParkTableOffset_;
	public static final int __threadSleepCountOffset_;
	public static final int __threadSleepTableOffset_;
	public static final int __threadStartCountOffset_;
	public static final int __threadStartTableOffset_;
	public static final int __threadStatisticsCountOffset_;
	public static final int __threadStatisticsTableOffset_;
	public static final int __threadTableOffset_;
	public static final int __unknownClassStringUTF8EntryOffset_;
	public static final int __vmOffset_;
	public static final int _privatePortLibraryOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__buildResultOffset_ = 0;
		__classCountOffset_ = 0;
		__classLoaderCountOffset_ = 0;
		__classLoaderTableOffset_ = 0;
		__classLoadingStatisticsCountOffset_ = 0;
		__classLoadingStatisticsTableOffset_ = 0;
		__classTableOffset_ = 0;
		__cpuLoadCountOffset_ = 0;
		__cpuLoadTableOffset_ = 0;
		__currentFrameCountOffset_ = 0;
		__currentStackFrameBufferOffset_ = 0;
		__currentThreadOffset_ = 0;
		__debugOffset_ = 0;
		__defaultClassEntryOffset_ = 0;
		__defaultMethodEntryOffset_ = 0;
		__defaultModuleEntryOffset_ = 0;
		__defaultPackageEntryOffset_ = 0;
		__defaultStackTraceEntryOffset_ = 0;
		__defaultStringUTF8EntryOffset_ = 0;
		__defaultThreadGroupOffset_ = 0;
		__executionSampleCountOffset_ = 0;
		__executionSampleTableOffset_ = 0;
		__firstClassEntryOffset_ = 0;
		__firstClassloaderEntryOffset_ = 0;
		__firstMethodEntryOffset_ = 0;
		__firstModuleEntryOffset_ = 0;
		__firstNativeLibraryEntryOffset_ = 0;
		__firstPackageEntryOffset_ = 0;
		__firstStackTraceEntryOffset_ = 0;
		__firstThreadEntryOffset_ = 0;
		__firstThreadGroupEntryOffset_ = 0;
		__globalStringTableOffset_ = 0;
		__methodCountOffset_ = 0;
		__methodTableOffset_ = 0;
		__moduleCountOffset_ = 0;
		__moduleExportCountOffset_ = 0;
		__moduleExportTableOffset_ = 0;
		__moduleRequireCountOffset_ = 0;
		__moduleRequireTableOffset_ = 0;
		__moduleTableOffset_ = 0;
		__monitorEnterCountOffset_ = 0;
		__monitorEnterTableOffset_ = 0;
		__monitorWaitCountOffset_ = 0;
		__monitorWaitTableOffset_ = 0;
		__nativeLibrariesCountOffset_ = 0;
		__nativeLibrariesTableOffset_ = 0;
		__nativeLibraryPathSizeTotalOffset_ = 0;
		__nativeMethodSignatureStringUTF8EntryOffset_ = 0;
		__nativeMethodStringUTF8EntryOffset_ = 0;
		__packageCountOffset_ = 0;
		__packageNameCountOffset_ = 0;
		__packageTableOffset_ = 0;
		__previousClassEntryOffset_ = 0;
		__previousClassloaderEntryOffset_ = 0;
		__previousMethodEntryOffset_ = 0;
		__previousModuleEntryOffset_ = 0;
		__previousNativeLibraryEntryOffset_ = 0;
		__previousPackageEntryOffset_ = 0;
		__previousStackTraceEntryOffset_ = 0;
		__previousThreadEntryOffset_ = 0;
		__previousThreadGroupEntryOffset_ = 0;
		__requiredBufferSizeOffset_ = 0;
		__stackFrameCountOffset_ = 0;
		__stackTraceCountOffset_ = 0;
		__stackTraceTableOffset_ = 0;
		__stringUTF8CountOffset_ = 0;
		__stringUTF8TableOffset_ = 0;
		__systemGCCountOffset_ = 0;
		__systemGCTableOffset_ = 0;
		__systemProcessCountOffset_ = 0;
		__systemProcessStringSizeTotalOffset_ = 0;
		__systemProcessTableOffset_ = 0;
		__threadCPULoadCountOffset_ = 0;
		__threadCPULoadTableOffset_ = 0;
		__threadContextSwitchRateCountOffset_ = 0;
		__threadContextSwitchRateTableOffset_ = 0;
		__threadCountOffset_ = 0;
		__threadEndCountOffset_ = 0;
		__threadEndTableOffset_ = 0;
		__threadGroupCountOffset_ = 0;
		__threadGroupTableOffset_ = 0;
		__threadParkCountOffset_ = 0;
		__threadParkTableOffset_ = 0;
		__threadSleepCountOffset_ = 0;
		__threadSleepTableOffset_ = 0;
		__threadStartCountOffset_ = 0;
		__threadStartTableOffset_ = 0;
		__threadStatisticsCountOffset_ = 0;
		__threadStatisticsTableOffset_ = 0;
		__threadTableOffset_ = 0;
		__unknownClassStringUTF8EntryOffset_ = 0;
		__vmOffset_ = 0;
		_privatePortLibraryOffset_ = 0;
	}

}
