/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_AllocateDescription
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_AllocateDescription {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __allocateFlagsOffset_;
	public static final int __allocationContextOffset_;
	public static final int __allocationSucceededOffset_;
	public static final int __allocationTaxSizeOffset_;
	public static final int __allocationTypeOffset_;
	public static final int __bytesRequestedOffset_;
	public static final int __chunkedArrayOffset_;
	public static final int __climbOffset_;
	public static final int __collectAndClimbOffset_;
	public static final int __collectorAllocateExpandOnFailureOffset_;
	public static final int __collectorAllocateSatisfyAnywhereOffset_;
	public static final int __completedFromTlhOffset_;
	public static final int __loaAllocationOffset_;
	public static final int __memoryPoolOffset_;
	public static final int __memorySpaceOffset_;
	public static final int __memorySubSpaceOffset_;
	public static final int __numArrayletsOffset_;
	public static final int __nurseryAllocationOffset_;
	public static final int __objectFlagsOffset_;
	public static final int __spineOffset_;
	public static final int __spineBytesOffset_;
	public static final int __threadAtSafePointOffset_;
	public static final int __tlhAllocationOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__allocateFlagsOffset_ = 0;
		__allocationContextOffset_ = 0;
		__allocationSucceededOffset_ = 0;
		__allocationTaxSizeOffset_ = 0;
		__allocationTypeOffset_ = 0;
		__bytesRequestedOffset_ = 0;
		__chunkedArrayOffset_ = 0;
		__climbOffset_ = 0;
		__collectAndClimbOffset_ = 0;
		__collectorAllocateExpandOnFailureOffset_ = 0;
		__collectorAllocateSatisfyAnywhereOffset_ = 0;
		__completedFromTlhOffset_ = 0;
		__loaAllocationOffset_ = 0;
		__memoryPoolOffset_ = 0;
		__memorySpaceOffset_ = 0;
		__memorySubSpaceOffset_ = 0;
		__numArrayletsOffset_ = 0;
		__nurseryAllocationOffset_ = 0;
		__objectFlagsOffset_ = 0;
		__spineOffset_ = 0;
		__spineBytesOffset_ = 0;
		__threadAtSafePointOffset_ = 0;
		__tlhAllocationOffset_ = 0;
	}

}
