/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_InterRegionRememberedSet
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_InterRegionRememberedSet {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __beingRebuiltRegionCountOffset_;
	public static final int __bufferControlBlockCountPerRegionOffset_;
	public static final int __bufferCountTotalOffset_;
	public static final int __cardTableOffset_;
	public static final int __cardToRegionDisplacementOffset_;
	public static final int __cardToRegionShiftOffset_;
	public static final int __compressObjectReferencesOffset_;
	public static final int __freeBufferCountOffset_;
	public static final int __heapRegionManagerOffset_;
	public static final int __lockOffset_;
	public static final int __overflowedListHeadOffset_;
	public static final int __overflowedListTailOffset_;
	public static final int __overflowedRegionCountOffset_;
	public static final int __regionSizeOffset_;
	public static final int __regionTableOffset_;
	public static final int __rememberedSetCardBucketPoolOffset_;
	public static final int __rsclBufferControlBlockHeadOffset_;
	public static final int __rsclBufferControlBlockPoolOffset_;
	public static final int __rsclBufferControlBlockPoolMemoryHandleOffset_;
	public static final int __shouldFlushBuffersForDecommitedRegionsOffset_;
	public static final int __stableRegionCountOffset_;
	public static final int __tableDescriptorSizeOffset_;
	public static final int __unusedRegionThresholdOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__beingRebuiltRegionCountOffset_ = 0;
		__bufferControlBlockCountPerRegionOffset_ = 0;
		__bufferCountTotalOffset_ = 0;
		__cardTableOffset_ = 0;
		__cardToRegionDisplacementOffset_ = 0;
		__cardToRegionShiftOffset_ = 0;
		__compressObjectReferencesOffset_ = 0;
		__freeBufferCountOffset_ = 0;
		__heapRegionManagerOffset_ = 0;
		__lockOffset_ = 0;
		__overflowedListHeadOffset_ = 0;
		__overflowedListTailOffset_ = 0;
		__overflowedRegionCountOffset_ = 0;
		__regionSizeOffset_ = 0;
		__regionTableOffset_ = 0;
		__rememberedSetCardBucketPoolOffset_ = 0;
		__rsclBufferControlBlockHeadOffset_ = 0;
		__rsclBufferControlBlockPoolOffset_ = 0;
		__rsclBufferControlBlockPoolMemoryHandleOffset_ = 0;
		__shouldFlushBuffersForDecommitedRegionsOffset_ = 0;
		__stableRegionCountOffset_ = 0;
		__tableDescriptorSizeOffset_ = 0;
		__unusedRegionThresholdOffset_ = 0;
	}

}
