/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: eproc
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class eproc {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _e_flagOffset_;
	public static final int _e_jobcOffset_;
	public static final int _e_loginOffset_;
	public static final int _e_paddrOffset_;
	public static final int _e_pcredOffset_;
	public static final int _e_pgidOffset_;
	public static final int _e_ppidOffset_;
	public static final int _e_sessOffset_;
	public static final int _e_spareOffset_;
	public static final int _e_tdevOffset_;
	public static final int _e_tpgidOffset_;
	public static final int _e_tsessOffset_;
	public static final int _e_ucredOffset_;
	public static final int _e_vmOffset_;
	public static final int _e_wmesgOffset_;
	public static final int _e_xccountOffset_;
	public static final int _e_xrssizeOffset_;
	public static final int _e_xsizeOffset_;
	public static final int _e_xswrssOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_e_flagOffset_ = 0;
		_e_jobcOffset_ = 0;
		_e_loginOffset_ = 0;
		_e_paddrOffset_ = 0;
		_e_pcredOffset_ = 0;
		_e_pgidOffset_ = 0;
		_e_ppidOffset_ = 0;
		_e_sessOffset_ = 0;
		_e_spareOffset_ = 0;
		_e_tdevOffset_ = 0;
		_e_tpgidOffset_ = 0;
		_e_tsessOffset_ = 0;
		_e_ucredOffset_ = 0;
		_e_vmOffset_ = 0;
		_e_wmesgOffset_ = 0;
		_e_xccountOffset_ = 0;
		_e_xrssizeOffset_ = 0;
		_e_xsizeOffset_ = 0;
		_e_xswrssOffset_ = 0;
	}

}
