/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import jdk.test.lib.hprof.model.Snapshot;

public class StackFrame {
    public static final int LINE_NUMBER_UNKNOWN = -1;
    public static final int LINE_NUMBER_COMPILED = -2;
    public static final int LINE_NUMBER_NATIVE = -3;
    private String methodName;
    private String methodSignature;
    private String className;
    private String sourceFileName;
    private int lineNumber;

    public StackFrame(String methodName, String methodSignature, String className, String sourceFileName, int lineNumber) {
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.className = className;
        this.sourceFileName = sourceFileName;
        this.lineNumber = lineNumber;
    }

    public void resolve(Snapshot snapshot) {
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getLineNumber() {
        switch (this.lineNumber) {
            case -1: {
                return "(unknown)";
            }
            case -2: {
                return "(compiled method)";
            }
            case -3: {
                return "(native method)";
            }
        }
        return Integer.toString(this.lineNumber, 10);
    }
}

