/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ThreadEndEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ThreadEndEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ThreadEndEntry.class)
public class ThreadEndEntryPointer extends StructurePointer {

	// NULL
	public static final ThreadEndEntryPointer NULL = new ThreadEndEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ThreadEndEntryPointer(long address) {
		super(address);
	}

	public static ThreadEndEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ThreadEndEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ThreadEndEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ThreadEndEntryPointer(address);
	}

	public ThreadEndEntryPointer add(long count) {
		return ThreadEndEntryPointer.cast(address + (ThreadEndEntry.SIZEOF * count));
	}

	public ThreadEndEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ThreadEndEntryPointer addOffset(long offset) {
		return ThreadEndEntryPointer.cast(address + offset);
	}

	public ThreadEndEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ThreadEndEntryPointer sub(long count) {
		return ThreadEndEntryPointer.cast(address - (ThreadEndEntry.SIZEOF * count));
	}

	public ThreadEndEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ThreadEndEntryPointer subOffset(long offset) {
		return ThreadEndEntryPointer.cast(address - offset);
	}

	public ThreadEndEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ThreadEndEntryPointer untag(long mask) {
		return ThreadEndEntryPointer.cast(address & ~mask);
	}

	public ThreadEndEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ThreadEndEntry.SIZEOF;
	}

	// Implementation methods

	// U32 eventThreadIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eventThreadIndexOffset_", declaredType="U32")
	public UDATA eventThreadIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ThreadEndEntry._eventThreadIndexOffset_));
	}

	// U32 eventThreadIndex
	public UDATAPointer eventThreadIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEndEntry._eventThreadIndexOffset_));
	}

	// U32 threadIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadIndexOffset_", declaredType="U32")
	public UDATA threadIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ThreadEndEntry._threadIndexOffset_));
	}

	// U32 threadIndex
	public UDATAPointer threadIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEndEntry._threadIndexOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(ThreadEndEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadEndEntry._ticksOffset_));
	}

}
