/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __darwin_i386_thread_statePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __darwin_i386_thread_statePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__darwin_i386_thread_state.class)
public class __darwin_i386_thread_statePointer extends StructurePointer {

	// NULL
	public static final __darwin_i386_thread_statePointer NULL = new __darwin_i386_thread_statePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __darwin_i386_thread_statePointer(long address) {
		super(address);
	}

	public static __darwin_i386_thread_statePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __darwin_i386_thread_statePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __darwin_i386_thread_statePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __darwin_i386_thread_statePointer(address);
	}

	public __darwin_i386_thread_statePointer add(long count) {
		return __darwin_i386_thread_statePointer.cast(address + (__darwin_i386_thread_state.SIZEOF * count));
	}

	public __darwin_i386_thread_statePointer add(Scalar count) {
		return add(count.longValue());
	}

	public __darwin_i386_thread_statePointer addOffset(long offset) {
		return __darwin_i386_thread_statePointer.cast(address + offset);
	}

	public __darwin_i386_thread_statePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __darwin_i386_thread_statePointer sub(long count) {
		return __darwin_i386_thread_statePointer.cast(address - (__darwin_i386_thread_state.SIZEOF * count));
	}

	public __darwin_i386_thread_statePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __darwin_i386_thread_statePointer subOffset(long offset) {
		return __darwin_i386_thread_statePointer.cast(address - offset);
	}

	public __darwin_i386_thread_statePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __darwin_i386_thread_statePointer untag(long mask) {
		return __darwin_i386_thread_statePointer.cast(address & ~mask);
	}

	public __darwin_i386_thread_statePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __darwin_i386_thread_state.SIZEOF;
	}

	// Implementation methods

	// U32 __cs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___csOffset_", declaredType="U32")
	public UDATA __cs() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___csOffset_));
	}

	// U32 __cs
	public UDATAPointer __csEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___csOffset_));
	}

	// U32 __ds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___dsOffset_", declaredType="U32")
	public UDATA __ds() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___dsOffset_));
	}

	// U32 __ds
	public UDATAPointer __dsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___dsOffset_));
	}

	// U32 __eax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___eaxOffset_", declaredType="U32")
	public UDATA __eax() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___eaxOffset_));
	}

	// U32 __eax
	public UDATAPointer __eaxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___eaxOffset_));
	}

	// U32 __ebp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ebpOffset_", declaredType="U32")
	public UDATA __ebp() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___ebpOffset_));
	}

	// U32 __ebp
	public UDATAPointer __ebpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___ebpOffset_));
	}

	// U32 __ebx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ebxOffset_", declaredType="U32")
	public UDATA __ebx() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___ebxOffset_));
	}

	// U32 __ebx
	public UDATAPointer __ebxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___ebxOffset_));
	}

	// U32 __ecx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ecxOffset_", declaredType="U32")
	public UDATA __ecx() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___ecxOffset_));
	}

	// U32 __ecx
	public UDATAPointer __ecxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___ecxOffset_));
	}

	// U32 __edi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ediOffset_", declaredType="U32")
	public UDATA __edi() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___ediOffset_));
	}

	// U32 __edi
	public UDATAPointer __ediEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___ediOffset_));
	}

	// U32 __edx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___edxOffset_", declaredType="U32")
	public UDATA __edx() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___edxOffset_));
	}

	// U32 __edx
	public UDATAPointer __edxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___edxOffset_));
	}

	// U32 __eflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___eflagsOffset_", declaredType="U32")
	public UDATA __eflags() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___eflagsOffset_));
	}

	// U32 __eflags
	public UDATAPointer __eflagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___eflagsOffset_));
	}

	// U32 __eip
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___eipOffset_", declaredType="U32")
	public UDATA __eip() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___eipOffset_));
	}

	// U32 __eip
	public UDATAPointer __eipEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___eipOffset_));
	}

	// U32 __es
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___esOffset_", declaredType="U32")
	public UDATA __es() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___esOffset_));
	}

	// U32 __es
	public UDATAPointer __esEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___esOffset_));
	}

	// U32 __esi
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___esiOffset_", declaredType="U32")
	public UDATA __esi() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___esiOffset_));
	}

	// U32 __esi
	public UDATAPointer __esiEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___esiOffset_));
	}

	// U32 __esp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___espOffset_", declaredType="U32")
	public UDATA __esp() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___espOffset_));
	}

	// U32 __esp
	public UDATAPointer __espEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___espOffset_));
	}

	// U32 __fs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___fsOffset_", declaredType="U32")
	public UDATA __fs() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___fsOffset_));
	}

	// U32 __fs
	public UDATAPointer __fsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___fsOffset_));
	}

	// U32 __gs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___gsOffset_", declaredType="U32")
	public UDATA __gs() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___gsOffset_));
	}

	// U32 __gs
	public UDATAPointer __gsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___gsOffset_));
	}

	// U32 __ss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___ssOffset_", declaredType="U32")
	public UDATA __ss() throws CorruptDataException {
		return new U32(getIntAtOffset(__darwin_i386_thread_state.___ssOffset_));
	}

	// U32 __ss
	public UDATAPointer __ssEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__darwin_i386_thread_state.___ssOffset_));
	}

}
