/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: x86_exception_statePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the x86_exception_statePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=x86_exception_state.class)
public class x86_exception_statePointer extends StructurePointer {

	// NULL
	public static final x86_exception_statePointer NULL = new x86_exception_statePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected x86_exception_statePointer(long address) {
		super(address);
	}

	public static x86_exception_statePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static x86_exception_statePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static x86_exception_statePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new x86_exception_statePointer(address);
	}

	public x86_exception_statePointer add(long count) {
		return x86_exception_statePointer.cast(address + (x86_exception_state.SIZEOF * count));
	}

	public x86_exception_statePointer add(Scalar count) {
		return add(count.longValue());
	}

	public x86_exception_statePointer addOffset(long offset) {
		return x86_exception_statePointer.cast(address + offset);
	}

	public x86_exception_statePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public x86_exception_statePointer sub(long count) {
		return x86_exception_statePointer.cast(address - (x86_exception_state.SIZEOF * count));
	}

	public x86_exception_statePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public x86_exception_statePointer subOffset(long offset) {
		return x86_exception_statePointer.cast(address - offset);
	}

	public x86_exception_statePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public x86_exception_statePointer untag(long mask) {
		return x86_exception_statePointer.cast(address & ~mask);
	}

	public x86_exception_statePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return x86_exception_state.SIZEOF;
	}

	// Implementation methods

	// x86_state_hdr_t esh
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_eshOffset_", declaredType="x86_state_hdr_t")
	public x86_state_hdrPointer esh() throws CorruptDataException {
		return x86_state_hdrPointer.cast(nonNullFieldEA(x86_exception_state._eshOffset_));
	}

	// x86_state_hdr_t esh
	public PointerPointer eshEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(x86_exception_state._eshOffset_));
	}

	// x86_exception_state32_t ues.es32
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ues$es32Offset_", declaredType="x86_exception_state32_t")
	public __darwin_i386_exception_statePointer ues$es32() throws CorruptDataException {
		return __darwin_i386_exception_statePointer.cast(nonNullFieldEA(x86_exception_state._ues$es32Offset_));
	}

	// x86_exception_state32_t ues.es32
	public PointerPointer ues$es32EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(x86_exception_state._ues$es32Offset_));
	}

	// x86_exception_state64_t ues.es64
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ues$es64Offset_", declaredType="x86_exception_state64_t")
	public __darwin_x86_exception_state64Pointer ues$es64() throws CorruptDataException {
		return __darwin_x86_exception_state64Pointer.cast(nonNullFieldEA(x86_exception_state._ues$es64Offset_));
	}

	// x86_exception_state64_t ues.es64
	public PointerPointer ues$es64EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(x86_exception_state._ues$es64Offset_));
	}

}
