/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9AbstractThread
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9AbstractThread {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9THREAD_ALREADY_ATTACHED;
	public static final long J9THREAD_ERR;
	public static final long J9THREAD_ERR_CANT_ALLOCATE_J9THREAD_T;
	public static final long J9THREAD_ERR_CANT_ALLOC_ATTACH_ATTR;
	public static final long J9THREAD_ERR_CANT_ALLOC_CREATE_ATTR;
	public static final long J9THREAD_ERR_CANT_ALLOC_STACK;
	public static final long J9THREAD_ERR_CANT_INIT_CONDITION;
	public static final long J9THREAD_ERR_CANT_INIT_MUTEX;
	public static final long J9THREAD_ERR_GETATTR_NP;
	public static final long J9THREAD_ERR_GETSTACK;
	public static final long J9THREAD_ERR_INVALID_ATTACH_ATTR;
	public static final long J9THREAD_ERR_INVALID_ATTR;
	public static final long J9THREAD_ERR_INVALID_CREATE_ATTR;
	public static final long J9THREAD_ERR_INVALID_PRIORITY;
	public static final long J9THREAD_ERR_INVALID_SCHEDPOLICY;
	public static final long J9THREAD_ERR_INVALID_THREAD;
	public static final long J9THREAD_ERR_INVALID_TIMESTAMP;
	public static final long J9THREAD_ERR_INVALID_VALUE;
	public static final long J9THREAD_ERR_NOMEMORY;
	public static final long J9THREAD_ERR_NO_SUCH_THREAD;
	public static final long J9THREAD_ERR_OS_ERRNO_SET;
	public static final long J9THREAD_ERR_THREAD_CREATE_FAILED;
	public static final long J9THREAD_ERR_UNSUPPORTED_ATTR;
	public static final long J9THREAD_ERR_UNSUPPORTED_PLAT;
	public static final long J9THREAD_ERR_UNSUPPORTED_VALUE;
	public static final long J9THREAD_ERR_USAGE_RETRIEVAL_ERROR;
	public static final long J9THREAD_ERR_USAGE_RETRIEVAL_UNSUPPORTED;
	public static final long J9THREAD_FLAG_ABORTABLE;
	public static final long J9THREAD_FLAG_ABORTED;
	public static final long J9THREAD_FLAG_ATTACHED;
	public static final long J9THREAD_FLAG_BLOCKED;
	public static final long J9THREAD_FLAG_CANCELED;
	public static final long J9THREAD_FLAG_CPU_SAMPLING_ENABLED;
	public static final long J9THREAD_FLAG_DEAD;
	public static final long J9THREAD_FLAG_DETACHED;
	public static final long J9THREAD_FLAG_INTERRUPTABLE;
	public static final long J9THREAD_FLAG_INTERRUPTED;
	public static final long J9THREAD_FLAG_JOINABLE;
	public static final long J9THREAD_FLAG_NOTIFIED;
	public static final long J9THREAD_FLAG_PARKED;
	public static final long J9THREAD_FLAG_PRIORITY_INTERRUPTED;
	public static final long J9THREAD_FLAG_SLEEPING;
	public static final long J9THREAD_FLAG_STARTED;
	public static final long J9THREAD_FLAG_SUSPENDED;
	public static final long J9THREAD_FLAG_TIMER_SET;
	public static final long J9THREAD_FLAG_UNPARKED;
	public static final long J9THREAD_FLAG_WAITING;
	public static final long J9THREAD_ILLEGAL_MONITOR_STATE;
	public static final long J9THREAD_INTERRUPTED;
	public static final long J9THREAD_INTERRUPTED_MONITOR_ENTER;
	public static final long J9THREAD_INVALID_ARGUMENT;
	public static final long J9THREAD_INVALID_OS_ERRNO;
	public static final long J9THREAD_PRIORITY_INTERRUPTED;
	public static final long J9THREAD_SUCCESS;
	public static final long J9THREAD_TIMED_OUT;
	public static final long J9THREAD_WOULD_BLOCK;

	// Offsets

	public static final int _attachcountOffset_;
	public static final int _categoryOffset_;
	public static final int _effective_categoryOffset_;
	public static final int _entryargOffset_;
	public static final int _entrypointOffset_;
	public static final int _flagsOffset_;
	public static final int _interrupterOffset_;
	public static final int _lastCategorySwitchTimeOffset_;
	public static final int _libraryOffset_;
	public static final int _lockedmonitorcountOffset_;
	public static final int _monitorOffset_;
	public static final int _nextOffset_;
	public static final int _os_errnoOffset_;
	public static final int _prevOffset_;
	public static final int _priorityOffset_;
	public static final int _tidOffset_;
	public static final int _tlsOffset_;
	public static final int _tracingOffset_;
	public static final int _waitNumberOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9THREAD_ALREADY_ATTACHED = 0;
		J9THREAD_ERR = 0;
		J9THREAD_ERR_CANT_ALLOCATE_J9THREAD_T = 0;
		J9THREAD_ERR_CANT_ALLOC_ATTACH_ATTR = 0;
		J9THREAD_ERR_CANT_ALLOC_CREATE_ATTR = 0;
		J9THREAD_ERR_CANT_ALLOC_STACK = 0;
		J9THREAD_ERR_CANT_INIT_CONDITION = 0;
		J9THREAD_ERR_CANT_INIT_MUTEX = 0;
		J9THREAD_ERR_GETATTR_NP = 0;
		J9THREAD_ERR_GETSTACK = 0;
		J9THREAD_ERR_INVALID_ATTACH_ATTR = 0;
		J9THREAD_ERR_INVALID_ATTR = 0;
		J9THREAD_ERR_INVALID_CREATE_ATTR = 0;
		J9THREAD_ERR_INVALID_PRIORITY = 0;
		J9THREAD_ERR_INVALID_SCHEDPOLICY = 0;
		J9THREAD_ERR_INVALID_THREAD = 0;
		J9THREAD_ERR_INVALID_TIMESTAMP = 0;
		J9THREAD_ERR_INVALID_VALUE = 0;
		J9THREAD_ERR_NOMEMORY = 0;
		J9THREAD_ERR_NO_SUCH_THREAD = 0;
		J9THREAD_ERR_OS_ERRNO_SET = 0;
		J9THREAD_ERR_THREAD_CREATE_FAILED = 0;
		J9THREAD_ERR_UNSUPPORTED_ATTR = 0;
		J9THREAD_ERR_UNSUPPORTED_PLAT = 0;
		J9THREAD_ERR_UNSUPPORTED_VALUE = 0;
		J9THREAD_ERR_USAGE_RETRIEVAL_ERROR = 0;
		J9THREAD_ERR_USAGE_RETRIEVAL_UNSUPPORTED = 0;
		J9THREAD_FLAG_ABORTABLE = 0;
		J9THREAD_FLAG_ABORTED = 0;
		J9THREAD_FLAG_ATTACHED = 0;
		J9THREAD_FLAG_BLOCKED = 0;
		J9THREAD_FLAG_CANCELED = 0;
		J9THREAD_FLAG_CPU_SAMPLING_ENABLED = 0;
		J9THREAD_FLAG_DEAD = 0;
		J9THREAD_FLAG_DETACHED = 0;
		J9THREAD_FLAG_INTERRUPTABLE = 0;
		J9THREAD_FLAG_INTERRUPTED = 0;
		J9THREAD_FLAG_JOINABLE = 0;
		J9THREAD_FLAG_NOTIFIED = 0;
		J9THREAD_FLAG_PARKED = 0;
		J9THREAD_FLAG_PRIORITY_INTERRUPTED = 0;
		J9THREAD_FLAG_SLEEPING = 0;
		J9THREAD_FLAG_STARTED = 0;
		J9THREAD_FLAG_SUSPENDED = 0;
		J9THREAD_FLAG_TIMER_SET = 0;
		J9THREAD_FLAG_UNPARKED = 0;
		J9THREAD_FLAG_WAITING = 0;
		J9THREAD_ILLEGAL_MONITOR_STATE = 0;
		J9THREAD_INTERRUPTED = 0;
		J9THREAD_INTERRUPTED_MONITOR_ENTER = 0;
		J9THREAD_INVALID_ARGUMENT = 0;
		J9THREAD_INVALID_OS_ERRNO = 0;
		J9THREAD_PRIORITY_INTERRUPTED = 0;
		J9THREAD_SUCCESS = 0;
		J9THREAD_TIMED_OUT = 0;
		J9THREAD_WOULD_BLOCK = 0;
		_attachcountOffset_ = 0;
		_categoryOffset_ = 0;
		_effective_categoryOffset_ = 0;
		_entryargOffset_ = 0;
		_entrypointOffset_ = 0;
		_flagsOffset_ = 0;
		_interrupterOffset_ = 0;
		_lastCategorySwitchTimeOffset_ = 0;
		_libraryOffset_ = 0;
		_lockedmonitorcountOffset_ = 0;
		_monitorOffset_ = 0;
		_nextOffset_ = 0;
		_os_errnoOffset_ = 0;
		_prevOffset_ = 0;
		_priorityOffset_ = 0;
		_tidOffset_ = 0;
		_tlsOffset_ = 0;
		_tracingOffset_ = 0;
		_waitNumberOffset_ = 0;
	}

}
