/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: SunVMI
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class SunVMI {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _JVM_AllocateNewArrayOffset_;
	public static final int _JVM_AllocateNewObjectOffset_;
	public static final int _JVM_ExtendBootClassPathOffset_;
	public static final int _JVM_FindClassFromClassLoaderOffset_;
	public static final int _JVM_FreeMemoryOffset_;
	public static final int _JVM_GCOffset_;
	public static final int _JVM_GCNoCompactOffset_;
	public static final int _JVM_GetCallerClassOffset_;
	public static final int _JVM_GetClassAccessFlagsOffset_;
	public static final int _JVM_GetClassLoaderOffset_;
	public static final int _JVM_GetClassTypeAnnotationsOffset_;
	public static final int _JVM_GetFieldTypeAnnotationsOffset_;
	public static final int _JVM_GetMethodParametersOffset_;
	public static final int _JVM_GetMethodTypeAnnotationsOffset_;
	public static final int _JVM_GetSystemPackageOffset_;
	public static final int _JVM_GetSystemPackagesOffset_;
	public static final int _JVM_GetThreadInterruptEventOffset_;
	public static final int _JVM_HaltOffset_;
	public static final int _JVM_InvokeMethodOffset_;
	public static final int _JVM_LatestUserDefinedLoaderOffset_;
	public static final int _JVM_MaxMemoryOffset_;
	public static final int _JVM_MaxObjectInspectionAgeOffset_;
	public static final int _JVM_NewInstanceFromConstructorOffset_;
	public static final int _JVM_TotalMemoryOffset_;
	public static final int _reservedOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_JVM_AllocateNewArrayOffset_ = 0;
		_JVM_AllocateNewObjectOffset_ = 0;
		_JVM_ExtendBootClassPathOffset_ = 0;
		_JVM_FindClassFromClassLoaderOffset_ = 0;
		_JVM_FreeMemoryOffset_ = 0;
		_JVM_GCOffset_ = 0;
		_JVM_GCNoCompactOffset_ = 0;
		_JVM_GetCallerClassOffset_ = 0;
		_JVM_GetClassAccessFlagsOffset_ = 0;
		_JVM_GetClassLoaderOffset_ = 0;
		_JVM_GetClassTypeAnnotationsOffset_ = 0;
		_JVM_GetFieldTypeAnnotationsOffset_ = 0;
		_JVM_GetMethodParametersOffset_ = 0;
		_JVM_GetMethodTypeAnnotationsOffset_ = 0;
		_JVM_GetSystemPackageOffset_ = 0;
		_JVM_GetSystemPackagesOffset_ = 0;
		_JVM_GetThreadInterruptEventOffset_ = 0;
		_JVM_HaltOffset_ = 0;
		_JVM_InvokeMethodOffset_ = 0;
		_JVM_LatestUserDefinedLoaderOffset_ = 0;
		_JVM_MaxMemoryOffset_ = 0;
		_JVM_MaxObjectInspectionAgeOffset_ = 0;
		_JVM_NewInstanceFromConstructorOffset_ = 0;
		_JVM_TotalMemoryOffset_ = 0;
		_reservedOffset_ = 0;
	}

}
